/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0001\u001a \u0010\u0017\u001a\u00020\u0018*\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011*\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0013\u0010 \u001a\u0004\u0018\u00010\u0003*\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010!\u001a\u000e\u0010\"\u001a\u0004\u0018\u00010\u0001*\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006#"}, d2={"ARGFILE_ARGUMENT", "", "BACKSLASH", "", "DOUBLE_QUOTE", "EXPERIMENTAL_ARGFILE_ARGUMENT", "SINGLE_QUOTE", "argfilePath", "getArgfilePath", "(Ljava/lang/String;)Ljava/lang/String;", "deprecatedArgfilePath", "getDeprecatedArgfilePath", "isArgfileArgument", "", "(Ljava/lang/String;)Z", "isDeprecatedArgfileArgument", "preprocessCommandLineArguments", "", "args", "errors", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "readArgumentsFromArgFile", "content", "consumeRestOfQuotedSequence", "", "Ljava/io/Reader;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "quote", "expand", "Ljava/io/File;", "nextChar", "(Ljava/io/Reader;)Ljava/lang/Character;", "parseNextArgument", "cli-common"})
public final class PreprocessCommandLineArgumentsKt {
    @NotNull
    public static final String ARGFILE_ARGUMENT = "@";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> preprocessCommandLineArguments(@NotNull List<String> args, @NotNull ArgumentParseErrors errors) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(errors, "errors");
        Iterable iterable = $receiver$iv = (Iterable)args;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List<String> list2;
            String arg = (String)element$iv$iv;
            if (PreprocessCommandLineArgumentsKt.isArgfileArgument(arg)) {
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getArgfilePath(arg)), errors);
            } else if (PreprocessCommandLineArgumentsKt.isDeprecatedArgfileArgument(arg)) {
                Map<String, String> map2 = errors.getDeprecatedArguments();
                String string = "-Xargfile=";
                String string2 = ARGFILE_ARGUMENT;
                map2.put(string, string2);
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getDeprecatedArgfilePath(arg)), errors);
            } else {
                list2 = CollectionsKt.listOf(arg);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<String> readArgumentsFromArgFile(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull(content, "content");
        String string = content;
        StringReader reader = new StringReader(string);
        return SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<String>(reader){
            final /* synthetic */ StringReader $reader;

            @Nullable
            public final String invoke() {
                return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$reader);
            }
            {
                this.$reader = stringReader;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> expand(@NotNull File $receiver, ArgumentParseErrors errors) {
        List list2;
        try {
            List list3;
            Object object;
            list2 = $receiver;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object = list2;
            object3 = new FileInputStream((File)object3);
            object = new InputStreamReader((InputStream)object3, (Charset)object2);
            list2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)((Object)list2);
                list3 = SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<String>(it){
                    final /* synthetic */ BufferedReader $it;

                    @Nullable
                    public final String invoke() {
                        return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$it);
                    }
                    {
                        this.$it = bufferedReader;
                        super(0);
                    }
                }));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list2), (Throwable)object2);
            }
            list2 = list3;
        }
        catch (FileNotFoundException e) {
            Collection collection = errors.getArgfileErrors();
            String string = "Argfile not found: " + $receiver.getAbsolutePath();
            collection.add(string);
            list2 = CollectionsKt.emptyList();
        }
        catch (IOException e) {
            Collection collection = errors.getArgfileErrors();
            String string = "Error while reading argfile: " + e;
            collection.add(string);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final String parseNextArgument(@NotNull Reader $receiver) {
        String string;
        String it;
        StringBuilder sb = new StringBuilder();
        Character r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        while (r != null && CharsKt.isWhitespace(r.charValue())) {
            r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
        while (r != null && !CharsKt.isWhitespace(r.charValue())) {
            block5: {
                block4: {
                    char c = '\"';
                    if (r.charValue() == c) break block4;
                    c = '\'';
                    if (r.charValue() != c) break block5;
                }
                PreprocessCommandLineArgumentsKt.consumeRestOfQuotedSequence($receiver, sb, r.charValue());
                return sb.toString();
            }
            sb.append(r.charValue());
            r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
        String string2 = it = (string = sb.toString());
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        return charSequence.length() > 0 ? string : null;
    }

    private static final void consumeRestOfQuotedSequence(@NotNull Reader $receiver, StringBuilder sb, char quote) {
        Character ch = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        while (ch != null && ch.charValue() != quote) {
            char c = '\\';
            if (ch.charValue() == c) {
                if (PreprocessCommandLineArgumentsKt.nextChar($receiver) != null) {
                    Character c2;
                    char p1 = c2.charValue();
                    sb.append(p1);
                }
            } else {
                sb.append(ch.charValue());
            }
            ch = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
    }

    private static final Character nextChar(@NotNull Reader $receiver) {
        Integer n = $receiver.read();
        int it = ((Number)n).intValue();
        Integer n2 = !(it == -1) ? n : null;
        return n2 != null ? Character.valueOf((char)n2.intValue()) : null;
    }

    private static final String getArgfilePath(@NotNull String $receiver) {
        return StringsKt.removePrefix($receiver, (CharSequence)ARGFILE_ARGUMENT);
    }

    private static final boolean isArgfileArgument(@NotNull String $receiver) {
        return StringsKt.startsWith$default($receiver, ARGFILE_ARGUMENT, false, 2, null);
    }

    private static final String getDeprecatedArgfilePath(@NotNull String $receiver) {
        return StringsKt.removePrefix($receiver, (CharSequence)"-Xargfile=");
    }

    private static final boolean isDeprecatedArgfileArgument(@NotNull String $receiver) {
        return StringsKt.startsWith$default($receiver, "-Xargfile=", false, 2, null);
    }

    public static final /* synthetic */ String access$parseNextArgument(Reader $receiver) {
        return PreprocessCommandLineArgumentsKt.parseNextArgument($receiver);
    }
}

