/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;)V", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "getTypeTranslator", "()Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "setTypeTranslator", "(Lorg/jetbrains/kotlin/ir/util/TypeTranslator;)V", "generateAnnotationConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "annotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "generateConstantValueAsExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getArrayElementType", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.tree"})
public final class ConstantValueGenerator {
    @NotNull
    public TypeTranslator typeTranslator;
    private final ModuleDescriptor moduleDescriptor;
    private final ReferenceSymbolTable symbolTable;

    @NotNull
    public final TypeTranslator getTypeTranslator() {
        TypeTranslator typeTranslator = this.typeTranslator;
        if (typeTranslator == null) {
            Intrinsics.throwUninitializedPropertyAccessException("typeTranslator");
        }
        return typeTranslator;
    }

    public final void setTypeTranslator(@NotNull TypeTranslator typeTranslator) {
        Intrinsics.checkParameterIsNotNull(typeTranslator, "<set-?>");
        this.typeTranslator = typeTranslator;
    }

    private final IrType toIrType(@NotNull KotlinType $receiver) {
        TypeTranslator typeTranslator = this.typeTranslator;
        if (typeTranslator == null) {
            Intrinsics.throwUninitializedPropertyAccessException("typeTranslator");
        }
        return typeTranslator.translateType($receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateConstantValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue, @Nullable KotlinType varargElementType) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull(constantValue, "constantValue");
        KotlinType constantKtType = constantValue.getType(this.moduleDescriptor);
        IrType constantType = this.toIrType(constantKtType);
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(startOffset, endOffset, constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof UIntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((UIntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(startOffset, endOffset, constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof ULongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((ULongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(startOffset, endOffset, constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(startOffset, endOffset, constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(startOffset, endOffset, constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof UByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((UByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof UShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((UShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof ArrayValue) {
            Collection<IrExpression> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            KotlinType kotlinType2 = varargElementType;
            if (kotlinType2 == null) {
                kotlinType2 = this.getArrayElementType(constantKtType);
            }
            KotlinType arrayElementType = kotlinType2;
            Iterable iterable = (Iterable)((ArrayValue)constantValue).getValue();
            IrType irType = this.toIrType(arrayElementType);
            IrType irType2 = constantType;
            int n = endOffset;
            int n2 = startOffset;
            void var10_18 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ConstantValue constantValue3 = (ConstantValue)item$iv$iv;
                collection = destination$iv$iv;
                IrExpression irExpression2 = this.generateConstantValueAsExpression(startOffset, endOffset, (ConstantValue<?>)it, null);
                collection.add(irExpression2);
            }
            Collection<IrExpression> collection2 = collection = (List)destination$iv$iv;
            IrType irType3 = irType;
            IrType irType4 = irType2;
            int n3 = n;
            int n4 = n2;
            irExpression = new IrVarargImpl(n4, n3, irType4, irType3, (List<? extends IrVarargElement>)collection2);
        } else if (constantValue2 instanceof EnumValue) {
            ClassifierDescriptor classifierDescriptor = constantKtType.getMemberScope().getContributedClassifier(((EnumValue)constantValue).getEnumEntryName(), NoLookupLocation.FROM_BACKEND);
            if (classifierDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No such enum entry " + ((EnumValue)constantValue).getEnumEntryName() + " in " + constantType)));
            }
            ClassifierDescriptor enumEntryDescriptor = classifierDescriptor;
            if (!(enumEntryDescriptor instanceof ClassDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)("Enum entry " + enumEntryDescriptor + " should be a ClassDescriptor")));
            }
            irExpression = new IrGetEnumValueImpl(startOffset, endOffset, constantType, this.symbolTable.referenceEnumEntry((ClassDescriptor)enumEntryDescriptor));
        } else if (constantValue2 instanceof AnnotationValue) {
            irExpression = this.generateAnnotationConstructorCall((AnnotationDescriptor)((AnnotationValue)constantValue).getValue());
        } else if (constantValue2 instanceof KClassValue) {
            KotlinType classifierKtType = ((KClassValue)constantValue).getArgumentType(this.moduleDescriptor);
            ClassifierDescriptor classifierDescriptor = classifierKtType.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected KClassValue: " + classifierKtType)));
            }
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "classifierKtType.constru\u2026alue: $classifierKtType\")");
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            IrType irType = this.toIrType(constantValue.getType(this.moduleDescriptor));
            SimpleType simpleType2 = classifierDescriptor2.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "classifierDescriptor.defaultType");
            irExpression = new IrClassReferenceImpl(startOffset, endOffset, irType, IrTypesKt.getClassifierOrFail(this.toIrType(simpleType2)), this.toIrType(classifierKtType));
        } else {
            String string = "Unexpected constant value: " + constantValue.getClass().getSimpleName() + ' ' + constantValue;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return irExpression;
    }

    @NotNull
    public static /* synthetic */ IrExpression generateConstantValueAsExpression$default(ConstantValueGenerator constantValueGenerator, int n, int n2, ConstantValue constantValue, KotlinType kotlinType2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            kotlinType2 = null;
        }
        return constantValueGenerator.generateConstantValueAsExpression(n, n2, constantValue, kotlinType2);
    }

    @NotNull
    public final IrCall generateAnnotationConstructorCall(@NotNull AnnotationDescriptor annotationDescriptor) {
        PsiElement psi;
        Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
        KotlinType annotationType = annotationDescriptor.getType();
        ClassifierDescriptor classifierDescriptor = annotationType.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No declaration descriptor for annotation " + annotationDescriptor)));
        }
        ClassDescriptor annotationClassDescriptor = classDescriptor2;
        boolean bl = DescriptorUtils.isAnnotationClass(annotationClassDescriptor);
        if (_Assertions.ENABLED && !bl) {
            String string = "Annotation class expected: " + annotationClassDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassConstructorDescriptor classConstructorDescriptor = annotationClassDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            Collection<ClassConstructorDescriptor> collection = annotationClassDescriptor.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "annotationClassDescriptor.constructors");
            classConstructorDescriptor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
        }
        if (classConstructorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No constructor for annotation class " + annotationClassDescriptor)));
        }
        ClassConstructorDescriptor primaryConstructorDescriptor = classConstructorDescriptor;
        IrConstructorSymbol primaryConstructorSymbol = this.symbolTable.referenceConstructor(primaryConstructorDescriptor);
        SourceElement $receiver$iv = annotationDescriptor.getSource();
        SourceElement sourceElement = $receiver$iv;
        if (!(sourceElement instanceof PsiSourceElement)) {
            sourceElement = null;
        }
        PsiSourceElement psiSourceElement = (PsiSourceElement)sourceElement;
        PsiElement psiElement = psi = psiSourceElement != null ? psiSourceElement.getPsi() : null;
        int startOffset = psiElement != null ? PsiUtilsKt.getStartOffset(psiElement) : -1;
        PsiElement psiElement2 = psi;
        int endOffset = psiElement2 != null ? PsiUtilsKt.getStartOffset(psiElement2) : -1;
        IrCallImpl irCall = new IrCallImpl(startOffset, endOffset, this.toIrType(annotationType), primaryConstructorSymbol, primaryConstructorDescriptor, 0, null, null, 192, null);
        for (ValueParameterDescriptor valueParameter : primaryConstructorDescriptor.getValueParameters()) {
            ConstantValue<?> argumentValue;
            int argumentIndex = valueParameter.getIndex();
            Map<Name, ConstantValue<?>> map2 = annotationDescriptor.getAllValueArguments();
            ValueParameterDescriptor valueParameterDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "valueParameter");
            if (map2.get(valueParameterDescriptor.getName()) == null) {
                continue;
            }
            IrExpression irArgument = this.generateConstantValueAsExpression(-1, -1, argumentValue, valueParameter.getVarargElementType());
            irCall.putValueArgument(argumentIndex, irArgument);
        }
        return irCall;
    }

    private final KotlinType getArrayElementType(@NotNull KotlinType $receiver) {
        KotlinType kotlinType2 = TypeUtilsKt.getBuiltIns($receiver).getArrayElementType($receiver);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "builtIns.getArrayElementType(this)");
        return kotlinType2;
    }

    public ConstantValueGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull ReferenceSymbolTable symbolTable) {
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(symbolTable, "symbolTable");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
    }
}

