/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.declaration.InlineCoroutineUtilKt$WhenMappings;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001d\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u0002H\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u001d\u0010\u0005\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u0002H\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"transformCoroutineMetadataToSpecialFunctions", "T", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "transformSpecialFunctionsToCoroutineMetadata", "ref", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "js.translator"})
public final class InlineCoroutineUtilKt {
    @NotNull
    public static final <T extends JsNode> T transformCoroutineMetadataToSpecialFunctions(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(){

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsExpression> ctx) {
                SpecialFunction specialFunction;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                SpecialFunction specialFunction2 = MetadataProperties.getCoroutineController(x) ? SpecialFunction.COROUTINE_CONTROLLER : (MetadataProperties.getCoroutineReceiver(x) ? SpecialFunction.COROUTINE_RECEIVER : (specialFunction = MetadataProperties.getCoroutineResult(x) ? SpecialFunction.COROUTINE_RESULT : null));
                if (specialFunction != null) {
                    Collection $receiver$iv;
                    Collection collection = $receiver$iv = (Collection)CollectionsKt.listOfNotNull(x.getQualifier());
                    if (collection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = collection;
                    JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
                    if (jsExpressionArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    JsExpression[] arguments2 = jsExpressionArray;
                    JsInvocation jsInvocation = new JsInvocation((JsExpression)InlineCoroutineUtilKt.access$ref(specialFunction), Arrays.copyOf(arguments2, arguments2.length));
                    JsContext<? super JsExpression> jsContext = ctx;
                    JsInvocation $receiver = jsInvocation;
                    MetadataProperties.setSynthetic($receiver, MetadataProperties.getSynthetic(x));
                    MetadataProperties.setSideEffects($receiver, MetadataProperties.getSideEffects(x));
                    $receiver.setSource(x.getSource());
                    JsInvocation jsInvocation2 = jsInvocation;
                    jsContext.replaceMe((JsNode)jsInvocation2);
                } else {
                    super.endVisit(x, ctx);
                }
            }

            public void endVisit(@NotNull JsExpression x, @NotNull JsContext<? super JsExpression> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (MetadataProperties.isSuspend(x)) {
                    MetadataProperties.setSuspend(x, false);
                    ctx.replaceMe(new JsInvocation((JsExpression)InlineCoroutineUtilKt.access$ref(SpecialFunction.SUSPEND_CALL), x).source(x.getSource()));
                }
            }

            public boolean visit(@NotNull JsBinaryOperation x, @NotNull JsContext<? super JsExpression> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                JsExpression lhs = x.getArg1();
                if (lhs instanceof JsNameRef && MetadataProperties.getCoroutineResult((JsNameRef)lhs)) {
                    JsExpression jsExpression;
                    JsExpression jsExpression2;
                    Object object;
                    JsExpression jsExpression3;
                    Collection collection = CollectionsKt.listOf(this.accept((JsNode)x.getArg2()));
                    JsExpression jsExpression4 = ((JsNameRef)lhs).getQualifier();
                    if (jsExpression4 != null) {
                        jsExpression3 = jsExpression4;
                        object = collection;
                        JsExpression it = jsExpression3;
                        jsExpression2 = (JsExpression)this.accept((JsNode)it);
                        collection = object;
                        jsExpression = jsExpression2;
                    } else {
                        jsExpression = null;
                    }
                    List<T> arguments2 = CollectionsKt.plus(collection, (Iterable)CollectionsKt.listOfNotNull(jsExpression));
                    jsExpression3 = new JsInvocation((JsExpression)InlineCoroutineUtilKt.access$ref(SpecialFunction.SET_COROUTINE_RESULT), arguments2);
                    object = ctx;
                    JsExpression $receiver = jsExpression3;
                    MetadataProperties.setSynthetic($receiver, MetadataProperties.getSynthetic(x));
                    MetadataProperties.setSideEffects($receiver, MetadataProperties.getSideEffects(x));
                    $receiver.setSource(x.getSource());
                    jsExpression2 = jsExpression3;
                    ((JsContext)object).replaceMe((JsNode)jsExpression2);
                    return false;
                }
                return super.visit(x, ctx);
            }
        };
        T t = visitor2.accept(node);
        Intrinsics.checkExpressionValueIsNotNull(t, "visitor.accept(node)");
        return t;
    }

    private static final JsNameRef ref(@NotNull SpecialFunction $receiver) {
        JsNameRef jsNameRef = JsAstUtils.pureFqn($receiver.getSuggestedName(), (JsExpression)Namer.kotlinObject());
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "pureFqn(suggestedName, Namer.kotlinObject())");
        return jsNameRef;
    }

    @NotNull
    public static final <T extends JsNode> T transformSpecialFunctionsToCoroutineMetadata(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(){

            public void endVisit(@NotNull JsInvocation x, @NotNull JsContext<? super JsExpression> ctx) {
                block8: {
                    JsExpression replacement;
                    JsExpression jsExpression;
                    JsExpression jsExpression2;
                    Object object;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    Object object2 = InlineUtils.getName(x.getQualifier());
                    if (object2 == null || (object2 = MetadataProperties.getSpecialFunction((JsName)object2)) == null) break block8;
                    Object specialFunction = object = object2;
                    switch (InlineCoroutineUtilKt$WhenMappings.$EnumSwitchMapping$0[((Enum)specialFunction).ordinal()]) {
                        case 1: {
                            List<JsExpression> list2 = x.getArguments();
                            Intrinsics.checkExpressionValueIsNotNull(list2, "x.arguments");
                            JsExpression $receiver = jsExpression2 = new JsNameRef("$$controller$$", CollectionsKt.getOrNull(list2, 0));
                            MetadataProperties.setCoroutineController((JsNameRef)$receiver, true);
                            jsExpression = jsExpression2;
                            break;
                        }
                        case 2: {
                            List<JsExpression> list3 = x.getArguments();
                            Intrinsics.checkExpressionValueIsNotNull(list3, "x.arguments");
                            JsExpression $receiver = jsExpression2 = new JsNameRef("$this$", CollectionsKt.getOrNull(list3, 0));
                            MetadataProperties.setCoroutineReceiver((JsNameRef)$receiver, true);
                            jsExpression = jsExpression2;
                            break;
                        }
                        case 3: {
                            List<JsExpression> list4 = x.getArguments();
                            Intrinsics.checkExpressionValueIsNotNull(list4, "x.arguments");
                            JsExpression $receiver = jsExpression2 = new JsNameRef("$result$", CollectionsKt.getOrNull(list4, 0));
                            MetadataProperties.setCoroutineResult((JsNameRef)$receiver, true);
                            jsExpression = jsExpression2;
                            break;
                        }
                        case 4: {
                            JsExpression $receiver = jsExpression2 = x.getArguments().get(0);
                            MetadataProperties.setSuspend($receiver, true);
                            jsExpression = jsExpression2;
                            break;
                        }
                        case 5: {
                            JsExpression $receiver;
                            List<JsExpression> list5 = x.getArguments();
                            Intrinsics.checkExpressionValueIsNotNull(list5, "x.arguments");
                            JsExpression $receiver2 = $receiver = new JsNameRef("$result$", CollectionsKt.getOrNull(list5, 1));
                            MetadataProperties.setCoroutineResult((JsNameRef)$receiver2, true);
                            JsExpression lhs = $receiver;
                            jsExpression = JsAstUtils.assignment(lhs, x.getArguments().get(0));
                            break;
                        }
                        default: {
                            jsExpression = null;
                        }
                    }
                    JsExpression jsExpression3 = replacement = jsExpression;
                    if (jsExpression3 != null) {
                        JsExpression it = jsExpression2 = jsExpression3;
                        it.setSource(x.getSource());
                        MetadataProperties.setSideEffects(it, MetadataProperties.getSideEffects(x));
                        MetadataProperties.setSynthetic(it, MetadataProperties.getSynthetic(x));
                        ctx.replaceMe((JsNode)it);
                    }
                }
            }
        };
        T t = visitor2.accept(node);
        Intrinsics.checkExpressionValueIsNotNull(t, "visitor.accept(node)");
        return t;
    }

    public static final /* synthetic */ JsNameRef access$ref(SpecialFunction $receiver) {
        return InlineCoroutineUtilKt.ref($receiver);
    }
}

