/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Pointer;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.mac.foundation.MacUtil");

    private MacUtil() {
    }

    public static Activity wakeUpNeo(@NotNull Object reason) {
        if (reason == null) {
            MacUtil.$$$reportNull$$$0(1);
        }
        return SystemInfo.isMacOSMavericks && Registry.is("idea.mac.prevent.app.nap") ? new ActivityImpl(reason) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "colorFromNative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustFocusTraversal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wakeUpNeo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ActivityImpl
    extends AtomicReference<ID>
    implements Activity {
        private static final ID processInfoCls = Foundation.getObjcClass("NSProcessInfo");
        private static final Pointer processInfoSel = Foundation.createSelector("processInfo");
        private static final Pointer beginActivityWithOptionsReasonSel = Foundation.createSelector("beginActivityWithOptions:reason:");
        private static final Pointer endActivitySel = Foundation.createSelector("endActivity:");
        private static final Pointer retainSel = Foundation.createSelector("retain");
        private static final Pointer releaseSel = Foundation.createSelector("release");

        private ActivityImpl(@NotNull Object reason) {
            if (reason == null) {
                ActivityImpl.$$$reportNull$$$0(0);
            }
            super(ActivityImpl.begin(reason));
        }

        @Override
        public void matrixHasYou() {
            ActivityImpl.end(this.getAndSet(null));
        }

        private static ID getProcessInfo() {
            return Foundation.invoke(processInfoCls, processInfoSel, new Object[0]);
        }

        private static ID begin(@NotNull Object reason) {
            if (reason == null) {
                ActivityImpl.$$$reportNull$$$0(1);
            }
            return Foundation.invoke(Foundation.invoke(ActivityImpl.getProcessInfo(), beginActivityWithOptionsReasonSel, 0xEFFFFFL, Foundation.nsString(reason.toString())), retainSel, new Object[0]);
        }

        private static void end(@Nullable ID activityToken) {
            if (activityToken == null) {
                return;
            }
            Foundation.invoke(ActivityImpl.getProcessInfo(), endActivitySel, activityToken);
            Foundation.invoke(activityToken, releaseSel, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "reason";
            objectArray2[1] = "com/intellij/ui/mac/foundation/MacUtil$ActivityImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "begin";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Activity {
        public void matrixHasYou();
    }
}

