/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ErrorTypesAreEqualToAnything;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00020\t\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0002\u00a8\u0006\f"}, d2={"asFlexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFlexible", "", "isNullabilityFlexible", "lowerIfFlexible", "Lorg/jetbrains/kotlin/types/SimpleType;", "singleBestRepresentative", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "upperIfFlexible", "descriptors"})
public final class FlexibleTypesKt {
    public static final boolean isFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return $receiver.unwrap() instanceof FlexibleType;
    }

    @NotNull
    public static final FlexibleType asFlexibleType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        UnwrappedType unwrappedType = $receiver.unwrap();
        if (unwrappedType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        }
        return (FlexibleType)unwrappedType;
    }

    public static final boolean isNullabilityFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        UnwrappedType unwrappedType = $receiver.unwrap();
        if (!(unwrappedType instanceof FlexibleType)) {
            unwrappedType = null;
        }
        FlexibleType flexibleType = (FlexibleType)unwrappedType;
        if (flexibleType == null) {
            return false;
        }
        FlexibleType flexibility = flexibleType;
        return TypeUtils.isNullableType(flexibility.getLowerBound()) != TypeUtils.isNullableType(flexibility.getUpperBound());
    }

    @Nullable
    public static final KotlinType singleBestRepresentative(@NotNull Collection<? extends KotlinType> $receiver) {
        Object v1;
        block6: {
            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
            if ($receiver.size() == 1) {
                return (KotlinType)CollectionsKt.first((Iterable)$receiver);
            }
            Iterable $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                boolean bl;
                block5: {
                    KotlinType candidate2 = (KotlinType)element$iv;
                    Iterable $receiver$iv2 = $receiver;
                    if (((Collection)$receiver$iv2).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $receiver$iv2) {
                            KotlinType other = (KotlinType)element$iv2;
                            if (Intrinsics.areEqual(candidate2, other) || ErrorTypesAreEqualToAnything.INSTANCE.equalTypes(candidate2, other)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(@NotNull Collection<? extends TypeProjection> $receiver) {
        void $receiver$iv$iv;
        Object object;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        if ($receiver.size() == 1) {
            return (TypeProjection)CollectionsKt.first((Iterable)$receiver);
        }
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getProjectionKind();
            collection.add(object);
        }
        Set projectionKinds = CollectionsKt.toSet((List)destination$iv$iv);
        if (projectionKinds.size() != 1) {
            return null;
        }
        Iterable $receiver$iv2 = $receiver;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection $i$a$1$map = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv2;
            object = it.getType();
            collection.add(object);
        }
        KotlinType kotlinType2 = FlexibleTypesKt.singleBestRepresentative((List)destination$iv$iv2);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType bestType = kotlinType2;
        return new TypeProjectionImpl((Variance)((Object)CollectionsKt.single(projectionKinds)), bestType);
    }

    @NotNull
    public static final SimpleType lowerIfFlexible(@NotNull KotlinType $receiver) {
        SimpleType simpleType2;
        UnwrappedType unwrappedType;
        UnwrappedType $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        UnwrappedType unwrappedType2 = $receiver2 = (unwrappedType = $receiver.unwrap());
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$receiver2).getLowerBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType2 = (SimpleType)$receiver2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }

    @NotNull
    public static final SimpleType upperIfFlexible(@NotNull KotlinType $receiver) {
        SimpleType simpleType2;
        UnwrappedType unwrappedType;
        UnwrappedType $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        UnwrappedType unwrappedType2 = $receiver2 = (unwrappedType = $receiver.unwrap());
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$receiver2).getUpperBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType2 = (SimpleType)$receiver2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }
}

