/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.DslScopeViolationCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DslScopeViolationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallImplicitReceiver", "callImplicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend"})
public final class DslScopeViolationCallChecker
implements CallChecker {
    public static final DslScopeViolationCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DslMarkersSupport)) {
            return;
        }
        Collection<ReceiverValue> callImplicitReceivers = ResolvedCallUtilKt.getImplicitReceivers(resolvedCall2);
        for (ReceiverValue callImplicitReceiver : callImplicitReceivers) {
            this.checkCallImplicitReceiver(callImplicitReceiver, resolvedCall2, reportOn, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCallImplicitReceiver(ReceiverValue callImplicitReceiver, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        Object v3;
        block16: {
            Object v1;
            List dslMarkersFromOuterReceivers;
            void callDslMarkers;
            Set<FqName> additionalCallDslMarkers;
            block14: {
                void $this$mapTo$iv$iv;
                List receiversUntilOneFromTheCall2 = SequencesKt.toList(SequencesKt.takeWhile(SequencesKt.mapNotNull(ScopeUtilsKt.getParentsWithSelf(context.getScope()), checkCallImplicitReceiver.receiversUntilOneFromTheCall.1.INSTANCE), (Function1)new Function1<ReceiverValue, Boolean>(callImplicitReceiver){
                    final /* synthetic */ ReceiverValue $callImplicitReceiver;

                    public final boolean invoke(@NotNull ReceiverValue it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return Intrinsics.areEqual(it, this.$callImplicitReceiver) ^ true;
                    }
                    {
                        this.$callImplicitReceiver = receiverValue;
                        super(1);
                    }
                }));
                if (receiversUntilOneFromTheCall2.isEmpty()) {
                    return;
                }
                DslMarkerUtils.DslMarkersFromReceiver dslMarkersFromReceiver = DslMarkerUtils.INSTANCE.extractDslMarkerFqNames(callImplicitReceiver);
                Set<FqName> set = dslMarkersFromReceiver.component1();
                additionalCallDslMarkers = dslMarkersFromReceiver.component2();
                if (callDslMarkers.isEmpty() && additionalCallDslMarkers.isEmpty()) {
                    return;
                }
                Iterable $this$map$iv = receiversUntilOneFromTheCall2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    ReceiverValue receiverValue = (ReceiverValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    DslMarkerUtils.DslMarkersFromReceiver dslMarkersFromReceiver2 = DslMarkerUtils.INSTANCE.extractDslMarkerFqNames((ReceiverValue)p1);
                    collection.add(dslMarkersFromReceiver2);
                }
                dslMarkersFromOuterReceivers = (List)destination$iv$iv;
                Iterable $this$firstOrNull$iv = dslMarkersFromOuterReceivers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block13: {
                        void $this$any$iv;
                        DslMarkerUtils.DslMarkersFromReceiver $dstr$dslMarkersFromReceiver$_u24__u24 = (DslMarkerUtils.DslMarkersFromReceiver)element$iv;
                        boolean bl2 = false;
                        Set<FqName> dslMarkersFromReceiver3 = $dstr$dslMarkersFromReceiver$_u24__u24.component1();
                        Iterable bl3 = dslMarkersFromReceiver3;
                        void var18_29 = callDslMarkers;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                FqName p1 = (FqName)element$iv2;
                                boolean bl4 = false;
                                if (!var18_29.contains(p1)) continue;
                                bl = true;
                                break block13;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v1 = element$iv;
                    break block14;
                }
                v1 = null;
            }
            DslMarkerUtils.DslMarkersFromReceiver closestAnotherReceiverWithSameDslMarker = v1;
            if (closestAnotherReceiverWithSameDslMarker != null) {
                context.getTrace().report(Errors.DSL_SCOPE_VIOLATION.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
                return;
            }
            Set allDslMarkersFromCall = SetsKt.plus(callDslMarkers, (Iterable)additionalCallDslMarkers);
            Iterable $this$firstOrNull$iv = dslMarkersFromOuterReceivers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block15: {
                    DslMarkerUtils.DslMarkersFromReceiver $dstr$dslMarkersFromReceiver$additionalDslMarkersFromReceiver = (DslMarkerUtils.DslMarkersFromReceiver)element$iv;
                    boolean bl5 = false;
                    Set<FqName> dslMarkersFromReceiver = $dstr$dslMarkersFromReceiver$additionalDslMarkersFromReceiver.component1();
                    Set<FqName> additionalDslMarkersFromReceiver = $dstr$dslMarkersFromReceiver$additionalDslMarkersFromReceiver.component2();
                    Set<FqName> allMarkersFromReceiver = SetsKt.plus(dslMarkersFromReceiver, (Iterable)additionalDslMarkersFromReceiver);
                    Iterable $this$any$iv = allDslMarkersFromCall;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            FqName p1 = (FqName)element$iv3;
                            boolean bl6 = false;
                            if (!allMarkersFromReceiver.contains(p1)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v3 = element$iv;
                break block16;
            }
            v3 = null;
        }
        DslMarkerUtils.DslMarkersFromReceiver closestAnotherReceiverWithSameDslMarkerWithDeprecation = v3;
        if (closestAnotherReceiverWithSameDslMarkerWithDeprecation != null) {
            DiagnosticFactory1<PsiElement, CallableDescriptor> diagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DslMarkerOnFunctionTypeReceiver) ? Errors.DSL_SCOPE_VIOLATION : Errors.DSL_SCOPE_VIOLATION_WARNING;
            context.getTrace().report(diagnostic.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
        }
    }

    private DslScopeViolationCallChecker() {
    }

    static {
        DslScopeViolationCallChecker dslScopeViolationCallChecker;
        INSTANCE = dslScopeViolationCallChecker = new DslScopeViolationCallChecker();
    }
}

