/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.FileUtil;

public final class ChecksumHelper {
    private static final int BUFFER_SIZE = 2048;
    private static Map algorithms = new HashMap();
    private static final char[] CHARS;

    public static void check(File dest, File checksumFile, String algorithm) throws IOException {
        String expected;
        String csFileContent = FileUtil.readEntirely(new BufferedReader(new FileReader(checksumFile))).trim().toLowerCase(Locale.US);
        if (csFileContent.indexOf(32) > -1 && (csFileContent.startsWith("md") || csFileContent.startsWith("sha"))) {
            int lastSpaceIndex = csFileContent.lastIndexOf(32);
            expected = csFileContent.substring(lastSpaceIndex + 1);
        } else {
            int spaceIndex = csFileContent.indexOf(32);
            if (spaceIndex != -1) {
                expected = csFileContent.substring(0, spaceIndex);
                if (expected.endsWith(":")) {
                    StringBuffer result = new StringBuffer();
                    char[] chars = csFileContent.substring(spaceIndex + 1).toCharArray();
                    for (int i = 0; i < chars.length; ++i) {
                        if (Character.isWhitespace(chars[i])) continue;
                        result.append(chars[i]);
                    }
                    expected = result.toString();
                }
            } else {
                expected = csFileContent;
            }
        }
        String computed = ChecksumHelper.computeAsString(dest, algorithm).trim().toLowerCase(Locale.US);
        if (!expected.equals(computed)) {
            throw new IOException("invalid " + algorithm + ": expected=" + expected + " computed=" + computed);
        }
    }

    public static String computeAsString(File f, String algorithm) throws IOException {
        return ChecksumHelper.byteArrayToHexString(ChecksumHelper.compute(f, algorithm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compute(File f, String algorithm) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            MessageDigest md = ChecksumHelper.getMessageDigest(algorithm);
            md.reset();
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = ((InputStream)is).read(buf)) != -1) {
                md.update(buf, 0, len);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
    }

    public static boolean isKnownAlgorithm(String algorithm) {
        return algorithms.containsKey(algorithm);
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        String mdAlgorithm = (String)algorithms.get(algorithm);
        if (mdAlgorithm == null) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
        try {
            return MessageDigest.getInstance(mdAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(CHARS[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(CHARS[ch]);
        }
        return out.toString();
    }

    private ChecksumHelper() {
    }

    static {
        algorithms.put("md5", "MD5");
        algorithms.put("sha1", "SHA-1");
        CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

