/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.ResourceHandle;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    public ZipHandlerBase(@NotNull String path2) {
        if (path2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(0);
        }
        super(path2);
    }

    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        Map<String, ArchiveHandler.EntryInfo> map2;
        try (ResourceHandle<ZipFile> existingZipRef = this.acquireZipHandle();){
            Map<String, ArchiveHandler.EntryInfo> map3 = this.buildEntryMapForZipFile(existingZipRef.get());
            map2 = map3;
        }
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(ZipFile zip2) {
        ZipEntryMap map2 = new ZipEntryMap(zip2.size());
        map2.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries2 = zip2.entries();
        while (entries2.hasMoreElements()) {
            this.getOrCreate(entries2.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map2, zip2);
        }
        ZipEntryMap zipEntryMap = map2;
        if (zipEntryMap == null) {
            ZipHandlerBase.$$$reportNull$$$0(2);
        }
        return zipEntryMap;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCaches();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip2) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            ZipHandlerBase.$$$reportNull$$$0(3);
        }
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(4);
        }
        if (zip2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(5);
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar(entryName, '/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map2.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(6);
            }
            return entryInfo;
        }
        Pair<String, String> path2 = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path2.first, map2, zip2);
        if (".".equals(path2.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(7);
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandlerBase.store(map2, parentInfo, (CharSequence)path2.second, isDirectory, entry.getSize(), this.getEntryFileStamp(), entryName);
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(8);
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map2, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(9);
        }
        if (shortName == null) {
            ZipHandlerBase.$$$reportNull$$$0(10);
        }
        if (string == null) {
            ZipHandlerBase.$$$reportNull$$$0(11);
        }
        CharSequence sequence2 = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfPossible(shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence2, isDirectory, size, time, parentInfo);
        map2.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(12);
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip2) {
        ArchiveHandler.EntryInfo info;
        if (entryName == null) {
            ZipHandlerBase.$$$reportNull$$$0(13);
        }
        if (zip2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(14);
        }
        if ((info = map2.get(entryName)) == null) {
            ZipEntry entry = zip2.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map2, zip2);
                if (entryInfo == null) {
                    ZipHandlerBase.$$$reportNull$$$0(15);
                }
                return entryInfo;
            }
            Pair<String, String> path2 = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path2.first, map2, zip2);
            info = ZipHandlerBase.store(map2, parentInfo, (CharSequence)path2.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(this.getClass()).info(zip2.getName() + ": " + entryName + " should be a directory");
            info = ZipHandlerBase.store(map2, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(16);
        }
        return entryInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block31: {
            byte[] byArray;
            Throwable throwable;
            ResourceHandle<ZipFile> zipRef;
            block32: {
                if (relativePath == null) {
                    ZipHandlerBase.$$$reportNull$$$0(17);
                }
                zipRef = this.acquireZipHandle();
                throwable = null;
                try {
                    ZipFile zip2 = zipRef.get();
                    ZipEntry entry = zip2.getEntry(relativePath);
                    if (entry == null) break block31;
                    long length = entry.getSize();
                    if (FileUtilRt.isTooLarge(length)) {
                        throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                    }
                    try (InputStream stream2 = zip2.getInputStream(entry);){
                        if (stream2 == null) break block31;
                        byArray = FileUtil.loadBytes(stream2, (int)length);
                        if (byArray != null) break block32;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                ZipHandlerBase.$$$reportNull$$$0(18);
            }
            return byArray;
            finally {
                if (zipRef != null) {
                    if (throwable != null) {
                        try {
                            zipRef.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        zipRef.close();
                    }
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<ZipFile> acquireZipHandle() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntryMapForZipFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "store";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

