/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/codegen/SourceInfo;", "", "source", "", "pathOrCleanFQN", "linesInFile", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getLinesInFile", "()I", "getPathOrCleanFQN", "()Ljava/lang/String;", "getSource", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "backend"})
public final class SourceInfo {
    @NotNull
    private final String source;
    @NotNull
    private final String pathOrCleanFQN;
    private final int linesInFile;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getPathOrCleanFQN() {
        return this.pathOrCleanFQN;
    }

    public final int getLinesInFile() {
        return this.linesInFile;
    }

    public SourceInfo(@NotNull String source, @NotNull String pathOrCleanFQN, int linesInFile) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(pathOrCleanFQN, "pathOrCleanFQN");
        this.source = source;
        this.pathOrCleanFQN = pathOrCleanFQN;
        this.linesInFile = linesInFile;
    }

    @NotNull
    public final String component1() {
        return this.source;
    }

    @NotNull
    public final String component2() {
        return this.pathOrCleanFQN;
    }

    public final int component3() {
        return this.linesInFile;
    }

    @NotNull
    public final SourceInfo copy(@NotNull String source, @NotNull String pathOrCleanFQN, int linesInFile) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(pathOrCleanFQN, "pathOrCleanFQN");
        return new SourceInfo(source, pathOrCleanFQN, linesInFile);
    }

    public static /* synthetic */ SourceInfo copy$default(SourceInfo sourceInfo, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = sourceInfo.source;
        }
        if ((n2 & 2) != 0) {
            string2 = sourceInfo.pathOrCleanFQN;
        }
        if ((n2 & 4) != 0) {
            n = sourceInfo.linesInFile;
        }
        return sourceInfo.copy(string, string2, n);
    }

    @NotNull
    public String toString() {
        return "SourceInfo(source=" + this.source + ", pathOrCleanFQN=" + this.pathOrCleanFQN + ", linesInFile=" + this.linesInFile + ")";
    }

    public int hashCode() {
        String string = this.source;
        String string2 = this.pathOrCleanFQN;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.linesInFile);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SourceInfo)) break block3;
                SourceInfo sourceInfo = (SourceInfo)object;
                if (!Intrinsics.areEqual(this.source, sourceInfo.source) || !Intrinsics.areEqual(this.pathOrCleanFQN, sourceInfo.pathOrCleanFQN) || !(this.linesInFile == sourceInfo.linesInFile)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/SourceInfo$Companion;", "", "()V", "createInfo", "Lorg/jetbrains/kotlin/codegen/SourceInfo;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "internalClassName", "", "createInfoForIr", "lineNumbers", "", "containingFileName", "backend"})
    public static final class Companion {
        @NotNull
        public final SourceInfo createInfo(@Nullable KtElement element, @NotNull String internalClassName) {
            Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
            boolean bl = element != null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-SourceInfo$Companion$createInfo$22 = false;
                String $i$a$-assert-SourceInfo$Companion$createInfo$22 = "Couldn't create source mapper for null element " + internalClassName;
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-SourceInfo$Companion$createInfo$22));
            }
            KtElement ktElement = element;
            if (ktElement == null) {
                Intrinsics.throwNpe();
            }
            PsiFile psiFile = ktElement.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull(psiFile, "element!!.containingFile");
            Integer n = CodegenUtil.getLineNumberForElement(psiFile, true);
            if (n == null) {
                String string = "Couldn't extract line count in " + element.getContainingFile();
                boolean $i$a$-assert-SourceInfo$Companion$createInfo$22 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int lineNumbers = n;
            boolean isTopLevel = element instanceof KtFile || element instanceof KtNamedFunction && element.getParent() instanceof KtFile;
            String cleanedClassFqName = !isTopLevel ? internalClassName : StringsKt.substringBefore$default(internalClassName, '$', null, 2, null);
            KtFile ktFile = element.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull(ktFile, "element.containingKtFile");
            String string = ktFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "element.containingKtFile.name");
            return new SourceInfo(string, cleanedClassFqName, lineNumbers);
        }

        @NotNull
        public final SourceInfo createInfoForIr(int lineNumbers, @NotNull String internalClassName, @NotNull String containingFileName) {
            Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
            Intrinsics.checkParameterIsNotNull(containingFileName, "containingFileName");
            return new SourceInfo(containingFileName, internalClassName, lineNumbers);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

