/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.functors.AbstractReducingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0014J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/EqualsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/functors/AbstractReducingFunctor;", "constants", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;", "isNegated", "", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;Z)V", "()Z", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "equateCallAndConstant", "call", "constant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "equateValues", "left", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "right", "invokeWithArguments", "isSafeToProduceFalse", "leftCall", "leftConstant", "rightConstant", "resolution"})
public final class EqualsFunctor
extends AbstractReducingFunctor {
    private final boolean isNegated;

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        boolean bl = arguments2.size() == 2;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Equals functor expected 2 arguments, got " + arguments2.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (arguments2.size() != 2) {
            return CollectionsKt.emptyList();
        }
        return this.invokeWithArguments(arguments2.get(0), arguments2.get(1));
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation left, @NotNull Computation right) {
        Intrinsics.checkParameterIsNotNull(left, "left");
        Intrinsics.checkParameterIsNotNull(right, "right");
        if (left instanceof ESValue && right instanceof ESValue) {
            return this.equateValues((ESValue)left, (ESValue)right);
        }
        if (left instanceof ESConstant) {
            return this.equateCallAndConstant(right, (ESConstant)left);
        }
        if (right instanceof ESConstant) {
            return this.equateCallAndConstant(left, (ESConstant)right);
        }
        return CollectionsKt.emptyList();
    }

    private final List<ESEffect> equateCallAndConstant(Computation call2, ESConstant constant) {
        boolean bl = false;
        List resultingClauses = new ArrayList();
        for (ESEffect effect : call2.getEffects()) {
            if (!(effect instanceof ConditionalEffect) || !(((ConditionalEffect)effect).getSimpleEffect() instanceof ESReturns) || ValuesKt.isWildcard(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue())) {
                Collection collection = resultingClauses;
                boolean bl2 = false;
                collection.add(effect);
                continue;
            }
            if (Intrinsics.areEqual(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant)) {
                ConditionalEffect trueClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(this.getConstants$resolution().booleanValue(!this.isNegated)));
                resultingClauses.add(trueClause);
            }
            if (!(Intrinsics.areEqual(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant) ^ true) || !(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue() instanceof ESConstant) || !this.isSafeToProduceFalse(call2, (ESConstant)((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant)) continue;
            ConditionalEffect falseClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(this.getConstants$resolution().booleanValue(this.isNegated)));
            resultingClauses.add(falseClause);
        }
        return resultingClauses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSafeToProduceFalse(Computation leftCall, ESConstant leftConstant, ESConstant rightConstant) {
        if (KotlinBuiltIns.isBoolean(rightConstant.getType()) && leftCall.getType() != null) {
            KotlinType kotlinType2 = leftCall.getType();
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (KotlinBuiltIns.isBoolean(kotlinType2)) {
                return true;
            }
        }
        if (!leftConstant.isNullConstant()) return false;
        if (!rightConstant.isNullConstant()) return false;
        return true;
    }

    private final List<ESEffect> equateValues(ESValue left, ESValue right) {
        return CollectionsKt.listOf(new ConditionalEffect(new ESEqual(this.getConstants$resolution(), left, right, this.isNegated), new ESReturns(this.getConstants$resolution().getTrueValue())), new ConditionalEffect(new ESEqual(this.getConstants$resolution(), left, right, !this.isNegated), new ESReturns(this.getConstants$resolution().getFalseValue())));
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    public EqualsFunctor(@NotNull ESConstants constants, boolean isNegated) {
        Intrinsics.checkParameterIsNotNull(constants, "constants");
        super(constants);
        this.isNegated = isNegated;
    }
}

