/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements Disposable,
DocumentListener {
    static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiDocumentManagerImpl");
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create("HARD_REFERENCE_TO_DOCUMENT");
    private static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create("ACTION_AFTER_COMMIT");
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    final Set<Document> myUncommittedDocuments;
    private final Map<Document, UncommittedInfo> myUncommittedInfos;
    boolean myStopTrackingDocuments;
    private boolean myPerformBackgroundCommit;
    private volatile boolean myIsCommitInProgress;
    private static volatile boolean ourIsFullReparseInProgress;
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners;
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted;
    private static final Object PERFORM_ALWAYS_KEY;

    protected PsiDocumentManagerBase(@NotNull Project project, @NotNull PsiManager psiManager, @NotNull MessageBus bus, @NotNull DocumentCommitProcessor documentCommitProcessor) {
        if (project == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(0);
        }
        if (psiManager == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(2);
        }
        if (documentCommitProcessor == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(3);
        }
        this.myUncommittedDocuments = ContainerUtil.newConcurrentSet();
        this.myUncommittedInfos = ContainerUtil.newConcurrentMap();
        this.myPerformBackgroundCommit = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myDocumentCommitProcessor = documentCommitProcessor;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener(this.mySynchronizer);
        bus.connect(this).subscribe(PsiDocumentTransactionListener.TOPIC, (document, file2) -> this.myUncommittedDocuments.remove(document));
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(4);
        }
        if (document instanceof DocumentWindow && !((DocumentWindow)document).isValid()) {
            return null;
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return PsiDocumentManagerBase.ensureValidFile(psiFile, "Cached PSI");
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile2);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    @NotNull
    private static PsiFile ensureValidFile(@NotNull PsiFile psiFile, @NotNull String debugInfo2) {
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(5);
        }
        if (debugInfo2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(6);
        }
        if (!psiFile.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)psiFile, debugInfo2);
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(7);
        }
        return psiFile2;
    }

    @Deprecated
    public static void cachePsi(@NotNull Document document, @Nullable PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(8);
        }
        LOG.warn("Unsupported method", new Throwable());
    }

    public void associatePsi(@NotNull Document document, @Nullable PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull Document document) {
        VirtualFile virtualFile2;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(10);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(document)) == null || !virtualFile2.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile2);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document) {
        VirtualFile virtualFile2;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(11);
        }
        if ((virtualFile2 = PsiDocumentManagerBase.getVirtualFile(document)) == null) {
            return null;
        }
        return this.getFileManager().findCachedViewProvider(virtualFile2);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        VirtualFile virtualFile2;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(12);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(document)) == null || !virtualFile2.isValid()) {
            return null;
        }
        return virtualFile2;
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(13);
        }
        return this.getFileManager().getCachedPsiFile(virtualFile2);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(14);
        }
        return this.getFileManager().findFile(virtualFile2);
    }

    @NotNull
    private FileManager getFileManager() {
        FileManager fileManager = ((PsiManagerEx)this.myPsiManager).getFileManager();
        if (fileManager == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(15);
        }
        return fileManager;
    }

    @Override
    public Document getDocument(@NotNull PsiFile file2) {
        Document document;
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(16);
        }
        if ((document = this.getCachedDocument(file2)) != null) {
            if (!file2.getViewProvider().isPhysical()) {
                PsiUtilCore.ensureValid(file2);
                this.associatePsi(document, file2);
            }
            return document;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file2.getTextLength()) {
                String message2 = "Document/PSI mismatch: " + file2 + " (" + file2.getClass() + "); physical=" + viewProvider.isPhysical();
                if (document.getTextLength() + file2.getTextLength() < 8096) {
                    message2 = message2 + "\n=== document ===\n" + document.getText() + "\n=== PSI ===\n" + file2.getText();
                }
                throw new AssertionError((Object)message2);
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid(file2);
                this.associatePsi(document, file2);
                file2.putUserData(HARD_REF_TO_DOCUMENT, document);
            }
        }
        return document;
    }

    @Override
    public Document getCachedDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(17);
        }
        if (!file2.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    @Override
    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            if (this.isCommitted(document)) {
                boolean success = this.doCommitWithoutReparse(document);
                LOG.error("Committed document in uncommitted set: " + document + ", force-committed=" + success);
                continue;
            }
            if (this.doCommit(document)) continue;
            LOG.error("Couldn't commit " + document);
        }
        this.assertEverythingCommitted();
    }

    private void assertEverythingCommitted() {
        LOG.assertTrue(!this.hasUncommitedDocuments(), this.myUncommittedDocuments);
    }

    public boolean doCommitWithoutReparse(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(18);
        }
        return this.finishCommitInWriteAction(document, Collections.emptyList(), Collections.emptyList(), true, true);
    }

    @Override
    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(19);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(20);
        }
        if (this.isCommitted(document = PsiDocumentManagerBase.getTopLevelDocument(doc))) {
            action.run();
        } else {
            PsiDocumentManagerBase.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key, @NotNull Runnable action) {
        if (key == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(21);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (this.myUncommittedDocuments.isEmpty()) {
            if (!this.isCommitInProgress()) assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            action.run();
            return true;
        }
        this.checkWeAreOutsideAfterCommitHandler();
        this.actionsWhenAllDocumentsAreCommitted.put(key, action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(23);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(24);
        }
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            List<Runnable> list2 = document.getUserData(ACTION_AFTER_COMMIT);
            if (list2 == null) {
                list2 = new SmartList<Runnable>();
                document.putUserData(ACTION_AFTER_COMMIT, list2);
            }
            list2.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Runnable> getAndClearActionsAfterCommit(@NotNull Document document) {
        List<Runnable> list2;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(25);
        }
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            list2 = document.getUserData(ACTION_AFTER_COMMIT);
            if (list2 != null) {
                list2 = new ArrayList<Runnable>(list2);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        return list2;
    }

    @Override
    public void commitDocument(@NotNull Document doc) {
        Document document;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(26);
        }
        if (this.isEventSystemEnabled(document = PsiDocumentManagerBase.getTopLevelDocument(doc))) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    private boolean isEventSystemEnabled(Document document) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        return viewProvider != null && viewProvider.isEventSystemEnabled() && !AbstractFileViewProvider.isFreeThreaded(viewProvider);
    }

    boolean finishCommit(final @NotNull Document document, final @NotNull List<? extends BooleanRunnable> finishProcessors, final @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, final boolean synchronously, @NotNull Object reason) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(27);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(28);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(29);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(30);
        }
        assert (!this.myProject.isDisposed()) : "Already disposed";
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean[] ok = new boolean[]{true};
        DocumentRunnable runnable = new DocumentRunnable(document, this.myProject){

            @Override
            public void run() {
                ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, synchronously, false);
            }
        };
        if (synchronously) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
        if (ok[0]) {
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationInfoImpl.isInStressTest()) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, boolean forceNoPsiCommit) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(31);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(32);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document instanceof DocumentWindow));
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile2 != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile2);
        }
        FileViewProvider viewProvider = forceNoPsiCommit ? null : this.getCachedViewProvider(document);
        this.myIsCommitInProgress = true;
        Ref<Boolean> success = new Ref<Boolean>(true);
        try {
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                if (viewProvider == null) {
                    this.handleCommitWithoutPsi(document);
                } else {
                    success.set(this.commitToExistingPsi(document, finishProcessors, reparseInjectedProcessors, synchronously, virtualFile2));
                }
            });
        }
        catch (Throwable e) {
            try {
                this.forceReload(virtualFile2, viewProvider);
            }
            finally {
                LOG.error(e);
            }
        }
        finally {
            if (success.get().booleanValue()) {
                this.myUncommittedDocuments.remove(document);
            }
            this.myIsCommitInProgress = false;
        }
        return success.get();
    }

    private boolean commitToExistingPsi(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @Nullable VirtualFile virtualFile2) {
        FileViewProvider viewProvider;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(34);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(35);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(36);
        }
        for (BooleanRunnable booleanRunnable : finishProcessors) {
            boolean bl = booleanRunnable.run();
            if (synchronously) assert (bl) : booleanRunnable + " in " + finishProcessors;
            if (bl) continue;
            return false;
        }
        this.clearUncommittedInfo(document);
        if (virtualFile2 != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile2);
        }
        if ((viewProvider = this.getCachedViewProvider(document)) != null) {
            viewProvider.contentsSynchronized();
        }
        for (BooleanRunnable booleanRunnable : reparseInjectedProcessors) {
            if (booleanRunnable.run()) continue;
            return false;
        }
        return true;
    }

    void forceReload(VirtualFile virtualFile2, @Nullable FileViewProvider viewProvider) {
        if (viewProvider != null) {
            ((AbstractFileViewProvider)viewProvider).markInvalidated();
        }
        if (virtualFile2 != null) {
            ((FileManagerImpl)this.getFileManager()).forceReload(virtualFile2);
        }
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        PsiFile psiFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(37);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(38);
        }
        if ((psiFile = this.getCachedPsiFile(document)) != null) {
            psiFile.accept(new PsiRecursiveElementWalkingVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private boolean doCommit(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(39);
        }
        assert (!this.myIsCommitInProgress) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
            return false;
        }
        PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document);
            this.runAfterCommitActions(document);
            return true;
        }
        Runnable runnable = () -> {
            this.myIsCommitInProgress = true;
            try {
                this.myDocumentCommitProcessor.commitSynchronously(document, this.myProject, psiFile);
            }
            finally {
                this.myIsCommitInProgress = false;
            }
            assert (!this.isInUncommittedSet(document)) : "Document :" + document;
        };
        ApplicationManager.getApplication().runWriteAction(runnable);
        return true;
    }

    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress || PsiDocumentManagerBase.isFullReparseInProgress();
    }

    public static boolean isFullReparseInProgress() {
        return ourIsFullReparseInProgress;
    }

    @Override
    public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(40);
        }
        Ref<Object> ref = Ref.create(null);
        this.commitAndRunReadAction(() -> ref.set(computation.compute()));
        return ref.get();
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files2, boolean includeOpenFiles) {
        if (files2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(41);
        }
        FileContentUtilCore.reparseFiles(files2);
    }

    @Override
    public void commitAndRunReadAction(@NotNull Runnable runnable) {
        boolean executed;
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(42);
        }
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable.run();
            return;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock. " + Thread.currentThread());
        }
        while (!(executed = ReadAction.compute(() -> {
            if (this.myUncommittedDocuments.isEmpty()) {
                runnable.run();
                return true;
            }
            return false;
        }).booleanValue())) {
            TransactionId contextTransaction = TransactionGuard.getInstance().getContextTransaction();
            Semaphore semaphore = new Semaphore(1);
            application.invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    semaphore.up();
                    return;
                }
                this.performWhenAllCommitted(() -> semaphore.up(), contextTransaction);
            }, ModalityState.any());
            while (!semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
    }

    @Override
    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(43);
        }
        return this.performWhenAllCommitted(action, TransactionGuard.getInstance().getContextTransaction());
    }

    private boolean performWhenAllCommitted(@NotNull Runnable action, @Nullable TransactionId context2) {
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(action);
        if (context2 != null) {
            for (Document document : this.myUncommittedDocuments) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, "re-added with context " + context2 + " because performWhenAllCommitted(" + context2 + ") was called", context2);
            }
        }
        return false;
    }

    @Override
    public void performLaterWhenAllCommitted(@NotNull Runnable runnable) {
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(45);
        }
        this.performLaterWhenAllCommitted(runnable, ModalityState.defaultModalityState());
    }

    @Override
    public void performLaterWhenAllCommitted(@NotNull Runnable runnable, ModalityState modalityState) {
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(46);
        }
        Runnable whenAllCommitted = () -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.hasUncommitedDocuments()) {
                this.performLaterWhenAllCommitted(runnable);
            } else {
                runnable.run();
            }
        }, modalityState, this.myProject.getDisposed());
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    this.performWhenAllCommitted(whenAllCommitted);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterCommitActions(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(47);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed() && this.isCommitted(document)) {
                    this.runAfterCommitActions(document);
                }
            });
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<Runnable> list2 = PsiDocumentManagerBase.getAndClearActionsAfterCommit(document);
        if (list2 != null) {
            for (Runnable runnable : list2) {
                runnable.run();
            }
        }
        if (!this.hasUncommitedDocuments() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty()) {
            ArrayList<Runnable> actions = new ArrayList<Runnable>(this.actionsWhenAllDocumentsAreCommitted.values());
            this.beforeCommitHandler();
            ArrayList<Pair<Runnable, Throwable>> exceptions = new ArrayList<Pair<Runnable, Throwable>>();
            try {
                for (Runnable runnable : actions) {
                    try {
                        runnable.run();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable e) {
                        exceptions.add(Pair.create(runnable, e));
                    }
                }
            }
            finally {
                this.actionsWhenAllDocumentsAreCommitted.clear();
            }
            for (Pair pair : exceptions) {
                Runnable action = (Runnable)pair.getFirst();
                Throwable e = (Throwable)pair.getSecond();
                LOG.error("During running " + action, e);
            }
        }
    }

    private void beforeCommitHandler() {
        this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, EmptyRunnable.getInstance());
    }

    private void checkWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        return this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY) == EmptyRunnable.getInstance();
    }

    @Override
    public void addListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(48);
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(49);
        }
        this.myListeners.remove(listener);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(50);
        }
        return false;
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(51);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(53);
        }
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(54);
        }
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.fileCreated(file2, document);
        }
    }

    @Override
    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(55);
        }
        CharSequence charSequence = this.getLastCommittedDocument(document).getImmutableCharSequence();
        if (charSequence == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(56);
        }
        return charSequence;
    }

    @Override
    public long getLastCommittedStamp(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(57);
        }
        return this.getLastCommittedDocument(PsiDocumentManagerBase.getTopLevelDocument(document)).getModificationStamp();
    }

    @Override
    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file2) {
        Document document;
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(58);
        }
        return (document = this.getDocument(file2)) == null ? null : this.getLastCommittedDocument(document);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(59);
        }
        if (document instanceof FrozenDocument) {
            DocumentEx documentEx = (DocumentEx)document;
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(60);
            }
            return documentEx;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                DocumentEx documentEx = (DocumentEx)((Object)window);
                if (documentEx == null) {
                    PsiDocumentManagerBase.$$$reportNull$$$0(61);
                }
                return documentEx;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate) + ", window=" + window));
            }
            UncommittedInfo info2 = this.myUncommittedInfos.get(delegate);
            DocumentWindow documentWindow = answer = info2 == null ? null : (DocumentWindow)info2.myFrozenWindows.get(document);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info2 != null) {
                answer = ConcurrencyUtil.cacheOrGet(info2.myFrozenWindows, window, answer);
            }
            DocumentEx documentEx = (DocumentEx)((Object)answer);
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(62);
            }
            return documentEx;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info3 = this.myUncommittedInfos.get(document);
        FrozenDocument frozenDocument = info3 != null ? info3.myFrozen : ((DocumentImpl)document).freeze();
        if (frozenDocument == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(63);
        }
        return frozenDocument;
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(64);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(65);
        }
        assert (document instanceof DocumentImpl) : document;
        UncommittedInfo info2 = this.myUncommittedInfos.get(document);
        if (info2 != null) {
            ArrayList<DocumentEvent> arrayList = new ArrayList<DocumentEvent>(info2.myEvents);
            if (arrayList == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(66);
            }
            return arrayList;
        }
        List<DocumentEvent> list2 = Collections.emptyList();
        if (list2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(67);
        }
        return list2;
    }

    @Override
    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document[] documents = this.myUncommittedDocuments.toArray(Document.EMPTY_ARRAY);
        if (documents == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(68);
        }
        return documents;
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(69);
        }
        return this.myUncommittedDocuments.contains(PsiDocumentManagerBase.getTopLevelDocument(document));
    }

    @Override
    public boolean isUncommited(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(70);
        }
        return !this.isCommitted(document);
    }

    @Override
    public boolean isCommitted(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(71);
        }
        document = PsiDocumentManagerBase.getTopLevelDocument(document);
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return (!(document instanceof DocumentEx) || !((DocumentEx)document).isInEventsHandling()) && !this.isInUncommittedSet(document);
    }

    @NotNull
    private static Document getTopLevelDocument(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(72);
        }
        Document document2 = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(73);
        }
        return document2;
    }

    @Override
    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    @Override
    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (event == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(74);
        }
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile2 != null && this.isRelevant(virtualFile2);
        if (document instanceof DocumentImpl && !this.myUncommittedInfos.containsKey(document)) {
            this.myUncommittedInfos.put(document, new UncommittedInfo((DocumentImpl)document));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List<PsiFile> files2 = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file2 : files2) {
            if (file2 == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files2 + " for file " + viewProvider.getVirtualFile()));
            }
            if (!PsiToDocumentSynchronizer.isInsideAtomicChange(file2)) continue;
            psiCause = file2;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(75);
        }
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (event == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(76);
        }
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        boolean isRelevant = virtualFile2 != null && this.isRelevant(virtualFile2);
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document);
            return;
        }
        List<PsiFile> files2 = viewProvider.getAllFiles();
        if (files2.isEmpty()) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean commitNecessary = files2.stream().noneMatch(file2 -> PsiToDocumentSynchronizer.isInsideAtomicChange(file2) || !(file2 instanceof PsiFileImpl));
        boolean bl2 = forceCommit = ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty("idea.force.commit.on.external.change", false) || ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!((DocumentEx)document).isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, event, TransactionGuard.getInstance().getContextTransaction());
            }
        } else {
            this.clearUncommittedInfo(document);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document) {
        UncommittedInfo prevInfo;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(77);
        }
        if ((prevInfo = this.clearUncommittedInfo(document)) == null) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        if (!this.myProject.isInitialized() || this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile2 != null) {
            FileManager fileManager = this.getFileManager();
            FileViewProvider viewProvider = fileManager.findCachedViewProvider(virtualFile2);
            if (viewProvider != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ((AbstractFileViewProvider)viewProvider).onContentReload());
            } else if (FileIndexFacade.getInstance(this.myProject).isInContent(virtualFile2)) {
                ApplicationManager.getApplication().runWriteAction(() -> ((FileManagerImpl)fileManager).firePropertyChangedForUnloadedPsi());
            }
        }
        this.runAfterCommitActions(document);
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        UncommittedInfo info2;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(78);
        }
        if ((info2 = this.myUncommittedInfos.remove(document)) != null) {
            this.getSmartPointerManager().updatePointers(document, info2.myFrozen, info2.myEvents);
        }
        return info2;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance(this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(79);
        }
        return !virtualFile2.getFileType().isBinary() && !this.myProject.isDisposed();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i;
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(80);
        }
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(81);
        }
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context2 = InjectedLanguageManager.getInstance(psiFile.getProject()).getInjectionHost(psiFile);
            if (context2 != null) {
                error = error + "context: " + context2 + "; text: '" + context2.getText() + "'\n";
                error = error + "context file: " + context2.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    public void clearUncommittedDocuments() {
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(82);
        }
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register(parentDisposable, () -> {
            this.myPerformBackgroundCommit = true;
        });
    }

    @Override
    public void dispose() {
        this.clearUncommittedDocuments();
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        PsiToDocumentSynchronizer psiToDocumentSynchronizer = this.mySynchronizer;
        if (psiToDocumentSynchronizer == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(83);
        }
        return psiToDocumentSynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseFileFromText(@NotNull PsiFileImpl file2) {
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(84);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isCommitInProgress()) {
            throw new IllegalStateException("Re-entrant commit is not allowed");
        }
        FileElement node = file2.calcTreeElement();
        CharSequence text2 = node.getChars();
        ourIsFullReparseInProgress = true;
        try {
            WriteAction.run(() -> {
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                if (indicator == null) {
                    indicator = new EmptyProgressIndicator();
                }
                DiffLog log2 = BlockSupportImpl.makeFullParse((PsiFileImpl)file2, (FileASTNode)node, (CharSequence)text2, (ProgressIndicator)indicator, (CharSequence)text2).log;
                log2.doActualPsiChange(file2);
                file2.getViewProvider().contentsSynchronized();
            });
        }
        finally {
            ourIsFullReparseInProgress = false;
        }
    }

    @NotNull
    List<BooleanRunnable> reparseChangedInjectedFragments(@NotNull Document hostDocument, @NotNull PsiFile hostPsiFile, @NotNull TextRange range, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        if (hostDocument == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(85);
        }
        if (hostPsiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(86);
        }
        if (range == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(87);
        }
        if (indicator == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(88);
        }
        if (oldRoot == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(89);
        }
        if (newRoot == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(90);
        }
        List<BooleanRunnable> list2 = Collections.emptyList();
        if (list2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(91);
        }
        return list2;
    }

    static {
        PERFORM_ALWAYS_KEY = ObjectUtils.sentinel("PERFORM_ALWAYS");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 15: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 83: 
            case 91: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 15: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 83: 
            case 91: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentCommitProcessor";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 39: 
            case 47: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfo";
                break;
            }
            case 7: 
            case 15: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 83: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 13: 
            case 14: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: 
            case 17: 
            case 54: 
            case 58: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 26: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 28: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparseInjectedProcessors";
                break;
            }
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 42: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureValidFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedText";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedDocument";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSinceCommit";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncommittedDocuments";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelDocument";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynchronizer";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "reparseChangedInjectedFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidFile";
                break;
            }
            case 7: 
            case 15: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 83: 
            case 91: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cachePsi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "associatePsi";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCachedViewProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doCommitWithoutReparse";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "performForCommittedDocument";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRunWhenAllCommitted";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addRunOnCommit";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAndClearActionsAfterCommit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "finishCommit";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "finishCommitInWriteAction";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "commitToExistingPsi";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkAllElementsValid";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "commitAndRunReadAction";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reparseFiles";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "performWhenAllCommitted";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "performLaterWhenAllCommitted";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "runAfterCommitActions";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentBlockedByPsi";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedOperationsAndUnblockDocument";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fireDocumentCreated";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fireFileCreated";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedText";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedStamp";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedDocument";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getEventsSinceCommit";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isInUncommittedSet";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isUncommited";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isCommitted";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelDocument";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChangeOnUnlockedDocument";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "clearUncommittedInfo";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isRelevant";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "checkConsistency";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "disableBackgroundCommit";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "reparseFileFromText";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "reparseChangedInjectedFragments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 15: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 83: 
            case 91: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UncommittedInfo {
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents;
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows;

        private UncommittedInfo(@NotNull DocumentImpl original) {
            if (original == null) {
                UncommittedInfo.$$$reportNull$$$0(0);
            }
            this.myEvents = ContainerUtil.newArrayList();
            this.myFrozenWindows = ContainerUtil.newConcurrentMap();
            this.myFrozen = original.freeze();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/PsiDocumentManagerBase$UncommittedInfo", "<init>"));
        }
    }

    class PriorityEventCollector
    implements PrioritizedInternalDocumentListener {
        final /* synthetic */ PsiDocumentManagerBase this$0;

        @Override
        public int getPriority() {
            return 40;
        }

        public void moveTextHappened(@NotNull Document document, int start, int end, int base) {
            UncommittedInfo info2;
            if (document == null) {
                PriorityEventCollector.$$$reportNull$$$0(0);
            }
            if ((info2 = (UncommittedInfo)this.this$0.myUncommittedInfos.get(document)) != null) {
                info2.myEvents.add(new RetargetRangeMarkers(document, start, end, base));
            }
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent event) {
            UncommittedInfo info2;
            if (event == null) {
                PriorityEventCollector.$$$reportNull$$$0(1);
            }
            if ((info2 = (UncommittedInfo)this.this$0.myUncommittedInfos.get(event.getDocument())) != null) {
                info2.myEvents.add(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerBase$PriorityEventCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveTextHappened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable : this) {
                runnable.run();
            }
        }
    }
}

