/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.NotNullizer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeTraversal {
    private static final NotNullizer ourNotNullizer = new NotNullizer("TreeTraversal.NotNull");
    private final String debugName;
    @NotNull
    public static final TreeTraversal BI_ORDER_DFS = new TreeTraversal("BI_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                5.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                5.$$$reportNull$$$0(1);
            }
            BiOrderIt<? super T> biOrderIt = new BiOrderIt<T>(roots2, tree, BiOrderIt.Order.BOTH);
            if (biOrderIt == null) {
                5.$$$reportNull$$$0(2);
            }
            return biOrderIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$5";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    public static final TreeTraversal PRE_ORDER_DFS = new TreeTraversal("PRE_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                6.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                6.$$$reportNull$$$0(1);
            }
            BiOrderIt<? super T> biOrderIt = new BiOrderIt<T>(roots2, tree, BiOrderIt.Order.PRE);
            if (biOrderIt == null) {
                6.$$$reportNull$$$0(2);
            }
            return biOrderIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$6";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$6";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    public static final TreeTraversal POST_ORDER_DFS = new TreeTraversal("POST_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                7.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                7.$$$reportNull$$$0(1);
            }
            BiOrderIt<? super T> biOrderIt = new BiOrderIt<T>(roots2, tree, BiOrderIt.Order.POST);
            if (biOrderIt == null) {
                7.$$$reportNull$$$0(2);
            }
            return biOrderIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$7";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$7";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_DFS = new TreeTraversal("LEAVES_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                8.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                8.$$$reportNull$$$0(1);
            }
            LeavesDfsIt<? super T> leavesDfsIt = new LeavesDfsIt<T>(roots2, tree);
            if (leavesDfsIt == null) {
                8.$$$reportNull$$$0(2);
            }
            return leavesDfsIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$8";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$8";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    public static final TreeTraversal INTERLEAVED_DFS = new TreeTraversal("INTERLEAVED_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                9.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                9.$$$reportNull$$$0(1);
            }
            InterleavedIt<? super T> interleavedIt = new InterleavedIt<T>(roots2, tree);
            if (interleavedIt == null) {
                9.$$$reportNull$$$0(2);
            }
            return interleavedIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$9";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$9";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    public static final TreeTraversal PLAIN_BFS = new TreeTraversal("PLAIN_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                10.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                10.$$$reportNull$$$0(1);
            }
            PlainBfsIt<? super T> plainBfsIt = new PlainBfsIt<T>(roots2, tree);
            if (plainBfsIt == null) {
                10.$$$reportNull$$$0(2);
            }
            return plainBfsIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$10";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$10";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    public static final TreeTraversal TRACING_BFS = new TreeTraversal("TRACING_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                11.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                11.$$$reportNull$$$0(1);
            }
            TracingBfsIt<? super T> tracingBfsIt = new TracingBfsIt<T>(roots2, tree);
            if (tracingBfsIt == null) {
                11.$$$reportNull$$$0(2);
            }
            return tracingBfsIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$11";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$11";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_BFS = new TreeTraversal("LEAVES_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                12.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                12.$$$reportNull$$$0(1);
            }
            LeavesBfsIt<? super T> leavesBfsIt = new LeavesBfsIt<T>(roots2, tree);
            if (leavesBfsIt == null) {
                12.$$$reportNull$$$0(2);
            }
            return leavesBfsIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$12";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$12";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    protected TreeTraversal(@NotNull String debugName) {
        if (debugName == null) {
            TreeTraversal.$$$reportNull$$$0(0);
        }
        this.debugName = debugName;
    }

    @NotNull
    public final <T> JBIterable<T> traversal(final @NotNull Iterable<? extends T> roots2, final @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
        if (roots2 == null) {
            TreeTraversal.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            TreeTraversal.$$$reportNull$$$0(2);
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                It it = TreeTraversal.this.createIterator(roots2, tree);
                if (it == null) {
                    1.$$$reportNull$$$0(0);
                }
                return it;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$1", "iterator"));
            }
        };
        if (jBIterable == null) {
            TreeTraversal.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> traversal(@Nullable T root2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            TreeTraversal.$$$reportNull$$$0(4);
        }
        JBIterable<? super T> jBIterable = this.traversal((T)ContainerUtil.createMaybeSingletonList(root2), tree);
        if (jBIterable == null) {
            TreeTraversal.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public TreeTraversal unique(final @NotNull Function<?, ?> identity) {
        if (identity == null) {
            TreeTraversal.$$$reportNull$$$0(9);
        }
        final TreeTraversal original = this;
        TreeTraversal treeTraversal = new TreeTraversal(this.debugName + " (UNIQUE)"){

            @Override
            @NotNull
            public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, final @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
                if (roots2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (tree == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (tree instanceof WrappedTree) {
                    It<? super T> it = original.createIterator(roots2, tree);
                    if (it == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return it;
                }
                class WrappedTree
                implements Condition<T>,
                Function<T, Iterable<? extends T>> {
                    HashSet<Object> visited;

                    WrappedTree() {
                    }

                    @Override
                    public boolean value(T e) {
                        if (this.visited == null) {
                            this.visited = new HashSet();
                        }
                        return this.visited.add(identity.fun(e));
                    }

                    @Override
                    public Iterable<? extends T> fun(T t) {
                        return JBIterable.from((Iterable)tree.fun(t)).filter(this);
                    }
                }
                WrappedTree wrappedTree = new WrappedTree();
                It<? extends T> it = original.createIterator(JBIterable.from(roots2).filter(wrappedTree), wrappedTree);
                if (it == null) {
                    2.$$$reportNull$$$0(3);
                }
                return it;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "roots";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/containers/TreeTraversal$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/containers/TreeTraversal$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createIterator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createIterator";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (treeTraversal == null) {
            TreeTraversal.$$$reportNull$$$0(10);
        }
        return treeTraversal;
    }

    @NotNull
    public <T> TreeTraversal onRange(final @NotNull Condition<T> rangeCondition) {
        if (rangeCondition == null) {
            TreeTraversal.$$$reportNull$$$0(11);
        }
        final TreeTraversal original = this;
        TreeTraversal treeTraversal = new TreeTraversal(original.toString() + " (ON_RANGE)"){

            @Override
            @NotNull
            public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, final @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
                if (roots2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (tree == null) {
                    3.$$$reportNull$$$0(1);
                }
                final Condition inRangeCondition = rangeCondition;
                final Condition notInRangeCondition = Conditions.not(rangeCondition);
                if (tree instanceof WrappedTree) {
                    It<? super T> it = original.createIterator(roots2, tree);
                    if (it == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return it;
                }
                class WrappedTree
                implements Function<T, Iterable<? extends T>> {
                    WrappedTree() {
                    }

                    @Override
                    public Iterable<? extends T> fun(T t) {
                        return JBIterable.from((Iterable)tree.fun(t)).skipWhile(notInRangeCondition).takeWhile(inRangeCondition);
                    }
                }
                WrappedTree wrappedTree = new WrappedTree();
                It<? extends T> it = original.createIterator(JBIterable.from(roots2).filter(inRangeCondition), wrappedTree);
                if (it == null) {
                    3.$$$reportNull$$$0(3);
                }
                return it;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "roots";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/containers/TreeTraversal$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/containers/TreeTraversal$3";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createIterator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createIterator";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (treeTraversal == null) {
            TreeTraversal.$$$reportNull$$$0(12);
        }
        return treeTraversal;
    }

    @NotNull
    public abstract <T> It<T> createIterator(@NotNull Iterable<? extends T> var1, @NotNull Function<? super T, ? extends Iterable<? extends T>> var2);

    public final String toString() {
        return this.debugName;
    }

    @NotNull
    public static TreeTraversal GUIDED_TRAVERSAL(final @NotNull GuidedIt.Guide<?> guide) {
        if (guide == null) {
            TreeTraversal.$$$reportNull$$$0(13);
        }
        TreeTraversal treeTraversal = new TreeTraversal("GUIDED_TRAVERSAL"){

            @Override
            @NotNull
            public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
                if (roots2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (tree == null) {
                    4.$$$reportNull$$$0(1);
                }
                GuidedItImpl<? super T> guidedItImpl = new GuidedItImpl<T>(roots2, tree, guide);
                if (guidedItImpl == null) {
                    4.$$$reportNull$$$0(2);
                }
                return guidedItImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "roots";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/containers/TreeTraversal$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/containers/TreeTraversal$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createIterator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createIterator";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (treeTraversal == null) {
            TreeTraversal.$$$reportNull$$$0(14);
        }
        return treeTraversal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/TreeTraversal";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeCondition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/TreeTraversal";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "traversal";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "onRange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "GUIDED_TRAVERSAL";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "traversal";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "GUIDED_TRAVERSAL";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class P2<T>
    extends P<T, P2<T>> {
        P2<T> next;
        P2<T> prev;

        private P2() {
        }

        static <T> P2<T> create(T node) {
            return P2.create(new P2<T>(), node);
        }

        static <T> P2<T> create(Iterable<? extends T> it) {
            return P2.create(new P2<T>(), it);
        }

        P2<T> add(@NotNull P2<T> next) {
            if (next == null) {
                P2.$$$reportNull$$$0(0);
            }
            next.next = this.next;
            next.prev = this;
            this.next = next;
            return next;
        }

        P2<T> remove() {
            P2<T> p = this.prev;
            P2<T> n = this.next;
            this.next = null;
            this.prev = null;
            if (p != null) {
                p.next = n;
            }
            if (n != null) {
                n.prev = p;
            }
            return p;
        }

        public String toString() {
            int h = 0;
            int t = 0;
            P2<T> p = this.prev;
            while (p != null) {
                ++h;
                p = p.prev;
            }
            p = this.next;
            while (p != null) {
                ++t;
                p = p.next;
            }
            return h + " of " + (h + t + 1) + ": " + this.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/util/containers/TreeTraversal$P2", "add"));
        }
    }

    private static final class P1<T>
    extends P<T, P1<T>> {
        private P1() {
        }

        static <T> P1<T> create(T node) {
            return P1.create(new P1<T>(), node);
        }

        static <T> P1<T> create(Iterable<? extends T> it) {
            return P1.create(new P1<T>(), it);
        }

        P1<T> add(@NotNull P1<T> next) {
            if (next == null) {
                P1.$$$reportNull$$$0(0);
            }
            next.parent = this;
            return next;
        }

        P1<T> remove() {
            P1 p = (P1)this.parent;
            return p;
        }

        public String toString() {
            int h = 0;
            P1 p = (P1)this.parent;
            while (p != null) {
                ++h;
                p = (P1)p.parent;
            }
            return h + ": " + this.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "next";
            objectArray2[1] = "com/intellij/util/containers/TreeTraversal$P1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addBefore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class P<T, Self extends P<T, Self>> {
        T node;
        Iterable<? extends T> itle;
        Iterator<? extends T> it;
        boolean empty;
        Self parent;
        static final Function TO_NODE = tp -> tp.node;
        static final Function TO_PREV = new Function.Mono<P<?, ?>>(){

            @Override
            public P<?, ?> fun(P<?, ?> tp) {
                return tp.parent;
            }
        };

        private P() {
        }

        static <T, Self extends P<T, Self>> Self create(Self p, T node) {
            p.node = node;
            return p;
        }

        static <T, Self extends P<T, Self>> Self create(Self p, Iterable<? extends T> it) {
            p.itle = it;
            return p;
        }

        final Iterator<? extends T> iterator(@NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (tree == null) {
                P.$$$reportNull$$$0(0);
            }
            if (this.it != null) {
                return this.it;
            }
            this.it = this.iterable(tree).iterator();
            this.empty = this.itle == null || !this.it.hasNext();
            return this.it;
        }

        final Iterable<? extends T> iterable(@NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            Iterable<? extends T> iterable;
            if (tree == null) {
                P.$$$reportNull$$$0(1);
            }
            if (this.itle != null) {
                iterable = this.itle;
            } else {
                this.itle = tree.fun(this.node);
                iterable = JBIterable.from(this.itle);
            }
            return iterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/util/containers/TreeTraversal$P";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class GuidedItImpl<T>
    extends GuidedIt<T> {
        final GuidedIt.Guide<T> guide;
        P1<T> first;
        P1<T> last;
        T curResult;

        GuidedItImpl(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree, @NotNull GuidedIt.Guide<T> guide) {
            if (roots2 == null) {
                GuidedItImpl.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                GuidedItImpl.$$$reportNull$$$0(1);
            }
            if (guide == null) {
                GuidedItImpl.$$$reportNull$$$0(2);
            }
            super(tree);
            this.last = P1.create(roots2);
            this.first = this.last;
            this.guide = guide;
        }

        @Override
        public GuidedIt<T> queueNext(T child) {
            if (child != null) {
                this.last = this.last.add(P1.create(child));
            }
            return this;
        }

        @Override
        public GuidedIt<T> result(T node) {
            this.curResult = node;
            return this;
        }

        @Override
        public T nextImpl() {
            if (this.guide == null) {
                return (T)this.stop();
            }
            while (this.last != null) {
                P1<T> top = this.last;
                Iterator it = top.iterator(this.tree);
                boolean hasNext = it.hasNext();
                this.curResult = null;
                if (top.node != null || hasNext) {
                    this.curChild = hasNext ? it.next() : null;
                    this.curParent = top.node;
                    this.curChildren = top.itle;
                    this.curNoChildren = top.empty;
                    this.guide.guide(this);
                }
                if (!hasNext) {
                    this.last = this.last.remove();
                }
                if (this.curResult == null) continue;
                return this.curResult;
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "guide";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$GuidedItImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TracingBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue;
        final Map<T, T> paths;
        P1<T> top;
        P1<T> cur;

        TracingBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                TracingBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.queue = new ArrayDeque();
            this.paths = ContainerUtil.newIdentityHashMap();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.queue);
        }

        @Override
        protected void currentChanged() {
            this.cur = this.top;
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                for (Object t : this.top.iterable(this.tree)) {
                    if (this.paths.containsKey(t)) continue;
                    this.queue.add(ourNotNullizer.notNullize(t));
                    this.paths.put(t, this.top.node);
                }
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(ourNotNullizer.nullize(this.queue.remove()));
            return (T)this.top.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$TracingBfsIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$TracingBfsIt";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "backtrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class LeavesBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue;

        LeavesBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                LeavesBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.queue = new ArrayDeque();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            while (!this.queue.isEmpty()) {
                Iterator it;
                T result2 = ourNotNullizer.nullize(this.queue.remove());
                Iterable children2 = (Iterable)this.tree.fun(result2);
                Iterator iterator2 = it = children2 == null ? null : children2.iterator();
                if (it == null || !it.hasNext()) {
                    return result2;
                }
                while (it.hasNext()) {
                    this.queue.add(ourNotNullizer.notNullize(it.next()));
                }
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesBfsIt", "<init>"));
        }
    }

    private static final class PlainBfsIt<T>
    extends It<T> {
        final ArrayDeque<T> queue;
        P1<T> top;

        PlainBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                PlainBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.queue = new ArrayDeque();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                JBIterable.from(this.top.iterable(this.tree)).map(ourNotNullizer::notNullize).addAllTo(this.queue);
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(ourNotNullizer.nullize(this.queue.remove()));
            return (T)this.top.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$PlainBfsIt", "<init>"));
        }
    }

    private static final class InterleavedIt<T>
    extends DfsIt<T, P2<T>> {
        P2<T> cur;
        P2<T> max;

        InterleavedIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                InterleavedIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.last = P2.create(roots2);
            this.cur = this.max = (P2)this.last;
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Iterator it;
                if (this.cur == null) {
                    this.cur = this.max;
                    this.max = this.max.next;
                }
                if ((it = this.cur.iterator(this.tree)).hasNext()) {
                    Object result2 = it.next();
                    this.last = ((P2)this.last).add(P2.create(result2));
                    ((P2)this.last).parent = this.cur;
                    this.cur = this.cur.prev;
                    if (this.max == null) {
                        this.max = (P2)this.last;
                    }
                    return result2;
                }
                if (this.cur == this.last) {
                    this.last = this.cur.prev;
                }
                this.cur = this.cur.remove();
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$InterleavedIt", "<init>"));
        }
    }

    private static final class LeavesDfsIt<T>
    extends DfsIt<T, P1<T>> {
        LeavesDfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                LeavesDfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.last = P1.create(roots2);
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                P1 top = (P1)this.last;
                if (top.iterator(this.tree).hasNext() && !top.empty) {
                    Object child = top.iterator(this.tree).next();
                    this.last = ((P1)this.last).add(P1.create(child));
                    continue;
                }
                this.last = ((P1)this.last).remove();
                if (!top.empty) continue;
                return (T)(this.last == null ? this.stop() : top.node);
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesDfsIt", "<init>"));
        }
    }

    private static final class BiOrderIt<T>
    extends DfsIt<T, P1<T>> {
        private final Order order;
        private boolean curDescending;
        private boolean descending;

        BiOrderIt(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree, @NotNull Order order2) {
            if (roots2 == null) {
                BiOrderIt.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                BiOrderIt.$$$reportNull$$$0(1);
            }
            if (order2 == null) {
                BiOrderIt.$$$reportNull$$$0(2);
            }
            super(tree);
            this.descending = true;
            this.order = order2;
            this.last = P1.create(roots2);
        }

        @Override
        protected void currentChanged() {
            super.currentChanged();
            this.curDescending = this.descending;
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Object result2;
                Iterator it = ((P1)this.last).iterator(this.tree);
                if (it.hasNext()) {
                    result2 = it.next();
                    this.last = ((P1)this.last).add(P1.create(result2));
                    this.descending = true;
                    if (this.order == Order.POST) continue;
                    return result2;
                }
                result2 = ((P1)this.last).node;
                this.last = ((P1)this.last).remove();
                this.descending = false;
                if (this.order == Order.PRE || this.last == null) continue;
                return result2;
            }
            this.descending = true;
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "order";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$BiOrderIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$BiOrderIt";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "backtrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum Order {
            PRE,
            POST,
            BOTH;

        }
    }

    private static abstract class DfsIt<T, H extends P<T, H>>
    extends TracingIt<T> {
        H last;
        H cur;

        protected DfsIt(Function<? super T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        @Override
        protected void currentChanged() {
            this.cur = this.last;
        }
    }

    public static abstract class GuidedIt<T>
    extends It<T> {
        @Nullable
        public T curChild;
        @Nullable
        public T curParent;
        @Nullable
        public Iterable<? extends T> curChildren;
        public boolean curNoChildren;

        public abstract GuidedIt<T> queueNext(@Nullable T var1);

        public abstract GuidedIt<T> result(@Nullable T var1);

        protected GuidedIt(Function<? super T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        public static interface Guide<T> {
            public void guide(@NotNull GuidedIt<T> var1);
        }
    }

    public static abstract class TracingIt<T>
    extends It<T> {
        protected TracingIt(Function<? super T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }
    }

    public static abstract class It<T>
    extends JBIterator<T> {
        protected final Function<? super T, ? extends Iterable<? extends T>> tree;

        protected It(Function<? super T, ? extends Iterable<? extends T>> tree) {
            this.tree = tree;
        }
    }
}

