/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.DescriptorBasedFunctionHandle;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a4\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\b0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\t0\f\u00a8\u0006\r"}, d2={"findImplementationFromInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "findInterfaceImplementation", "firstSuperMethodFromKotlin", "implementation", "generateBridgesForFunctionDescriptor", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "signature", "Lkotlin/Function1;", "backend-common"})
public final class ImplKt {
    @NotNull
    public static final <Signature> Set<Bridge<Signature>> generateBridgesForFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull Function1<? super FunctionDescriptor, ? extends Signature> signature) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        return BridgesKt.generateBridges((FunctionHandle)new DescriptorBasedFunctionHandle(descriptor2), new Function1<DescriptorBasedFunctionHandle, Signature>(signature){
            final /* synthetic */ Function1 $signature;

            public final Signature invoke(@NotNull DescriptorBasedFunctionHandle it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return (Signature)this.$signature.invoke(it.getDescriptor());
            }
            {
                this.$signature = function1;
                super(1);
            }
        });
    }

    @Nullable
    public static final CallableMemberDescriptor findInterfaceImplementation(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        CallableMemberDescriptor.Kind kind = descriptor2.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)kind, "descriptor.kind");
        if (kind.isReal()) {
            return null;
        }
        if (CallResolverUtilKt.isOrOverridesSynthesized(descriptor2)) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = ImplKt.findImplementationFromInterface(descriptor2);
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor implementation = callableMemberDescriptor;
        CallableMemberDescriptor callableMemberDescriptor2 = ImplKt.firstSuperMethodFromKotlin(descriptor2, implementation);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor immediateConcreteSuper = callableMemberDescriptor2;
        if (!DescriptorUtils.isInterface(immediateConcreteSuper.getContainingDeclaration())) {
            return null;
        }
        return immediateConcreteSuper;
    }

    @Nullable
    public static final CallableMemberDescriptor findImplementationFromInterface(@NotNull CallableMemberDescriptor descriptor2) {
        Object v3;
        block3: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations(descriptor2);
            Intrinsics.checkExpressionValueIsNotNull(set, "OverridingUtil.getOverri\u2026nDeclarations(descriptor)");
            Set<CallableMemberDescriptor> overridden = set;
            Set<CallableMemberDescriptor> set2 = OverridingUtil.filterOutOverridden(overridden);
            Intrinsics.checkExpressionValueIsNotNull(set2, "OverridingUtil.filterOutOverridden(overridden)");
            Set<CallableMemberDescriptor> filtered = set2;
            Iterable $this$firstOrNull$iv = filtered;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                CallableMemberDescriptor callableMemberDescriptor = it;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                if (!(callableMemberDescriptor.getModality() != Modality.ABSTRACT)) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = v3;
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor result2 = callableMemberDescriptor;
        if (DescriptorUtils.isClassOrEnumClass(result2.getContainingDeclaration())) {
            return null;
        }
        return result2;
    }

    @Nullable
    public static final CallableMemberDescriptor firstSuperMethodFromKotlin(@NotNull CallableMemberDescriptor descriptor2, @NotNull CallableMemberDescriptor implementation) {
        Object v2;
        block1: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(implementation, "implementation");
            Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "descriptor.overriddenDescriptors");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CallableMemberDescriptor overridden = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                CallableMemberDescriptor callableMemberDescriptor = overridden;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "overridden");
                if (!(callableMemberDescriptor.getModality() != Modality.ABSTRACT && (Intrinsics.areEqual(overridden, implementation) || OverridingUtil.overrides((CallableDescriptor)overridden, (CallableDescriptor)implementation)))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }
}

