/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\r\u0010\b\u001a\u00020\t*\u00020\u0002H\u0080\u0010\u001a\n\u0010\n\u001a\u00020\u0002*\u00020\u0002\u001a!\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e*\u0002H\rH\u0000\u00a2\u0006\u0002\u0010\u000f\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0010"}, d2={"isExpectMember", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isForwardDeclarationModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Z", "isSerializableExpectClass", "findPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "findTopLevelDescriptor", "resolveFakeOverrideMaybeAbstract", "", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Ljava/util/Set;", "ir.serialization.common"})
public final class LegacyDescriptorUtilsKt {
    public static final boolean isExpectMember(@NotNull DeclarationDescriptor $this$isExpectMember) {
        Intrinsics.checkParameterIsNotNull($this$isExpectMember, "$this$isExpectMember");
        return $this$isExpectMember instanceof MemberDescriptor && ((MemberDescriptor)$this$isExpectMember).isExpect();
    }

    public static final boolean isSerializableExpectClass(@NotNull DeclarationDescriptor $this$isSerializableExpectClass) {
        Intrinsics.checkParameterIsNotNull($this$isSerializableExpectClass, "$this$isSerializableExpectClass");
        return $this$isSerializableExpectClass instanceof ClassDescriptor && ExpectedActualDeclarationChecker.Companion.shouldGenerateExpectClass((ClassDescriptor)$this$isSerializableExpectClass);
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        while (true) {
            Intrinsics.checkParameterIsNotNull($this$findPackage, "$this$findPackage");
            if ($this$findPackage instanceof PackageFragmentDescriptor) break;
            if ($this$findPackage.getContainingDeclaration() == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull($this$findPackage, "this.containingDeclaration!!");
        }
        return (PackageFragmentDescriptor)$this$findPackage;
    }

    @NotNull
    public static final DeclarationDescriptor findTopLevelDescriptor(@NotNull DeclarationDescriptor $this$findTopLevelDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($this$findTopLevelDescriptor, "$this$findTopLevelDescriptor");
        if ($this$findTopLevelDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            declarationDescriptor = DescriptorUtilsKt.getPropertyIfAccessor($this$findTopLevelDescriptor);
        } else {
            DeclarationDescriptor declarationDescriptor2 = $this$findTopLevelDescriptor.getContainingDeclaration();
            if (declarationDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "this.containingDeclaration!!");
            declarationDescriptor = LegacyDescriptorUtilsKt.findTopLevelDescriptor(declarationDescriptor2);
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final <T extends CallableMemberDescriptor> Set<T> resolveFakeOverrideMaybeAbstract(@NotNull T $this$resolveFakeOverrideMaybeAbstract) {
        Set<CallableMemberDescriptor> filtered;
        Intrinsics.checkParameterIsNotNull($this$resolveFakeOverrideMaybeAbstract, "$this$resolveFakeOverrideMaybeAbstract");
        CallableMemberDescriptor.Kind kind = $this$resolveFakeOverrideMaybeAbstract.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)kind, "this.kind");
        if (kind.isReal()) {
            return SetsKt.setOf($this$resolveFakeOverrideMaybeAbstract);
        }
        Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations($this$resolveFakeOverrideMaybeAbstract);
        Intrinsics.checkExpressionValueIsNotNull(set, "OverridingUtil.getOverriddenDeclarations(this)");
        Set<CallableMemberDescriptor> overridden = set;
        Set<CallableMemberDescriptor> set2 = OverridingUtil.filterOutOverridden(overridden);
        Intrinsics.checkExpressionValueIsNotNull(set2, "OverridingUtil.filterOutOverridden(overridden)");
        Set<CallableMemberDescriptor> set3 = filtered = set2;
        if (set3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<T>");
        }
        return set3;
    }

    public static final boolean isForwardDeclarationModule(@NotNull ModuleDescriptor $this$isForwardDeclarationModule) {
        Intrinsics.checkParameterIsNotNull($this$isForwardDeclarationModule, "$this$isForwardDeclarationModule");
        return Intrinsics.areEqual($this$isForwardDeclarationModule.getName(), Name.special("<forward declarations>"));
    }
}

