/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.FirProvider;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassDeclaredMemberScope;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001e\u001a\u00020!H\u0016J\"\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\f2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\rJ\u0018\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/impl/FirProviderImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "state", "Lorg/jetbrains/kotlin/fir/resolve/impl/FirProviderImpl$State;", "ensureConsistent", "", "files", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getClassDeclaredMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirClassDeclaredMemberScope;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassUseSiteMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "useSiteSession", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "fqName", "getFirClassifierContainerFile", "getFirFilesByPackage", "Lorg/jetbrains/kotlin/name/FqName;", "getTopLevelCallableSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "recordFile", "file", "State", "resolve"})
public final class FirProviderImpl
extends FirProvider {
    private final State state;
    @NotNull
    private final FirSession session;

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull ConeCallableSymbol symbol2) {
        Intrinsics.checkParameterIsNotNull(symbol2, "symbol");
        return this.state.getCallableContainerMap().get(symbol2);
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FirMemberDeclaration firMemberDeclaration = this.getFirClassifierByFqName(classId);
        return firMemberDeclaration != null ? firMemberDeclaration.getSymbol() : null;
    }

    @Override
    @NotNull
    public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(name, "name");
        List<FirCallableSymbol<Object>> list2 = this.state.getCallableMap().get(new CallableId(packageFqName, null, name));
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @Nullable
    public FirClassDeclaredMemberScope getClassDeclaredMemberScope(@NotNull ClassId classId) {
        FirClassDeclaredMemberScope firClassDeclaredMemberScope;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FirMemberDeclaration firMemberDeclaration = this.getFirClassifierByFqName(classId);
        if (!(firMemberDeclaration instanceof FirRegularClass)) {
            firMemberDeclaration = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firMemberDeclaration;
        if (firRegularClass != null) {
            FirRegularClass firRegularClass2 = firRegularClass;
            boolean bl = false;
            boolean bl2 = false;
            FirRegularClass p1 = firRegularClass2;
            boolean bl3 = false;
            firClassDeclaredMemberScope = new FirClassDeclaredMemberScope(p1);
        } else {
            firClassDeclaredMemberScope = null;
        }
        return firClassDeclaredMemberScope;
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        FirFile firFile = this.state.getClassifierContainerFileMap().get(fqName2);
        if (firFile == null) {
            String string = "Couldn't find container for " + fqName2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return firFile;
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        this.recordFile(file2, this.state);
    }

    private final void recordFile(FirFile file2, State state) {
        FqName packageName = file2.getPackageFqName();
        state.getFileMap().merge(packageName, CollectionsKt.listOf(file2), recordFile.1.INSTANCE);
        file2.acceptChildren(new FirVisitorVoid(state, file2){
            final /* synthetic */ State $state;
            final /* synthetic */ FirFile $file;

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
            }

            public void visitRegularClass(@NotNull FirRegularClass regularClass) {
                Intrinsics.checkParameterIsNotNull(regularClass, "regularClass");
                ClassId classId = regularClass.getSymbol().getClassId();
                this.$state.getClassifierMap().put(classId, regularClass);
                this.$state.getClassifierContainerFileMap().put(classId, this.$file);
                regularClass.acceptChildren(this);
            }

            public void visitTypeAlias(@NotNull FirTypeAlias typeAlias) {
                Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
                ClassId classId = typeAlias.getSymbol().getClassId();
                this.$state.getClassifierMap().put(classId, typeAlias);
                this.$state.getClassifierContainerFileMap().put(classId, this.$file);
            }

            public <F extends FirCallableMemberDeclaration<F>> void visitCallableMemberDeclaration(@NotNull FirCallableMemberDeclaration<F> callableMemberDeclaration) {
                Intrinsics.checkParameterIsNotNull(callableMemberDeclaration, "callableMemberDeclaration");
                FirCallableSymbol<F> symbol2 = callableMemberDeclaration.getSymbol();
                CallableId callableId = symbol2.getCallableId();
                this.$state.getCallableMap().merge(callableId, CollectionsKt.listOf(symbol2), recordFile.visitCallableMemberDeclaration.1.INSTANCE);
                this.$state.getCallableContainerMap().put(symbol2, this.$file);
            }

            public void visitConstructor(@NotNull FirConstructor constructor) {
                Intrinsics.checkParameterIsNotNull(constructor, "constructor");
                this.visitCallableMemberDeclaration(constructor);
            }

            public void visitNamedFunction(@NotNull FirNamedFunction namedFunction) {
                Intrinsics.checkParameterIsNotNull(namedFunction, "namedFunction");
                this.visitCallableMemberDeclaration(namedFunction);
            }

            public void visitProperty(@NotNull FirProperty property) {
                Intrinsics.checkParameterIsNotNull(property, "property");
                this.visitCallableMemberDeclaration(property);
            }
            {
                this.$state = $captured_local_variable$0;
                this.$file = $captured_local_variable$1;
            }
        });
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<FirFile> list2 = this.state.getFileMap().get(fqName2);
        boolean bl = false;
        List<FirFile> list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration<?> getFirClassifierByFqName(@NotNull ClassId fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.state.getClassifierMap().get(fqName2);
    }

    public final void ensureConsistent(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, "files");
        State newState = new State();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            this.recordFile(it, newState);
        }
        $i$f$forEach = false;
        List failures = new ArrayList();
        Function4 $fun$checkMapDiff$2 = new Function4<String, Map<K, ? extends V>, Map<K, ? extends V>, Function2<? super V, ? super V, ? extends Boolean>, Unit>(failures){
            final /* synthetic */ List $failures;

            /*
             * WARNING - void declaration
             */
            public final <K, V> void invoke(@NotNull String title, @NotNull Map<K, ? extends V> a, @NotNull Map<K, ? extends V> b, @NotNull Function2<? super V, ? super V, Boolean> equal) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(title, "title");
                Intrinsics.checkParameterIsNotNull(a, "a");
                Intrinsics.checkParameterIsNotNull(b, "b");
                Intrinsics.checkParameterIsNotNull(equal, "equal");
                boolean hasTitle = false;
                Set<K> unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
                Iterable $this$map$iv = unionKeys;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Triple<void, V, V> triple = new Triple<void, V, V>(it, a.get(it), b.get(it));
                    collection.add(triple);
                }
                for (Triple triple : (List)destination$iv$iv) {
                    Collection collection;
                    C bValue;
                    A key = triple.component1();
                    B aValue = triple.component2();
                    if (equal.invoke(aValue, bValue = triple.component3()).booleanValue()) continue;
                    if (!hasTitle) {
                        collection = this.$failures;
                        boolean bl = false;
                        collection.add(title);
                        hasTitle = true;
                    }
                    collection = this.$failures;
                    String string = "diff at key = '" + key + "': was: '" + aValue + "', become: '" + bValue + '\'';
                    boolean bl = false;
                    collection.add(string);
                }
            }

            public static /* synthetic */ void invoke$default(ensureConsistent.2 var0, String string, Map map2, Map map3, Function2 function2, int n, Object object) {
                if ((n & 8) != 0) {
                    function2 = ensureConsistent.1.INSTANCE;
                }
                var0.invoke(string, map2, map3, function2);
            }
            {
                this.$failures = list2;
                super(4);
            }
        };
        Function3 $fun$checkMMapDiff$3 = new Function3<String, Map<K, ? extends List<? extends V>>, Map<K, ? extends List<? extends V>>, Unit>(failures){
            final /* synthetic */ List $failures;

            /*
             * WARNING - void declaration
             */
            public final <K, V> void invoke(@NotNull String title, @NotNull Map<K, ? extends List<? extends V>> a, @NotNull Map<K, ? extends List<? extends V>> b) {
                Collection it;
                boolean $i$a$-map-FirProviderImpl$ensureConsistent$3$22;
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(title, "title");
                Intrinsics.checkParameterIsNotNull(a, "a");
                Intrinsics.checkParameterIsNotNull(b, "b");
                boolean hasTitle = false;
                Set<K> unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
                Iterable $this$map$iv = unionKeys;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo2 = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    T item$iv$iv;
                    T t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                    Triple<void, List<? extends V>, List<? extends V>> triple = new Triple<void, List<? extends V>, List<? extends V>>((void)it, a.get(it), b.get(it));
                    collection.add(triple);
                }
                for (Triple triple : (List)destination$iv$iv) {
                    boolean bl;
                    String string;
                    Collection collection;
                    T it2;
                    T element$iv;
                    A key = triple.component1();
                    List aValue = (List)triple.component2();
                    List bValue = (List)triple.component3();
                    if (aValue == null || bValue == null) {
                        if (!hasTitle) {
                            destination$iv$iv = this.$failures;
                            $i$f$mapTo2 = false;
                            destination$iv$iv.add(title);
                            hasTitle = true;
                        }
                        destination$iv$iv = this.$failures;
                        String $i$f$mapTo2 = "diff at key = '" + key + "': was: " + aValue + ", become: " + bValue;
                        boolean bl2 = false;
                        destination$iv$iv.add($i$f$mapTo2);
                        continue;
                    }
                    Set<T> aSet = CollectionsKt.toSet(aValue);
                    Set<T> bSet = CollectionsKt.toSet(bValue);
                    Set<T> aLost = SetsKt.minus(aSet, (Iterable)bSet);
                    Set<T> bNew = SetsKt.minus(bSet, (Iterable)aSet);
                    it = aLost;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                    if (!(!it.isEmpty())) {
                        it = bNew;
                        $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                        if (!(!it.isEmpty())) continue;
                    }
                    it = this.$failures;
                    String $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = "diff at key = '" + key + "':";
                    boolean bl3 = false;
                    it.add($i$a$-map-FirProviderImpl$ensureConsistent$3$22);
                    it = this.$failures;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = "    Lost:";
                    bl3 = false;
                    it.add($i$a$-map-FirProviderImpl$ensureConsistent$3$22);
                    Iterable $this$forEach$iv = aLost;
                    boolean $i$f$forEach22 = false;
                    Iterator<T> iterator3 = $this$forEach$iv.iterator();
                    while (iterator3.hasNext()) {
                        it2 = element$iv = iterator3.next();
                        boolean bl4 = false;
                        collection = this.$failures;
                        string = "     " + it2;
                        bl = false;
                        collection.add(string);
                    }
                    $this$forEach$iv = this.$failures;
                    String $i$f$forEach22 = "    New:";
                    boolean bl5 = false;
                    $this$forEach$iv.add($i$f$forEach22);
                    $this$forEach$iv = bNew;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator4 = $this$forEach$iv.iterator();
                    while (iterator4.hasNext()) {
                        it2 = element$iv = iterator4.next();
                        boolean bl6 = false;
                        collection = this.$failures;
                        string = "     " + it2;
                        bl = false;
                        collection.add(string);
                    }
                }
            }
            {
                this.$failures = list2;
                super(3);
            }
        };
        $fun$checkMMapDiff$3.invoke("fileMap", this.state.getFileMap(), newState.getFileMap());
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "classifierMap", this.state.getClassifierMap(), newState.getClassifierMap(), null, 8, null);
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "classifierContainerFileMap", this.state.getClassifierContainerFileMap(), newState.getClassifierContainerFileMap(), null, 8, null);
        $fun$checkMMapDiff$3.invoke("callableMap", this.state.getCallableMap(), newState.getCallableMap());
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "callableContainerMap", this.state.getCallableContainerMap(), newState.getCallableContainerMap(), null, 8, null);
        this.state.setFrom(newState);
    }

    @Override
    @Nullable
    public FirScope getClassUseSiteMemberScope(@NotNull ClassId classId, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        FirScope firScope;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        Intrinsics.checkParameterIsNotNull(useSiteSession, "useSiteSession");
        Intrinsics.checkParameterIsNotNull(scopeSession, "scopeSession");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getClassLikeSymbolByFqName(classId);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        if (symbol2 instanceof FirClassSymbol) {
            firScope = SupertypeUtilsKt.buildDefaultUseSiteScope((FirRegularClass)((FirClassSymbol)symbol2).getFir(), useSiteSession, scopeSession);
        } else if (symbol2 instanceof FirTypeAliasSymbol) {
            FirTypeRef firTypeRef = ((FirTypeAlias)((FirTypeAliasSymbol)symbol2).getFir()).getExpandedTypeRef();
            if (firTypeRef == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            FirResolvedTypeRef expandedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType = expandedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType = null;
            }
            ConeLookupTagBasedType coneLookupTagBasedType = (ConeLookupTagBasedType)coneKotlinType;
            if (coneLookupTagBasedType == null) {
                return null;
            }
            ConeLookupTagBasedType expandedType = coneLookupTagBasedType;
            ConeClassifierLookupTag coneClassifierLookupTag = expandedType.getLookupTag();
            if (!(coneClassifierLookupTag instanceof ConeClassLikeLookupTag)) {
                coneClassifierLookupTag = null;
            }
            ConeClassLikeLookupTag coneClassLikeLookupTag = (ConeClassLikeLookupTag)coneClassifierLookupTag;
            if (coneClassLikeLookupTag == null) {
                return null;
            }
            ConeClassLikeLookupTag lookupTag = coneClassLikeLookupTag;
            firScope = this.getClassUseSiteMemberScope(lookupTag.getClassId(), useSiteSession, scopeSession);
        } else {
            throw (Throwable)new IllegalArgumentException("Unexpected FIR symbol in getClassUseSiteMemberScope: " + symbol2);
        }
        return firScope;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    public FirProviderImpl(@NotNull FirSession session) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        this.session = session;
        this.state = new State();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR'\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/impl/FirProviderImpl$State;", "", "()V", "callableContainerMap", "", "Lorg/jetbrains/kotlin/fir/symbols/ConeCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCallableContainerMap", "()Ljava/util/Map;", "callableMap", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getCallableMap", "classifierContainerFileMap", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassifierContainerFileMap", "classifierMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassifierMap", "fileMap", "Lorg/jetbrains/kotlin/name/FqName;", "getFileMap", "setFrom", "", "other", "resolve"})
    private static final class State {
        @NotNull
        private final Map<FqName, List<FirFile>> fileMap;
        @NotNull
        private final Map<ClassId, FirClassLikeDeclaration<?>> classifierMap;
        @NotNull
        private final Map<ClassId, FirFile> classifierContainerFileMap;
        @NotNull
        private final Map<CallableId, List<FirCallableSymbol<?>>> callableMap;
        @NotNull
        private final Map<ConeCallableSymbol, FirFile> callableContainerMap;

        @NotNull
        public final Map<FqName, List<FirFile>> getFileMap() {
            return this.fileMap;
        }

        @NotNull
        public final Map<ClassId, FirClassLikeDeclaration<?>> getClassifierMap() {
            return this.classifierMap;
        }

        @NotNull
        public final Map<ClassId, FirFile> getClassifierContainerFileMap() {
            return this.classifierContainerFileMap;
        }

        @NotNull
        public final Map<CallableId, List<FirCallableSymbol<?>>> getCallableMap() {
            return this.callableMap;
        }

        @NotNull
        public final Map<ConeCallableSymbol, FirFile> getCallableContainerMap() {
            return this.callableContainerMap;
        }

        public final void setFrom(@NotNull State other) {
            Intrinsics.checkParameterIsNotNull(other, "other");
            this.fileMap.clear();
            this.classifierMap.clear();
            this.classifierContainerFileMap.clear();
            this.callableMap.clear();
            this.callableContainerMap.clear();
            this.fileMap.putAll(other.fileMap);
            this.classifierMap.putAll(other.classifierMap);
            this.classifierContainerFileMap.putAll(other.classifierContainerFileMap);
            this.callableMap.putAll(other.callableMap);
            this.callableContainerMap.putAll(other.callableContainerMap);
        }

        public State() {
            Map map2;
            State state = this;
            boolean bl = false;
            state.fileMap = map2 = (Map)new LinkedHashMap();
            state = this;
            bl = false;
            state.classifierMap = map2 = (Map)new LinkedHashMap();
            state = this;
            bl = false;
            state.classifierContainerFileMap = map2 = (Map)new LinkedHashMap();
            state = this;
            bl = false;
            state.callableMap = map2 = (Map)new LinkedHashMap();
            state = this;
            bl = false;
            state.callableContainerMap = map2 = (Map)new LinkedHashMap();
        }
    }
}

