/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CharsetKt;
import io.ktor.util.CryptoKt;
import io.ktor.util.InternalAPI;
import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.NonceKt;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u001a\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u001a\b\u0010\u0010\u001a\u00020\rH\u0007\u001a\b\u0010\u0011\u001a\u00020\rH\u0002\u001a \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0007\u001a\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u001a\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u001a\b\u0010\u0019\u001a\u00020\rH\u0007\u001a\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u001a\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u0002\u001a\u00020\u00038FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"digits", "", "nonceRandom", "Ljava/util/Random;", "nonceRandom$annotations", "()V", "getNonceRandom", "()Ljava/util/Random;", "nonceRandom$delegate", "Lkotlin/Lazy;", "decodeBase64", "", "s", "", "encodeBase64", "bytes", "generateNonce", "generateNonceBlocking", "getDigest", "text", "algorithm", "salt", "getDigestFunction", "Lkotlin/Function1;", "hex", "nextNonce", "raw", "sha1", "ktor-utils-jvm"})
public final class CryptoKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final char[] digits;
    @NotNull
    private static final Lazy nonceRandom$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(CryptoKt.class, (String)"ktor-utils-jvm"), "nonceRandom", "getNonceRandom()Ljava/util/Random;"))};
        digits = CharsetKt.toCharArray("0123456789abcdef");
        nonceRandom$delegate = LazyKt.lazy((Function0)nonceRandom.2.INSTANCE);
    }

    @KtorExperimentalAPI
    @NotNull
    public static final Function1<String, byte[]> getDigestFunction(@NotNull String algorithm, @NotNull String salt) {
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull((Object)salt, (String)"salt");
        return (Function1)new Function1<String, byte[]>(algorithm, salt){
            final /* synthetic */ String $algorithm;
            final /* synthetic */ String $salt;

            @NotNull
            public final byte[] invoke(@NotNull String e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return CryptoKt.access$getDigest(e, this.$algorithm, this.$salt);
            }
            {
                this.$algorithm = string;
                this.$salt = string2;
                super(1);
            }
        };
    }

    private static final byte[] getDigest(String text, String algorithm, String salt) {
        MessageDigest messageDigest;
        MessageDigest $receiver = messageDigest = MessageDigest.getInstance(algorithm);
        String string = salt;
        MessageDigest messageDigest2 = $receiver;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        messageDigest2.update(byArray2);
        string = text;
        messageDigest2 = $receiver;
        charset = Charsets.UTF_8;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray3 = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byArray2 = byArray3;
        byte[] byArray4 = messageDigest2.digest(byArray2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"digest(text.toByteArray())");
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"with(MessageDigest.getIn\u2026text.toByteArray())\n    }");
        return byArray4;
    }

    @InternalAPI
    @NotNull
    public static final byte[] decodeBase64(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        byte[] byArray = Base64.getDecoder().decode(s);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(s)");
        return byArray;
    }

    @InternalAPI
    @NotNull
    public static final String encodeBase64(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        String string = Base64.getEncoder().encodeToString(bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getEncoder().encodeToString(bytes)");
        return string;
    }

    @KtorExperimentalAPI
    @NotNull
    public static final byte[] sha1(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        byte[] byArray = MessageDigest.getInstance("SHA1").digest(bytes);
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @KtorExperimentalAPI
    @NotNull
    public static final byte[] hex(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        byte[] result = new byte[s.length() / 2];
        int n = 0;
        int n2 = result.length;
        while (n < n2) {
            void idx;
            void srcIdx = idx * 2;
            result[idx] = (byte)(Integer.parseInt(String.valueOf(s.charAt((int)srcIdx)), 16) << 4 | Integer.parseInt(String.valueOf(s.charAt((int)(srcIdx + true))), 16));
            ++idx;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @KtorExperimentalAPI
    @NotNull
    public static final String hex(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        char[] result = new char[bytes.length * 2];
        int resultIndex = 0;
        char[] digits = CryptoKt.digits;
        int n = 0;
        int n2 = bytes.length;
        while (n < n2) {
            void index;
            int b = bytes[index] & 0xFF;
            result[resultIndex++] = digits[b >> 4];
            result[resultIndex++] = digits[b & 0xF];
            ++index;
        }
        return new String(result);
    }

    @KtorExperimentalAPI
    @Deprecated(message="Will be removed in future releases", replaceWith=@ReplaceWith(imports={}, expression="s.toByteArray(Charsets.UTF_8)"))
    @NotNull
    public static final byte[] raw(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        String string = s;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @Deprecated(message="Use generateNonce() instead")
    public static /* synthetic */ void nonceRandom$annotations() {
    }

    @NotNull
    public static final Random getNonceRandom() {
        Lazy lazy = nonceRandom$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (Random)lazy.getValue();
    }

    @KtorExperimentalAPI
    @Deprecated(message="Use generateNonce() instead", replaceWith=@ReplaceWith(imports={}, expression="generateNonce()"))
    @NotNull
    public static final String nextNonce() {
        return CryptoKt.generateNonce();
    }

    @KtorExperimentalAPI
    @NotNull
    public static final String generateNonce() {
        String nonce = (String)NonceKt.getSeedChannel().poll();
        if (nonce != null) {
            return nonce;
        }
        return CryptoKt.generateNonceBlocking();
    }

    private static final String generateNonceBlocking() {
        NonceKt.ensureNonceGeneratorRunning();
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(null){
            private CoroutineScope p$;
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2 = result;
                        if (object2 instanceof Result.Failure) {
                            throw ((Result.Failure)object2).exception;
                        }
                        CoroutineScope coroutineScope = this.p$;
                        this.label = 1;
                        Object object3 = NonceKt.getSeedChannel().receive((Continuation)this);
                        if (object3 != object) return object3;
                        return object;
                    }
                    case 1: {
                        Object object4 = result;
                        if (object4 instanceof Result.Failure) {
                            throw ((Result.Failure)object4).exception;
                        }
                        Object object3 = result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super String>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getDigest(@NotNull String text, @NotNull String algorithm, @NotNull String salt) {
        return CryptoKt.getDigest(text, algorithm, salt);
    }
}

