/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx
implements Disposable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
    private static final ExtensionPointImpl<VirtualFileManagerListener> MANAGER_LISTENER_EP = ((ExtensionsAreaImpl)ApplicationManager.getApplication().getExtensionArea()).getExtensionPoint("com.intellij.virtualFileManagerListener");
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector;
    private final VirtualFileSystem[] myPhysicalFileSystems;
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster;
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners;
    private final List<Object> myAsyncFileListeners;

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> fileSystems) {
        if (fileSystems == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(0);
        }
        this(fileSystems, ApplicationManager.getApplication().getMessageBus());
    }

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> fileSystems, @NotNull MessageBus bus) {
        if (fileSystems == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(2);
        }
        this.myCollector = new KeyedExtensionCollector("com.intellij.virtualFileSystem");
        this.myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
        this.myVirtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myAsyncFileListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        ArrayList<? extends VirtualFileSystem> physicalFileSystems = new ArrayList<VirtualFileSystem>(fileSystems);
        ExtensionPoint<KeyedLazyInstance<VirtualFileSystem>> point = this.myCollector.getPoint();
        if (point != null) {
            for (KeyedLazyInstance<VirtualFileSystem> keyedLazyInstance : point.getExtensionList()) {
                if (!((VirtualFileSystemBean)keyedLazyInstance).physical) continue;
                physicalFileSystems.add(keyedLazyInstance.getInstance());
            }
        }
        this.myPhysicalFileSystems = physicalFileSystems.toArray(new VirtualFileSystem[0]);
        for (VirtualFileSystem virtualFileSystem : fileSystems) {
            this.myCollector.addExplicitExtension(virtualFileSystem.getProtocol(), virtualFileSystem);
            if (virtualFileSystem instanceof CachingVirtualFileSystem) continue;
            virtualFileSystem.addVirtualFileListener(this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        if (LOG.isDebugEnabled() && !ApplicationInfoImpl.isInStressTest()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    @Override
    public void dispose() {
    }

    @Override
    public long getStructureModificationCount() {
        return 0L;
    }

    @Override
    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List<VirtualFileSystem> systems = this.myCollector.forKey(protocol);
        int size = systems.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            LOG.error(protocol + ": " + systems);
        }
        return systems.get(0);
    }

    @Override
    public VirtualFile findFileByUrl(@NotNull String url) {
        VirtualFileSystem fileSystem;
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(3);
        }
        if ((fileSystem = this.getFileSystemForUrl(url)) == null) {
            return null;
        }
        return fileSystem.findFileByPath(VirtualFileManagerImpl.extractPath(url));
    }

    @Nullable
    private VirtualFileSystem getFileSystemForUrl(@NotNull String url) {
        String protocol;
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(5);
        }
        return (protocol = VirtualFileManagerImpl.extractProtocol(url)) == null ? null : this.getFileSystem(protocol);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(6);
        }
        this.myVirtualFileListenerMulticaster.addListener(listener);
    }

    @Override
    public void notifyPropertyChanged(@NotNull VirtualFile virtualFile2, @NotNull String property, Object oldValue, Object newValue2) {
        if (virtualFile2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(16);
        }
        if (property == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(17);
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> {
            if (virtualFile2.isValid() && !app.isDisposed()) {
                app.runWriteAction(() -> {
                    List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent(this, virtualFile2, property, oldValue, newValue2, false));
                    BulkFileListener listener = app.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                    listener.before(events);
                    listener.after(events);
                });
            }
        }, ModalityState.NON_MODAL);
    }

    @Override
    public long getModificationCount() {
        return 0L;
    }

    @Override
    @NotNull
    public CharSequence getVFileName(int nameId) {
        throw new AbstractMethodError();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystems";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshAndFindFileByUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileSystemForUrl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addVirtualFileListener";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVirtualFileListener";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addVirtualFileManagerListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVirtualFileManagerListener";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addAsyncFileListener";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyPropertyChanged";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "storeName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        @Override
        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(0);
            }
            LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(1);
            }
            LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(2);
            }
            LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(3);
            }
            LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(4);
            }
            LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(5);
            }
            LOG.debug("fileCopied: file = " + event.getFile() + ", originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(6);
            }
            LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(7);
            }
            LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(8);
            }
            LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        @Override
        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(9);
            }
            LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeContentsChange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VirtualFileSystemBean
    extends KeyedLazyInstanceEP<VirtualFileSystem> {
        @Attribute
        public boolean physical;

        private VirtualFileSystemBean() {
        }
    }
}

