/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J$\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SuspensionPointInsideMutexLockChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCall", "", "parent", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "child", "insideLambda", "reportProblem", "frontend.java"})
public final class SuspensionPointInsideMutexLockChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend()) {
            return;
        }
        Object object = CoroutineCallCheckerKt.findEnclosingSuspendFunction(context2);
        if (object == null || (object = object.getSource()) == null || (object = KotlinSourceElementKt.getPsi((SourceElement)object)) == null) {
            return;
        }
        Object enclosingSuspendFunctionSource = object;
        PsiElement parent2 = reportOn;
        PsiElement child = reportOn;
        boolean insideLambda = false;
        while (!(!(Intrinsics.areEqual(parent2, enclosingSuspendFunctionSource) ^ true) || parent2 instanceof KtCallExpression && this.checkCall(context2, (KtCallExpression)parent2, child, insideLambda, reportOn, resolvedCall2))) {
            if (parent2 instanceof KtLambdaExpression) {
                insideLambda = true;
            }
            if (!(parent2 instanceof KtValueArgumentList)) {
                child = parent2;
            }
            if (parent2.getParent() != null) continue;
            return;
        }
    }

    private final boolean checkCall(CallCheckerContext context2, KtCallExpression parent2, PsiElement child, boolean insideLambda, PsiElement reportOn, ResolvedCall<?> resolvedCall2) {
        Call call2 = (Call)context2.getTrace().get(BindingContext.CALL, parent2.getCalleeExpression());
        if (call2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull(call2, "context.trace[BindingCon\u2026pression] ?: return false");
        Call call3 = call2;
        ResolvedCall resolvedCall3 = (ResolvedCall)context2.getTrace().get(BindingContext.RESOLVED_CALL, call3);
        if (resolvedCall3 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "context.trace[BindingCon\u2026LL, call] ?: return false");
        ResolvedCall resolved = resolvedCall3;
        Object d = resolved.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "resolved.resultingDescriptor");
        boolean isSynchronized = DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)d, "synchronized", "kotlin");
        if (isSynchronized) {
            List<ResolvedValueArgument> list2 = resolved.getValueArgumentsByIndex();
            ResolvedValueArgument resolvedValueArgument = list2 != null ? list2.get(1) : null;
            if (!(resolvedValueArgument instanceof ExpressionValueArgument)) {
                resolvedValueArgument = null;
            }
            ExpressionValueArgument expressionValueArgument = (ExpressionValueArgument)resolvedValueArgument;
            boolean isSecondArgument = Intrinsics.areEqual(expressionValueArgument != null ? expressionValueArgument.getValueArgument() : null, child);
            if (insideLambda && isSecondArgument) {
                this.reportProblem(context2, reportOn, resolvedCall2);
            }
            return true;
        }
        Object d2 = resolved.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d2, "resolved.resultingDescriptor");
        boolean isWithLock = DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)d2, "withLock", "kotlin.concurrent");
        if (isWithLock) {
            this.reportProblem(context2, reportOn, resolvedCall2);
            return true;
        }
        return false;
    }

    private final void reportProblem(CallCheckerContext context2, PsiElement reportOn, ResolvedCall<?> resolvedCall2) {
        context2.getTrace().report(ErrorsJvm.SUSPENSION_POINT_INSIDE_CRITICAL_SECTION.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
    }
}

