/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypesUtil {
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new THashMap();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new THashMap();

    private PsiTypesUtil() {
    }

    public static Object getDefaultValue(PsiType type2) {
        if (!(type2 instanceof PsiPrimitiveType)) {
            return null;
        }
        switch (type2.getCanonicalText()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type2) {
        return PsiTypesUtil.getDefaultValueOfType(type2, false);
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type2, boolean customDefaultValues) {
        if (type2 instanceof PsiArrayType) {
            PsiClassType classType;
            int count = type2.getArrayDimensions() - 1;
            PsiType componentType = type2.getDeepComponentType();
            if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                return "null";
            }
            PsiType erasedComponentType = TypeConversionUtil.erasure(componentType);
            StringBuilder buffer = new StringBuilder();
            buffer.append("new");
            buffer.append(" ");
            buffer.append(erasedComponentType.getCanonicalText());
            buffer.append("[0]");
            for (int i = 0; i < count; ++i) {
                buffer.append("[]");
            }
            String string2 = buffer.toString();
            if (string2 == null) {
                PsiTypesUtil.$$$reportNull$$$0(0);
            }
            return string2;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return PsiType.BOOLEAN.equals(type2) ? "false" : "0";
        }
        if (customDefaultValues) {
            PsiClassType rawType;
            PsiClassType psiClassType = rawType = type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : null;
            if (rawType != null && rawType.equalsToText("java.util.Optional")) {
                return "java.util.Optional.empty()";
            }
        }
        return "null";
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String unboxIfPossible(@Nullable String type2) {
        if (type2 == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type2);
        return s == null ? type2 : s;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String boxIfPossible(@Nullable String type2) {
        if (type2 == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type2);
        return s == null ? type2 : s;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType2) {
        return psiType2 instanceof PsiClassType ? ((PsiClassType)psiType2).resolve() : null;
    }

    @NotNull
    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiTypesUtil.$$$reportNull$$$0(1);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
        if (psiClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(2);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type2) {
        PsiType lub;
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(3);
        }
        if ((lub = type2.getLeastUpperBound()) instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass2;
                if (!(subType instanceof PsiClassType) || (aClass2 = ((PsiClassType)subType).resolve()) == null || aClass2.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiMethodReferenceExpression methodExpression, @NotNull PsiMethod method) {
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(4);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(5);
        }
        if (PsiTypesUtil.isGetClass(method)) {
            PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(methodExpression);
            return qualifierType != null ? PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true) : null;
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call2, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @NotNull Condition<? super IElementType> condition, @NotNull LanguageLevel languageLevel) {
        if (call2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(6);
        }
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(7);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(8);
        }
        if (condition == null) {
            PsiTypesUtil.$$$reportNull$$$0(9);
        }
        if (languageLevel == null) {
            PsiTypesUtil.$$$reportNull$$$0(10);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && PsiTypesUtil.isGetClass(method)) {
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call2.getProject();
            if (qualifier != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier.getType());
            } else {
                PsiElement parent2;
                for (parent2 = call2.getContext(); parent2 != null && condition.value(parent2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parent2).getElementType() : parent2.getNode().getElementType()); parent2 = parent2.getContext()) {
                }
                if (parent2 != null) {
                    qualifierType = JavaPsiFacade.getElementFactory(project).createType((PsiClass)parent2);
                }
            }
            return PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true);
        }
        return null;
    }

    public static boolean isGetClass(@NotNull PsiMethod method) {
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(11);
        }
        if ("getClass".equals(method.getName())) {
            PsiClass aClass2 = method.getContainingClass();
            return aClass2 != null && "java.lang.Object".equals(aClass2.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@NotNull PsiElement context2, @Nullable PsiType qualifierType, boolean captureTopLevelWildcards) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(12);
        }
        if (qualifierType != null) {
            PsiUtil.ensureValidType(qualifierType);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(context2.getProject());
            PsiClass javaLangClass2 = facade.findClass("java.lang.Class", context2.getResolveScope());
            if (javaLangClass2 != null && javaLangClass2.getTypeParameters().length == 1) {
                PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY.put(javaLangClass2.getTypeParameters()[0], PsiWildcardType.createExtends(context2.getManager(), qualifierType));
                PsiClassType classType = facade.getElementFactory().createType(javaLangClass2, substitutor2, PsiUtil.getLanguageLevel(context2));
                return captureTopLevelWildcards ? PsiUtil.captureToplevelWildcards(classType, context2) : classType;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getExpectedTypeByParent(@NotNull PsiElement element) {
        PsiElement parent2;
        if (element == null) {
            PsiTypesUtil.$$$reportNull$$$0(13);
        }
        if ((parent2 = PsiUtil.skipParenthesizedExprUp(element.getParent())) instanceof PsiVariable) {
            if (PsiUtil.checkSameExpression(element, ((PsiVariable)parent2).getInitializer())) {
                PsiTypeElement typeElement = ((PsiVariable)parent2).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return null;
                }
                return ((PsiVariable)parent2).getType();
            }
        } else if (parent2 instanceof PsiAssignmentExpression) {
            if (PsiUtil.checkSameExpression(element, ((PsiAssignmentExpression)parent2).getRExpression())) {
                PsiType type2 = ((PsiAssignmentExpression)parent2).getLExpression().getType();
                return !PsiType.NULL.equals(type2) ? type2 : null;
            }
        } else if (parent2 instanceof PsiReturnStatement) {
            Object psiElement = PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, PsiMethod.class);
            if (psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else {
            if (PsiUtil.isCondition(element, parent2)) {
                return PsiType.BOOLEAN;
            }
            if (parent2 instanceof PsiArrayInitializerExpression) {
                PsiElement gParent = parent2.getParent();
                if (gParent instanceof PsiNewExpression) {
                    PsiType type3 = ((PsiNewExpression)gParent).getType();
                    if (type3 instanceof PsiArrayType) {
                        return ((PsiArrayType)type3).getComponentType();
                    }
                } else if (gParent instanceof PsiVariable) {
                    PsiType type4 = ((PsiVariable)gParent).getType();
                    if (type4 instanceof PsiArrayType) {
                        return ((PsiArrayType)type4).getComponentType();
                    }
                } else if (gParent instanceof PsiArrayInitializerExpression) {
                    PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(parent2);
                    return expectedTypeByParent instanceof PsiArrayType ? ((PsiArrayType)expectedTypeByParent).getComponentType() : null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getMethodReturnType(@NotNull PsiElement element) {
        Object methodOrLambda;
        if (element == null) {
            PsiTypesUtil.$$$reportNull$$$0(14);
        }
        return (methodOrLambda = PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiLambdaExpression.class)) instanceof PsiMethod ? ((PsiMethod)methodOrLambda).getReturnType() : (methodOrLambda instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)methodOrLambda) : null);
    }

    public static boolean compareTypes(PsiType leftType, PsiType rightType, boolean ignoreEllipsis) {
        if (ignoreEllipsis) {
            if (leftType instanceof PsiEllipsisType) {
                leftType = ((PsiEllipsisType)leftType).toArrayType();
            }
            if (rightType instanceof PsiEllipsisType) {
                rightType = ((PsiEllipsisType)rightType).toArrayType();
            }
        }
        return Comparing.equal(leftType, rightType);
    }

    @Deprecated
    public static boolean isDenotableType(@Nullable PsiType type2) {
        return !(type2 instanceof PsiWildcardType) && !(type2 instanceof PsiCapturedWildcardType);
    }

    public static boolean isDenotableType(@Nullable PsiType type2, @NotNull PsiElement context2) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(15);
        }
        if (type2 == null || type2 instanceof PsiWildcardType) {
            return false;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(context2.getProject());
        try {
            PsiType typeAfterReplacement = elementFactory.createTypeElementFromText(type2.getCanonicalText(), context2).getType();
            return type2.equals(typeAfterReplacement);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public static boolean hasUnresolvedComponents(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(16);
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass psiClass = resolveResult.getElement();
                if (psiClass == null) {
                    return true;
                }
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                for (PsiTypeParameter param : PsiUtil.typeParametersIterable(psiClass)) {
                    PsiType psiType2 = substitutor2.substitute(param);
                    if (psiType2 == null || !psiType2.accept(this).booleanValue()) continue;
                    return true;
                }
                return (Boolean)super.visitClassType(classType);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @NotNull
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                Boolean bl = bound != null && bound.accept(this) != false;
                if (bl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return bl;
            }

            @Override
            public Boolean visitType(PsiType type2) {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTypesUtil$1", "visitWildcardType"));
            }
        });
    }

    @NotNull
    public static PsiType getParameterType(@NotNull PsiParameter[] parameters2, int i, boolean varargs) {
        PsiParameter parameter;
        PsiType parameterType;
        if (parameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(17);
        }
        if ((parameterType = (parameter = parameters2[i < parameters2.length ? i : parameters2.length - 1]).getType()) instanceof PsiEllipsisType && varargs) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        if (!parameterType.isValid()) {
            PsiUtil.ensureValidType(parameterType, "Invalid type of parameter " + parameter + " of " + parameter.getClass());
        }
        PsiType psiType2 = parameterType;
        if (psiType2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(18);
        }
        return psiType2;
    }

    @NotNull
    public static PsiTypeParameter[] filterUnusedTypeParameters(@NotNull PsiTypeParameter[] typeParameters2, PsiType ... types2) {
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(19);
        }
        if (types2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(20);
        }
        if (typeParameters2.length == 0) {
            if (PsiTypeParameter.EMPTY_ARRAY == null) {
                PsiTypesUtil.$$$reportNull$$$0(21);
            }
            return PsiTypeParameter.EMPTY_ARRAY;
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        for (PsiType type2 : types2) {
            type2.accept(searcher);
        }
        PsiTypeParameter[] psiTypeParameterArray = searcher.getTypeParameters().toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiTypesUtil.$$$reportNull$$$0(22);
        }
        return psiTypeParameterArray;
    }

    @NotNull
    public static PsiTypeParameter[] filterUnusedTypeParameters(@NotNull PsiType superReturnTypeInBaseClassType, @NotNull PsiTypeParameter[] typeParameters2) {
        if (superReturnTypeInBaseClassType == null) {
            PsiTypesUtil.$$$reportNull$$$0(23);
        }
        if (typeParameters2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(24);
        }
        return PsiTypesUtil.filterUnusedTypeParameters(typeParameters2, superReturnTypeInBaseClassType);
    }

    private static boolean isAccessibleAt(@NotNull PsiTypeParameter parameter, @NotNull PsiElement context2) {
        PsiTypeParameterListOwner owner;
        if (parameter == null) {
            PsiTypesUtil.$$$reportNull$$$0(25);
        }
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(26);
        }
        if ((owner = parameter.getOwner()) instanceof PsiMethod) {
            return PsiTreeUtil.isAncestor(owner, context2, false);
        }
        if (owner instanceof PsiClass) {
            return PsiTreeUtil.isAncestor(owner, context2, false) && InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)owner, context2, false, false);
        }
        return false;
    }

    public static boolean allTypeParametersResolved(@NotNull PsiElement context2, @NotNull PsiType targetType) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(27);
        }
        if (targetType == null) {
            PsiTypesUtil.$$$reportNull$$$0(28);
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        targetType.accept(searcher);
        Set<PsiTypeParameter> parameters2 = searcher.getTypeParameters();
        return parameters2.stream().allMatch(parameter -> PsiTypesUtil.isAccessibleAt(parameter, context2));
    }

    @NotNull
    public static PsiType createArrayType(@NotNull PsiType newType, int arrayDim) {
        if (newType == null) {
            PsiTypesUtil.$$$reportNull$$$0(29);
        }
        for (int i = 0; i < arrayDim; ++i) {
            newType = newType.createArrayType();
        }
        PsiType psiType2 = newType;
        if (psiType2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(30);
        }
        return psiType2;
    }

    @Nullable
    public static PsiTypeElement replaceWithExplicitType(PsiTypeElement typeElement) {
        PsiType type2 = typeElement.getType();
        if (!PsiTypesUtil.isDenotableType(type2, typeElement)) {
            return null;
        }
        Project project = typeElement.getProject();
        PsiTypeElement typeElementByExplicitType = JavaPsiFacade.getElementFactory(project).createTypeElement(type2);
        PsiElement explicitTypeElement = typeElement.replace(typeElementByExplicitType);
        explicitTypeElement = JavaCodeStyleManager.getInstance(project).shortenClassReferences(explicitTypeElement);
        return (PsiTypeElement)CodeStyleManager.getInstance(project).reformat(explicitTypeElement);
    }

    public static PsiType getTypeByMethod(@NotNull PsiElement context2, PsiExpressionList argumentList2, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor2, boolean inferParent) {
        if (context2 == null) {
            PsiTypesUtil.$$$reportNull$$$0(31);
        }
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters2 = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters2.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList2.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters2.length != args.length && !inferParent) {
                return null;
            }
            PsiElement arg = context2;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            PsiType parameterType = substitutor2 != null ? substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i, varargs)) : null;
            boolean isRaw = substitutor2 != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor2);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public static boolean mentionsTypeParameters(@Nullable PsiType type2, Set<PsiTypeParameter> typeParameters2) {
        return PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(type2, typeParameters2, false);
    }

    public static boolean isUncheckedCall(JavaResolveResult resolveResult) {
        PsiSubstitutor substitutor2;
        PsiMethod method;
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && PsiUtil.isRawSubstitutor(method = (PsiMethod)element, substitutor2 = resolveResult.getSubstitutor())) {
            HashSet<PsiTypeParameter> typeParameters2 = new HashSet<PsiTypeParameter>(substitutor2.getSubstitutionMap().keySet());
            Arrays.stream(method.getTypeParameters()).forEach(typeParameters2::remove);
            return Arrays.stream(method.getParameterList().getParameters()).anyMatch(parameter -> PsiTypesUtil.mentionsTypeParametersOrUnboundedWildcard(parameter.getType(), typeParameters2, true));
        }
        return false;
    }

    private static boolean mentionsTypeParametersOrUnboundedWildcard(@Nullable PsiType type2, final Set<PsiTypeParameter> typeParameters2, final boolean acceptUnboundedWildcard) {
        if (type2 == null) {
            return false;
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(PsiType type2) {
                return false;
            }

            @Override
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return bound.accept(this);
                }
                return acceptUnboundedWildcard;
            }

            @Override
            public Boolean visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
                PsiClass psiClass = result2.getElement();
                if (psiClass != null) {
                    PsiSubstitutor substitutor2 = result2.getSubstitutor();
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(psiClass)) {
                        PsiType type2 = substitutor2.substitute(parameter);
                        if (type2 == null || !type2.accept(this).booleanValue()) continue;
                        return true;
                    }
                }
                return psiClass instanceof PsiTypeParameter && typeParameters2.contains(psiClass);
            }

            @Override
            public Boolean visitIntersectionType(PsiIntersectionType intersectionType) {
                for (PsiType conjunct : intersectionType.getConjuncts()) {
                    if (!conjunct.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitMethodReferenceType(PsiMethodReferenceType methodReferenceType) {
                return false;
            }

            @Override
            public Boolean visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
                return false;
            }

            @Override
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }
        });
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 12: 
            case 15: 
            case 26: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReturnTypeInBaseClassType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueOfType";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnusedTypeParameters";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLowestUpperBoundClassType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchMethodGetClassReturnType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGetClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createJavaLangClassType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeByParent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReturnType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDenotableType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedComponents";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterUnusedTypeParameters";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleAt";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "allTypeParametersResolved";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByMethod";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeParameterSearcher
    extends PsiTypeVisitor<Boolean> {
        private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

        @NotNull
        public Set<PsiTypeParameter> getTypeParameters() {
            Set<PsiTypeParameter> set = this.myTypeParams;
            if (set == null) {
                TypeParameterSearcher.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        public Boolean visitType(PsiType type2) {
            return false;
        }

        @Override
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass2 = resolveResult.getElement();
            if (aClass2 instanceof PsiTypeParameter) {
                this.myTypeParams.add((PsiTypeParameter)aClass2);
            }
            if (aClass2 != null) {
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass2)) {
                    PsiType psiType2 = substitutor2.substitute(parameter);
                    if (psiType2 == null) continue;
                    psiType2.accept(this);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                bound.accept(this);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTypesUtil$TypeParameterSearcher", "getTypeParameters"));
        }
    }
}

