/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.PrimitiveTypes;
import org.jetbrains.kotlin.fir.PrimitivesKt;
import org.jetbrains.kotlin.fir.backend.PrimitiveConeNumericComparisonInfo;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\n*\u00020\u000eH\u0002\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\nH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0010"}, d2={"left", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "getLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "right", "getRight", "inferPrimitiveNumericComparisonInfo", "Lorg/jetbrains/kotlin/fir/backend/PrimitiveConeNumericComparisonInfo;", "leastCommonPrimitiveNumericType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "t1", "t2", "getPrimitiveTypeOrSupertype", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "promoteIntegerTypeToIntIfRequired", "fir2ir"})
public final class PrimitiveComparisonKt {
    @NotNull
    public static final FirExpression getLeft(@NotNull FirComparisonExpression $this$left) {
        Intrinsics.checkNotNullParameter($this$left, "$this$left");
        FirExpression firExpression2 = $this$left.getCompareToCall().getExplicitReceiver();
        if (firExpression2 == null) {
            String string2 = "There should be an explicit receiver for " + FirRendererKt.render$default($this$left.getCompareToCall(), null, 1, null);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firExpression2;
    }

    @NotNull
    public static final FirExpression getRight(@NotNull FirComparisonExpression $this$right) {
        Intrinsics.checkNotNullParameter($this$right, "$this$right");
        FirCall $this$arguments$iv = $this$right.getCompareToCall();
        boolean $i$f$getArguments = false;
        FirExpression firExpression2 = CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), 0);
        if (firExpression2 == null) {
            String string2 = "There should be a first arg for " + FirRendererKt.render$default($this$right.getCompareToCall(), null, 1, null);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firExpression2;
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull FirComparisonExpression $this$inferPrimitiveNumericComparisonInfo) {
        Intrinsics.checkNotNullParameter($this$inferPrimitiveNumericComparisonInfo, "$this$inferPrimitiveNumericComparisonInfo");
        return PrimitiveComparisonKt.inferPrimitiveNumericComparisonInfo(PrimitiveComparisonKt.getLeft($this$inferPrimitiveNumericComparisonInfo), PrimitiveComparisonKt.getRight($this$inferPrimitiveNumericComparisonInfo));
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull FirExpression left, @NotNull FirExpression right) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        FirTypeRef $this$coneTypeSafe$iv = left.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType leftType = coneKotlinType;
        FirTypeRef $this$coneTypeSafe$iv2 = right.getTypeRef();
        boolean $i$f$coneTypeSafe2 = false;
        boolean bl2 = false;
        FirTypeRef firTypeRef2 = $this$coneTypeSafe$iv2;
        if (!(firTypeRef2 instanceof FirResolvedTypeRef)) {
            firTypeRef2 = null;
        }
        FirResolvedTypeRef firResolvedTypeRef2 = (FirResolvedTypeRef)firTypeRef2;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType rightType = coneKotlinType2;
        ConeClassLikeType coneClassLikeType = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(leftType);
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType leftPrimitiveOrNullableType = coneClassLikeType;
        ConeClassLikeType coneClassLikeType2 = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(rightType);
        if (coneClassLikeType2 == null) {
            return null;
        }
        ConeClassLikeType rightPrimitiveOrNullableType = coneClassLikeType2;
        ConeClassLikeType leastCommonType = PrimitiveComparisonKt.leastCommonPrimitiveNumericType(leftPrimitiveOrNullableType, rightPrimitiveOrNullableType);
        return new PrimitiveConeNumericComparisonInfo(leastCommonType, leftPrimitiveOrNullableType, rightPrimitiveOrNullableType);
    }

    private static final ConeClassLikeType leastCommonPrimitiveNumericType(ConeClassLikeType t1, ConeClassLikeType t2) {
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType pt1 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t1);
        ConeClassLikeType pt2 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t2);
        if (PrimitivesKt.isDouble(pt1) || PrimitivesKt.isDouble(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getDouble();
        } else if (PrimitivesKt.isFloat(pt1) || PrimitivesKt.isFloat(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getFloat();
        } else if (PrimitivesKt.isLong(pt1) || PrimitivesKt.isLong(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getLong();
        } else if (PrimitivesKt.isInt(pt1) || PrimitivesKt.isInt(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getInt();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected types: t1=" + t1 + ", t2=" + t2)));
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType promoteIntegerTypeToIntIfRequired(ConeClassLikeType $this$promoteIntegerTypeToIntIfRequired) {
        ConeClassLikeType coneClassLikeType;
        ClassId classId = $this$promoteIntegerTypeToIntIfRequired.getLookupTag().getClassId();
        if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getByte()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getShort())) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getInt();
        } else if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getLong()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getInt()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getFloat()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getDouble()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getChar())) {
            coneClassLikeType = $this$promoteIntegerTypeToIntIfRequired;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Primitive number type expected: " + $this$promoteIntegerTypeToIntIfRequired)));
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType getPrimitiveTypeOrSupertype(ConeKotlinType $this$getPrimitiveTypeOrSupertype) {
        ConeClassLikeType coneClassLikeType;
        block5: {
            if ($this$getPrimitiveTypeOrSupertype instanceof ConeTypeParameterType) {
                Iterable $this$firstNotNullResult$iv = ((FirTypeParameter)((ConeTypeParameterType)$this$getPrimitiveTypeOrSupertype).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
                boolean $i$f$firstNotNullResult = false;
                for (Object element$iv : $this$firstNotNullResult$iv) {
                    ConeClassLikeType result$iv;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl = false;
                    FirTypeRef $this$coneTypeSafe$iv = it;
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl2 = false;
                    FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                    if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                        firTypeRef = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeKotlinType)) {
                        coneKotlinType = null;
                    }
                    if ((result$iv = coneKotlinType != null ? PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(coneKotlinType) : null) == null) continue;
                    coneClassLikeType = result$iv;
                    break block5;
                }
                coneClassLikeType = null;
            } else {
                coneClassLikeType = $this$getPrimitiveTypeOrSupertype instanceof ConeClassLikeType && PrimitivesKt.isPrimitiveNumberType((ConeClassLikeType)$this$getPrimitiveTypeOrSupertype) ? (ConeClassLikeType)$this$getPrimitiveTypeOrSupertype : ($this$getPrimitiveTypeOrSupertype instanceof ConeFlexibleType ? PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(((ConeFlexibleType)$this$getPrimitiveTypeOrSupertype).getLowerBound()) : null);
            }
        }
        return coneClassLikeType;
    }
}

