/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.FirWhenSubject;
import org.jetbrains.kotlin.fir.builder.BaseFirBuilder;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.builder.FirLabelBuilder;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayOfCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBreakExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCatchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckNotNullCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirContinueExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirDoWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirElseIfTrueConditionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirEmptyExpressionBlockBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionStubBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirGetClassCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLambdaArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopJumpBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThrowExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTryExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTypeOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirUnitExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenBranchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenSubjectExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirModifiableQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.lightTree.converter.BaseConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ConverterUtilKt;
import org.jetbrains.kotlin.fir.lightTree.converter.DeclarationsConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ExpressionsConverter;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.lightTree.fir.ValueParameter;
import org.jetbrains.kotlin.fir.lightTree.fir.WhenEntry;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitSuperReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0002J)\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\b2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0002\b\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\bH\u0002J \u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0004\u0012\u00020(\u0018\u00010&2\u0006\u0010)\u001a\u00020\bH\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\bH\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\bH\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\bH\u0002J\u0010\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\bH\u0002J\u0016\u00102\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\b2\u0006\u00103\u001a\u00020\u001dJ\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\bH\u0002J\u0010\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020\bH\u0002J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020!0;2\u0006\u0010<\u001a\u00020\bH\u0002J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\bH\u0002J\u0010\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020\bH\u0002J\u0012\u0010A\u001a\u00020(2\b\u0010B\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020\bH\u0002J\u0010\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020\bH\u0002J\u0010\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020\bH\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\bH\u0002J\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020\bH\u0002J\u0010\u0010N\u001a\u00020J2\u0006\u0010O\u001a\u00020\bH\u0002J\u0010\u0010P\u001a\u00020J2\u0006\u0010Q\u001a\u00020\bH\u0002J\u0010\u0010R\u001a\u00020!2\u0006\u0010S\u001a\u00020\bH\u0002J\u0010\u0010T\u001a\u00020!2\u0006\u0010U\u001a\u00020\bH\u0002J\u0010\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020\bH\u0002J\u0010\u0010X\u001a\u00020!2\u0006\u0010Y\u001a\u00020\bH\u0002J\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020!0;2\u0006\u0010[\u001a\u00020\bJ\u001a\u0010\\\u001a\u00020!2\u0006\u0010]\u001a\u00020\b2\b\u0010^\u001a\u0004\u0018\u00010_H\u0002J\u001a\u0010`\u001a\u00020!2\u0006\u0010]\u001a\u00020\b2\b\u0010^\u001a\u0004\u0018\u00010_H\u0002J\u001a\u0010a\u001a\u00020!2\u0006\u0010]\u001a\u00020\b2\b\u0010^\u001a\u0004\u0018\u00010_H\u0002J\u001a\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\b2\b\u0010^\u001a\u0004\u0018\u00010_H\u0002J\u0010\u0010e\u001a\u00020!2\u0006\u0010f\u001a\u00020\bH\u0002J\u0010\u0010g\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\bH\u0002J.\u0010i\u001a\u0002Hj\"\n\b\u0000\u0010j\u0018\u0001*\u00020\u00112\b\u0010-\u001a\u0004\u0018\u00010\b2\b\b\u0002\u00103\u001a\u00020\u001dH\u0086\b\u00a2\u0006\u0002\u0010kJ\u0016\u0010l\u001a\u00020!*\u0004\u0018\u00010\b2\u0006\u00103\u001a\u00020\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter;", "Lorg/jetbrains/kotlin/fir/lightTree/converter/BaseConverter;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "stubMode", "", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "declarationsConverter", "Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;", "offset", "", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "(Lorg/jetbrains/kotlin/fir/FirSession;ZLcom/intellij/util/diff/FlyweightCapableTreeStructure;Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;ILorg/jetbrains/kotlin/fir/builder/Context;)V", "convertAnnotatedExpression", "Lorg/jetbrains/kotlin/fir/FirElement;", "annotatedExpression", "convertArrayAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "arrayAccess", "convertBinaryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "binaryExpression", "convertBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "toFirOperation", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "Lkotlin/ExtensionFunctionType;", "convertCallExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "callSuffix", "convertCallableReferenceExpression", "callableReferenceExpression", "convertCatchClause", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/lightTree/fir/ValueParameter;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "catchClause", "convertClassLiteralExpression", "classLiteralExpression", "convertCollectionLiteralExpression", "expression", "convertConstantExpression", "constantExpression", "convertDoWhile", "doWhileLoop", "convertExpression", "errorReason", "convertFinally", "finallyExpression", "convertFor", "forLoop", "convertIfExpression", "ifExpression", "convertIndices", "", "indices", "convertLabeledExpression", "labeledExpression", "convertLambdaExpression", "lambdaExpression", "convertLoopBody", "body", "convertLoopJump", "jump", "convertQualifiedExpression", "dotQualifiedExpression", "convertReturn", "returnExpression", "convertSimpleNameExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "referenceExpression", "convertStringTemplate", "stringTemplate", "convertSuperExpression", "superExpression", "convertThisExpression", "thisExpression", "convertThrow", "throwExpression", "convertTryExpression", "tryExpression", "convertUnaryExpression", "unaryExpression", "convertValueArgument", "valueArgument", "convertValueArguments", "valueArguments", "convertWhenConditionExpression", "whenCondition", "subject", "Lorg/jetbrains/kotlin/fir/FirWhenSubject;", "convertWhenConditionInRange", "convertWhenConditionIsPattern", "convertWhenEntry", "Lorg/jetbrains/kotlin/fir/lightTree/fir/WhenEntry;", "whenEntry", "convertWhenExpression", "whenExpression", "convertWhile", "whileLoop", "getAsFirExpression", "R", "(Lcom/intellij/lang/LighterASTNode;Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/FirElement;", "convertShortOrLongStringTemplate", "light-tree2fir"})
public final class ExpressionsConverter
extends BaseConverter {
    private final boolean stubMode;
    private final DeclarationsConverter declarationsConverter;

    @NotNull
    public final /* synthetic */ <R extends FirElement> R getAsFirExpression(@Nullable LighterASTNode expression2, @NotNull String errorReason) {
        FirElement firElement;
        int $i$f$getAsFirExpression = 0;
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        LighterASTNode lighterASTNode = expression2;
        if (lighterASTNode != null) {
            LighterASTNode lighterASTNode2 = lighterASTNode;
            boolean bl = false;
            boolean bl2 = false;
            LighterASTNode it = lighterASTNode2;
            boolean bl3 = false;
            firElement = this.convertExpression(it, errorReason);
        } else {
            firElement = null;
        }
        Intrinsics.reifiedOperationMarker(2, "R");
        FirElement firElement2 = firElement;
        if (firElement2 == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired));
            Intrinsics.reifiedOperationMarker(1, "R");
            firElement2 = firErrorExpression;
        }
        return (R)firElement2;
    }

    public static /* synthetic */ FirElement getAsFirExpression$default(ExpressionsConverter this_, LighterASTNode expression2, String errorReason, int n, Object object) {
        FirElement firElement;
        if ((n & 2) != 0) {
            errorReason = "";
        }
        boolean $i$f$getAsFirExpression = false;
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        LighterASTNode lighterASTNode = expression2;
        if (lighterASTNode != null) {
            object = lighterASTNode;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            firElement = this_.convertExpression((LighterASTNode)it, errorReason);
        } else {
            firElement = null;
        }
        Intrinsics.reifiedOperationMarker(2, "R");
        FirElement firElement2 = firElement;
        if (firElement2 == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired));
            Intrinsics.reifiedOperationMarker(1, "R");
            firElement2 = firErrorExpression;
        }
        return firElement2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirElement convertExpression(@NotNull LighterASTNode expression2, @NotNull String errorReason) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        if (!this.stubMode) {
            FirElement firElement;
            IElementType iElementType = expression2.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_EXPRESSION)) {
                FlyweightCapableTreeStructure<LighterASTNode> lambdaTree = LightTree2Fir.Companion.buildLightTreeLambdaExpression(this.getAsText(expression2));
                ExpressionsConverter expressionsConverter = new ExpressionsConverter(this.getBaseSession(), this.stubMode, lambdaTree, this.declarationsConverter, this.getOffset(), this.getContext());
                LighterASTNode lighterASTNode = lambdaTree.getRoot();
                Intrinsics.checkNotNullExpressionValue(lighterASTNode, "lambdaTree.root");
                firElement = expressionsConverter.convertLambdaExpression(lighterASTNode);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BINARY_EXPRESSION)) {
                firElement = this.convertBinaryExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BINARY_WITH_TYPE)) {
                firElement = this.convertBinaryWithTypeRHSExpression(expression2, convertExpression.1.INSTANCE);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.IS_EXPRESSION)) {
                firElement = this.convertBinaryWithTypeRHSExpression(expression2, convertExpression.2.INSTANCE);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.LABELED_EXPRESSION)) {
                firElement = this.convertLabeledExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PREFIX_EXPRESSION) || Intrinsics.areEqual(iElementType, KtNodeTypes.POSTFIX_EXPRESSION)) {
                firElement = this.convertUnaryExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION)) {
                firElement = this.convertAnnotatedExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS_LITERAL_EXPRESSION)) {
                firElement = this.convertClassLiteralExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION)) {
                firElement = this.convertCallableReferenceExpression(expression2);
            } else if (ConverterUtilKt.getQualifiedAccessTokens().contains(iElementType)) {
                firElement = this.convertQualifiedExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CALL_EXPRESSION)) {
                firElement = this.convertCallExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN)) {
                firElement = this.convertWhenExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.ARRAY_ACCESS_EXPRESSION)) {
                firElement = this.convertArrayAccessExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.COLLECTION_LITERAL_EXPRESSION)) {
                firElement = this.convertCollectionLiteralExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.STRING_TEMPLATE)) {
                firElement = this.convertStringTemplate(expression2);
            } else if (iElementType instanceof KtConstantExpressionElementType) {
                firElement = this.convertConstantExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.REFERENCE_EXPRESSION)) {
                firElement = this.convertSimpleNameExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.DO_WHILE)) {
                firElement = this.convertDoWhile(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHILE)) {
                firElement = this.convertWhile(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FOR)) {
                firElement = this.convertFor(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.TRY)) {
                firElement = this.convertTryExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.IF)) {
                firElement = this.convertIfExpression(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BREAK) || Intrinsics.areEqual(iElementType, KtNodeTypes.CONTINUE)) {
                firElement = this.convertLoopJump(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.RETURN)) {
                firElement = this.convertReturn(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.THROW)) {
                firElement = this.convertThrow(expression2);
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PARENTHESIZED)) {
                FirElement firElement2;
                FirElement firElement3;
                void expression$iv;
                ExpressionsConverter lambdaTree = this;
                LighterASTNode lighterASTNode = this.getExpressionInParentheses(expression2);
                String errorReason$iv = "Empty parentheses";
                boolean $i$f$getAsFirExpression = false;
                void v3 = expression$iv;
                if (v3 != null) {
                    void this_$iv;
                    void var8_18 = v3;
                    boolean bl = false;
                    boolean bl2 = false;
                    void it$iv = var8_18;
                    boolean bl3 = false;
                    firElement3 = this_$iv.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                } else {
                    firElement3 = firElement2 = null;
                }
                if (!(firElement3 instanceof FirElement)) {
                    firElement2 = firElement = null;
                }
                if (firElement2 == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                    }
                    firElement = firErrorExpression;
                }
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY_DELEGATE) || Intrinsics.areEqual(iElementType, KtNodeTypes.INDICES) || Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION) || Intrinsics.areEqual(iElementType, KtNodeTypes.LOOP_RANGE)) {
                FirElement firElement4;
                FirElement firElement5;
                ExpressionsConverter this_$iv = this;
                LighterASTNode expression$iv = this.getExpressionInParentheses(expression2);
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode = expression$iv;
                if (lighterASTNode != null) {
                    LighterASTNode lighterASTNode2 = lighterASTNode;
                    boolean bl = false;
                    boolean bl4 = false;
                    LighterASTNode it$iv = lighterASTNode2;
                    boolean bl5 = false;
                    firElement5 = this_$iv.convertExpression(it$iv, errorReason);
                } else {
                    firElement5 = firElement4 = null;
                }
                if (!(firElement5 instanceof FirElement)) {
                    firElement4 = firElement = null;
                }
                if (firElement4 == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                    }
                    firElement = firErrorExpression;
                }
            } else {
                firElement = Intrinsics.areEqual(iElementType, KtNodeTypes.THIS_EXPRESSION) ? (FirElement)this.convertThisExpression(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.SUPER_EXPRESSION) ? (FirElement)this.convertSuperExpression(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_LITERAL) ? this.declarationsConverter.convertObjectLiteral(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.FUN) ? (FirElement)this.declarationsConverter.convertFunctionDeclaration(expression2) : (FirElement)FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionRequired)))));
            }
            return firElement;
        }
        boolean $i$f$buildExpressionStub = false;
        boolean bl = false;
        FirExpressionStubBuilder firExpressionStubBuilder = new FirExpressionStubBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirExpressionStubBuilder $receiver = firExpressionStubBuilder;
        return firExpressionStubBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertLambdaExpression(LighterASTNode lambdaExpression) {
        FirBlock firBlock;
        FirValueParameterBuilder firValueParameterBuilder;
        boolean bl;
        boolean bl2;
        Object object;
        boolean $i$f$buildValueParameter232;
        Object object2;
        boolean bl322;
        boolean bl3;
        boolean bl4;
        Object object3;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean bl6 = false;
        List valueParameterList = new ArrayList();
        LighterASTNode block = null;
        IElementType iElementType = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkNotNullExpressionValue(iElementType, "FUNCTION_LITERAL");
        LighterASTNode lighterASTNode = CollectionsKt.first(this.getChildNodesByType(lambdaExpression, iElementType));
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode lighterASTNode2 : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (lighterASTNode2 == null) break;
            IElementType tokenType$iv = lighterASTNode2.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it2 = lighterASTNode2;
            boolean bl7 = false;
            object3 = it2.getTokenType();
            if (Intrinsics.areEqual(object3, KtNodeTypes.VALUE_PARAMETER_LIST)) {
                Collection collection = valueParameterList;
                Iterable iterable = this.declarationsConverter.convertValueParameters(it2);
                bl4 = false;
                CollectionsKt.addAll(collection, iterable);
                continue;
            }
            if (!Intrinsics.areEqual(object3, KtNodeTypes.BLOCK)) continue;
            block = it2;
        }
        FirLightSourceElement expressionSource = this.toFirSourceElement(lambdaExpression);
        FirFunctionTarget target = null;
        boolean $i$f$buildAnonymousFunction = false;
        boolean bl8 = false;
        FirAnonymousFunctionBuilder firAnonymousFunctionBuilder = new FirAnonymousFunctionBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        FirAnonymousFunctionBuilder $this$buildAnonymousFunction = firAnonymousFunctionBuilder;
        boolean bl11 = false;
        $this$buildAnonymousFunction.setSource(expressionSource);
        $this$buildAnonymousFunction.setSession(this.getBaseSession());
        $this$buildAnonymousFunction.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        $this$buildAnonymousFunction.setReturnTypeRef(this.getImplicitType());
        $this$buildAnonymousFunction.setReceiverTypeRef(this.getImplicitType());
        $this$buildAnonymousFunction.setSymbol(new FirAnonymousFunctionSymbol());
        $this$buildAnonymousFunction.setLambda(true);
        Object object4 = $this$buildAnonymousFunction;
        FirLabel firLabel = this.pop(this.getContext().getFirLabels());
        if (firLabel == null) {
            Name name = CollectionsKt.lastOrNull(this.getContext().getCalleeNamesForLambda());
            if (name != null) {
                void it;
                Name name2 = name;
                boolean tokenType$iv = false;
                boolean it2 = false;
                Name bl7 = name2;
                object3 = object4;
                boolean bl12 = false;
                boolean $i$f$buildLabel = false;
                bl4 = false;
                FirLabelBuilder firLabelBuilder = new FirLabelBuilder();
                boolean bl5 = false;
                bl3 = false;
                FirLabelBuilder $this$buildLabel = firLabelBuilder;
                bl322 = false;
                String string2 = it.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "it.asString()");
                $this$buildLabel.setName(string2);
                object2 = firLabelBuilder.build();
                object4 = object3;
                firLabel = object2;
            } else {
                firLabel = null;
            }
        }
        ((FirAnonymousFunctionBuilder)object4).setLabel(firLabel);
        FirLabel firLabel2 = $this$buildAnonymousFunction.getLabel();
        target = new FirFunctionTarget(firLabel2 != null ? firLabel2.getName() : null, true);
        Collection collection = this.getContext().getFirFunctionTargets();
        FirFunctionTarget tokenType$iv = target;
        boolean it2 = false;
        collection.add(tokenType$iv);
        FirExpression firExpression2 = null;
        for (Object valueParameter : valueParameterList) {
            FirValueParameter firValueParameter;
            Object name;
            DestructuringDeclaration multiDeclaration = ((ValueParameter)valueParameter).getDestructuringDeclaration();
            Collection bl12 = $this$buildAnonymousFunction.getValueParameters();
            if (multiDeclaration != null) {
                Name name3 = Name.special("<destruct>");
                Intrinsics.checkNotNullExpressionValue(name3, "Name.special(\"<destruct>\")");
                name = name3;
                $i$f$buildValueParameter232 = false;
                bl3 = false;
                FirValueParameterBuilder firValueParameterBuilder2 = new FirValueParameterBuilder();
                boolean bl7 = false;
                bl322 = false;
                FirValueParameterBuilder $this$buildValueParameter = firValueParameterBuilder2;
                boolean bl15 = false;
                $this$buildValueParameter.setSession(this.getBaseSession());
                $this$buildValueParameter.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                boolean $i$f$buildImplicitTypeRef = false;
                boolean bl13 = false;
                object = new FirImplicitTypeRefBuilder();
                bl2 = false;
                bl = false;
                FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = object;
                firValueParameterBuilder = $this$buildValueParameter;
                Unit unit = Unit.INSTANCE;
                firValueParameterBuilder.setReturnTypeRef(((FirImplicitTypeRefBuilder)object).build());
                $this$buildValueParameter.setName((Name)name);
                $this$buildValueParameter.setSymbol(new FirVariableSymbol<FirValueParameter>((Name)name));
                $this$buildValueParameter.setDefaultValue(null);
                $this$buildValueParameter.setCrossinline(false);
                $this$buildValueParameter.setNoinline(false);
                $this$buildValueParameter.setVararg(false);
                FirValueParameter multiParameter = firValueParameterBuilder2.build();
                FirExpression firExpression3 = ConverterUtilKt.generateDestructuringBlock(this.getBaseSession(), multiDeclaration, multiParameter, false);
                firValueParameter = multiParameter;
            } else {
                firValueParameter = ((ValueParameter)valueParameter).getFirValueParameter();
            }
            name = firValueParameter;
            boolean multiParameter = false;
            bl12.add(name);
        }
        Object object5 = $this$buildAnonymousFunction;
        if (block != null) {
            void var12_27;
            void $this$apply;
            Object valueParameter;
            LighterASTNode lighterASTNode3 = block;
            Intrinsics.checkNotNull(lighterASTNode3);
            valueParameter = this.declarationsConverter.convertBlockExpressionWithoutBuilding(lighterASTNode3);
            it2 = false;
            boolean bl14 = false;
            Object bl12 = valueParameter;
            object3 = object5;
            boolean bl18 = false;
            if ($this$apply.getStatements().isEmpty()) {
                void $this$buildUnitExpression;
                void $this$buildReturnExpression;
                boolean $i$f$buildReturnExpression = false;
                $i$f$buildValueParameter232 = false;
                FirReturnExpressionBuilder $i$f$buildValueParameter232 = new FirReturnExpressionBuilder();
                bl3 = false;
                boolean bl15 = false;
                FirReturnExpressionBuilder bl322 = $i$f$buildValueParameter232;
                List<FirStatement> list2 = $this$apply.getStatements();
                boolean bl20 = false;
                $this$buildReturnExpression.setSource(expressionSource);
                $this$buildReturnExpression.setTarget(target);
                boolean $i$f$buildUnitExpression = false;
                boolean bl16 = false;
                object = new FirUnitExpressionBuilder();
                bl2 = false;
                bl = false;
                Object $receiver = object;
                firValueParameterBuilder = $this$buildReturnExpression;
                boolean bl22 = false;
                $this$buildUnitExpression.setSource(expressionSource);
                Unit unit = Unit.INSTANCE;
                ((FirReturnExpressionBuilder)((Object)firValueParameterBuilder)).setResult(((FirUnitExpressionBuilder)object).build());
                Unit unit2 = Unit.INSTANCE;
                list2.add($i$f$buildValueParameter232.build());
            }
            if (var12_27 instanceof FirBlock) {
                boolean $i$f$buildReturnExpression = false;
                for (FirStatement statement2 : (Iterable)((FirBlock)var12_27).getStatements()) {
                    void index2;
                    $this$apply.getStatements().add((int)index2, statement2);
                    ++index2;
                }
            }
            object2 = Unit.INSTANCE;
            object5 = object3;
            firBlock = ((FirBlockBuilder)valueParameter).build();
        } else {
            FirStatement statement$iv = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Lambda has no body", DiagnosticKind.Syntax));
            boolean $i$f$buildSingleExpressionBlock = false;
            firBlock = new FirSingleExpressionBlock(statement$iv);
        }
        ((FirAnonymousFunctionBuilder)object5).setBody(firBlock);
        this.removeLast(this.getContext().getFirFunctionTargets());
        FirAnonymousFunction firAnonymousFunction = firAnonymousFunctionBuilder.build();
        boolean bl23 = false;
        bl9 = false;
        FirAnonymousFunction it = firAnonymousFunction;
        boolean bl24 = false;
        target.bind((FirTargetElement)it);
        return firAnonymousFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final FirStatement convertBinaryExpression(LighterASTNode binaryExpression) {
        FirStatement firStatement;
        boolean bl;
        FirElement firElement;
        FirElement firElement2;
        FirElement firElement3;
        IElementType this_$iv;
        void expression$iv;
        FirExpression firExpression2;
        ExpressionsConverter expression$iv2;
        Object errorReason$iv;
        IElementType operationToken;
        void $this$forEachChildren$iv;
        void this_$iv2;
        Object kidsArray$iv2;
        boolean isLeftArgument = true;
        String operationTokenName = null;
        LighterASTNode leftArgNode = null;
        LighterASTNode rightArg = null;
        FirLightSourceElement operationReferenceSource = null;
        LighterASTNode lighterASTNode = binaryExpression;
        BaseConverter baseConverter = this;
        Object skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren2 = false;
        for (LighterASTNode kid$iv : kidsArray$iv2 = this_$iv2.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OPERATION_REFERENCE)) {
                isLeftArgument = false;
                operationTokenName = this.getAsText(it);
                operationReferenceSource = this.toFirSourceElement(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            if (isLeftArgument) {
                leftArgNode = it;
                continue;
            }
            rightArg = it;
        }
        FirLightSourceElement baseSource = this.toFirSourceElement(binaryExpression);
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
        }
        if (Intrinsics.areEqual(operationToken = ConverterUtilKt.getOperationSymbol(string2), KtTokens.IDENTIFIER)) {
            skipTokens$iv = this.getContext().getCalleeNamesForLambda();
            Name $i$f$forEachChildren2 = ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null);
            boolean kidsArray$iv2 = false;
            skipTokens$iv.add($i$f$forEachChildren2);
        }
        if (rightArg != null) {
            FirElement firElement4;
            FirElement firElement5;
            FirElement firElement6;
            ExpressionsConverter $i$f$forEachChildren2 = this;
            kidsArray$iv2 = rightArg;
            errorReason$iv = "No right operand";
            boolean $i$f$getAsFirExpression = false;
            void v1 = expression$iv2;
            if (v1 != null) {
                void this_$iv3;
                void var14_24 = v1;
                boolean bl3 = false;
                boolean tokenType$iv = false;
                void it$iv = var14_24;
                boolean bl4 = false;
                firElement6 = this_$iv3.convertExpression((LighterASTNode)it$iv, (String)errorReason$iv);
            } else {
                firElement6 = firElement5 = null;
            }
            if (!(firElement6 instanceof FirExpression)) {
                firElement5 = null;
            }
            if ((firElement4 = (FirElement)((FirExpression)firElement5)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic((String)errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement4 = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement4;
        } else {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No right operand", DiagnosticKind.Syntax));
        }
        FirExpression rightArgAsFir = firExpression2;
        expression$iv2 = this;
        errorReason$iv = leftArgNode;
        String errorReason$iv222 = "No left operand";
        boolean $i$f$getAsFirExpression = false;
        void v7 = expression$iv;
        if (v7 != null) {
            void var15_29 = v7;
            boolean tokenType$iv = false;
            boolean it$iv = false;
            void it$iv2 = var15_29;
            boolean bl5 = false;
            firElement3 = ((ExpressionsConverter)((Object)this_$iv)).convertExpression((LighterASTNode)it$iv2, errorReason$iv222);
        } else {
            firElement3 = firElement2 = null;
        }
        if (!(firElement3 instanceof FirExpression)) {
            firElement2 = null;
        }
        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv222, DiagnosticKind.ExpressionRequired));
            if (firErrorExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
            }
            firElement = firErrorExpression;
        }
        FirExpression leftArgAsFir = (FirExpression)firElement;
        if (Intrinsics.areEqual(operationToken, KtTokens.IDENTIFIER)) {
            this.removeLast(this.getContext().getCalleeNamesForLambda());
        }
        if (Intrinsics.areEqual(this_$iv = operationToken, KtTokens.ELVIS)) {
            return ConversionUtilsKt.generateNotNullOrOther(leftArgAsFir, this.getBaseSession(), rightArgAsFir, "elvis", baseSource);
        }
        if (Intrinsics.areEqual(this_$iv, KtTokens.ANDAND) || Intrinsics.areEqual(this_$iv, KtTokens.OROR)) {
            return ConversionUtilsKt.generateLazyLogicalOperation(leftArgAsFir, rightArgAsFir, Intrinsics.areEqual(operationToken, KtTokens.ANDAND), baseSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, "OperatorConventions.IN_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet, this_$iv)) {
            return ConversionUtilsKt.generateContainsOperation(rightArgAsFir, leftArgAsFir, Intrinsics.areEqual(operationToken, KtTokens.NOT_IN), baseSource, operationReferenceSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet2 = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet2, "OperatorConventions.COMPARISON_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet2, this_$iv)) {
            return ConversionUtilsKt.generateComparisonExpression(leftArgAsFir, rightArgAsFir, operationToken, baseSource, operationReferenceSource);
        }
        Name conventionCallName = ConversionUtilsKt.toBinaryName(operationToken);
        if (conventionCallName != null || Intrinsics.areEqual(operationToken, KtTokens.IDENTIFIER)) {
            void $this$buildSimpleNamedReference;
            boolean $i$f$buildFunctionCall = false;
            boolean errorReason$iv222 = false;
            FirFunctionCallBuilder errorReason$iv222 = new FirFunctionCallBuilder();
            bl = false;
            boolean bl6 = false;
            FirFunctionCallBuilder $this$buildFunctionCall = errorReason$iv222;
            boolean bl7 = false;
            $this$buildFunctionCall.setSource(this.toFirSourceElement(binaryExpression));
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl8 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            boolean bl9 = false;
            boolean bl10 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
            FirFunctionCallBuilder firFunctionCallBuilder = $this$buildFunctionCall;
            boolean bl11 = false;
            $this$buildSimpleNamedReference.setSource($this$buildFunctionCall.getSource());
            Name name = conventionCallName;
            if (name == null) {
                name = ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null);
            }
            $this$buildSimpleNamedReference.setName(name);
            Unit unit = Unit.INSTANCE;
            firFunctionCallBuilder.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$buildFunctionCall.setExplicitReceiver(leftArgAsFir);
            $this$buildFunctionCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(rightArgAsFir));
            firStatement = errorReason$iv222.build();
        } else {
            FirOperation firOperation = ConversionUtilsKt.toFirOperation(operationToken);
            if (FirOperation.Companion.getASSIGNMENTS().contains((Object)firOperation)) {
                return this.generateAssignment(leftArgNode, this.toFirSourceElement(binaryExpression), rightArg, rightArgAsFir, firOperation, (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateAssignment) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter($this$generateAssignment, "$receiver");
                        ExpressionsConverter this_$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode lighterASTNode = $this$generateAssignment;
                        boolean bl = false;
                        boolean bl2 = false;
                        LighterASTNode it$iv = lighterASTNode;
                        boolean bl3 = false;
                        FirElement firElement2 = this_$iv.convertExpression(it$iv, errorReason$iv);
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                    {
                        this.this$0 = expressionsConverter;
                        super(1);
                    }
                });
            }
            boolean $i$f$buildOperatorCall = false;
            bl = false;
            FirOperatorCallBuilder firOperatorCallBuilder = new FirOperatorCallBuilder();
            boolean bl12 = false;
            boolean bl13 = false;
            FirOperatorCallBuilder $this$buildOperatorCall = firOperatorCallBuilder;
            boolean bl14 = false;
            $this$buildOperatorCall.setSource(this.toFirSourceElement(binaryExpression));
            $this$buildOperatorCall.setOperation(firOperation);
            $this$buildOperatorCall.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(leftArgAsFir, rightArgAsFir));
            firStatement = firOperatorCallBuilder.build();
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeOperatorCall convertBinaryWithTypeRHSExpression(LighterASTNode binaryExpression, Function1<? super String, ? extends FirOperation> toFirOperation) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String operationTokenName = null;
        FirExpression leftArgAsFir = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No left operand", DiagnosticKind.Syntax));
        FirTypeRef firType = null;
        LighterASTNode lighterASTNode = binaryExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OPERATION_REFERENCE)) {
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No left operand";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            leftArgAsFir = (FirExpression)firElement;
        }
        boolean $i$f$buildTypeOperatorCall = false;
        boolean bl = false;
        FirTypeOperatorCallBuilder firTypeOperatorCallBuilder = new FirTypeOperatorCallBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirTypeOperatorCallBuilder $this$buildTypeOperatorCall = firTypeOperatorCallBuilder;
        boolean bl7 = false;
        $this$buildTypeOperatorCall.setSource(this.toFirSourceElement(binaryExpression));
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
        }
        $this$buildTypeOperatorCall.setOperation(toFirOperation.invoke(string2));
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firType");
        }
        $this$buildTypeOperatorCall.setConversionTypeRef(firTypeRef);
        $this$buildTypeOperatorCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(leftArgAsFir));
        return firTypeOperatorCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertLabeledExpression(LighterASTNode labeledExpression) {
        FirElement firElement;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        int size = this.getContext().getFirLabels().size();
        FirElement firExpression2 = null;
        LighterASTNode lighterASTNode = labeledExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement2;
            boolean bl;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.LABEL_QUALIFIER)) {
                Collection collection = this.getContext().getFirLabels();
                boolean $i$f$buildLabel22 = false;
                boolean bl3 = false;
                FirLabelBuilder firLabelBuilder = new FirLabelBuilder();
                boolean bl4 = false;
                bl = false;
                FirLabelBuilder $this$buildLabel = firLabelBuilder;
                boolean bl5 = false;
                $this$buildLabel.setName(StringsKt.replace$default(it.toString(), "@", "", false, 4, null));
                FirLabel $i$f$buildLabel22 = firLabelBuilder.build();
                bl3 = false;
                collection.add($i$f$buildLabel22);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firExpression2 = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY)) {
                firExpression2 = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, it, null, 2, null);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter this_$iv2 = this;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            bl = false;
            boolean bl6 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl7 = false;
            FirElement firElement3 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement3 instanceof FirElement)) {
                firElement3 = firElement2 = null;
            }
            if (firElement3 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement2 = firErrorExpression;
            }
            firExpression2 = firElement2;
        }
        if (size != this.getContext().getFirLabels().size()) {
            this.removeLast(this.getContext().getFirLabels());
        }
        if ((firElement = firExpression2) == null) {
            firElement = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Empty label", DiagnosticKind.Syntax));
        }
        return firElement;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertUnaryExpression(LighterASTNode unaryExpression) {
        FirExpression firExpression2;
        boolean $i$f$getAsFirExpression;
        Object object;
        Object tokenType$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String operationTokenName = null;
        LighterASTNode argument = null;
        LighterASTNode operationReference = null;
        LighterASTNode lighterASTNode = unaryExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren232 = false;
        for (LighterASTNode lighterASTNode2 : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (lighterASTNode2 == null) break;
            tokenType$iv = lighterASTNode2.getTokenType();
            if (KtTokens.COMMENTS.contains((IElementType)tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = lighterASTNode2;
            boolean bl = false;
            object = it.getTokenType();
            if (Intrinsics.areEqual(object, KtNodeTypes.OPERATION_REFERENCE)) {
                operationReference = it;
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            argument = it;
        }
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
        }
        IElementType operationToken = ConverterUtilKt.getOperationSymbol(string2);
        Name conventionCallName = ConversionUtilsKt.toUnaryName(operationToken);
        if (Intrinsics.areEqual(operationToken, KtTokens.EXCLEXCL)) {
            FirElement firElement;
            FirElement firElement2;
            FirElement firElement3;
            void expression$iv2232;
            boolean $i$f$buildCheckNotNullCall = false;
            $i$f$forEachChildren232 = false;
            FirCheckNotNullCallBuilder $i$f$forEachChildren232 = new FirCheckNotNullCallBuilder();
            boolean bl = false;
            boolean bl2 = false;
            FirCheckNotNullCallBuilder $this$buildCheckNotNullCall = $i$f$forEachChildren232;
            boolean bl3 = false;
            $this$buildCheckNotNullCall.setSource(this.toFirSourceElement(unaryExpression));
            ExpressionsConverter expressionsConverter = this;
            tokenType$iv = argument;
            String errorReason$iv32 = "No operand";
            $i$f$getAsFirExpression = false;
            void v1 = expression$iv2232;
            if (v1 != null) {
                object = v1;
                boolean firFunctionCallBuilder = false;
                boolean bl10 = false;
                IElementType it$iv = object;
                boolean bl6 = false;
                firElement3 = expressionsConverter.convertExpression((LighterASTNode)((Object)it$iv), errorReason$iv32);
            } else {
                firElement3 = firElement2 = null;
            }
            if (!(firElement3 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv32, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$buildCheckNotNullCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList((FirExpression)firElement));
            firExpression2 = $i$f$forEachChildren232.build();
        } else if (conventionCallName != null) {
            FirElement firElement;
            FirElement firElement4;
            FirElement firElement5;
            void expression$iv2;
            void $this$buildSimpleNamedReference;
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.INCREMENT_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, "OperatorConventions.INCREMENT_OPERATIONS");
            if (CollectionsKt.contains((Iterable)immutableSet, operationToken)) {
                return this.generateIncrementOrDecrementBlock(unaryExpression, operationReference, argument, conventionCallName, Intrinsics.areEqual(unaryExpression.getTokenType(), KtNodeTypes.PREFIX_EXPRESSION), (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateIncrementOrDecrementBlock) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter($this$generateIncrementOrDecrementBlock, "$receiver");
                        ExpressionsConverter this_$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode lighterASTNode = $this$generateIncrementOrDecrementBlock;
                        boolean bl = false;
                        boolean bl2 = false;
                        LighterASTNode it$iv = lighterASTNode;
                        boolean bl3 = false;
                        FirElement firElement2 = this_$iv.convertExpression(it$iv, errorReason$iv);
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                    {
                        this.this$0 = expressionsConverter;
                        super(1);
                    }
                });
            }
            boolean $i$f$buildFunctionCall = false;
            $i$f$forEachChildren232 = false;
            FirFunctionCallBuilder $i$f$forEachChildren232 = new FirFunctionCallBuilder();
            boolean bl = false;
            boolean bl7 = false;
            FirFunctionCallBuilder $this$buildFunctionCall = $i$f$forEachChildren232;
            boolean bl8 = false;
            $this$buildFunctionCall.setSource(this.toFirSourceElement(unaryExpression));
            boolean bl2 = false;
            boolean expression$iv2232 = false;
            Object expression$iv2232 = new FirSimpleNamedReferenceBuilder();
            boolean errorReason$iv32 = false;
            $i$f$getAsFirExpression = false;
            object = expression$iv2232;
            FirFunctionCallBuilder firFunctionCallBuilder = $this$buildFunctionCall;
            boolean bl9 = false;
            $this$buildSimpleNamedReference.setSource($this$buildFunctionCall.getSource());
            $this$buildSimpleNamedReference.setName(conventionCallName);
            Unit bl14 = Unit.INSTANCE;
            firFunctionCallBuilder.setCalleeReference(((FirSimpleNamedReferenceBuilder)expression$iv2232).build());
            ExpressionsConverter expressionsConverter = this;
            expression$iv2232 = argument;
            String errorReason$iv2 = "No operand";
            $i$f$getAsFirExpression = false;
            void v8 = expression$iv2;
            if (v8 != null) {
                $this$buildSimpleNamedReference = v8;
                boolean bl13 = false;
                boolean bl6 = false;
                void it$iv = $this$buildSimpleNamedReference;
                boolean bl3 = false;
                firElement5 = expressionsConverter.convertExpression((LighterASTNode)it$iv, errorReason$iv2);
            } else {
                firElement5 = firElement4 = null;
            }
            if (!(firElement5 instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv2, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$buildFunctionCall.setExplicitReceiver((FirExpression)firElement);
            firExpression2 = $i$f$forEachChildren232.build();
        } else {
            FirElement firElement;
            FirElement firElement6;
            FirElement firElement7;
            void expression$iv;
            FirOperation firOperation = ConversionUtilsKt.toFirOperation(operationToken);
            boolean $i$f$buildOperatorCall = false;
            boolean bl = false;
            FirOperatorCallBuilder firOperatorCallBuilder = new FirOperatorCallBuilder();
            boolean bl11 = false;
            int n = 0;
            FirOperatorCallBuilder $this$buildOperatorCall = firOperatorCallBuilder;
            boolean bl4 = false;
            $this$buildOperatorCall.setSource(this.toFirSourceElement(unaryExpression));
            $this$buildOperatorCall.setOperation(firOperation);
            ExpressionsConverter expression$iv2 = this;
            LighterASTNode errorReason$iv2 = argument;
            String errorReason$iv = "No operand";
            boolean $i$f$getAsFirExpression2 = false;
            void v13 = expression$iv;
            if (v13 != null) {
                void this_$iv4;
                void var18_44 = v13;
                boolean bl5 = false;
                boolean bl6 = false;
                void it$iv = var18_44;
                boolean bl15 = false;
                firElement7 = this_$iv4.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            } else {
                firElement7 = firElement6 = null;
            }
            if (!(firElement7 instanceof FirExpression)) {
                firElement6 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement6)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$buildOperatorCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList((FirExpression)firElement));
            firExpression2 = firOperatorCallBuilder.build();
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertAnnotatedExpression(LighterASTNode annotatedExpression) {
        Object object;
        block12: {
            FirElement firExpression2;
            block11: {
                void $this$forEachChildren$iv;
                void this_$iv;
                LighterASTNode[] kidsArray$iv;
                firExpression2 = null;
                boolean bl = false;
                List firAnnotationList = new ArrayList();
                LighterASTNode lighterASTNode = annotatedExpression;
                Object object2 = this;
                KtToken[] skipTokens$iv = new KtToken[]{};
                boolean $i$f$forEachChildren = false;
                for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                    FirElement firElement;
                    boolean bl2;
                    Object object3;
                    Collection collection;
                    if (kid$iv == null) break;
                    IElementType tokenType$iv = kid$iv.getTokenType();
                    if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                    LighterASTNode it = kid$iv;
                    boolean bl3 = false;
                    IElementType iElementType = it.getTokenType();
                    if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATION)) {
                        collection = firAnnotationList;
                        object3 = this.declarationsConverter.convertAnnotation(it);
                        bl2 = false;
                        CollectionsKt.addAll(collection, object3);
                        continue;
                    }
                    if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATION_ENTRY)) {
                        collection = firAnnotationList;
                        object3 = DeclarationsConverter.convertAnnotationEntry$default(this.declarationsConverter, it, null, 2, null);
                        bl2 = false;
                        collection.add(object3);
                        continue;
                    }
                    if (!ConverterUtilKt.isExpression(it)) continue;
                    ExpressionsConverter this_$iv2 = this;
                    String errorReason$iv = "";
                    boolean $i$f$getAsFirExpression = false;
                    LighterASTNode lighterASTNode2 = it;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    LighterASTNode it$iv = lighterASTNode2;
                    boolean bl6 = false;
                    FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                    if (!(firElement2 instanceof FirElement)) {
                        firElement2 = firElement = null;
                    }
                    if (firElement2 == null) {
                        FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                        if (firErrorExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                        }
                        firElement = firErrorExpression;
                    }
                    firExpression2 = firElement;
                }
                object = firExpression2;
                if (object == null) break block11;
                object2 = object;
                boolean bl7 = false;
                boolean bl8 = false;
                Object it = object2;
                boolean bl9 = false;
                boolean bl10 = it instanceof FirAnnotationContainer;
                int n = 0;
                int n2 = 0;
                n2 = 0;
                boolean bl11 = false;
                if (!bl10) {
                    boolean bl12 = false;
                    String string2 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                List<FirAnnotationCall> list2 = ((FirAnnotationContainer)it).getAnnotations();
                if (list2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
                }
                Collection collection = TypeIntrinsics.asMutableList(list2);
                Iterable iterable = firAnnotationList;
                n2 = 0;
                CollectionsKt.addAll(collection, iterable);
                object = object2;
                if (object != null) break block12;
            }
            FirElement firElement = firExpression2;
            object = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Strange annotated expression: " + (firElement != null ? FirRendererKt.render$default(firElement, null, 1, null) : null), DiagnosticKind.Syntax));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertClassLiteralExpression(LighterASTNode classLiteralExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firReceiverExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No receiver in class literal", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode = classLiteralExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No receiver in class literal";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firReceiverExpression = (FirExpression)firElement;
        }
        boolean $i$f$buildGetClassCall = false;
        boolean bl = false;
        FirGetClassCallBuilder firGetClassCallBuilder = new FirGetClassCallBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirGetClassCallBuilder $this$buildGetClassCall = firGetClassCallBuilder;
        boolean bl7 = false;
        $this$buildGetClassCall.setSource(this.toFirSourceElement(classLiteralExpression));
        $this$buildGetClassCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(firReceiverExpression));
        return firGetClassCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallableReferenceExpression(LighterASTNode callableReferenceExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isReceiver = true;
        boolean safe = false;
        FirExpression firReceiverExpression = null;
        FirQualifiedAccess firCallableReference = null;
        LighterASTNode lighterASTNode = callableReferenceExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtTokens.COLONCOLON)) {
                isReceiver = false;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.QUEST)) {
                safe = true;
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            if (isReceiver) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "Incorrect receiver expression";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode2 = it;
                boolean bl2 = false;
                boolean bl3 = false;
                LighterASTNode it$iv = lighterASTNode2;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firReceiverExpression = (FirExpression)firElement;
                continue;
            }
            firCallableReference = this.convertSimpleNameExpression(it);
        }
        boolean $i$f$buildCallableReferenceAccess = false;
        boolean bl = false;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirCallableReferenceAccessBuilder $this$buildCallableReferenceAccess = firCallableReferenceAccessBuilder;
        boolean bl7 = false;
        $this$buildCallableReferenceAccess.setSource(this.toFirSourceElement(callableReferenceExpression));
        FirQualifiedAccess firQualifiedAccess = firCallableReference;
        if (firQualifiedAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firCallableReference");
        }
        FirReference firReference = firQualifiedAccess.getCalleeReference();
        if (firReference == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.references.FirNamedReference");
        }
        $this$buildCallableReferenceAccess.setCalleeReference((FirNamedReference)firReference);
        $this$buildCallableReferenceAccess.setExplicitReceiver(firReceiverExpression);
        $this$buildCallableReferenceAccess.setSafe(safe);
        return firCallableReferenceAccessBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertQualifiedExpression(LighterASTNode dotQualifiedExpression) {
        FirExpression firSelector;
        block11: {
            void $this$forEachChildren$iv;
            void this_$iv;
            LighterASTNode[] kidsArray$iv;
            boolean isSelector = false;
            boolean isSafe = false;
            firSelector = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Qualified expression without selector", DiagnosticKind.Syntax));
            FirExpression firReceiver = null;
            LighterASTNode lighterASTNode = dotQualifiedExpression;
            Object object = this;
            KtToken[] skipTokens$iv = new KtToken[]{};
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                ExpressionsConverter this_$iv2;
                boolean bl;
                LighterASTNode it$iv;
                boolean bl2;
                boolean bl3;
                LighterASTNode lighterASTNode2;
                boolean $i$f$getAsFirExpression;
                String errorReason$iv;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                LighterASTNode it = kid$iv;
                boolean bl4 = false;
                IElementType iElementType = it.getTokenType();
                if (Intrinsics.areEqual(iElementType, KtTokens.DOT)) {
                    isSelector = true;
                    continue;
                }
                if (Intrinsics.areEqual(iElementType, KtTokens.SAFE_ACCESS)) {
                    isSafe = true;
                    isSelector = true;
                    continue;
                }
                if (isSelector && Intrinsics.areEqual(it.getTokenType(), TokenType.ERROR_ELEMENT) ^ true) {
                    FirElement firElement2;
                    ExpressionsConverter expressionsConverter = this;
                    errorReason$iv = "Incorrect selector expression";
                    $i$f$getAsFirExpression = false;
                    lighterASTNode2 = it;
                    bl3 = false;
                    bl2 = false;
                    it$iv = lighterASTNode2;
                    bl = false;
                    FirElement firElement3 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                    if (!(firElement3 instanceof FirExpression)) {
                        firElement3 = null;
                    }
                    if ((firElement2 = (FirElement)((FirExpression)firElement3)) == null) {
                        FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                        if (firErrorExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                        }
                        firElement2 = firErrorExpression;
                    }
                    firSelector = (FirExpression)firElement2;
                    continue;
                }
                this_$iv2 = this;
                errorReason$iv = "Incorrect receiver expression";
                $i$f$getAsFirExpression = false;
                lighterASTNode2 = it;
                bl3 = false;
                bl2 = false;
                it$iv = lighterASTNode2;
                bl = false;
                FirElement firElement4 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement4 instanceof FirExpression)) {
                    firElement4 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firReceiver = (FirExpression)firElement;
            }
            FirExpression firExpression2 = firSelector;
            if (!(firExpression2 instanceof FirModifiableQualifiedAccess)) {
                firExpression2 = null;
            }
            FirModifiableQualifiedAccess firModifiableQualifiedAccess = (FirModifiableQualifiedAccess)((Object)firExpression2);
            if (firModifiableQualifiedAccess == null) break block11;
            object = firModifiableQualifiedAccess;
            boolean bl = false;
            boolean bl5 = false;
            Object it = object;
            boolean bl6 = false;
            it.setSafe(isSafe);
            it.setExplicitReceiver(firReceiver);
        }
        return firSelector;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallExpression(LighterASTNode callSuffix) {
        FirQualifiedAccessBuilder builder;
        FirQualifiedAccessBuilder firQualifiedAccessBuilder;
        void calleeReference;
        FirAnnotationContainerBuilder $this$apply;
        boolean bl;
        FirQualifiedAccessBuilder firQualifiedAccessBuilder2;
        Object node;
        Object $this$buildErrorNamedReference;
        boolean $i$f$buildErrorNamedReference;
        Pair<FirNamedReference, Object> pair;
        Object $this$buildSimpleNamedReference;
        int n;
        int n2;
        Object object;
        boolean $i$f$buildSimpleNamedReference;
        void hasArguments;
        void additionalArgument;
        void superNode;
        void name;
        boolean $i$a$-forEachChildren-ExpressionsConverter$convertCallExpression$22;
        FirNamedReference $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        boolean bl2 = false;
        List firTypeArguments = new ArrayList();
        boolean bl3 = false;
        List valueArguments = new ArrayList();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        LighterASTNode lighterASTNode = callSuffix;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)((Object)$this$forEachChildren$iv))) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode child = kid$iv;
            $i$a$-forEachChildren-ExpressionsConverter$convertCallExpression$22 = false;
            Function1<LighterASTNode, Unit> $fun$process$1 = new Function1<LighterASTNode, Unit>(this, (Ref.ObjectRef)name, (Ref.ObjectRef)superNode, (Ref.ObjectRef)additionalArgument, firTypeArguments, (Ref.BooleanRef)hasArguments, valueArguments){
                final /* synthetic */ ExpressionsConverter this$0;
                final /* synthetic */ Ref.ObjectRef $name$inlined;
                final /* synthetic */ Ref.ObjectRef $superNode$inlined;
                final /* synthetic */ Ref.ObjectRef $additionalArgument$inlined;
                final /* synthetic */ List $firTypeArguments$inlined;
                final /* synthetic */ Ref.BooleanRef $hasArguments$inlined;
                final /* synthetic */ List $valueArguments$inlined;
                {
                    this.this$0 = expressionsConverter;
                    this.$name$inlined = objectRef;
                    this.$superNode$inlined = objectRef2;
                    this.$additionalArgument$inlined = objectRef3;
                    this.$firTypeArguments$inlined = list2;
                    this.$hasArguments$inlined = booleanRef;
                    this.$valueArguments$inlined = list3;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull LighterASTNode node) {
                    Intrinsics.checkNotNullParameter(node, "node");
                    IElementType iElementType = node.getTokenType();
                    if (Intrinsics.areEqual(iElementType, KtNodeTypes.REFERENCE_EXPRESSION)) {
                        this.$name$inlined.element = this.this$0.getAsText(node);
                    } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.SUPER_EXPRESSION)) {
                        this.$superNode$inlined.element = node;
                    } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PARENTHESIZED)) {
                        LighterASTNode lighterASTNode = this.this$0.getExpressionInParentheses(node);
                        if (lighterASTNode != null) {
                            LighterASTNode lighterASTNode2 = lighterASTNode;
                            boolean bl = false;
                            boolean bl2 = false;
                            LighterASTNode it = lighterASTNode2;
                            boolean bl3 = false;
                            this.invoke(it);
                        } else {
                            FirElement firElement;
                            void this_$iv;
                            void expression$iv;
                            ExpressionsConverter expressionsConverter = this.this$0;
                            boolean bl = false;
                            boolean bl4 = false;
                            ExpressionsConverter $this$run = expressionsConverter;
                            boolean bl5 = false;
                            ExpressionsConverter expressionsConverter2 = $this$run;
                            LighterASTNode lighterASTNode3 = node;
                            String errorReason$iv = "Incorrect invoke receiver";
                            boolean $i$f$getAsFirExpression = false;
                            void var12_30 = expression$iv;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            void it$iv = var12_30;
                            boolean bl8 = false;
                            FirElement firElement2 = this_$iv.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                            if (!(firElement2 instanceof FirExpression)) {
                                firElement2 = null;
                            }
                            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                                if (firErrorExpression == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                                }
                                firElement = firErrorExpression;
                            }
                            this.$additionalArgument$inlined.element = (FirExpression)firElement;
                        }
                    } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_ARGUMENT_LIST)) {
                        Collection collection = this.$firTypeArguments$inlined;
                        Iterable iterable = ExpressionsConverter.access$getDeclarationsConverter$p(this.this$0).convertTypeArguments(node);
                        boolean bl = false;
                        CollectionsKt.addAll(collection, iterable);
                    } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT_LIST) || Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_ARGUMENT)) {
                        this.$hasArguments$inlined.element = true;
                        Collection collection = this.$valueArguments$inlined;
                        boolean bl = false;
                        collection.add(node);
                    } else if (Intrinsics.areEqual(node.getTokenType(), TokenType.ERROR_ELEMENT) ^ true) {
                        FirElement firElement;
                        void this_$iv;
                        ExpressionsConverter expressionsConverter = this.this$0;
                        String errorReason$iv = "Incorrect invoke receiver";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode lighterASTNode = node;
                        boolean bl = false;
                        boolean bl9 = false;
                        LighterASTNode it$iv = lighterASTNode;
                        boolean bl10 = false;
                        FirElement firElement3 = this_$iv.convertExpression(it$iv, errorReason$iv);
                        if (!(firElement3 instanceof FirExpression)) {
                            firElement3 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        this.$additionalArgument$inlined.element = (FirExpression)firElement;
                    }
                }
            };
            $fun$process$1.invoke(child);
        }
        FirLightSourceElement source = this.toFirSourceElement(callSuffix);
        if ((String)name.element != null) {
            $i$f$buildSimpleNamedReference = false;
            boolean bl4 = false;
            object = new FirSimpleNamedReferenceBuilder();
            n2 = 0;
            n = 0;
            $this$buildSimpleNamedReference = object;
            boolean bl5 = false;
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setSource(source);
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setName(ConverterUtilKt.nameAsSafeName$default((String)name.element, null, 1, null));
            pair = TuplesKt.to(((FirSimpleNamedReferenceBuilder)object).build(), null);
        } else if ((FirExpression)additionalArgument.element != null) {
            $i$f$buildSimpleNamedReference = false;
            boolean bl6 = false;
            object = new FirSimpleNamedReferenceBuilder();
            n2 = 0;
            n = 0;
            $this$buildSimpleNamedReference = object;
            boolean bl7 = false;
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setSource(source);
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference).setName(OperatorNameConventions.INVOKE);
            FirNamedReference firNamedReference = ((FirSimpleNamedReferenceBuilder)object).build();
            FirExpression firExpression2 = (FirExpression)additionalArgument.element;
            Intrinsics.checkNotNull(firExpression2);
            pair = TuplesKt.to(firNamedReference, firExpression2);
        } else if ((LighterASTNode)superNode.element != null) {
            $i$f$buildErrorNamedReference = false;
            boolean bl8 = false;
            object = new FirErrorNamedReferenceBuilder();
            n2 = 0;
            n = 0;
            $this$buildErrorNamedReference = object;
            boolean bl9 = false;
            LighterASTNode lighterASTNode2 = (LighterASTNode)superNode.element;
            Intrinsics.checkNotNull(lighterASTNode2);
            node = lighterASTNode2;
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setSource(this.toFirSourceElement((LighterASTNode)node));
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setDiagnostic(new ConeSimpleDiagnostic("Super cannot be a callee", DiagnosticKind.SuperNotAllowed));
            pair = TuplesKt.to(((FirErrorNamedReferenceBuilder)object).build(), null);
        } else {
            $i$f$buildErrorNamedReference = false;
            boolean bl10 = false;
            object = new FirErrorNamedReferenceBuilder();
            n2 = 0;
            n = 0;
            $this$buildErrorNamedReference = object;
            boolean bl11 = false;
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setSource(source);
            ((FirErrorNamedReferenceBuilder)$this$buildErrorNamedReference).setDiagnostic(new ConeSimpleDiagnostic("Call has no callee", DiagnosticKind.Syntax));
            pair = TuplesKt.to(((FirErrorNamedReferenceBuilder)object).build(), null);
        }
        Pair<FirNamedReference, Object> $i$f$forEachChildren22 = pair;
        $this$forEachChildren$iv = $i$f$forEachChildren22.component1();
        FirExpression explicitReceiver = $i$f$forEachChildren22.component2();
        if (hasArguments.element) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            firQualifiedAccessBuilder2 = new FirFunctionCallBuilder();
            bl = false;
            n2 = 0;
            $this$apply = firQualifiedAccessBuilder2;
            boolean bl12 = false;
            ((FirFunctionCallBuilder)$this$apply).setSource(source);
            ((FirFunctionCallBuilder)$this$apply).setCalleeReference((FirNamedReference)calleeReference);
            Iterable bl11 = this.getContext().getCalleeNamesForLambda();
            node = calleeReference.getName();
            $i$a$-forEachChildren-ExpressionsConverter$convertCallExpression$22 = false;
            bl11.add(node);
            bl11 = valueArguments;
            FirCallBuilder firCallBuilder = (FirCallBuilder)((Object)$this$apply);
            boolean $i$f$flatMap = false;
            void $i$a$-forEachChildren-ExpressionsConverter$convertCallExpression$22 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl13 = false;
                Iterable list$iv$iv = this.convertValueArguments(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            ConverterUtilKt.extractArgumentsFrom(firCallBuilder, list2, this.stubMode);
            this.removeLast(this.getContext().getCalleeNamesForLambda());
            firQualifiedAccessBuilder = firQualifiedAccessBuilder2;
        } else {
            firQualifiedAccessBuilder2 = new FirQualifiedAccessExpressionBuilder();
            bl = false;
            n2 = 0;
            $this$apply = firQualifiedAccessBuilder2;
            boolean bl14 = false;
            ((FirQualifiedAccessExpressionBuilder)$this$apply).setSource(source);
            ((FirQualifiedAccessExpressionBuilder)$this$apply).setCalleeReference((FirReference)calleeReference);
            firQualifiedAccessBuilder = firQualifiedAccessBuilder2;
        }
        firQualifiedAccessBuilder2 = builder = firQualifiedAccessBuilder;
        bl = false;
        n2 = 0;
        $this$apply = firQualifiedAccessBuilder2;
        boolean bl15 = false;
        $this$apply.setExplicitReceiver(explicitReceiver);
        Collection collection = $this$apply.getTypeArguments();
        Iterable iterable = firTypeArguments;
        boolean bl16 = false;
        CollectionsKt.addAll(collection, iterable);
        FirQualifiedAccess firQualifiedAccess = firQualifiedAccessBuilder2.build();
        if (firQualifiedAccess == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
        }
        return (FirExpression)((Object)firQualifiedAccess);
    }

    private final FirExpression convertStringTemplate(LighterASTNode stringTemplate) {
        return this.toInterpolatingCall(this.getChildrenAsArray(stringTemplate), stringTemplate, (Function2)new Function2<LighterASTNode, String, FirExpression>(this){
            final /* synthetic */ ExpressionsConverter this$0;

            @NotNull
            public final FirExpression invoke(@Nullable LighterASTNode $this$toInterpolatingCall, @NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ExpressionsConverter.access$convertShortOrLongStringTemplate(this.this$0, $this$toInterpolatingCall, it);
            }
            {
                this.this$0 = expressionsConverter;
                super(2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertShortOrLongStringTemplate(LighterASTNode $this$convertShortOrLongStringTemplate, String errorReason) {
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode = $this$convertShortOrLongStringTemplate;
        if (lighterASTNode != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            LighterASTNode[] kidsArray$iv;
            LighterASTNode lighterASTNode2 = lighterASTNode;
            BaseConverter baseConverter = this;
            KtToken[] ktTokenArray = new KtToken[2];
            KtToken ktToken = KtTokens.LONG_TEMPLATE_ENTRY_START;
            Intrinsics.checkNotNullExpressionValue(ktToken, "LONG_TEMPLATE_ENTRY_START");
            ktTokenArray[0] = ktToken;
            KtToken ktToken2 = KtTokens.LONG_TEMPLATE_ENTRY_END;
            Intrinsics.checkNotNullExpressionValue(ktToken2, "LONG_TEMPLATE_ENTRY_END");
            ktTokenArray[1] = ktToken2;
            KtToken[] skipTokens$iv = ktTokenArray;
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                void this_$iv2;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                LighterASTNode it = kid$iv;
                boolean bl = false;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = errorReason;
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode3 = it;
                boolean bl2 = false;
                boolean bl3 = false;
                LighterASTNode it$iv = lighterASTNode3;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firExpression2 = (FirExpression)firElement;
            }
        }
        return firExpression2;
    }

    private final FirExpression convertConstantExpression(LighterASTNode constantExpression) {
        return this.generateConstantExpressionByLiteral(constantExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenExpression(LighterASTNode whenExpression) {
        Object this_$iv;
        boolean bl;
        boolean bl2;
        Object object;
        void $this$forEachChildren$iv;
        void this_$iv2;
        LighterASTNode[] kidsArray$iv;
        FirPureAbstractElement subjectExpression = null;
        FirVariable subjectVariable = null;
        boolean bl3 = false;
        List whenEntryNodes = new ArrayList();
        boolean bl4 = false;
        List whenEntries = new ArrayList();
        LighterASTNode lighterASTNode = whenExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv2.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            boolean bl5;
            Object it$iv;
            boolean bl6;
            boolean $i$f$getAsFirExpression;
            boolean bl7;
            Object variable2;
            Object object2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it2 = kid$iv;
            boolean bl8 = false;
            object = it2.getTokenType();
            if (Intrinsics.areEqual(object, KtNodeTypes.PROPERTY)) {
                FirDeclaration firDeclaration = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, it2, null, 2, null);
                if (firDeclaration == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirVariable<*>");
                }
                object2 = (FirVariable)firDeclaration;
                boolean bl9 = false;
                bl2 = false;
                variable2 = object2;
                bl7 = false;
                boolean $i$f$buildProperty = false;
                boolean bl10 = false;
                FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
                bl = false;
                boolean bl11 = false;
                FirPropertyBuilder $this$buildProperty = firPropertyBuilder;
                boolean bl12 = false;
                $this$buildProperty.setSource(this.toFirSourceElement(it2));
                $this$buildProperty.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$buildProperty.setSession(this.getBaseSession());
                $this$buildProperty.setReturnTypeRef(((FirVariable)variable2).getReturnTypeRef());
                $this$buildProperty.setName(((FirVariable)variable2).getName());
                $this$buildProperty.setInitializer(((FirVariable)variable2).getInitializer());
                $this$buildProperty.setVar(false);
                $this$buildProperty.setSymbol(new FirPropertySymbol(((FirVariable)variable2).getName()));
                $this$buildProperty.setLocal(true);
                Visibility visibility = Visibilities.LOCAL;
                Intrinsics.checkNotNullExpressionValue(visibility, "Visibilities.LOCAL");
                $this$buildProperty.setStatus(new FirDeclarationStatusImpl(visibility, Modality.FINAL));
                FirProperty firProperty = firPropertyBuilder.build();
                subjectVariable = firProperty;
                continue;
            }
            if (Intrinsics.areEqual(object, KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                FirElement firElement2;
                object2 = this;
                String errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
                $i$f$getAsFirExpression = false;
                variable2 = it2;
                bl7 = false;
                bl6 = false;
                it$iv = variable2;
                bl5 = false;
                FirElement firElement3 = ((ExpressionsConverter)this_$iv).convertExpression((LighterASTNode)it$iv, errorReason$iv);
                if (!(firElement3 instanceof FirExpression)) {
                    firElement3 = null;
                }
                if ((firElement2 = (FirElement)((FirExpression)firElement3)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement2 = firErrorExpression;
                }
                subjectExpression = (FirExpression)firElement2;
                continue;
            }
            if (Intrinsics.areEqual(object, KtNodeTypes.WHEN_ENTRY)) {
                this_$iv = whenEntryNodes;
                boolean errorReason$iv = false;
                this_$iv.add(it2);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it2)) continue;
            this_$iv = this;
            String errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
            $i$f$getAsFirExpression = false;
            variable2 = it2;
            bl7 = false;
            bl6 = false;
            it$iv = variable2;
            bl5 = false;
            FirElement firElement4 = ((ExpressionsConverter)this_$iv).convertExpression((LighterASTNode)it$iv, errorReason$iv);
            if (!(firElement4 instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            subjectExpression = (FirExpression)firElement;
        }
        FirPureAbstractElement firPureAbstractElement = subjectVariable;
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getInitializer()) == null) {
            firPureAbstractElement = subjectExpression;
        }
        subjectExpression = firPureAbstractElement;
        boolean hasSubject = subjectExpression != null;
        FirWhenSubject subject = new FirWhenSubject();
        Iterable $this$mapTo$iv = whenEntryNodes;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            LighterASTNode lighterASTNode2 = (LighterASTNode)item$iv;
            Collection collection = whenEntries;
            boolean bl13 = false;
            FirWhenSubject firWhenSubject = subject;
            boolean tokenType$iv = false;
            boolean it2 = false;
            FirWhenSubject bl8 = firWhenSubject;
            object = it;
            this_$iv = this;
            boolean bl14 = false;
            bl2 = hasSubject;
            WhenEntry whenEntry = super.convertWhenEntry((LighterASTNode)object, (FirWhenSubject)(bl2 ? firWhenSubject : null));
            collection.add(whenEntry);
        }
        boolean $i$f$buildWhenExpression = false;
        boolean bl15 = false;
        FirWhenExpressionBuilder firWhenExpressionBuilder = new FirWhenExpressionBuilder();
        boolean bl16 = false;
        boolean item$iv = false;
        FirWhenExpressionBuilder $this$buildWhenExpression = firWhenExpressionBuilder;
        boolean bl17 = false;
        $this$buildWhenExpression.setSource(this.toFirSourceElement(whenExpression));
        $this$buildWhenExpression.setSubject((FirExpression)subjectExpression);
        $this$buildWhenExpression.setSubjectVariable(subjectVariable);
        for (WhenEntry entry : whenEntries) {
            FirWhenBranch firWhenBranch;
            FirBlock branch = entry.getFirBlock();
            Collection collection = $this$buildWhenExpression.getBranches();
            if (!entry.isElse()) {
                FirExpression firCondition;
                if (hasSubject) {
                    firCondition = entry.toFirWhenCondition();
                    boolean $i$f$buildWhenBranch = false;
                    boolean bl18 = false;
                    FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
                    bl2 = false;
                    boolean variable2 = false;
                    FirWhenBranchBuilder $this$buildWhenBranch = firWhenBranchBuilder;
                    boolean bl19 = false;
                    $this$buildWhenBranch.setCondition(firCondition);
                    $this$buildWhenBranch.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                } else {
                    firCondition = entry.toFirWhenConditionWithoutSubject();
                    boolean $i$f$buildWhenBranch = false;
                    boolean bl20 = false;
                    FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
                    bl2 = false;
                    boolean variable2 = false;
                    FirWhenBranchBuilder $this$buildWhenBranch = firWhenBranchBuilder;
                    boolean bl21 = false;
                    $this$buildWhenBranch.setCondition(firCondition);
                    $this$buildWhenBranch.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                }
            } else {
                boolean $i$f$buildWhenBranch = false;
                boolean bl22 = false;
                FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
                boolean bl23 = false;
                bl2 = false;
                FirWhenBranchBuilder $this$buildWhenBranch = firWhenBranchBuilder;
                boolean bl24 = false;
                boolean $i$f$buildElseIfTrueCondition = false;
                boolean bl25 = false;
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
                boolean bl26 = false;
                bl = false;
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder2 = firElseIfTrueConditionBuilder;
                FirWhenBranchBuilder firWhenBranchBuilder2 = $this$buildWhenBranch;
                Unit unit = Unit.INSTANCE;
                firWhenBranchBuilder2.setCondition(firElseIfTrueConditionBuilder.build());
                $this$buildWhenBranch.setResult(branch);
                firWhenBranch = firWhenBranchBuilder.build();
            }
            object = firWhenBranch;
            boolean bl27 = false;
            collection.add(object);
        }
        FirWhenExpression firWhenExpression = firWhenExpressionBuilder.build();
        boolean bl28 = false;
        bl16 = false;
        FirWhenExpression it = firWhenExpression;
        boolean bl29 = false;
        if (hasSubject) {
            subject.bind(it);
        }
        return firWhenExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final WhenEntry convertWhenEntry(LighterASTNode whenEntry, FirWhenSubject subject) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isElse = false;
        FirBlock firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        boolean bl = false;
        List conditions2 = new ArrayList();
        LighterASTNode lighterASTNode = whenEntry;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            boolean bl2;
            FirExpression firExpression2;
            Collection collection;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl3 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_EXPRESSION)) {
                collection = conditions2;
                firExpression2 = this.convertWhenConditionExpression(it, subject);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_IN_RANGE)) {
                collection = conditions2;
                firExpression2 = this.convertWhenConditionInRange(it, subject);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_IS_PATTERN)) {
                collection = conditions2;
                firExpression2 = this.convertWhenConditionIsPattern(it, subject);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.ELSE_KEYWORD)) {
                isElse = true;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            firBlock = this.declarationsConverter.convertBlock(it);
        }
        return new WhenEntry(conditions2, firBlock, isElse);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionExpression(LighterASTNode whenCondition, FirWhenSubject subject) {
        FirExpression firExpression2;
        Object object;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firExpression3 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode = whenCondition;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!ConverterUtilKt.isExpression((LighterASTNode)it)) continue;
            object = this;
            String errorReason$iv = "No expression in condition with expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression3 = (FirExpression)firElement;
        }
        if (subject != null) {
            void $this$buildWhenSubjectExpression;
            boolean $i$f$buildOperatorCall = false;
            boolean bl = false;
            FirOperatorCallBuilder firOperatorCallBuilder = new FirOperatorCallBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            FirOperatorCallBuilder $this$buildOperatorCall = firOperatorCallBuilder;
            boolean bl7 = false;
            $this$buildOperatorCall.setSource(this.toFirSourceElement(whenCondition));
            $this$buildOperatorCall.setOperation(FirOperation.EQ);
            boolean $i$f$buildWhenSubjectExpression = false;
            int n = 0;
            FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
            boolean bl8 = false;
            boolean bl9 = false;
            it = firWhenSubjectExpressionBuilder;
            FirOperatorCallBuilder firOperatorCallBuilder2 = $this$buildOperatorCall;
            boolean bl10 = false;
            $this$buildWhenSubjectExpression.setWhenSubject(subject);
            object = Unit.INSTANCE;
            firOperatorCallBuilder2.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(firWhenSubjectExpressionBuilder.build(), firExpression3));
            firExpression2 = firOperatorCallBuilder.build();
        } else {
            firExpression2 = firExpression3;
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionInRange(LighterASTNode whenCondition, FirWhenSubject subject) {
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isNegate = false;
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No range in condition with range", DiagnosticKind.Syntax));
        FirLightSourceElement conditionSource = null;
        LighterASTNode lighterASTNode = whenCondition;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                String string2 = this.getAsText(it);
                KtKeywordToken ktKeywordToken = KtTokens.NOT_IN;
                Intrinsics.checkNotNullExpressionValue(ktKeywordToken, "NOT_IN");
                if (Intrinsics.areEqual(string2, ktKeywordToken.getValue())) {
                    conditionSource = this.toFirSourceElement(it);
                    isNegate = true;
                    continue;
                }
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter this_$iv2 = this;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl3 = false;
            boolean bl4 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        if (subject == null) {
            boolean $i$f$buildErrorExpression = false;
            boolean bl6 = false;
            FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
            bl = false;
            boolean bl7 = false;
            FirErrorExpressionBuilder $this$buildErrorExpression = firErrorExpressionBuilder;
            boolean bl8 = false;
            $this$buildErrorExpression.setSource(this.toFirSourceElement(whenCondition));
            $this$buildErrorExpression.setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
            return firErrorExpressionBuilder.build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        boolean bl9 = false;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
        bl = false;
        boolean bl10 = false;
        FirWhenSubjectExpressionBuilder $this$buildWhenSubjectExpression = firWhenSubjectExpressionBuilder;
        boolean bl11 = false;
        $this$buildWhenSubjectExpression.setWhenSubject(subject);
        FirWhenSubjectExpression subjectExpression = firWhenSubjectExpressionBuilder.build();
        return ConversionUtilsKt.generateContainsOperation(firExpression2, subjectExpression, isNegate, this.toFirSourceElement(whenCondition), conditionSource);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionIsPattern(LighterASTNode whenCondition, FirWhenSubject subject) {
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirOperation firOperation = null;
        FirTypeRef firType = null;
        LighterASTNode lighterASTNode = whenCondition;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.IS_KEYWORD)) {
                firOperation = FirOperation.IS;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtTokens.NOT_IS)) continue;
            firOperation = FirOperation.NOT_IS;
        }
        if (subject == null) {
            boolean $i$f$buildErrorExpression = false;
            boolean bl3 = false;
            FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
            bl = false;
            boolean bl4 = false;
            FirErrorExpressionBuilder $this$buildErrorExpression = firErrorExpressionBuilder;
            boolean bl5 = false;
            $this$buildErrorExpression.setSource(this.toFirSourceElement(whenCondition));
            $this$buildErrorExpression.setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
            return firErrorExpressionBuilder.build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        boolean bl6 = false;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
        bl = false;
        boolean bl7 = false;
        FirWhenSubjectExpressionBuilder $this$buildWhenSubjectExpression = firWhenSubjectExpressionBuilder;
        boolean bl8 = false;
        $this$buildWhenSubjectExpression.setWhenSubject(subject);
        FirWhenSubjectExpression subjectExpression = firWhenSubjectExpressionBuilder.build();
        boolean $i$f$buildTypeOperatorCall = false;
        boolean bl9 = false;
        FirTypeOperatorCallBuilder firTypeOperatorCallBuilder = new FirTypeOperatorCallBuilder();
        bl = false;
        bl7 = false;
        FirTypeOperatorCallBuilder $this$buildTypeOperatorCall = firTypeOperatorCallBuilder;
        boolean bl10 = false;
        $this$buildTypeOperatorCall.setSource(this.toFirSourceElement(whenCondition));
        FirOperation firOperation2 = firOperation;
        if (firOperation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firOperation");
        }
        $this$buildTypeOperatorCall.setOperation(firOperation2);
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firType");
        }
        $this$buildTypeOperatorCall.setConversionTypeRef(firTypeRef);
        $this$buildTypeOperatorCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(subjectExpression));
        return firTypeOperatorCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirFunctionCall convertArrayAccessExpression(LighterASTNode arrayAccess) {
        void $this$buildArgumentList;
        FirArgumentListBuilder $this$buildSimpleNamedReference;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No array expression", DiagnosticKind.Syntax));
        boolean bl2 = false;
        List indices = new ArrayList();
        LighterASTNode lighterASTNode = arrayAccess;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            Object object4;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl3 = false;
            object3 = it.getTokenType();
            if (Intrinsics.areEqual(object3, KtNodeTypes.INDICES)) {
                object4 = indices;
                object2 = this.convertIndices(it);
                boolean bl4 = false;
                CollectionsKt.addAll(object4, object2);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            object4 = this;
            String errorReason$iv = "No array expression";
            boolean $i$f$getAsFirExpression = false;
            object = it;
            bl = false;
            boolean bl5 = false;
            LighterASTNode it$iv = object;
            boolean bl6 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        FirExpression getArgument = this.getContext().getArraySetArgument().remove(arrayAccess);
        boolean $i$f$buildFunctionCall = false;
        boolean bl7 = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        FirFunctionCallBuilder $this$buildFunctionCall = firFunctionCallBuilder;
        boolean bl10 = false;
        $this$buildFunctionCall.setSource(this.toFirSourceElement(arrayAccess));
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl11 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl12 = false;
        boolean bl13 = false;
        FirSimpleNamedReferenceBuilder bl3 = firSimpleNamedReferenceBuilder;
        object3 = $this$buildFunctionCall;
        boolean bl14 = false;
        ((FirSimpleNamedReferenceBuilder)((Object)$this$buildSimpleNamedReference)).setSource($this$buildFunctionCall.getSource());
        ((FirSimpleNamedReferenceBuilder)((Object)$this$buildSimpleNamedReference)).setName(getArgument == null ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        object2 = Unit.INSTANCE;
        ((FirFunctionCallBuilder)object3).setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$buildFunctionCall.setExplicitReceiver(firExpression2);
        boolean $i$f$buildArgumentList = false;
        boolean bl15 = false;
        FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
        bl12 = false;
        bl13 = false;
        $this$buildSimpleNamedReference = firArgumentListBuilder;
        object3 = $this$buildFunctionCall;
        boolean bl16 = false;
        Object object5 = $this$buildArgumentList.getArguments();
        object = indices;
        bl = false;
        CollectionsKt.addAll(object5, object);
        FirExpression firExpression3 = getArgument;
        if (firExpression3 != null) {
            object5 = firExpression3;
            boolean bl17 = false;
            bl = false;
            Object it = object5;
            boolean bl18 = false;
            Collection collection = $this$buildArgumentList.getArguments();
            boolean bl19 = false;
            collection.add(it);
        }
        object2 = Unit.INSTANCE;
        ((FirFunctionCallBuilder)object3).setArgumentList(firArgumentListBuilder.build());
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCollectionLiteralExpression(LighterASTNode expression2) {
        void $this$buildArgumentList;
        Object object;
        Object object2;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean bl = false;
        List firExpressionList = new ArrayList();
        LighterASTNode lighterASTNode = expression2;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            it = kid$iv;
            boolean bl2 = false;
            if (!ConverterUtilKt.isExpression((LighterASTNode)it)) continue;
            Collection collection = firExpressionList;
            object2 = this;
            String errorReason$iv = "Incorrect collection literal argument";
            boolean $i$f$getAsFirExpression = false;
            object = it;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it$iv = object;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object2 = firElement;
            boolean bl6 = false;
            collection.add(object2);
        }
        boolean $i$f$buildArrayOfCall = false;
        boolean bl7 = false;
        FirArrayOfCallBuilder firArrayOfCallBuilder = new FirArrayOfCallBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        FirArrayOfCallBuilder $this$buildArrayOfCall = firArrayOfCallBuilder;
        boolean bl10 = false;
        $this$buildArrayOfCall.setSource(this.toFirSourceElement(expression2));
        boolean $i$f$buildArgumentList = false;
        int n = 0;
        FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
        boolean bl11 = false;
        boolean bl12 = false;
        it = firArgumentListBuilder;
        FirArrayOfCallBuilder firArrayOfCallBuilder2 = $this$buildArrayOfCall;
        boolean bl13 = false;
        object2 = $this$buildArgumentList.getArguments();
        Iterable iterable = firExpressionList;
        boolean bl14 = false;
        CollectionsKt.addAll(object2, iterable);
        object = Unit.INSTANCE;
        firArrayOfCallBuilder2.setArgumentList(firArgumentListBuilder.build());
        return firArrayOfCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirExpression> convertIndices(LighterASTNode indices) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean bl = false;
        List firExpressionList = new ArrayList();
        LighterASTNode lighterASTNode = indices;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            if (!ConverterUtilKt.isExpression(it)) continue;
            Collection collection = firExpressionList;
            Object object = this;
            String errorReason$iv = "Incorrect index expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl3 = false;
            boolean bl4 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object = firElement;
            boolean bl6 = false;
            collection.add(object);
        }
        return firExpressionList;
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertSimpleNameExpression(LighterASTNode referenceExpression) {
        void $this$buildSimpleNamedReference;
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$buildQualifiedAccessExpression.setSource(this.toFirSourceElement(referenceExpression));
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
        boolean bl8 = false;
        $this$buildSimpleNamedReference.setSource($this$buildQualifiedAccessExpression.getSource());
        $this$buildSimpleNamedReference.setName(ConverterUtilKt.nameAsSafeName$default(this.getAsText(referenceExpression), null, 1, null));
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertDoWhile(LighterASTNode doWhileLoop) {
        void block;
        void $this$apply;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        FirExpression firCondition = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No condition in do-while loop", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode = doWhileLoop;
        Object object = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No condition in do-while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = (FirExpression)firElement;
        }
        object = new FirDoWhileLoopBuilder();
        boolean bl = false;
        boolean bl5 = false;
        Object $i$f$forEachChildren22 = object;
        ExpressionsConverter expressionsConverter = this;
        boolean bl6 = false;
        $this$apply.setSource(this.toFirSourceElement(doWhileLoop));
        $this$apply.setCondition(firCondition);
        Unit unit = Unit.INSTANCE;
        return expressionsConverter.configure((FirLoopBuilder)object, (Function0<FirBlock>)new Function0<FirBlock>(this, (Ref.ObjectRef)block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef $block;

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
            {
                this.this$0 = expressionsConverter;
                this.$block = objectRef;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertWhile(LighterASTNode whileLoop) {
        void block;
        void $this$apply;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        FirExpression firCondition = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No condition in while loop", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode = whileLoop;
        Object object = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No condition in while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = (FirExpression)firElement;
        }
        object = new FirWhileLoopBuilder();
        boolean bl = false;
        boolean bl5 = false;
        Object $i$f$forEachChildren22 = object;
        ExpressionsConverter expressionsConverter = this;
        boolean bl6 = false;
        $this$apply.setSource(this.toFirSourceElement(whileLoop));
        $this$apply.setCondition(firCondition);
        Unit unit = Unit.INSTANCE;
        return expressionsConverter.configure((FirLoopBuilder)object, (Function0<FirBlock>)new Function0<FirBlock>(this, (Ref.ObjectRef)block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef $block;

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
            {
                this.this$0 = expressionsConverter;
                this.$block = objectRef;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertFor(LighterASTNode forLoop) {
        void parameter;
        void blockNode;
        void $this$buildSimpleNamedReference;
        void $this$buildFunctionCall;
        void $this$apply;
        void rangeExpression;
        FirFunctionCallBuilder $this$buildSimpleNamedReference2;
        FirWhileLoopBuilder $this$buildFunctionCall2;
        Object it$iv;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No range in for loop", DiagnosticKind.Syntax));
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        LighterASTNode lighterASTNode = forLoop;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            it = kid$iv;
            boolean bl3 = false;
            object2 = it.getTokenType();
            if (Intrinsics.areEqual(object2, KtNodeTypes.VALUE_PARAMETER)) {
                parameter.element = this.declarationsConverter.convertValueParameter((LighterASTNode)it);
                continue;
            }
            if (Intrinsics.areEqual(object2, KtNodeTypes.LOOP_RANGE)) {
                FirElement firElement;
                void this_$iv2;
                object = this;
                String errorReason$iv = "No range in for loop";
                boolean $i$f$getAsFirExpression = false;
                Object object3 = it;
                bl2 = false;
                bl = false;
                it$iv = object3;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                rangeExpression.element = (FirExpression)firElement;
                continue;
            }
            if (!Intrinsics.areEqual(object2, KtNodeTypes.BODY)) continue;
            blockNode.element = it;
        }
        boolean $i$f$buildBlock = false;
        boolean bl5 = false;
        FirBlockBuilder firBlockBuilder = new FirBlockBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirBlockBuilder $this$buildBlock = firBlockBuilder;
        boolean bl8 = false;
        $this$buildBlock.setSource(this.toFirSourceElement(forLoop));
        FirSession firSession = this.getBaseSession();
        Name name = Name.special("<iterator>");
        Intrinsics.checkNotNullExpressionValue(name, "Name.special(\"<iterator>\")");
        boolean $i$f$buildFunctionCall = false;
        int n = 0;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        it = firFunctionCallBuilder;
        Name name2 = name;
        object2 = null;
        object = firSession;
        boolean bl11 = false;
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl12 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        bl2 = false;
        bl = false;
        it$iv = firSimpleNamedReferenceBuilder;
        void var25_43 = $this$buildFunctionCall2;
        boolean bl13 = false;
        Name name3 = Name.identifier("iterator");
        Intrinsics.checkNotNullExpressionValue(name3, "Name.identifier(\"iterator\")");
        ((FirSimpleNamedReferenceBuilder)((Object)$this$buildSimpleNamedReference2)).setName(name3);
        Unit unit = Unit.INSTANCE;
        var25_43.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        ((FirFunctionCallBuilder)((Object)$this$buildFunctionCall2)).setExplicitReceiver((FirExpression)rangeExpression.element);
        Unit unit2 = Unit.INSTANCE;
        FirVariable iteratorVal = ConversionUtilsKt.generateTemporaryVariable$default((FirSession)object, (FirSourceElement)object2, name2, firFunctionCallBuilder.build(), null, 16, null);
        Collection collection = $this$buildBlock.getStatements();
        boolean bl14 = false;
        collection.add(iteratorVal);
        collection = $this$buildBlock.getStatements();
        Object object4 = new FirWhileLoopBuilder();
        bl9 = false;
        bl10 = false;
        $this$buildFunctionCall2 = object4;
        object = this;
        boolean bl15 = false;
        $this$apply.setSource(this.toFirSourceElement(forLoop));
        boolean $i$f$buildFunctionCall2 = false;
        boolean bl16 = false;
        FirFunctionCallBuilder firFunctionCallBuilder2 = new FirFunctionCallBuilder();
        bl2 = false;
        bl = false;
        $this$buildSimpleNamedReference2 = firFunctionCallBuilder2;
        var25_43 = $this$apply;
        boolean bl17 = false;
        boolean $i$f$buildSimpleNamedReference2 = false;
        boolean bl18 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = new FirSimpleNamedReferenceBuilder();
        boolean bl19 = false;
        boolean bl20 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder3 = firSimpleNamedReferenceBuilder2;
        void var34_54 = $this$buildFunctionCall;
        boolean bl21 = false;
        Name name4 = Name.identifier("hasNext");
        Intrinsics.checkNotNullExpressionValue(name4, "Name.identifier(\"hasNext\")");
        $this$buildSimpleNamedReference.setName(name4);
        Unit unit3 = Unit.INSTANCE;
        var34_54.setCalleeReference(firSimpleNamedReferenceBuilder2.build());
        $this$buildFunctionCall.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(null, iteratorVal));
        Unit unit4 = Unit.INSTANCE;
        var25_43.setCondition(firFunctionCallBuilder2.build());
        object2 = Unit.INSTANCE;
        object4 = ((BaseFirBuilder)object).configure((FirLoopBuilder)object4, (Function0<? extends FirBlock>)new Function0<FirBlock>(iteratorVal, this, forLoop, (Ref.ObjectRef)rangeExpression, (Ref.ObjectRef)blockNode, (Ref.ObjectRef)parameter){
            final /* synthetic */ FirVariable $iteratorVal;
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ LighterASTNode $forLoop$inlined;
            final /* synthetic */ Ref.ObjectRef $rangeExpression$inlined;
            final /* synthetic */ Ref.ObjectRef $blockNode$inlined;
            final /* synthetic */ Ref.ObjectRef $parameter$inlined;
            {
                this.$iteratorVal = firVariable;
                this.this$0 = expressionsConverter;
                this.$forLoop$inlined = lighterASTNode;
                this.$rangeExpression$inlined = objectRef;
                this.$blockNode$inlined = objectRef2;
                this.$parameter$inlined = objectRef3;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirBlock invoke() {
                boolean $i$f$buildBlock = false;
                boolean bl = false;
                FirBlockBuilder firBlockBuilder = new FirBlockBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirBlockBuilder $this$block = firBlockBuilder;
                boolean bl4 = false;
                LighterASTNode lighterASTNode = (LighterASTNode)this.$blockNode$inlined.element;
                $this$block.setSource(lighterASTNode != null ? this.this$0.toFirSourceElement(lighterASTNode) : null);
                Collection collection = $this$block.getStatements();
                Iterable iterable = ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$blockNode$inlined.element).getStatements();
                boolean bl5 = false;
                CollectionsKt.addAll(collection, iterable);
                if ((ValueParameter)this.$parameter$inlined.element != null) {
                    void $this$buildSimpleNamedReference;
                    void $this$buildFunctionCall;
                    Name name;
                    ValueParameter valueParameter = (ValueParameter)this.$parameter$inlined.element;
                    Intrinsics.checkNotNull(valueParameter);
                    DestructuringDeclaration multiDeclaration = valueParameter.getDestructuringDeclaration();
                    FirSession firSession = this.this$0.getBaseSession();
                    if (multiDeclaration != null) {
                        name = Name.special("<destruct>");
                    } else {
                        ValueParameter valueParameter2 = (ValueParameter)this.$parameter$inlined.element;
                        Intrinsics.checkNotNull(valueParameter2);
                        name = valueParameter2.getFirValueParameter().getName();
                    }
                    Intrinsics.checkNotNullExpressionValue(name, "if (multiDeclaration != \u2026!!.firValueParameter.name");
                    boolean $i$f$buildFunctionCall = false;
                    boolean bl6 = false;
                    FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    FirFunctionCallBuilder firFunctionCallBuilder2 = firFunctionCallBuilder;
                    Name name2 = name;
                    FirSourceElement firSourceElement = null;
                    FirSession firSession2 = firSession;
                    boolean bl9 = false;
                    boolean $i$f$buildSimpleNamedReference = false;
                    boolean bl10 = false;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                    boolean bl11 = false;
                    boolean bl12 = false;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
                    void var23_30 = $this$buildFunctionCall;
                    boolean bl13 = false;
                    Name name3 = Name.identifier("next");
                    Intrinsics.checkNotNullExpressionValue(name3, "Name.identifier(\"next\")");
                    $this$buildSimpleNamedReference.setName(name3);
                    Unit unit = Unit.INSTANCE;
                    var23_30.setCalleeReference(firSimpleNamedReferenceBuilder.build());
                    $this$buildFunctionCall.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(null, this.$iteratorVal));
                    Unit unit2 = Unit.INSTANCE;
                    FirExpression firExpression2 = firFunctionCallBuilder.build();
                    ValueParameter valueParameter3 = (ValueParameter)this.$parameter$inlined.element;
                    Intrinsics.checkNotNull(valueParameter3);
                    FirVariable<?> firLoopParameter = ConversionUtilsKt.generateTemporaryVariable(firSession2, firSourceElement, name2, firExpression2, valueParameter3.getFirValueParameter().getReturnTypeRef());
                    if (multiDeclaration != null) {
                        FirExpression destructuringBlock = ConverterUtilKt.generateDestructuringBlock(this.this$0.getBaseSession(), multiDeclaration, firLoopParameter, true);
                        if (destructuringBlock instanceof FirBlock) {
                            boolean bl14 = false;
                            for (FirStatement statement2 : (Iterable)((FirBlock)destructuringBlock).getStatements()) {
                                void index2;
                                $this$block.getStatements().add((int)index2, statement2);
                                ++index2;
                            }
                        }
                    } else {
                        $this$block.getStatements().add(0, firLoopParameter);
                    }
                }
                return firBlockBuilder.build();
            }
        });
        bl9 = false;
        collection.add(object4);
        return firBlockBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertLoopBody(LighterASTNode body2) {
        FirBlock firBlock;
        FirBlock firBlock2 = null;
        FirStatement firStatement = null;
        LighterASTNode lighterASTNode = body2;
        if (lighterASTNode != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            LighterASTNode[] kidsArray$iv;
            LighterASTNode lighterASTNode2 = lighterASTNode;
            BaseConverter baseConverter = this;
            KtToken[] skipTokens$iv = new KtToken[]{};
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                LighterASTNode it = kid$iv;
                boolean bl = false;
                IElementType iElementType = it.getTokenType();
                if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                    firBlock2 = this.declarationsConverter.convertBlockExpression(it);
                    continue;
                }
                if (!ConverterUtilKt.isExpression(it)) continue;
                ExpressionsConverter this_$iv2 = this;
                String errorReason$iv = "";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode3 = it;
                boolean bl2 = false;
                boolean bl3 = false;
                LighterASTNode it$iv = lighterASTNode3;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirStatement)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirStatement)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
                    }
                    firElement = firErrorExpression;
                }
                firStatement = (FirStatement)firElement;
            }
        }
        if (firStatement != null) {
            FirStatement firStatement2 = firStatement;
            Intrinsics.checkNotNull(firStatement2);
            firBlock = new FirSingleExpressionBlock(firStatement2);
        } else if (firBlock2 == null) {
            firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        } else {
            FirBlock firBlock3 = firBlock2;
            firBlock = firBlock3;
            Intrinsics.checkNotNull(firBlock3);
        }
        return firBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertTryExpression(LighterASTNode tryExpression) {
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirBlock tryBlock = null;
        boolean bl2 = false;
        List catchClauses = new ArrayList();
        FirBlock finallyBlock = null;
        LighterASTNode lighterASTNode = tryExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode lighterASTNode2 : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (lighterASTNode2 == null) break;
            IElementType tokenType$iv = lighterASTNode2.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = lighterASTNode2;
            boolean bl3 = false;
            IElementType firCatchBuilder = it.getTokenType();
            if (Intrinsics.areEqual(firCatchBuilder, KtNodeTypes.BLOCK)) {
                tryBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual(firCatchBuilder, KtNodeTypes.CATCH)) {
                if (this.convertCatchClause(it) != null) {
                    Pair<ValueParameter, FirBlock> pair;
                    bl = false;
                    boolean bl4 = false;
                    Pair<ValueParameter, FirBlock> oneClause = pair;
                    boolean bl5 = false;
                    Collection collection = catchClauses;
                    boolean bl6 = false;
                    collection.add(oneClause);
                }
                continue;
            }
            if (!Intrinsics.areEqual(firCatchBuilder, KtNodeTypes.FINALLY)) continue;
            finallyBlock = this.convertFinally(it);
        }
        boolean $i$f$buildTryExpression = false;
        boolean bl7 = false;
        FirTryExpressionBuilder firTryExpressionBuilder = new FirTryExpressionBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        FirTryExpressionBuilder $this$buildTryExpression = firTryExpressionBuilder;
        boolean bl10 = false;
        $this$buildTryExpression.setSource(this.toFirSourceElement(tryExpression));
        FirBlock firBlock = tryBlock;
        if (firBlock == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tryBlock");
        }
        $this$buildTryExpression.setTryBlock(firBlock);
        $this$buildTryExpression.setFinallyBlock(finallyBlock);
        for (Pair pair : catchClauses) {
            ValueParameter valueParameter = (ValueParameter)pair.component1();
            FirBlock block = (FirBlock)pair.component2();
            if (valueParameter == null) continue;
            Collection collection = $this$buildTryExpression.getCatches();
            boolean $i$f$buildCatch = false;
            boolean bl14 = false;
            FirCatchBuilder firCatchBuilder = new FirCatchBuilder();
            boolean bl11 = false;
            bl = false;
            FirCatchBuilder $this$buildCatch = firCatchBuilder;
            boolean bl13 = false;
            $this$buildCatch.setParameter(valueParameter.getFirValueParameter());
            $this$buildCatch.setBlock(block);
            FirCatch firCatch = firCatchBuilder.build();
            boolean bl12 = false;
            collection.add(firCatch);
        }
        return firTryExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ValueParameter, FirBlock> convertCatchClause(LighterASTNode catchClause) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        ValueParameter valueParameter = null;
        LighterASTNode blockNode = null;
        LighterASTNode lighterASTNode = catchClause;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_PARAMETER_LIST)) {
                if (CollectionsKt.firstOrNull(this.declarationsConverter.convertValueParameters(it)) != null) continue;
                return null;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return new Pair<ValueParameter, FirBlock>(valueParameter, this.declarationsConverter.convertBlock(blockNode));
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertFinally(LighterASTNode finallyExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        LighterASTNode blockNode = null;
        LighterASTNode lighterASTNode = finallyExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return this.declarationsConverter.convertBlock(blockNode);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertIfExpression(LighterASTNode ifExpression) {
        Object it$iv;
        boolean bl;
        boolean bl2;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firCondition = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("If statement should have condition", DiagnosticKind.Syntax));
        LighterASTNode thenBlock = null;
        LighterASTNode elseBlock = null;
        LighterASTNode lighterASTNode = ifExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv322 = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv322) || Intrinsics.areEqual(tokenType$iv322, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv322, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv322)) continue;
            LighterASTNode it = kid$iv;
            boolean bl3 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "If statement should have condition";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode2 = it;
                bl2 = false;
                bl = false;
                it$iv = lighterASTNode2;
                boolean bl4 = false;
                FirElement firElement2 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firCondition = (FirExpression)firElement;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.THEN)) {
                thenBlock = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.ELSE)) continue;
            elseBlock = it;
        }
        boolean $i$f$buildWhenExpression = false;
        boolean bl5 = false;
        FirWhenExpressionBuilder firWhenExpressionBuilder = new FirWhenExpressionBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirWhenExpressionBuilder $this$buildWhenExpression = firWhenExpressionBuilder;
        boolean bl8 = false;
        FirBlock trueBranch = this.convertLoopBody(thenBlock);
        Collection collection = $this$buildWhenExpression.getBranches();
        boolean $i$f$buildWhenBranch = false;
        boolean tokenType$iv322 = false;
        FirWhenBranchBuilder tokenType$iv322 = new FirWhenBranchBuilder();
        boolean bl9 = false;
        boolean bl10 = false;
        FirWhenBranchBuilder $this$buildWhenBranch = tokenType$iv322;
        boolean bl11 = false;
        LighterASTNode lighterASTNode3 = thenBlock;
        $this$buildWhenBranch.setSource(lighterASTNode3 != null ? this.toFirSourceElement(lighterASTNode3) : null);
        $this$buildWhenBranch.setCondition(firCondition);
        $this$buildWhenBranch.setResult(trueBranch);
        Object object = tokenType$iv322.build();
        boolean tokenType$iv322 = false;
        collection.add(object);
        if (elseBlock != null) {
            FirBlock elseBranch = this.convertLoopBody(elseBlock);
            object = $this$buildWhenExpression.getBranches();
            boolean $i$f$buildWhenBranch2 = false;
            bl9 = false;
            FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
            bl10 = false;
            boolean bl12 = false;
            FirWhenBranchBuilder $this$buildWhenBranch2 = firWhenBranchBuilder;
            boolean bl13 = false;
            LighterASTNode lighterASTNode4 = elseBlock;
            $this$buildWhenBranch2.setSource(lighterASTNode4 != null ? this.toFirSourceElement(lighterASTNode4) : null);
            boolean $i$f$buildElseIfTrueCondition = false;
            boolean bl14 = false;
            FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
            bl2 = false;
            bl = false;
            it$iv = firElseIfTrueConditionBuilder;
            FirWhenBranchBuilder firWhenBranchBuilder2 = $this$buildWhenBranch2;
            Unit unit = Unit.INSTANCE;
            firWhenBranchBuilder2.setCondition(firElseIfTrueConditionBuilder.build());
            $this$buildWhenBranch2.setResult(elseBranch);
            FirWhenBranch firWhenBranch = firWhenBranchBuilder.build();
            boolean bl15 = false;
            object.add(firWhenBranch);
        }
        return firWhenExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertLoopJump(LighterASTNode jump) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        boolean isBreak = true;
        LighterASTNode lighterASTNode = jump;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!Intrinsics.areEqual(iElementType, KtTokens.CONTINUE_KEYWORD)) continue;
            isBreak = false;
        }
        FirLoopJumpBuilder jumpBuilder = isBreak ? new FirBreakExpressionBuilder() : new FirContinueExpressionBuilder();
        FirLightSourceElement sourceElement = this.toFirSourceElement(jump);
        FirLoopJumpBuilder firLoopJumpBuilder = jumpBuilder;
        boolean bl = false;
        boolean bl2 = false;
        FirLoopJumpBuilder firLoopJumpBuilder2 = firLoopJumpBuilder;
        ExpressionsConverter expressionsConverter = this;
        boolean bl3 = false;
        ((FirLoopJumpBuilder)firLoopJumpBuilder2).setSource(sourceElement);
        Unit unit = Unit.INSTANCE;
        return expressionsConverter.bindLabel(firLoopJumpBuilder, jump).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertReturn(LighterASTNode returnExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String labelName = null;
        boolean $i$f$buildUnitExpression22 = false;
        boolean bl = false;
        FirUnitExpressionBuilder firUnitExpressionBuilder = new FirUnitExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirUnitExpressionBuilder $receiver = firUnitExpressionBuilder;
        Unit unit = Unit.INSTANCE;
        FirExpression firExpression2 = firUnitExpressionBuilder.build();
        LighterASTNode $i$f$buildUnitExpression22 = returnExpression;
        BaseConverter init$iv = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl4 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.LABEL_QUALIFIER)) {
                labelName = StringsKt.replace$default(ConverterUtilKt.getAsStringWithoutBacktick(it), "@", "", false, 4, null);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Incorrect return expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode = it;
            boolean bl5 = false;
            boolean bl6 = false;
            LighterASTNode it$iv = lighterASTNode;
            boolean bl7 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        return BaseFirBuilder.toReturn$default(this, firExpression2, null, labelName, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertThrow(LighterASTNode throwExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        FirExpression firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Nothing to throw", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode = throwExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Nothing to throw";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl4 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement;
        }
        boolean $i$f$buildThrowExpression = false;
        boolean bl = false;
        FirThrowExpressionBuilder firThrowExpressionBuilder = new FirThrowExpressionBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirThrowExpressionBuilder $this$buildThrowExpression = firThrowExpressionBuilder;
        boolean bl7 = false;
        $this$buildThrowExpression.setSource(this.toFirSourceElement(throwExpression));
        $this$buildThrowExpression.setException(firExpression2);
        return firThrowExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertThisExpression(LighterASTNode thisExpression) {
        void $this$buildExplicitThisReference;
        String label = this.getLabelName(thisExpression);
        boolean $i$f$buildThisReceiverExpression = false;
        boolean bl = false;
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirThisReceiverExpressionBuilder $this$buildThisReceiverExpression = firThisReceiverExpressionBuilder;
        boolean bl4 = false;
        $this$buildThisReceiverExpression.setSource(this.toFirSourceElement(thisExpression));
        boolean $i$f$buildExplicitThisReference = false;
        boolean bl5 = false;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder = new FirExplicitThisReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder2 = firExplicitThisReferenceBuilder;
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$buildThisReceiverExpression;
        boolean bl8 = false;
        $this$buildExplicitThisReference.setLabelName(label);
        Unit unit = Unit.INSTANCE;
        firThisReceiverExpressionBuilder2.setCalleeReference(firExplicitThisReferenceBuilder.build());
        return firThisReceiverExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertSuperExpression(LighterASTNode superExpression) {
        void $this$buildExplicitSuperReference;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String label = this.getLabelName(superExpression);
        FirTypeRef superTypeRef = this.getImplicitType();
        LighterASTNode lighterASTNode = superExpression;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_REFERENCE)) continue;
            superTypeRef = this.declarationsConverter.convertType((LighterASTNode)it);
        }
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$buildQualifiedAccessExpression.setSource(this.toFirSourceElement(superExpression));
        boolean $i$f$buildExplicitSuperReference = false;
        int n = 0;
        FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder = new FirExplicitSuperReferenceBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        it = firExplicitSuperReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
        boolean bl7 = false;
        $this$buildExplicitSuperReference.setLabelName(label);
        $this$buildExplicitSuperReference.setSuperTypeRef(superTypeRef);
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firExplicitSuperReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirExpression> convertValueArguments(@NotNull LighterASTNode valueArguments) {
        void $this$forEachChildrenReturnList$iv;
        Intrinsics.checkNotNullParameter(valueArguments, "valueArguments");
        LighterASTNode lighterASTNode = valueArguments;
        BaseConverter this_$iv = this;
        boolean $i$f$forEachChildrenReturnList = false;
        LighterASTNode[] kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildrenReturnList$iv);
        boolean bl = false;
        List container$iv = new ArrayList();
        for (LighterASTNode kid$iv : kidsArray$iv) {
            FirElement firElement;
            void this_$iv2;
            boolean bl2;
            FirExpression firExpression2;
            Collection collection;
            void container;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON)) continue;
            List list2 = container$iv;
            LighterASTNode node = kid$iv;
            boolean bl3 = false;
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT)) {
                collection = (Collection)container;
                firExpression2 = this.convertValueArgument(node);
                bl2 = false;
                collection.add(firExpression2);
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_EXPRESSION) && !Intrinsics.areEqual(iElementType, KtNodeTypes.LABELED_EXPRESSION) && !Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION)) continue;
            collection = (Collection)container;
            boolean $i$f$buildLambdaArgumentExpression = false;
            bl2 = false;
            FirLambdaArgumentExpressionBuilder firLambdaArgumentExpressionBuilder = new FirLambdaArgumentExpressionBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            FirLambdaArgumentExpressionBuilder $this$buildLambdaArgumentExpression = firLambdaArgumentExpressionBuilder;
            boolean bl6 = false;
            $this$buildLambdaArgumentExpression.setSource(this.toFirSourceElement(valueArguments));
            ExpressionsConverter expressionsConverter = this;
            LighterASTNode expression$iv = node;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = expression$iv;
            boolean bl7 = false;
            boolean bl8 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl9 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$buildLambdaArgumentExpression.setExpression((FirExpression)firElement);
            firExpression2 = firLambdaArgumentExpressionBuilder.build();
            bl2 = false;
            collection.add(firExpression2);
        }
        return container$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertValueArgument(LighterASTNode valueArgument) {
        FirExpression firExpression2;
        boolean bl;
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode[] kidsArray$iv;
        String identifier = null;
        boolean isSpread = false;
        FirExpression firExpression3 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Argument is absent", DiagnosticKind.Syntax));
        LighterASTNode lighterASTNode = valueArgument;
        BaseConverter baseConverter = this;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT_NAME)) {
                identifier = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.MUL)) {
                isSpread = true;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.STRING_TEMPLATE)) {
                firExpression3 = this.convertStringTemplate(it);
                continue;
            }
            if (iElementType instanceof KtConstantExpressionElementType) {
                firExpression3 = this.convertConstantExpression(it);
                continue;
            }
            if (!ConverterUtilKt.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Argument is absent";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode2 = it;
            boolean bl3 = false;
            boolean bl4 = false;
            LighterASTNode it$iv = lighterASTNode2;
            boolean bl5 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionRequired));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression3 = (FirExpression)firElement;
        }
        if (identifier != null) {
            boolean $i$f$buildNamedArgumentExpression = false;
            boolean bl6 = false;
            FirNamedArgumentExpressionBuilder firNamedArgumentExpressionBuilder = new FirNamedArgumentExpressionBuilder();
            boolean bl7 = false;
            bl = false;
            FirNamedArgumentExpressionBuilder $this$buildNamedArgumentExpression = firNamedArgumentExpressionBuilder;
            boolean bl8 = false;
            $this$buildNamedArgumentExpression.setSource(this.toFirSourceElement(valueArgument));
            $this$buildNamedArgumentExpression.setExpression(firExpression3);
            $this$buildNamedArgumentExpression.setSpread(isSpread);
            $this$buildNamedArgumentExpression.setName(ConverterUtilKt.nameAsSafeName$default(identifier, null, 1, null));
            firExpression2 = firNamedArgumentExpressionBuilder.build();
        } else if (isSpread) {
            boolean $i$f$buildSpreadArgumentExpression = false;
            boolean bl9 = false;
            FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl10 = false;
            bl = false;
            FirSpreadArgumentExpressionBuilder $this$buildSpreadArgumentExpression = firSpreadArgumentExpressionBuilder;
            boolean bl11 = false;
            $this$buildSpreadArgumentExpression.setSource(this.toFirSourceElement(valueArgument));
            $this$buildSpreadArgumentExpression.setExpression(firExpression3);
            firExpression2 = firSpreadArgumentExpressionBuilder.build();
        } else {
            firExpression2 = firExpression3;
        }
        return firExpression2;
    }

    public ExpressionsConverter(@NotNull FirSession session, boolean stubMode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull DeclarationsConverter declarationsConverter, int offset2, @NotNull Context<LighterASTNode> context2) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(declarationsConverter, "declarationsConverter");
        Intrinsics.checkNotNullParameter(context2, "context");
        super(session, tree, offset2, context2);
        this.stubMode = stubMode;
        this.declarationsConverter = declarationsConverter;
    }

    public /* synthetic */ ExpressionsConverter(FirSession firSession, boolean bl, FlyweightCapableTreeStructure flyweightCapableTreeStructure, DeclarationsConverter declarationsConverter, int n, Context context2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            context2 = new Context<LighterASTNode>();
        }
        this(firSession, bl, flyweightCapableTreeStructure, declarationsConverter, n, context2);
    }

    public static final /* synthetic */ DeclarationsConverter access$getDeclarationsConverter$p(ExpressionsConverter $this) {
        return $this.declarationsConverter;
    }

    public static final /* synthetic */ FirExpression access$convertShortOrLongStringTemplate(ExpressionsConverter $this, LighterASTNode $this$access_u24convertShortOrLongStringTemplate, String errorReason) {
        return $this.convertShortOrLongStringTemplate($this$access_u24convertShortOrLongStringTemplate, errorReason);
    }

    public static final /* synthetic */ FirBlock access$convertLoopBody(ExpressionsConverter $this, LighterASTNode body2) {
        return $this.convertLoopBody(body2);
    }
}

