/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend.java"})
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block1: {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context2, "context");
            AnnotationDescriptor annotationDescriptor = JvmAnnotationUtilKt.findJvmOverloadsAnnotation(descriptor2);
            if (annotationDescriptor == null) break block1;
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            AnnotationDescriptor annotation2 = annotationDescriptor2;
            boolean bl3 = false;
            KtAnnotationEntry annotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
            if (annotationEntry != null) {
                this.checkDeclaration(annotationEntry, descriptor2, context2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkDeclaration(KtAnnotationEntry annotationEntry, DeclarationDescriptor descriptor2, DeclarationCheckerContext context2) {
        BindingTrace diagnosticHolder = context2.getTrace();
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((CallableDescriptor)descriptor2).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if ((classDescriptor2 != null ? classDescriptor2.getKind() : null) == ClassKind.INTERFACE) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_INTERFACE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            return;
        } else if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).getModality() == Modality.ABSTRACT) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            return;
        } else if (DescriptorUtils.isLocal(descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_LOCAL.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            return;
        } else if (DescriptorUtilsKt.isAnnotationConstructor(descriptor2)) {
            DiagnosticFactory0<KtAnnotationEntry> diagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitJvmOverloadsOnConstructorsOfAnnotationClasses) ? ErrorsJvm.OVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR : ErrorsJvm.OVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR_WARNING;
            diagnosticHolder.report(diagnostic.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            return;
        } else if (!((CallableDescriptor)descriptor2).getVisibility().isPublicAPI() && Intrinsics.areEqual(((CallableDescriptor)descriptor2).getVisibility(), Visibilities.INTERNAL) ^ true) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            return;
        } else {
            boolean bl;
            List<ValueParameterDescriptor> list2 = ((CallableDescriptor)descriptor2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "descriptor.valueParameters");
            Iterable $this$none$iv = list2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (it.declaresDefaultValue()) return;
                    ValueParameterDescriptor valueParameterDescriptor = it;
                    Intrinsics.checkNotNullExpressionValue(valueParameterDescriptor, "it");
                    if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(valueParameterDescriptor)) {
                        return;
                    }
                    boolean bl3 = false;
                    if (!bl3) continue;
                    return;
                }
                bl = true;
            }
            if (!bl) return;
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }
}

