/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;

public class BasicComponentParameter
implements Serializable,
Parameter {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        return this.resolveAdapter(container, adapter, expectedType2) != null;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType2);
        if (componentAdapter != null) {
            return container.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        ComponentAdapter result2 = this.getTargetAdapter(container, expectedType2, adapter);
        if (result2 == null) {
            return null;
        }
        if (!expectedType2.isAssignableFrom(result2.getComponentImplementation())) {
            if (expectedType2.isPrimitive()) {
                try {
                    Field field = result2.getComponentImplementation().getField("TYPE");
                    Class type2 = (Class)field.get(result2.getComponentInstance(null));
                    if (expectedType2.isAssignableFrom(type2)) {
                        return result2;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return result2;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType2, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapterOfType(expectedType2);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container.getComponentAdapter(expectedType2);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List found2 = container.getComponentAdaptersOfType(expectedType2);
        ComponentAdapter exclude = null;
        Iterator iterator2 = found2.iterator();
        while (iterator2.hasNext()) {
            ComponentAdapter work = (ComponentAdapter)iterator2.next();
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found2.remove(exclude);
        if (found2.size() == 0) {
            if (container.getParent() != null) {
                return container.getParent().getComponentAdapterOfType(expectedType2);
            }
            return null;
        }
        if (found2.size() == 1) {
            return (ComponentAdapter)found2.get(0);
        }
        Object[] foundClasses = new Class[found2.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found2.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType2, foundClasses);
    }
}

