/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectJavaWildcardType
extends ReflectJavaType
implements JavaWildcardType {
    @NotNull
    private final WildcardType reflectType;

    @Override
    @Nullable
    public ReflectJavaType getBound() {
        ReflectJavaType reflectJavaType;
        Object[] upperBounds2 = this.getReflectType().getUpperBounds();
        Object[] lowerBounds = this.getReflectType().getLowerBounds();
        if (upperBounds2.length > 1 || lowerBounds.length > 1) {
            throw (Throwable)new UnsupportedOperationException("Wildcard types with many bounds are not yet supported: " + this.getReflectType());
        }
        if (lowerBounds.length == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)lowerBounds, (String)"lowerBounds");
            Object object = ArraysKt.single((Object[])lowerBounds);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lowerBounds.single()");
            reflectJavaType = ReflectJavaType.Factory.create((Type)object);
        } else if (upperBounds2.length == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)upperBounds2, (String)"upperBounds");
            Object object = ArraysKt.single((Object[])upperBounds2);
            boolean bl = false;
            boolean bl2 = false;
            Type ub = (Type)object;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)ub, Object.class) ^ true) {
                Type type2 = ub;
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"ub");
                reflectJavaType = ReflectJavaType.Factory.create(type2);
            } else {
                reflectJavaType = null;
            }
        } else {
            reflectJavaType = null;
        }
        return reflectJavaType;
    }

    @Override
    public boolean isExtends() {
        Object[] objectArray = this.getReflectType().getUpperBounds();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"reflectType.upperBounds");
        return Intrinsics.areEqual((Object)((Type)ArraysKt.firstOrNull((Object[])objectArray)), Object.class) ^ true;
    }

    @Override
    @NotNull
    protected WildcardType getReflectType() {
        return this.reflectType;
    }

    public ReflectJavaWildcardType(@NotNull WildcardType reflectType) {
        Intrinsics.checkNotNullParameter((Object)reflectType, (String)"reflectType");
        this.reflectType = reflectType;
    }
}

