/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.optimizations;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "isSafeToInline", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "AccessorInliner", "ir.backend.common"})
public final class PropertyAccessorInlineLowering
implements BodyLoweringPass {
    private final CommonBackendContext context;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSafeToInline(IrProperty $this$isSafeToInline) {
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel($this$isSafeToInline)) return true;
        if ($this$isSafeToInline.getModality() == Modality.FINAL) return true;
        if (Intrinsics.areEqual($this$isSafeToInline.getVisibility(), DescriptorVisibilities.PRIVATE)) return true;
        IrDeclarationParent irDeclarationParent = $this$isSafeToInline.getParent();
        if (irDeclarationParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        if (((IrClass)irDeclarationParent).getModality() != Modality.FINAL) return false;
        return true;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new AccessorInliner());
    }

    public PropertyAccessorInlineLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering$AccessorInliner;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/common/lower/optimizations/PropertyAccessorInlineLowering;)V", "unitType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isSimpleGetter", "", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isSimpleSetter", "tryInlineSimpleGetter", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "tryInlineSimpleSetter", "visitCall", "expression", "ir.backend.common"})
    private final class AccessorInliner
    extends IrElementTransformerVoid {
        private final IrType unitType;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            Object object = callee.getCorrespondingPropertySymbol();
            if (object == null || (object = (IrProperty)object.getOwner()) == null) {
                return expression2;
            }
            Object property2 = object;
            if (!PropertyAccessorInlineLowering.this.isSafeToInline((IrProperty)property2)) {
                return expression2;
            }
            IrDeclarationParent parent2 = property2.getParent();
            if (parent2 instanceof IrClass) {
                if (((IrClass)parent2).isExpect() || ((IrProperty)property2).isExpect()) {
                    return expression2;
                }
                if (((IrClass)parent2).getParent() instanceof IrExternalPackageFragment) {
                    return expression2;
                }
                if (((IrClass)parent2).isInline()) {
                    return expression2;
                }
            }
            if (IrUtilsKt.isEffectivelyExternal((IrDeclaration)property2)) {
                return expression2;
            }
            if (((IrProperty)property2).isConst()) {
                void p2;
                void p1;
                IrElementBase irElementBase = ((IrProperty)property2).getBackingField();
                if (irElementBase == null || (irElementBase = ((IrField)irElementBase).getInitializer()) == null) {
                    String string2 = "Constant property has to have a backing field with initializer";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                IrElementBase initializer2 = irElementBase;
                IrElement $this$deepCopyWithSymbols$iv = ((IrExpressionBody)initializer2).getExpression();
                IrDeclarationParent initialParent$iv = null;
                boolean $i$f$deepCopyWithSymbols = false;
                DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
                DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                TypeRemapper typeRemapper = typeRemapper$iv;
                SymbolRemapper symbolRemapper = symbolRemapper$iv;
                IrElement irElement = $this$deepCopyWithSymbols$iv;
                DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p1, (TypeRemapper)p2);
                IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                }
                return (IrExpression)((IrElement)((IrExpression)irElement2));
            }
            IrField irField = ((IrProperty)property2).getBackingField();
            if (irField == null) {
                return expression2;
            }
            IrField backingField2 = irField;
            if (((IrProperty)property2).getGetter() == callee) {
                IrExpression irExpression = this.tryInlineSimpleGetter(expression2, callee, backingField2);
                if (irExpression == null) {
                    irExpression = expression2;
                }
                return irExpression;
            }
            if (((IrProperty)property2).getSetter() == callee) {
                IrExpression irExpression = this.tryInlineSimpleSetter(expression2, callee, backingField2);
                if (irExpression == null) {
                    irExpression = expression2;
                }
                return irExpression;
            }
            return expression2;
        }

        private final IrExpression tryInlineSimpleGetter(IrCall call2, IrSimpleFunction callee, IrField backingField2) {
            if (!this.isSimpleGetter(callee, backingField2)) {
                return null;
            }
            IrCall irCall = call2;
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$run = irCall;
            boolean bl3 = false;
            return new IrGetFieldImpl($this$run.getStartOffset(), $this$run.getEndOffset(), (IrFieldSymbol)backingField2.getSymbol(), backingField2.getType(), call2.getDispatchReceiver(), $this$run.getOrigin(), null, 64, null);
        }

        private final boolean isSimpleGetter(IrSimpleFunction callee, IrField backingField2) {
            IrBody irBody;
            block14: {
                block13: {
                    irBody = callee.getBody();
                    if (irBody == null) break block13;
                    IrBody irBody2 = irBody;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrBody it = irBody2;
                    boolean bl3 = false;
                    IrBody irBody3 = it;
                    if (irBody3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                    }
                    irBody = (IrBlockBody)irBody3;
                    if (irBody != null) break block14;
                }
                return false;
            }
            IrBody body2 = irBody;
            IrStatement irStatement = CollectionsKt.singleOrNull(body2.getStatements());
            if (irStatement == null) {
                return false;
            }
            IrStatement stmt = irStatement;
            IrStatement irStatement2 = stmt;
            if (!(irStatement2 instanceof IrReturn)) {
                irStatement2 = null;
            }
            IrReturn irReturn = (IrReturn)irStatement2;
            if (irReturn == null) {
                return false;
            }
            IrReturn returnStmt = irReturn;
            IrExpression irExpression = returnStmt.getValue();
            if (!(irExpression instanceof IrGetField)) {
                irExpression = null;
            }
            IrGetField irGetField = (IrGetField)irExpression;
            if (irGetField == null) {
                return false;
            }
            IrGetField getFieldStmt = irGetField;
            if (getFieldStmt.getSymbol() != (IrFieldSymbol)backingField2.getSymbol()) {
                return false;
            }
            IrExpression receiver = getFieldStmt.getReceiver();
            if (receiver == null) {
                boolean bl = callee.getDispatchReceiverParameter() == null;
                boolean bl4 = false;
                boolean bl5 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                return true;
            }
            if (receiver instanceof IrGetValue) {
                return ((IrGetValue)receiver).getSymbol().getOwner() == callee.getDispatchReceiverParameter();
            }
            return false;
        }

        private final IrExpression tryInlineSimpleSetter(IrCall call2, IrSimpleFunction callee, IrField backingField2) {
            if (!this.isSimpleSetter(callee, backingField2)) {
                return null;
            }
            IrCall irCall = call2;
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$run = irCall;
            boolean bl3 = false;
            IrExpression irExpression = $this$run.getValueArgument(0);
            if (irExpression == null) {
                String string2 = "Setter should have a value argument";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            IrExpression value2 = irExpression;
            return new IrSetFieldImpl($this$run.getStartOffset(), $this$run.getEndOffset(), (IrFieldSymbol)backingField2.getSymbol(), call2.getDispatchReceiver(), value2, this.unitType, $this$run.getOrigin(), null, 128, null);
        }

        private final boolean isSimpleSetter(IrSimpleFunction callee, IrField backingField2) {
            IrBody irBody;
            block15: {
                block14: {
                    irBody = callee.getBody();
                    if (irBody == null) break block14;
                    IrBody irBody2 = irBody;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrBody it = irBody2;
                    boolean bl3 = false;
                    IrBody irBody3 = it;
                    if (irBody3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                    }
                    irBody = (IrBlockBody)irBody3;
                    if (irBody != null) break block15;
                }
                return false;
            }
            IrBody body2 = irBody;
            IrStatement irStatement = CollectionsKt.singleOrNull(body2.getStatements());
            if (irStatement == null) {
                return false;
            }
            IrStatement stmt = irStatement;
            IrStatement irStatement2 = stmt;
            if (!(irStatement2 instanceof IrSetField)) {
                irStatement2 = null;
            }
            IrSetField irSetField = (IrSetField)irStatement2;
            if (irSetField == null) {
                return false;
            }
            IrSetField setFieldStmt = irSetField;
            if (setFieldStmt.getSymbol() != (IrFieldSymbol)backingField2.getSymbol()) {
                return false;
            }
            IrExpression irExpression = setFieldStmt.getValue();
            if (!(irExpression instanceof IrGetValue)) {
                irExpression = null;
            }
            IrGetValue irGetValue = (IrGetValue)irExpression;
            if (irGetValue == null) {
                return false;
            }
            IrGetValue setValue = irGetValue;
            IrValueParameterSymbol valueSymbol = (IrValueParameterSymbol)CollectionsKt.single(callee.getValueParameters()).getSymbol();
            if (setValue.getSymbol() != valueSymbol) {
                return false;
            }
            IrExpression receiver = setFieldStmt.getReceiver();
            if (receiver == null) {
                boolean bl = callee.getDispatchReceiverParameter() == null;
                boolean bl4 = false;
                boolean bl5 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                return true;
            }
            if (receiver instanceof IrGetValue) {
                return ((IrGetValue)receiver).getSymbol().getOwner() == callee.getDispatchReceiverParameter();
            }
            return false;
        }

        public AccessorInliner() {
            this.unitType = PropertyAccessorInlineLowering.this.context.getIrBuiltIns().getUnitType();
        }
    }
}

