/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0011*\u00020\u0014\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\n*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFileClassInfo", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "internalNameWithoutInnerClasses", "", "Lorg/jetbrains/kotlin/name/FqName;", "getInternalNameWithoutInnerClasses", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/String;", "javaFileFacadeFqName", "getJavaFileFacadeFqName", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/name/FqName;", "isInsideJvmMultifileClassFile", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isTopLevelInJvmMultifileClass", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "frontend.java"})
public final class JvmFileClassUtilKt {
    private static final Logger LOG;

    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull KtFile $this$fileClassInfo) {
        Intrinsics.checkNotNullParameter($this$fileClassInfo, "$this$fileClassInfo");
        Object t = CachedValuesManager.getCachedValue($this$fileClassInfo, new CachedValueProvider<JvmFileClassInfo>($this$fileClassInfo){
            final /* synthetic */ KtFile $this_fileClassInfo;

            @Nullable
            public final CachedValueProvider.Result<JvmFileClassInfo> compute() {
                return new CachedValueProvider.Result<JvmFileClassInfo>(JvmFileClassUtil.getFileClassInfoNoResolve(this.$this_fileClassInfo), this.$this_fileClassInfo);
            }
            {
                this.$this_fileClassInfo = ktFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, "CachedValuesManager.getC\u2026ve(this), this)\n        }");
        return (JvmFileClassInfo)t;
    }

    @NotNull
    public static final FqName getJavaFileFacadeFqName(@NotNull KtFile $this$javaFileFacadeFqName) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$javaFileFacadeFqName, "$this$javaFileFacadeFqName");
        if ($this$javaFileFacadeFqName.isCompiled()) {
            FqName fqName3 = $this$javaFileFacadeFqName.getPackageFqName();
            VirtualFile virtualFile2 = $this$javaFileFacadeFqName.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue(virtualFile2, "virtualFile");
            fqName2 = fqName3.child(Name.identifier(virtualFile2.getNameWithoutExtension()));
        } else {
            fqName2 = JvmFileClassUtilKt.getFileClassInfo($this$javaFileFacadeFqName).getFacadeClassFqName();
        }
        Intrinsics.checkNotNullExpressionValue(fqName2, "if (isCompiled) packageF\u2026assInfo.facadeClassFqName");
        FqName facadeFqName = fqName2;
        Name name = facadeFqName.shortName();
        Intrinsics.checkNotNullExpressionValue(name, "facadeFqName.shortName()");
        if (!Name.isValidIdentifier(name.getIdentifier())) {
            LOG.error("An invalid fqName `" + facadeFqName + "` with short name `" + facadeFqName.shortName() + "` is created for file `" + $this$javaFileFacadeFqName.getName() + "` " + "(isCompiled = " + $this$javaFileFacadeFqName.isCompiled() + ')');
        }
        return facadeFqName;
    }

    public static final boolean isInsideJvmMultifileClassFile(@NotNull KtDeclaration $this$isInsideJvmMultifileClassFile) {
        Intrinsics.checkNotNullParameter($this$isInsideJvmMultifileClassFile, "$this$isInsideJvmMultifileClassFile");
        KtFile ktFile = $this$isInsideJvmMultifileClassFile.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue(ktFile, "containingKtFile");
        return JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(ktFile, JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
    }

    public static final boolean isTopLevelInJvmMultifileClass(@NotNull DeclarationDescriptor $this$isTopLevelInJvmMultifileClass) {
        DeserializedContainerSource containerSource;
        Intrinsics.checkNotNullParameter($this$isTopLevelInJvmMultifileClass, "$this$isTopLevelInJvmMultifileClass");
        if (!($this$isTopLevelInJvmMultifileClass.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            return false;
        }
        PsiElement declaration2 = DescriptorToSourceUtils.descriptorToDeclaration($this$isTopLevelInJvmMultifileClass);
        if (declaration2 instanceof KtDeclaration) {
            return JvmFileClassUtilKt.isInsideJvmMultifileClassFile((KtDeclaration)declaration2);
        }
        return $this$isTopLevelInJvmMultifileClass instanceof DeserializedMemberDescriptor && (containerSource = ((DeserializedMemberDescriptor)$this$isTopLevelInJvmMultifileClass).getContainerSource()) instanceof JvmPackagePartSource && ((JvmPackagePartSource)containerSource).getFacadeClassName() != null;
    }

    @NotNull
    public static final String getInternalNameWithoutInnerClasses(@NotNull FqName $this$internalNameWithoutInnerClasses) {
        Intrinsics.checkNotNullParameter($this$internalNameWithoutInnerClasses, "$this$internalNameWithoutInnerClasses");
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses($this$internalNameWithoutInnerClasses);
        Intrinsics.checkNotNullExpressionValue(jvmClassName, "JvmClassName.byFqNameWithoutInnerClasses(this)");
        String string2 = jvmClassName.getInternalName();
        Intrinsics.checkNotNullExpressionValue(string2, "JvmClassName.byFqNameWit\u2026lasses(this).internalName");
        return string2;
    }

    static {
        Logger logger = Logger.getInstance("JvmFileClassUtil");
        Intrinsics.checkNotNullExpressionValue(logger, "Logger.getInstance(\"JvmFileClassUtil\")");
        LOG = logger;
    }
}

