/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentMapping;
import org.jetbrains.kotlin.fir.resolve.calls.FirCallArgumentsProcessor;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"EmptyArgumentMapping", "Lorg/jetbrains/kotlin/fir/resolve/calls/ArgumentMapping;", "mapArguments", "arguments", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "resolve"})
public final class FirArgumentsToParametersMapperKt {
    private static final ArgumentMapping EmptyArgumentMapping = new ArgumentMapping(MapsKt.emptyMap(), CollectionsKt.emptyList());

    @NotNull
    public static final ArgumentMapping mapArguments(@NotNull List<? extends FirExpression> arguments2, @NotNull FirFunction<?> function2) {
        FirExpression firExpression2;
        block4: {
            Intrinsics.checkNotNullParameter(arguments2, "arguments");
            Intrinsics.checkNotNullParameter(function2, "function");
            if (arguments2.isEmpty() && function2.getValueParameters().isEmpty()) {
                return EmptyArgumentMapping;
            }
            List<? extends FirExpression> $this$lastOrNull$iv = arguments2;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends FirExpression> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                FirExpression element$iv;
                FirExpression it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it instanceof FirLambdaArgumentExpression)) continue;
                firExpression2 = element$iv;
                break block4;
            }
            firExpression2 = null;
        }
        FirExpression externalArgument = firExpression2;
        List<? extends FirExpression> argumentsInParenthesis = externalArgument == null ? arguments2 : arguments2.subList(0, arguments2.size() - 1);
        FirCallArgumentsProcessor processor2 = new FirCallArgumentsProcessor(function2);
        processor2.processArgumentsInParenthesis(argumentsInParenthesis);
        if (externalArgument != null) {
            processor2.processExternalArgument(externalArgument);
        }
        processor2.processDefaultsAndRunChecks();
        Map<FirValueParameter, ResolvedCallArgument> map2 = processor2.getResult();
        List<ResolutionDiagnostic> list2 = processor2.getDiagnostics();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return new ArgumentMapping(map2, list2);
    }
}

