/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Repository;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;

public final class ResolverHelper {
    public static String[] listTokenValues(Repository rep, String pattern, String token) {
        String tokenString;
        String fileSep = rep.getFileSeparator();
        int index = (pattern = rep.standardize(pattern)).indexOf(tokenString = IvyPatternHelper.getTokenString(token));
        if (index == -1) {
            Message.verbose("unable to list " + token + " in " + pattern + ": token not found in pattern");
            return null;
        }
        if ((pattern.length() <= index + tokenString.length() || fileSep.equals(pattern.substring(index + tokenString.length(), index + tokenString.length() + 1))) && (index == 0 || fileSep.equals(pattern.substring(index - 1, index)))) {
            String root = pattern.substring(0, index);
            return ResolverHelper.listAll(rep, root);
        }
        int slashIndex = pattern.substring(0, index).lastIndexOf(fileSep);
        String root = slashIndex == -1 ? "" : pattern.substring(0, slashIndex);
        try {
            Message.debug("\tusing " + rep + " to list all in " + root);
            String[] all = ResolverHelper.listAll(rep, root);
            if (all == null) {
                return null;
            }
            Message.debug("\t\tfound " + all.length + " urls");
            ArrayList<String> ret = new ArrayList<String>(all.length);
            int endNameIndex = pattern.indexOf(fileSep, slashIndex + 1);
            String namePattern = endNameIndex != -1 ? pattern.substring(slashIndex + 1, endNameIndex) : pattern.substring(slashIndex + 1);
            namePattern = namePattern.replaceAll("\\.", "\\\\.");
            namePattern = IvyPatternHelper.substituteToken(namePattern, token, "(.+)");
            Pattern p = Pattern.compile(namePattern);
            for (String path : all) {
                Matcher m = p.matcher(path);
                if (!m.matches()) continue;
                String value = m.group(1);
                ret.add(value);
            }
            Message.debug("\t\t" + ret.size() + " matched " + pattern);
            return ret.toArray(new String[ret.size()]);
        }
        catch (Exception e) {
            Message.warn("problem while listing resources in " + root + " with " + rep, e);
            return null;
        }
    }

    public static String[] listAll(Repository rep, String parent) {
        try {
            String fileSep = rep.getFileSeparator();
            Message.debug("\tusing " + rep + " to list all in " + parent);
            List<String> all = rep.list(parent);
            if (all == null) {
                Message.debug("\t\tno resources found");
                return null;
            }
            Message.debug("\t\tfound " + all.size() + " resources");
            ArrayList<String> names = new ArrayList<String>(all.size());
            for (String path : all) {
                if (path.endsWith(fileSep)) {
                    path = path.substring(0, path.length() - 1);
                }
                int slashIndex = path.lastIndexOf(fileSep);
                names.add(path.substring(slashIndex + 1));
            }
            return names.toArray(new String[names.size()]);
        }
        catch (IOException e) {
            Message.verbose("problem while listing resources in " + parent + " with " + rep, e);
            return null;
        }
        catch (Exception e) {
            Message.warn("problem while listing resources in " + parent + " with " + rep, e);
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository rep, ModuleRevisionId mrid, String pattern, Artifact artifact) {
        String partiallyResolvedPattern = IvyPatternHelper.substitute(pattern, ModuleRevisionId.newInstance(mrid, IvyPatternHelper.getTokenString("revision")), artifact);
        Message.debug("\tlisting all in " + partiallyResolvedPattern);
        String[] revs = ResolverHelper.listTokenValues(rep, partiallyResolvedPattern, "revision");
        if (revs != null) {
            Message.debug("\tfound revs: " + Arrays.asList(revs));
            ArrayList<ResolvedResource> ret = new ArrayList<ResolvedResource>(revs.length);
            for (String rev : revs) {
                String rres = IvyPatternHelper.substituteToken(partiallyResolvedPattern, "revision", rev);
                try {
                    Resource res2 = rep.getResource(rres);
                    if (res2 == null) continue;
                    ret.add(new ResolvedResource(res2, rev));
                }
                catch (IOException e) {
                    Message.warn("impossible to get resource from name listed by repository: " + rres, e);
                }
            }
            if (revs.length != ret.size()) {
                Message.debug("\tfound resolved res: " + ret);
            }
            return ret.toArray(new ResolvedResource[ret.size()]);
        }
        if (!partiallyResolvedPattern.contains("[revision]")) {
            try {
                Resource res3 = rep.getResource(partiallyResolvedPattern);
                if (res3.exists()) {
                    Message.debug("\tonly one resource found without real listing: using and defining it as working@" + rep.getName() + " revision: " + res3.getName());
                    return new ResolvedResource[]{new ResolvedResource(res3, "working@" + rep.getName())};
                }
            }
            catch (IOException e) {
                Message.debug("\timpossible to get resource from name listed by repository: " + partiallyResolvedPattern, e);
            }
            Message.debug("\tno revision found");
        }
        return null;
    }
}

