/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.text.OrdinalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundleBase {
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    private static boolean assertOnMissedKeys = false;
    private static final String[] SUFFIXES = new String[]{"</body></html>", "</html>"};

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(0);
        }
        if (key == null) {
            BundleBase.$$$reportNull$$$0(1);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(2);
        }
        String string2 = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string2 == null) {
            BundleBase.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        String value2;
        if (key == null) {
            BundleBase.$$$reportNull$$$0(4);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(5);
        }
        if (bundle == null) {
            return defaultValue;
        }
        try {
            value2 = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            value2 = BundleBase.useDefaultValue(bundle, key, defaultValue);
        }
        String result2 = BundleBase.postprocessValue(bundle, value2, params);
        if (SHOW_LOCALIZED_MESSAGES) {
            return BundleBase.appendLocalizationMarker(result2);
        }
        return result2;
    }

    @NotNull
    protected static String appendLocalizationMarker(@NotNull String result2) {
        if (result2 == null) {
            BundleBase.$$$reportNull$$$0(6);
        }
        for (String suffix : SUFFIXES) {
            if (!result2.endsWith(suffix)) continue;
            String string2 = result2.substring(0, result2.length() - suffix.length()) + "\ud83d\udd05" + suffix;
            if (string2 == null) {
                BundleBase.$$$reportNull$$$0(7);
            }
            return string2;
        }
        String string3 = result2 + "\ud83d\udd05";
        if (string3 == null) {
            BundleBase.$$$reportNull$$$0(8);
        }
        return string3;
    }

    @NotNull
    static String useDefaultValue(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue) {
        if (key == null) {
            BundleBase.$$$reportNull$$$0(9);
        }
        if (defaultValue != null) {
            String string2 = defaultValue;
            if (string2 == null) {
                BundleBase.$$$reportNull$$$0(10);
            }
            return string2;
        }
        if (assertOnMissedKeys) assert (false) : "'" + key + "' is not found in " + bundle;
        String string3 = "!" + key + "!";
        if (string3 == null) {
            BundleBase.$$$reportNull$$$0(11);
        }
        return string3;
    }

    @Nullable
    static String postprocessValue(@NotNull ResourceBundle bundle, @Nullable String value2, @NotNull Object[] params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(12);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(13);
        }
        value2 = BundleBase.replaceMnemonicAmpersand(value2);
        if (params.length > 0 && value2.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            try {
                MessageFormat format = locale != null ? new MessageFormat(value2, locale) : new MessageFormat(value2);
                OrdinalFormat.apply(format);
                value2 = format.format(params);
            }
            catch (IllegalArgumentException e) {
                value2 = "!invalid format: `" + value2 + "`!";
            }
        }
        return value2;
    }

    @Contract(value="null -> null")
    public static String replaceMnemonicAmpersand(@Nullable String value2) {
        if (value2 == null || value2.indexOf(38) < 0) {
            return value2;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = value2.contains("&&");
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c == '\\') {
                if (i < value2.length() - 1 && value2.charAt(i + 1) == '&') {
                    builder.append('&');
                    ++i;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                if (i < value2.length() - 1 && value2.charAt(i + 1) == '&') {
                    if (SystemInfoRt.isMac) {
                        builder.append('\u001b');
                    }
                    ++i;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic) continue;
                builder.append('\u001b');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/BundleBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/BundleBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLocalizationMarker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "useDefaultValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendLocalizationMarker";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "useDefaultValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "postprocessValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

