/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JF\u0010\u0015\u001a\u00020\u0006\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u0017\"\b\b\u0001\u0010\u0018*\u00020\u0019*\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u0001H\u00162\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\u001cH\u0082\b\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isAllowedArray", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAllowedClassKind", "cone", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "report", "T", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "P", "Lcom/intellij/psi/PsiElement;", "source", "factory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "(Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;)V", "checkers"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object factory$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration2 instanceof FirRegularClass)) {
            return;
        }
        if (((FirRegularClass)declaration2).getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        Object $this$isLocal$iv = (FirRegularClass)declaration2;
        boolean $i$f$isLocal22 = false;
        if (((FirRegularClass)$this$isLocal$iv).getSymbol().getClassId().isLocal()) {
            DiagnosticReporter $i$f$isLocal22 = reporter;
            $this$isLocal$iv = this;
            FirSourceElement firSourceElement = declaration2.getSource();
            factory$iv = FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR();
            boolean $i$f$report = false;
            FirSourceElement firSourceElement2 = firSourceElement;
            if (firSourceElement2 != null) {
                void $this$report$iv;
                FirSourceElement firSourceElement3 = firSourceElement2;
                boolean bl = false;
                boolean bl2 = false;
                FirSourceElement it$iv = firSourceElement3;
                boolean bl3 = false;
                $this$report$iv.report((FirDiagnostic)((FirDiagnosticFactory0)factory$iv).on(it$iv));
            }
        }
        for (FirDeclaration it : ((FirRegularClass)declaration2).getDeclarations()) {
            void $this$report$iv;
            void var11_31;
            void source$iv;
            if (it instanceof FirConstructor && ((FirConstructor)it).isPrimary()) {
                for (FirValueParameter firValueParameter : ((FirConstructor)it).getValueParameters()) {
                    void $this$report$iv2;
                    void var16_69;
                    void source$iv2;
                    boolean bl;
                    void it$iv;
                    boolean bl3;
                    ClassId classId;
                    ConeLookupTagBasedType coneType;
                    FirTypeRef typeRef;
                    boolean bl4;
                    Object factory$iv2;
                    int $i$f$report;
                    FirSourceElement parameterSourceElement = firValueParameter.getSource();
                    if (parameterSourceElement instanceof FirPsiSourceElement) {
                        Object p = ((FirPsiSourceElement)parameterSourceElement).getPsi();
                        if (p == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                        }
                        KtParameter parameterPsiElement = (KtParameter)p;
                        if (!parameterPsiElement.hasValOrVar()) {
                            void $this$report$iv22;
                            DiagnosticReporter diagnosticReporter = reporter;
                            FirAnnotationClassDeclarationChecker firAnnotationClassDeclarationChecker = this;
                            FirDiagnosticFactory0<FirSourceElement, KtParameter> factory$iv22 = FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER();
                            $i$f$report = 0;
                            FirSourceElement firSourceElement4 = parameterSourceElement;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            FirSourceElement it$iv2 = firSourceElement4;
                            boolean bl52 = false;
                            $this$report$iv22.report((FirDiagnostic)factory$iv22.on(it$iv2));
                        } else if (parameterPsiElement.isMutable()) {
                            void $this$report$iv3;
                            DiagnosticReporter $this$report$iv22 = reporter;
                            FirAnnotationClassDeclarationChecker this_$iv = this;
                            factory$iv2 = FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER();
                            $i$f$report = 0;
                            FirSourceElement firSourceElement5 = parameterSourceElement;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            FirSourceElement it$iv3 = firSourceElement5;
                            bl4 = false;
                            $this$report$iv3.report((FirDiagnostic)((FirDiagnosticFactory0)factory$iv2).on(it$iv3));
                        }
                    } else if (parameterSourceElement instanceof FirLightSourceElement) {
                        boolean bl9;
                        Object $this$any$iv;
                        Ref<T[]> kidsRef;
                        block27: {
                            kidsRef = new Ref<T[]>();
                            ((FirLightSourceElement)parameterSourceElement).getTree().getChildren(((FirLightSourceElement)parameterSourceElement).getElement(), kidsRef);
                            Intrinsics.checkNotNullExpressionValue(kidsRef.get(), "kidsRef.get()");
                            boolean $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                LighterASTNode it2 = (LighterASTNode)element$iv;
                                boolean bl11 = false;
                                LighterASTNode lighterASTNode = it2;
                                if (!Intrinsics.areEqual(lighterASTNode != null ? lighterASTNode.getTokenType() : null, KtTokens.VAR_KEYWORD)) continue;
                                bl9 = true;
                                break block27;
                            }
                            bl9 = false;
                        }
                        if (bl9) {
                            void $this$report$iv3;
                            DiagnosticReporter $i$f$any = reporter;
                            $this$any$iv = this;
                            factory$iv2 = FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER();
                            $i$f$report = 0;
                            FirSourceElement firSourceElement = parameterSourceElement;
                            boolean element$iv = false;
                            boolean it2 = false;
                            FirSourceElement it$iv4 = firSourceElement;
                            bl4 = false;
                            $this$report$iv3.report((FirDiagnostic)((FirDiagnosticFactory0)factory$iv2).on(it$iv4));
                        } else {
                            boolean bl10;
                            Object $this$all$iv;
                            block28: {
                                Intrinsics.checkNotNullExpressionValue(kidsRef.get(), "kidsRef.get()");
                                boolean $i$f$all = false;
                                for (Object element$iv : $this$all$iv) {
                                    LighterASTNode it3 = (LighterASTNode)element$iv;
                                    boolean bl13 = false;
                                    LighterASTNode lighterASTNode = it3;
                                    if (Intrinsics.areEqual(lighterASTNode != null ? lighterASTNode.getTokenType() : null, KtTokens.VAL_KEYWORD) ^ true) continue;
                                    bl10 = false;
                                    break block28;
                                }
                                bl10 = true;
                            }
                            if (bl10) {
                                void $this$report$iv4;
                                DiagnosticReporter $i$f$all = reporter;
                                $this$all$iv = this;
                                FirDiagnosticFactory0<FirSourceElement, KtParameter> factory$iv322 = FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER();
                                boolean $i$f$report2 = false;
                                FirSourceElement firSourceElement = parameterSourceElement;
                                boolean element$iv = false;
                                boolean firSourceElement4 = false;
                                FirSourceElement it$iv5 = firSourceElement;
                                bl4 = false;
                                $this$report$iv4.report((FirDiagnostic)factory$iv322.on(it$iv5));
                            }
                        }
                    }
                    FirTypeRef $this$coneTypeSafe$iv = typeRef = firValueParameter.getReturnTypeRef();
                    boolean $i$f$coneTypeSafe22 = false;
                    boolean factory$iv322 = false;
                    FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                    if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                        firTypeRef = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                        coneKotlinType = null;
                    }
                    ConeLookupTagBasedType coneLookupTagBasedType = coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType));
                    ClassId classId2 = classId = coneLookupTagBasedType != null ? ConeTypeUtilsKt.getClassId(coneLookupTagBasedType) : null;
                    if (coneType == null || Intrinsics.areEqual(classId, ClassId.fromString("<error>"))) continue;
                    if (ConeTypeUtilsKt.isNullable(coneType)) {
                        void source$iv22;
                        DiagnosticReporter factory$iv322 = reporter;
                        FirAnnotationClassDeclarationChecker $i$f$coneTypeSafe22 = this;
                        FirSourceElement $i$f$report2 = typeRef.getSource();
                        FirDiagnosticFactory0<FirSourceElement, KtTypeReference> factory$iv4 = FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER();
                        boolean $i$f$report3 = false;
                        if (source$iv22 != null) {
                            void $this$report$iv5;
                            void var16_67;
                            boolean bl11 = false;
                            bl3 = false;
                            it$iv = var16_67;
                            boolean bl12 = false;
                            $this$report$iv5.report((FirDiagnostic)factory$iv4.on((FirSourceElement)it$iv));
                        }
                        continue;
                    }
                    if (CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveTypes(), classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedTypes(), classId) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), classId)) continue;
                    if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getArray())) {
                        void source$iv3;
                        if (this.isAllowedArray(typeRef, context2.getSession())) continue;
                        DiagnosticReporter $this$report$iv5 = reporter;
                        FirAnnotationClassDeclarationChecker this_$iv = this;
                        FirSourceElement source$iv22 = typeRef.getSource();
                        FirDiagnosticFactory0<FirSourceElement, KtTypeReference> factory$iv5 = FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER();
                        boolean $i$f$report4 = false;
                        if (source$iv3 != null) {
                            void $this$report$iv6;
                            void var16_68;
                            boolean bl13 = false;
                            bl3 = false;
                            it$iv = var16_68;
                            bl = false;
                            $this$report$iv6.report((FirDiagnostic)factory$iv5.on((FirSourceElement)it$iv));
                        }
                        continue;
                    }
                    if (this.isAllowedClassKind(coneType, context2.getSession())) continue;
                    DiagnosticReporter $this$report$iv6 = reporter;
                    FirAnnotationClassDeclarationChecker this_$iv = this;
                    FirSourceElement source$iv3 = typeRef.getSource();
                    FirDiagnosticFactory0<FirSourceElement, KtTypeReference> factory$iv6 = FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER();
                    boolean $i$f$report5 = false;
                    if (source$iv2 == null) continue;
                    boolean bl14 = false;
                    bl3 = false;
                    it$iv = var16_69;
                    bl = false;
                    $this$report$iv2.report((FirDiagnostic)factory$iv6.on((FirSourceElement)it$iv));
                }
                continue;
            }
            if (it instanceof FirRegularClass) continue;
            if (it instanceof FirProperty) {
                FirSourceElement firSourceElement = it.getSource();
                if (Intrinsics.areEqual(firSourceElement != null ? firSourceElement.getElementType() : null, KtNodeTypes.VALUE_PARAMETER)) continue;
            }
            if (it instanceof FirSimpleFunction) {
                FirSourceElement firSourceElement = it.getSource();
                if (Intrinsics.areEqual(firSourceElement != null ? firSourceElement.getElementType() : null, KtNodeTypes.FUN) ^ true) continue;
            }
            factory$iv = reporter;
            FirAnnotationClassDeclarationChecker firAnnotationClassDeclarationChecker = this;
            FirSourceElement typeRef = it.getSource();
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv7 = FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER();
            boolean $i$f$report = false;
            if (source$iv == null) continue;
            boolean bl = false;
            boolean bl15 = false;
            void it$iv = var11_31;
            boolean bl19 = false;
            $this$report$iv.report((FirDiagnostic)factory$iv7.on((FirSourceElement)it$iv));
        }
    }

    private final boolean isAllowedClassKind(ConeLookupTagBasedType cone, FirSession session2) {
        Object object;
        FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.toSymbol(cone.getLookupTag(), session2);
        Object object2 = firClassifierSymbol != null ? firClassifierSymbol.getFir() : null;
        if (!(object2 instanceof FirRegularClass)) {
            object2 = null;
        }
        if ((object = (FirRegularClass)object2) == null || (object = object.getClassKind()) == null) {
            return false;
        }
        Object typeRefClassKind = object;
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(FirTypeRef typeRef, FirSession session2) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        FirTypeRef $this$coneType$iv = typeRef;
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeTypeProjection[] typeArguments2 = coneKotlinType.getTypeArguments();
        if (typeArguments2.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments2[0];
        if (!(coneTypeProjection instanceof ConeKotlinTypeProjection)) {
            coneTypeProjection = null;
        }
        if ((coneKotlinTypeProjection = (ConeKotlinTypeProjection)coneTypeProjection) == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return false;
        }
        ConeKotlinTypeProjection arrayType = coneKotlinTypeProjection;
        if (ConeTypeUtilsKt.isNullable((ConeKotlinType)arrayType)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)arrayType);
        if (Intrinsics.areEqual(arrayTypeClassId, StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual(arrayTypeClassId, StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        ConeKotlinTypeProjection coneKotlinTypeProjection2 = arrayType;
        if (coneKotlinTypeProjection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType");
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)coneKotlinTypeProjection2, session2);
    }

    private FirAnnotationClassDeclarationChecker() {
    }

    static {
        FirAnnotationClassDeclarationChecker firAnnotationClassDeclarationChecker;
        INSTANCE = firAnnotationClassDeclarationChecker = new FirAnnotationClassDeclarationChecker();
    }
}

