/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeStubDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.builder.FirAbstractResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionWithSmartcastBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedReifiedParameterReferenceBuilder;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.TreeResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitDispatchReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassSubstitutionScopeKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u00c0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a8\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u001a \u0010\n\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b\u001a\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a>\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u001a\u0018\u0010!\u001a\u00020\"*\u0006\u0012\u0002\b\u00030#2\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010$\u001a\u0004\u0018\u00010\u0004*\u00020%H\u0002\u001a\u0014\u0010&\u001a\u0004\u0018\u00010'*\u00020(2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010)\u001a\u0004\u0018\u00010**\u00020(2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010+\u001a\u00020\b*\u00020,\u001a\n\u0010-\u001a\u00020\b*\u00020,\u001a\n\u0010.\u001a\u00020\b*\u00020,\u001a\n\u0010/\u001a\u00020\b*\u00020,\u001a\n\u00100\u001a\u00020\b*\u00020,\u001a\u001a\u00101\u001a\u000202*\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u00106\u001a\u000202*\u0002072\u0006\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001b\u00108\u001a\b\u0012\u0004\u0012\u00020:09*\b\u0012\u0004\u0012\u00020;0\u0003\u00a2\u0006\u0002\u0010<\u001a\u0012\u0010=\u001a\u00020>*\u00020\u00182\u0006\u0010?\u001a\u00020>\u001a\u0012\u0010@\u001a\u00020\r*\u00020\u00182\u0006\u0010A\u001a\u00020\u0017\u001a!\u0010B\u001a\u00020\"\"\b\b\u0000\u0010C*\u00020D*\u00020\u00182\u0006\u0010E\u001a\u0002HC\u00a2\u0006\u0002\u0010F\u001a \u0010G\u001a\u00020\"*\u00020\u00182\n\u0010H\u001a\u0006\u0012\u0002\b\u00030I2\u0006\u0010J\u001a\u00020\bH\u0002\u00a8\u0006K"}, d2={"createFunctionalType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "parameters", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "receiverType", "rawReturnType", "isSuspend", "", "isKFunctionType", "createKPropertyType", "isMutable", "typeForQualifierByDeclaration", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "resultType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "typeForReifiedParameterReference", "parameterReferenceBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirResolvedReifiedParameterReferenceBuilder;", "buildResolvedQualifierForClass", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "regularClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "sourceElement", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "typeArgumentsForQualifier", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "constructFunctionalTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "expressionTypeOrUnitForAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "getCorrespondingClassSymbolOrNull", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isInvoke", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "isIterator", "isIteratorHasNext", "isIteratorNext", "isKFunctionInvoke", "propagateTypeFromOriginalReceiver", "", "Lorg/jetbrains/kotlin/fir/expressions/FirCheckedSafeCallSubject;", "nullableReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "propagateTypeFromQualifiedAccessAfterNullCheck", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "toTypeProjections", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "(Ljava/util/List;)[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "transformQualifiedAccessUsingSmartcastInfo", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedAccessExpression", "typeForQualifier", "resolvedQualifier", "typeFromCallee", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "access", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;)Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "typeFromSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "makeNullable", "resolve"})
public final class ResolveUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeTypeProjection[] toTypeProjections(@NotNull List<? extends FirQualifierPart> $this$toTypeProjections) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toTypeProjections, "$this$toTypeProjections");
        Iterable $this$flatMap$iv = CollectionsKt.asReversed($this$toTypeProjections);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            FirQualifierPart it = (FirQualifierPart)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = it.getTypeArgumentList().getTypeArguments();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void typeArgument;
                FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                ConeTypeProjection coneTypeProjection = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)typeArgument);
                collection.add(coneTypeProjection);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return coneTypeProjectionArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirResolvedTypeRef constructFunctionalTypeRef(@NotNull FirFunction<?> $this$constructFunctionalTypeRef, boolean isSuspend) {
        ConeKotlinType coneKotlinType;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$constructFunctionalTypeRef, "$this$constructFunctionalTypeRef");
        FirFunction<?> firFunction = $this$constructFunctionalTypeRef;
        FirTypeRef receiverTypeRef = firFunction instanceof FirSimpleFunction ? $this$constructFunctionalTypeRef.getReceiverTypeRef() : (firFunction instanceof FirAnonymousFunction ? $this$constructFunctionalTypeRef.getReceiverTypeRef() : null);
        Iterable $this$map$iv = $this$constructFunctionalTypeRef.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConeKotlinType coneKotlinType2;
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirTypeRef $this$coneTypeSafe$iv = it.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl2 = false;
            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType3 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                coneKotlinType3 = coneKotlinType2 = null;
            }
            if (coneKotlinType3 == null) {
                coneKotlinType2 = new ConeClassErrorType(new ConeSimpleDiagnostic("No type for parameter", DiagnosticKind.NoTypeForTypeParameter));
            }
            ConeKotlinType coneKotlinType4 = coneKotlinType2;
            collection.add(coneKotlinType4);
        }
        List parameters2 = (List)destination$iv$iv;
        FirTypeRef $this$coneType$iv = ((FirTypedDeclaration)$this$constructFunctionalTypeRef).getReturnTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType5 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType rawReturnType = coneKotlinType5;
        FirTypeRef firTypeRef = receiverTypeRef;
        if (firTypeRef != null) {
            FirTypeRef $this$coneType$iv2 = firTypeRef;
            boolean $i$f$getConeType2 = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv2 = $this$coneType$iv2;
            boolean $i$f$coneTypeUnsafe2 = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv2).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        } else {
            coneKotlinType = null;
        }
        ConeLookupTagBasedType functionalType = ResolveUtilsKt.createFunctionalType$default(parameters2, coneKotlinType, rawReturnType, isSuspend, false, 16, null);
        boolean $i$f$buildResolvedTypeRef = false;
        boolean bl = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
        boolean bl5 = false;
        FirSourceElement firSourceElement = $this$constructFunctionalTypeRef.getSource();
        $this$buildResolvedTypeRef.setSource(firSourceElement != null ? FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.ImplicitTypeRef.INSTANCE) : null);
        $this$buildResolvedTypeRef.setType(functionalType);
        $this$buildResolvedTypeRef.setSuspend(isSuspend);
        return firResolvedTypeRefBuilder.build();
    }

    public static /* synthetic */ FirResolvedTypeRef constructFunctionalTypeRef$default(FirFunction firFunction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ResolveUtilsKt.constructFunctionalTypeRef(firFunction, bl);
    }

    @NotNull
    public static final ConeLookupTagBasedType createFunctionalType(@NotNull List<? extends ConeKotlinType> parameters2, @Nullable ConeKotlinType receiverType, @NotNull ConeKotlinType rawReturnType, boolean isSuspend, boolean isKFunctionType) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(rawReturnType, "rawReturnType");
        List receiverAndParameterTypes = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(receiverType), (Iterable)parameters2), (Iterable)CollectionsKt.listOf(rawReturnType));
        FunctionClassKind kind = isSuspend ? (isKFunctionType ? FunctionClassKind.KSuspendFunction : FunctionClassKind.SuspendFunction) : (isKFunctionType ? FunctionClassKind.KFunction : FunctionClassKind.Function);
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName(receiverAndParameterTypes.size() - 1));
        Collection $this$toTypedArray$iv = receiverAndParameterTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeKotlinType[] coneKotlinTypeArray = thisCollection$iv.toArray(new ConeKotlinType[0]);
        if (coneKotlinTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), coneKotlinTypeArray, false, null, 8, null);
    }

    public static /* synthetic */ ConeLookupTagBasedType createFunctionalType$default(List list2, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return ResolveUtilsKt.createFunctionalType(list2, coneKotlinType, coneKotlinType2, bl, bl2);
    }

    @NotNull
    public static final ConeLookupTagBasedType createKPropertyType(@Nullable ConeKotlinType receiverType, @NotNull ConeKotlinType rawReturnType, boolean isMutable) {
        Intrinsics.checkNotNullParameter(rawReturnType, "rawReturnType");
        List<ConeKotlinType> arguments2 = receiverType != null ? CollectionsKt.listOf(receiverType, rawReturnType) : CollectionsKt.listOf(rawReturnType);
        ClassId classId = StandardClassIds.INSTANCE.reflectByName('K' + (isMutable ? "Mutable" : "") + "Property" + (arguments2.size() - 1));
        Collection $this$toTypedArray$iv = arguments2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeKotlinType[] coneKotlinTypeArray = thisCollection$iv.toArray(new ConeKotlinType[0]);
        if (coneKotlinTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(classId), coneKotlinTypeArray, false, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirResolvedQualifier buildResolvedQualifierForClass(@NotNull BodyResolveComponents $this$buildResolvedQualifierForClass, @NotNull FirClassLikeSymbol<?> regularClass, @Nullable FirSourceElement sourceElement, @NotNull List<? extends FirTypeProjection> typeArgumentsForQualifier, @Nullable ConeDiagnostic diagnostic) {
        void type$iv;
        FirTypeRef firTypeRef;
        FirAnnotationContainer $this$resultType$iv;
        Object $this$apply;
        boolean bl;
        boolean bl2;
        Object object;
        FirAbstractResolvedQualifierBuilder firAbstractResolvedQualifierBuilder;
        Intrinsics.checkNotNullParameter($this$buildResolvedQualifierForClass, "$this$buildResolvedQualifierForClass");
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter(typeArgumentsForQualifier, "typeArgumentsForQualifier");
        ClassId classId = regularClass.getClassId();
        if (diagnostic == null) {
            firAbstractResolvedQualifierBuilder = new FirResolvedQualifierBuilder();
        } else {
            object = new FirErrorResolvedQualifierBuilder();
            bl2 = false;
            bl = false;
            $this$apply = object;
            boolean bl3 = false;
            ((FirErrorResolvedQualifierBuilder)$this$apply).setDiagnostic(diagnostic);
            firAbstractResolvedQualifierBuilder = object;
        }
        FirAbstractResolvedQualifierBuilder builder = firAbstractResolvedQualifierBuilder;
        object = builder;
        bl2 = false;
        bl = false;
        $this$apply = object;
        boolean bl4 = false;
        $this$apply.setSource(sourceElement);
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        $this$apply.setPackageFqName(fqName2);
        $this$apply.setRelativeClassFqName(classId.getRelativeClassName());
        $this$apply.getTypeArguments().addAll((Collection<FirTypeProjection>)typeArgumentsForQualifier);
        $this$apply.setSymbol(regularClass);
        object = object.build();
        bl2 = false;
        bl = false;
        $this$apply = object;
        boolean bl5 = false;
        FirExpression firExpression2 = (FirExpression)$this$apply;
        if (classId.isLocal()) {
            $this$resultType$iv = (FirExpression)$this$apply;
            boolean $i$f$getResultType = false;
            firTypeRef = ResolveUtilsKt.typeForQualifierByDeclaration((FirDeclaration)regularClass.getFir(), ((FirExpression)$this$resultType$iv).getTypeRef(), $this$buildResolvedQualifierForClass.getSession());
            if (firTypeRef == null) {
                firTypeRef = $this$buildResolvedQualifierForClass.getSession().getBuiltinTypes().getUnitType();
            }
        } else {
            firTypeRef = ResolveUtilsKt.typeForQualifier($this$buildResolvedQualifierForClass, (FirResolvedQualifier)$this$apply);
        }
        $this$resultType$iv = firTypeRef;
        FirExpression $this$resultType$iv2 = firExpression2;
        boolean $i$f$setResultType = false;
        $this$resultType$iv2.replaceTypeRef((FirTypeRef)type$iv);
        return object;
    }

    public static /* synthetic */ FirResolvedQualifier buildResolvedQualifierForClass$default(BodyResolveComponents bodyResolveComponents, FirClassLikeSymbol firClassLikeSymbol, FirSourceElement firSourceElement, List list2, ConeDiagnostic coneDiagnostic, int n, Object object) {
        if ((n & 2) != 0) {
            firSourceElement = null;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            coneDiagnostic = null;
        }
        return ResolveUtilsKt.buildResolvedQualifierForClass(bodyResolveComponents, firClassLikeSymbol, firSourceElement, list2, coneDiagnostic);
    }

    @NotNull
    public static final FirTypeRef typeForQualifier(@NotNull BodyResolveComponents $this$typeForQualifier, @NotNull FirResolvedQualifier resolvedQualifier) {
        Intrinsics.checkNotNullParameter($this$typeForQualifier, "$this$typeForQualifier");
        Intrinsics.checkNotNullParameter(resolvedQualifier, "resolvedQualifier");
        FirClassLikeSymbol<?> classSymbol = resolvedQualifier.getSymbol();
        FirExpression $this$resultType$iv = resolvedQualifier;
        boolean $i$f$getResultType = false;
        FirTypeRef resultType = $this$resultType$iv.getTypeRef();
        if (classSymbol != null) {
            PhaseUtilsKt.ensureResolved((AbstractFirBasedSymbol)classSymbol, FirResolvePhase.STATUS, $this$typeForQualifier.getSession());
            FirClassLikeDeclaration declaration2 = (FirClassLikeDeclaration)classSymbol.getFir();
            if (!(declaration2 instanceof FirTypeAlias) || resolvedQualifier.getTypeArguments().isEmpty()) {
                FirTypeRef firTypeRef = ResolveUtilsKt.typeForQualifierByDeclaration(declaration2, resultType, $this$typeForQualifier.getSession());
                if (firTypeRef != null) {
                    FirTypeRef firTypeRef2 = firTypeRef;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirTypeRef it = firTypeRef2;
                    boolean bl3 = false;
                    return it;
                }
            }
        }
        return $this$typeForQualifier.getSession().getBuiltinTypes().getUnitType();
    }

    @NotNull
    public static final FirTypeRef typeForReifiedParameterReference(@NotNull FirResolvedReifiedParameterReferenceBuilder parameterReferenceBuilder) {
        Intrinsics.checkNotNullParameter(parameterReferenceBuilder, "parameterReferenceBuilder");
        FirTypeRef resultType = parameterReferenceBuilder.getTypeRef();
        FirTypeParameterSymbol typeParameterSymbol = parameterReferenceBuilder.getSymbol();
        return CopyUtilsKt.resolvedTypeFromPrototype(resultType, TreeResolveUtilsKt.constructType$default(typeParameterSymbol, new ConeTypeProjection[0], false, null, 4, null));
    }

    @Nullable
    public static final FirTypeRef typeForQualifierByDeclaration(@NotNull FirDeclaration declaration2, @NotNull FirTypeRef resultType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(resultType, "resultType");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (declaration2 instanceof FirTypeAlias) {
            Object object = FirDeclarationUtilKt.getExpandedConeType((FirTypeAlias)declaration2);
            if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, session2)) == null || (object = (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object).getFir()) == null) {
                return null;
            }
            Object expandedDeclaration = object;
            return ResolveUtilsKt.typeForQualifierByDeclaration((FirDeclaration)expandedDeclaration, resultType, session2);
        }
        if (declaration2 instanceof FirRegularClass) {
            if (((FirRegularClass)declaration2).getClassKind() == ClassKind.OBJECT) {
                return CopyUtilsKt.resolvedTypeFromPrototype(resultType, TreeResolveUtilsKt.constructType$default(((FirRegularClass)declaration2).getSymbol(), new ConeTypeProjection[0], false, null, 4, null));
            }
            FirRegularClass companionObject = ((FirRegularClass)declaration2).getCompanionObject();
            if (companionObject != null) {
                return CopyUtilsKt.resolvedTypeFromPrototype(resultType, TreeResolveUtilsKt.constructType$default(companionObject.getSymbol(), new ConeTypeProjection[0], false, null, 4, null));
            }
        }
        return null;
    }

    @NotNull
    public static final <T extends FirResolvable> FirResolvedTypeRef typeFromCallee(@NotNull BodyResolveComponents $this$typeFromCallee, @NotNull T access) {
        FirResolvedTypeRef firResolvedTypeRef;
        Intrinsics.checkNotNullParameter($this$typeFromCallee, "$this$typeFromCallee");
        Intrinsics.checkNotNullParameter(access, "access");
        FirReference newCallee = access.getCalleeReference();
        if (newCallee instanceof FirErrorNamedReference) {
            boolean $i$f$buildErrorTypeRef = false;
            boolean bl = false;
            FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirErrorTypeRefBuilder $this$buildErrorTypeRef = firErrorTypeRefBuilder;
            boolean bl4 = false;
            FirSourceElement firSourceElement = access.getSource();
            $this$buildErrorTypeRef.setSource(firSourceElement != null ? FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.ErrorTypeRef.INSTANCE) : null);
            $this$buildErrorTypeRef.setDiagnostic(new ConeStubDiagnostic(((FirErrorNamedReference)newCallee).getDiagnostic()));
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        } else if (newCallee instanceof FirNamedReferenceWithCandidate) {
            firResolvedTypeRef = ResolveUtilsKt.typeFromSymbol($this$typeFromCallee, ((FirNamedReferenceWithCandidate)newCallee).getCandidateSymbol(), false);
        } else if (newCallee instanceof FirResolvedNamedReference) {
            firResolvedTypeRef = ResolveUtilsKt.typeFromSymbol($this$typeFromCallee, ((FirResolvedNamedReference)newCallee).getResolvedSymbol(), false);
        } else if (newCallee instanceof FirThisReference) {
            String labelName = ((FirThisReference)newCallee).getLabelName();
            ImplicitReceiverValue<?> implicitReceiver = $this$typeFromCallee.getImplicitReceiverStack().get(labelName);
            boolean $i$f$buildResolvedTypeRef = false;
            boolean bl = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
            boolean bl7 = false;
            $this$buildResolvedTypeRef.setSource(null);
            ImplicitReceiverValue<?> implicitReceiverValue = implicitReceiver;
            if (implicitReceiverValue == null || (implicitReceiverValue = implicitReceiverValue.getType()) == null) {
                implicitReceiverValue = new ConeClassErrorType(new ConeSimpleDiagnostic("Unresolved this@" + labelName, DiagnosticKind.UnresolvedLabel));
            }
            $this$buildResolvedTypeRef.setType((ConeKotlinType)((Object)implicitReceiverValue));
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        } else if (newCallee instanceof FirSuperReference) {
            FirResolvedTypeRef resolvedTypeRef;
            FirResolvedTypeRef firResolvedTypeRef2;
            FirTypeRef firTypeRef;
            ImplicitDispatchReceiverValue implicitReceiver;
            ImplicitDispatchReceiverValue implicitDispatchReceiverValue;
            String labelName = ((FirSuperReference)newCallee).getLabelName();
            if (labelName != null) {
                ImplicitReceiverValue<?> implicitReceiverValue = $this$typeFromCallee.getImplicitReceiverStack().get(labelName);
                if (!(implicitReceiverValue instanceof ImplicitDispatchReceiverValue)) {
                    implicitReceiverValue = null;
                }
                implicitDispatchReceiverValue = (ImplicitDispatchReceiverValue)implicitReceiverValue;
            } else {
                implicitDispatchReceiverValue = implicitReceiver = $this$typeFromCallee.getImplicitReceiverStack().lastDispatchReceiver();
            }
            if (!((firTypeRef = ((FirSuperReference)newCallee).getSuperTypeRef()) instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            if ((firResolvedTypeRef2 = (FirResolvedTypeRef)firTypeRef) == null) {
                FirTypeRef firTypeRef2;
                Object object = implicitReceiver;
                if (!((object != null && (object = (FirClassSymbol)((ImplicitReceiverValue)object).getBoundSymbol()) != null && (object = (FirClass)((AbstractFirBasedSymbol)object).getFir()) != null && (object = object.getSuperTypeRefs()) != null ? CollectionsKt.singleOrNull(object) : (firTypeRef2 = null)) instanceof FirResolvedTypeRef)) {
                    firTypeRef2 = null;
                }
                firResolvedTypeRef2 = (FirResolvedTypeRef)firTypeRef2;
            }
            if ((firResolvedTypeRef = (resolvedTypeRef = firResolvedTypeRef2)) == null) {
                boolean $i$f$buildErrorTypeRef = false;
                boolean bl = false;
                FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                boolean bl8 = false;
                boolean bl9 = false;
                FirErrorTypeRefBuilder $this$buildErrorTypeRef = firErrorTypeRefBuilder;
                boolean bl10 = false;
                $this$buildErrorTypeRef.setSource(newCallee.getSource());
                Name name = Name.identifier("super");
                Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"super\")");
                $this$buildErrorTypeRef.setDiagnostic(new ConeUnresolvedNameError(name));
                firResolvedTypeRef = firErrorTypeRefBuilder.build();
            }
        } else {
            String string2 = "Failed to extract type from: " + newCallee;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firResolvedTypeRef;
    }

    private static final FirResolvedTypeRef typeFromSymbol(BodyResolveComponents $this$typeFromSymbol, AbstractFirBasedSymbol<?> symbol2, boolean makeNullable) {
        FirResolvedTypeRef firResolvedTypeRef;
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = symbol2;
        if (abstractFirBasedSymbol instanceof FirCallableSymbol) {
            FirResolvedTypeRef returnTypeRef = $this$typeFromSymbol.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)((FirCallableSymbol)symbol2).getFir());
            if (makeNullable) {
                firResolvedTypeRef = FirClassSubstitutionScopeKt.withReplacedConeType(returnTypeRef, TypeUtilsKt.withNullability(returnTypeRef.getType(), ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext($this$typeFromSymbol.getSession())), FirFakeSourceElementKind.ImplicitTypeRef.INSTANCE);
            } else {
                boolean $i$f$buildResolvedTypeRef = false;
                boolean bl = false;
                FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
                boolean bl4 = false;
                FirSourceElement firSourceElement = returnTypeRef.getSource();
                $this$buildResolvedTypeRef.setSource(firSourceElement != null ? FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.ImplicitTypeRef.INSTANCE) : null);
                $this$buildResolvedTypeRef.setType(returnTypeRef.getType());
                Collection collection = $this$buildResolvedTypeRef.getAnnotations();
                Iterable iterable = returnTypeRef.getAnnotations();
                boolean bl5 = false;
                CollectionsKt.addAll(collection, iterable);
                firResolvedTypeRef = firResolvedTypeRefBuilder.build();
            }
        } else if (abstractFirBasedSymbol instanceof FirClassifierSymbol) {
            boolean $i$f$buildResolvedTypeRef = false;
            boolean bl = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
            boolean bl8 = false;
            $this$buildResolvedTypeRef.setSource(null);
            $this$buildResolvedTypeRef.setType(TreeResolveUtilsKt.constructType$default((FirClassifierSymbol)symbol2, new ConeTypeProjection[0], false, null, 4, null));
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        } else {
            String string2 = "WTF ! " + symbol2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firResolvedTypeRef;
    }

    @NotNull
    public static final FirQualifiedAccessExpression transformQualifiedAccessUsingSmartcastInfo(@NotNull BodyResolveComponents $this$transformQualifiedAccessUsingSmartcastInfo, @NotNull FirQualifiedAccessExpression qualifiedAccessExpression) {
        List<ConeKotlinType> typesFromSmartCast;
        Intrinsics.checkNotNullParameter($this$transformQualifiedAccessUsingSmartcastInfo, "$this$transformQualifiedAccessUsingSmartcastInfo");
        Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
        List<ConeKotlinType> list2 = $this$transformQualifiedAccessUsingSmartcastInfo.getDataFlowAnalyzer().getTypeUsingSmartcastInfo(qualifiedAccessExpression);
        if (list2 == null) {
            return qualifiedAccessExpression;
        }
        List<ConeKotlinType> list3 = typesFromSmartCast = list2;
        boolean bl = false;
        boolean bl2 = false;
        List<ConeKotlinType> it = list3;
        boolean bl3 = false;
        Collection collection = it;
        FirExpression $this$resultType$iv = qualifiedAccessExpression;
        boolean $i$f$getResultType = false;
        Object $this$coneType$iv = $this$resultType$iv.getTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        $this$coneType$iv = coneKotlinType;
        $i$f$getConeType = false;
        collection.add($this$coneType$iv);
        List<ConeKotlinType> allTypes = list3;
        ConeKotlinType intersectedType = ConeTypeIntersector.INSTANCE.intersectTypes(InferenceComponentsKt.getInferenceComponents($this$transformQualifiedAccessUsingSmartcastInfo.getSession()).getCtx(), allTypes);
        boolean $i$f$buildResolvedTypeRef = false;
        boolean bl4 = false;
        Object object = new FirResolvedTypeRefBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = object;
        boolean bl7 = false;
        FirExpression $this$resultType$iv2 = qualifiedAccessExpression;
        boolean $i$f$getResultType2 = false;
        FirSourceElement firSourceElement = $this$resultType$iv2.getTypeRef().getSource();
        $this$buildResolvedTypeRef.setSource(firSourceElement != null ? FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.SmartCastedTypeRef.INSTANCE) : null);
        $this$buildResolvedTypeRef.setType(intersectedType);
        Collection collection2 = $this$buildResolvedTypeRef.getAnnotations();
        FirExpression $this$resultType$iv3 = qualifiedAccessExpression;
        boolean $i$f$getResultType3 = false;
        Iterable iterable = $this$resultType$iv3.getTypeRef().getAnnotations();
        boolean bl8 = false;
        CollectionsKt.addAll(collection2, iterable);
        FirResolvedTypeRef intersectedTypeRef = ((FirResolvedTypeRefBuilder)object).build();
        boolean $i$f$buildExpressionWithSmartcast = false;
        object = new FirExpressionWithSmartcastBuilder();
        bl5 = false;
        bl6 = false;
        Object $this$buildExpressionWithSmartcast = object;
        boolean bl9 = false;
        ((FirExpressionWithSmartcastBuilder)$this$buildExpressionWithSmartcast).setOriginalExpression(qualifiedAccessExpression);
        ((FirExpressionWithSmartcastBuilder)$this$buildExpressionWithSmartcast).setTypeRef(intersectedTypeRef);
        ((FirExpressionWithSmartcastBuilder)$this$buildExpressionWithSmartcast).setTypesFromSmartCast((Collection<? extends ConeKotlinType>)typesFromSmartCast);
        return ((FirExpressionWithSmartcastBuilder)object).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInvoke(@NotNull CallableId $this$isInvoke) {
        Intrinsics.checkNotNullParameter($this$isInvoke, "$this$isInvoke");
        if (ResolveUtilsKt.isKFunctionInvoke($this$isInvoke)) return true;
        if (!Intrinsics.areEqual($this$isInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName2 = $this$isInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, "Function", false, 2, null)) return false;
        if (!Intrinsics.areEqual($this$isInvoke.getPackageName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKFunctionInvoke(@NotNull CallableId $this$isKFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isKFunctionInvoke, "$this$isKFunctionInvoke");
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName2 = $this$isKFunctionInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, "KFunction", false, 2, null)) return false;
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getPackageName().asString(), "kotlin.reflect")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorNext(@NotNull CallableId $this$isIteratorNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorNext, "$this$isIteratorNext");
        if (!Intrinsics.areEqual($this$isIteratorNext.getCallableName().asString(), "next")) return false;
        FqName fqName2 = $this$isIteratorNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        if (!Intrinsics.areEqual($this$isIteratorNext.getPackageName().asString(), "kotlin.collections")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorHasNext(@NotNull CallableId $this$isIteratorHasNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorHasNext, "$this$isIteratorHasNext");
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getCallableName().asString(), "hasNext")) return false;
        FqName fqName2 = $this$isIteratorHasNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getPackageName().asString(), "kotlin.collections")) return false;
        return true;
    }

    public static final boolean isIterator(@NotNull CallableId $this$isIterator) {
        Intrinsics.checkNotNullParameter($this$isIterator, "$this$isIterator");
        return Intrinsics.areEqual($this$isIterator.getCallableName().asString(), "iterator") && Intrinsics.areEqual($this$isIterator.getPackageName().asString(), "kotlin.collections");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName fqName(@NotNull FirAnnotationCall $this$fqName, @NotNull FirSession session2) {
        AbstractFirBasedSymbol abstractFirBasedSymbol;
        Object object;
        Intrinsics.checkNotNullParameter($this$fqName, "$this$fqName");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirSymbolProvider firSymbolProvider = MainSessionComponentsKt.getFirSymbolProvider(session2);
        FirTypeRef typeRef$iv = $this$fqName.getAnnotationTypeRef();
        boolean $i$f$getSymbolByTypeRef = false;
        FirTypeRef $this$coneTypeSafe$iv$iv = typeRef$iv;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType))) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
            abstractFirBasedSymbol = null;
        } else {
            void $this$getSymbolByTypeRef$iv;
            Object lookupTag$iv = object;
            FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag((FirSymbolProvider)$this$getSymbolByTypeRef$iv, (ConeClassifierLookupTag)lookupTag$iv);
            if (!(firClassifierSymbol instanceof FirRegularClassSymbol)) {
                firClassifierSymbol = null;
            }
            abstractFirBasedSymbol = (FirRegularClassSymbol)firClassifierSymbol;
        }
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)abstractFirBasedSymbol;
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol symbol2 = firRegularClassSymbol;
        return symbol2.getClassId().asSingleFqName();
    }

    public static final void propagateTypeFromOriginalReceiver(@NotNull FirCheckedSafeCallSubject $this$propagateTypeFromOriginalReceiver, @NotNull FirExpression nullableReceiverExpression, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$propagateTypeFromOriginalReceiver, "$this$propagateTypeFromOriginalReceiver");
        Intrinsics.checkNotNullParameter(nullableReceiverExpression, "nullableReceiverExpression");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirTypeRef $this$coneTypeSafe$iv = nullableReceiverExpression.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType receiverType = coneKotlinType;
        ConeKotlinType expandedReceiverType = receiverType instanceof ConeClassLikeType ? (ConeKotlinType)TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)receiverType, session2, null, 2, null) : receiverType;
        $this$propagateTypeFromOriginalReceiver.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype($this$propagateTypeFromOriginalReceiver.getTypeRef(), TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull(expandedReceiverType)));
    }

    /*
     * Unable to fully structure code
     */
    public static final void propagateTypeFromQualifiedAccessAfterNullCheck(@NotNull FirSafeCallExpression $this$propagateTypeFromQualifiedAccessAfterNullCheck, @NotNull FirExpression nullableReceiverExpression, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$propagateTypeFromQualifiedAccessAfterNullCheck, "$this$propagateTypeFromQualifiedAccessAfterNullCheck");
        Intrinsics.checkNotNullParameter(nullableReceiverExpression, "nullableReceiverExpression");
        Intrinsics.checkNotNullParameter(session, "session");
        $this$coneTypeSafe$iv = nullableReceiverExpression.getTypeRef();
        $i$f$coneTypeSafe = false;
        var6_5 = false;
        v0 = $this$coneTypeSafe$iv;
        if (!(v0 instanceof FirResolvedTypeRef)) {
            v0 = null;
        }
        v1 = (FirResolvedTypeRef)v0;
        v2 = v1 != null ? v1.getType() : null;
        if (!(v2 instanceof ConeKotlinType)) {
            v2 = null;
        }
        receiverType = v2;
        v3 = ResolveUtilsKt.expressionTypeOrUnitForAssignment($this$propagateTypeFromQualifiedAccessAfterNullCheck.getRegularQualifiedAccess());
        if (v3 == null) {
            return;
        }
        typeAfterNullCheck = v3;
        if (receiverType == null) ** GOTO lbl-1000
        var6_6 = SessionUtilsKt.getTypeContext(session);
        var7_9 = false;
        var8_10 = false;
        $this$run = var6_6;
        $i$a$-run-ResolveUtilsKt$propagateTypeFromQualifiedAccessAfterNullCheck$isReceiverActuallyNullable$1 = false;
        if ($this$run.isNullableType(receiverType)) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        isReceiverActuallyNullable = v4;
        resultingType = isReceiverActuallyNullable != false ? TypeUtilsKt.withNullability(typeAfterNullCheck, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(session)) : typeAfterNullCheck;
        $this$propagateTypeFromQualifiedAccessAfterNullCheck.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype($this$propagateTypeFromQualifiedAccessAfterNullCheck.getTypeRef(), resultingType));
    }

    private static final ConeKotlinType expressionTypeOrUnitForAssignment(FirQualifiedAccess $this$expressionTypeOrUnitForAssignment) {
        if ($this$expressionTypeOrUnitForAssignment instanceof FirExpression) {
            FirTypeRef $this$coneTypeSafe$iv = ((FirExpression)((Object)$this$expressionTypeOrUnitForAssignment)).getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            return coneKotlinType;
        }
        boolean bl = $this$expressionTypeOrUnitForAssignment instanceof FirVariableAssignment;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "The only non-expression FirQualifiedAccess is FirVariableAssignment, but " + Reflection.getOrCreateKotlinClass($this$expressionTypeOrUnitForAssignment.getClass()) + " was found";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return TypeConstructionUtilsKt.constructClassLikeType(StandardClassIds.INSTANCE.getUnit(), new ConeTypeProjection[0], false);
    }

    @Nullable
    public static final FirRegularClassSymbol getCorrespondingClassSymbolOrNull(@NotNull FirAnnotationCall $this$getCorrespondingClassSymbolOrNull, @NotNull FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter($this$getCorrespondingClassSymbolOrNull, "$this$getCorrespondingClassSymbolOrNull");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirTypeRef $this$coneType$iv = $this$getCorrespondingClassSymbolOrNull.getAnnotationTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ClassId classId = ConeTypeUtilsKt.getClassId(TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType, session2));
        if (classId != null) {
            ClassId classId2 = classId;
            boolean bl = false;
            boolean bl2 = false;
            ClassId it = classId2;
            boolean bl3 = false;
            if (it.isLocal()) {
                firRegularClassSymbol = null;
            } else {
                FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(session2).getClassLikeSymbolByFqName(it);
                if (!(firClassLikeSymbol instanceof FirRegularClassSymbol)) {
                    firClassLikeSymbol = null;
                }
                firRegularClassSymbol = (FirRegularClassSymbol)firClassLikeSymbol;
            }
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }
}

