/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Field;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.CollectionComponentParameter;

public final class ComponentParameter
implements Parameter {
    public static final ComponentParameter DEFAULT = new ComponentParameter();
    public static final ComponentParameter ARRAY = new ComponentParameter(false);
    private final Parameter collectionParameter;
    private final Object componentKey;

    public ComponentParameter() {
        this(false);
    }

    public ComponentParameter(boolean emptyCollection) {
        this(null, emptyCollection ? CollectionComponentParameter.ARRAY_ALLOW_EMPTY : CollectionComponentParameter.ARRAY);
    }

    private ComponentParameter(Object componentKey, Parameter collectionParameter) {
        this.componentKey = componentKey;
        this.collectionParameter = collectionParameter;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        Object result2 = null;
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType2);
        if (componentAdapter != null) {
            result2 = container.getComponentInstance(componentAdapter.getComponentKey());
        }
        if (result2 == null && this.collectionParameter != null) {
            result2 = this.collectionParameter.resolveInstance(container, adapter, expectedType2);
        }
        return result2;
    }

    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        if (this.resolveAdapter(container, adapter, expectedType2) == null) {
            if (this.collectionParameter != null) {
                return this.collectionParameter.isResolvable(container, adapter, expectedType2);
            }
            return false;
        }
        return true;
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType2) {
        ComponentAdapter result2 = this.getTargetAdapter(container, expectedType2, adapter);
        if (result2 == null) {
            return null;
        }
        if (!expectedType2.isAssignableFrom(result2.getComponentImplementation())) {
            if (expectedType2.isPrimitive()) {
                try {
                    Field field = result2.getComponentImplementation().getField("TYPE");
                    Class type2 = (Class)field.get(result2.getComponentInstance(null));
                    if (expectedType2.isAssignableFrom(type2)) {
                        return result2;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return result2;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType2, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapterOfType(expectedType2);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container.getComponentAdapter(expectedType2);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List<ComponentAdapter> found2 = container.getComponentAdaptersOfType(expectedType2);
        ComponentAdapter exclude = null;
        for (ComponentAdapter o : found2) {
            ComponentAdapter work = o;
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found2.remove(exclude);
        if (found2.size() == 0) {
            if (container.getParent() != null) {
                return container.getParent().getComponentAdapterOfType(expectedType2);
            }
            return null;
        }
        if (found2.size() == 1) {
            return found2.get(0);
        }
        Object[] foundClasses = new Class[found2.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found2.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType2, foundClasses);
    }
}

