/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t\u001a\u001b\u0010\u0010\u001a\u00020\t*\u00020\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\n\u0010\u0011\u001a\u00020\t*\u00020\u0012\u001a\u001a\u0010\u0013\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00f2\u0001\u0004\n\u00020\u0004\u00a8\u0006\u0019"}, d2={"containingPackage", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findContinuationClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "lookupLocation", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "releaseCoroutines", "", "findContinuationClassDescriptorOrNull", "getContinuationOfTypeOrAny", "Lorg/jetbrains/kotlin/types/SimpleType;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReleaseCoroutines", "isSealed", "isSupportedForCallableReference", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isTopLevelInPackage", "name", "", "packageName", "resolveClassByFqName", "fqName", "descriptors"})
public final class DescriptorUtilKt {
    @Nullable
    public static final ClassDescriptor resolveClassByFqName(@NotNull ModuleDescriptor $this$resolveClassByFqName, @NotNull FqName fqName2, @NotNull LookupLocation lookupLocation2) {
        ClassifierDescriptor classifierDescriptor;
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter($this$resolveClassByFqName, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(lookupLocation2, "lookupLocation");
        if (fqName2.isRoot()) {
            return null;
        }
        Object object = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(object, "fqName.parent()");
        MemberScope memberScope2 = $this$resolveClassByFqName.getPackage((FqName)object).getMemberScope();
        object = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue(object, "fqName.shortName()");
        ClassifierDescriptor classifierDescriptor2 = memberScope2.getContributedClassifier((Name)object, lookupLocation2);
        ClassDescriptor classDescriptor3 = classDescriptor2 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
        if (classDescriptor2 != null) {
            classifierDescriptor2 = classDescriptor2;
            boolean bl = false;
            boolean bl2 = false;
            ClassifierDescriptor it = classifierDescriptor2;
            boolean bl3 = false;
            return it;
        }
        object = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(object, "fqName.parent()");
        classifierDescriptor2 = DescriptorUtilKt.resolveClassByFqName($this$resolveClassByFqName, (FqName)object, lookupLocation2);
        if (classifierDescriptor2 == null) {
            classifierDescriptor = null;
        } else {
            object = classifierDescriptor2.getUnsubstitutedInnerClassesScope();
            if (object == null) {
                classifierDescriptor = null;
            } else {
                Name name = fqName2.shortName();
                Intrinsics.checkNotNullExpressionValue(name, "fqName.shortName()");
                classifierDescriptor = object.getContributedClassifier(name, lookupLocation2);
            }
        }
        classDescriptor2 = classifierDescriptor;
        return classDescriptor2 instanceof ClassDescriptor ? classDescriptor2 : null;
    }

    @Nullable
    public static final ClassDescriptor findContinuationClassDescriptorOrNull(@NotNull ModuleDescriptor $this$findContinuationClassDescriptorOrNull, @NotNull LookupLocation lookupLocation2, boolean releaseCoroutines) {
        Intrinsics.checkNotNullParameter($this$findContinuationClassDescriptorOrNull, "<this>");
        Intrinsics.checkNotNullParameter(lookupLocation2, "lookupLocation");
        return releaseCoroutines ? DescriptorUtilKt.resolveClassByFqName($this$findContinuationClassDescriptorOrNull, StandardNames.CONTINUATION_INTERFACE_FQ_NAME_RELEASE, lookupLocation2) : DescriptorUtilKt.resolveClassByFqName($this$findContinuationClassDescriptorOrNull, StandardNames.CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL, lookupLocation2);
    }

    @NotNull
    public static final ClassDescriptor findContinuationClassDescriptor(@NotNull ModuleDescriptor $this$findContinuationClassDescriptor, @NotNull LookupLocation lookupLocation2, boolean releaseCoroutines) {
        Intrinsics.checkNotNullParameter($this$findContinuationClassDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(lookupLocation2, "lookupLocation");
        ClassDescriptor $this$sure$iv = DescriptorUtilKt.findContinuationClassDescriptorOrNull($this$findContinuationClassDescriptor, lookupLocation2, releaseCoroutines);
        boolean $i$f$sure = false;
        ClassDescriptor classDescriptor2 = $this$sure$iv;
        if (classDescriptor2 == null) {
            String string2;
            boolean bl = false;
            String string3 = string2 = "Continuation interface is not found";
            throw new AssertionError((Object)string3);
        }
        return classDescriptor2;
    }

    @NotNull
    public static final SimpleType getContinuationOfTypeOrAny(@NotNull ModuleDescriptor $this$getContinuationOfTypeOrAny, @NotNull KotlinType kotlinType, boolean isReleaseCoroutines) {
        Annotated annotated;
        Annotated annotated2;
        Intrinsics.checkNotNullParameter($this$getContinuationOfTypeOrAny, "<this>");
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        Annotated annotated3 = DescriptorUtilKt.findContinuationClassDescriptorOrNull(DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny), NoLookupLocation.FROM_DESERIALIZATION, isReleaseCoroutines);
        if (annotated3 == null) {
            annotated2 = null;
        } else {
            SimpleType simpleType2 = annotated3.getDefaultType();
            if (simpleType2 == null) {
                annotated2 = null;
            } else {
                SimpleType simpleType3 = simpleType2;
                boolean bl = false;
                boolean bl2 = false;
                SimpleType it = simpleType3;
                boolean bl3 = false;
                annotated2 = KotlinTypeFactory.simpleType$default(it, null, null, CollectionsKt.listOf(TypeUtilsKt.asTypeProjection(kotlinType)), false, 22, null);
            }
        }
        Annotated annotated4 = annotated2;
        if (annotated4 == null) {
            annotated3 = DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny).getBuiltIns().getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue(annotated3, "module.builtIns.nullableAnyType");
            annotated = annotated3;
        } else {
            annotated = annotated4;
        }
        return annotated;
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage, @NotNull String name, @NotNull String packageName) {
        PackageFragmentDescriptor packageFragmentDescriptor;
        Intrinsics.checkNotNullParameter($this$isTopLevelInPackage, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        if (!Intrinsics.areEqual(name, $this$isTopLevelInPackage.getName().asString())) {
            return false;
        }
        Object object = $this$isTopLevelInPackage.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor = object instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)object : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingDeclaration = packageFragmentDescriptor;
        object = containingDeclaration.getFqName().asString();
        Intrinsics.checkNotNullExpressionValue(object, "containingDeclaration.fqName.asString()");
        Object packageFqName = object;
        return Intrinsics.areEqual(packageName, packageFqName);
    }

    public static final boolean isSupportedForCallableReference(@NotNull CallableDescriptor $this$isSupportedForCallableReference) {
        Intrinsics.checkNotNullParameter($this$isSupportedForCallableReference, "<this>");
        return $this$isSupportedForCallableReference instanceof PropertyDescriptor || $this$isSupportedForCallableReference instanceof FunctionDescriptor;
    }

    public static final boolean isSealed(@NotNull DeclarationDescriptor $this$isSealed) {
        Intrinsics.checkNotNullParameter($this$isSealed, "<this>");
        boolean bl = false;
        return DescriptorUtils.isSealedClass($this$isSealed);
    }

    @Nullable
    public static final FqName containingPackage(@NotNull DeclarationDescriptor $this$containingPackage) {
        DeclarationDescriptor container2;
        Intrinsics.checkNotNullParameter($this$containingPackage, "<this>");
        for (container2 = $this$containingPackage.getContainingDeclaration(); container2 != null && !(container2 instanceof PackageFragmentDescriptor); container2 = container2.getContainingDeclaration()) {
        }
        DeclarationDescriptor declarationDescriptor = container2;
        boolean bl = declarationDescriptor == null ? true : declarationDescriptor instanceof PackageFragmentDescriptor;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        DeclarationDescriptor declarationDescriptor2 = container2;
        return declarationDescriptor2 == null ? null : ((PackageFragmentDescriptor)declarationDescriptor2).getFqName();
    }
}

