/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractPhaseTransformer;", "D", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "transformerPhase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getTransformerPhase", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "checkSessionConsistency", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformDeclaration", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "data", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "resolve"})
public abstract class FirAbstractPhaseTransformer<D>
extends FirDefaultTransformer<D> {
    @NotNull
    private final FirResolvePhase transformerPhase;

    public FirAbstractPhaseTransformer(@NotNull FirResolvePhase transformerPhase) {
        Intrinsics.checkNotNullParameter((Object)transformerPhase, "transformerPhase");
        this.transformerPhase = transformerPhase;
        boolean bl = this.transformerPhase != FirResolvePhase.RAW_FIR;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Raw FIR building shouldn't be done in phase transformer";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    @NotNull
    public final FirResolvePhase getTransformerPhase() {
        return this.transformerPhase;
    }

    @NotNull
    public abstract FirSession getSession();

    @Override
    @NotNull
    public CompositeTransformResult<FirFile> transformFile(@NotNull FirFile file2, D data) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.checkSessionConsistency(file2);
        file2.replaceResolvePhase(this.transformerPhase);
        return super.transformFile(file2, data);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformDeclaration(@NotNull FirDeclaration declaration2, D data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        declaration2.replaceResolvePhase(this.transformerPhase);
        return super.transformDeclaration(declaration2, data);
    }

    protected final void checkSessionConsistency(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean bl = this.getSession() == file2.getSession();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "File " + file2.getName() + " and transformer " + Reflection.getOrCreateKotlinClass(this.getClass()) + " have inconsistent sessions";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }
}

