/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\u0000J\u001a\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0004J\u0014\u0010,\u001a\u0004\u0018\u00010\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0002J\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\t\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;)V", "getFields", "()Ljava/util/List;", "interfaces", "getInterfaces", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerClass", "getOuterClass", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "setOuterClass", "(Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;)V", "subClass", "getSubClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "setSubClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;)V", "superClass", "getSuperClass", "setSuperClass", "typeArguments", "getTypeArguments", "contains", "", "variable", "getIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getIrFunctionByIrCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getOriginal", "getOverridden", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "owner", "qualifier", "getThisOrSuperReceiver", "superIrClass", "irClassFqName", "", "setSuperClassInstance", "", "ir.interpreter"})
public abstract class Complex
implements State {
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final List<Variable> fields;
    @Nullable
    private Complex superClass;
    @Nullable
    private Complex subClass;
    @NotNull
    private final List<Complex> interfaces;
    @NotNull
    private final List<Variable> typeArguments;
    @Nullable
    private Variable outerClass;

    public Complex(@NotNull IrClass irClass2, @NotNull List<Variable> fields2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(fields2, "fields");
        this.irClass = irClass2;
        this.fields = fields2;
        boolean bl = false;
        this.interfaces = new ArrayList();
        bl = false;
        this.typeArguments = new ArrayList();
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    @Nullable
    public final Complex getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(@Nullable Complex complex) {
        this.superClass = complex;
    }

    @Nullable
    public final Complex getSubClass() {
        return this.subClass;
    }

    public final void setSubClass(@Nullable Complex complex) {
        this.subClass = complex;
    }

    @NotNull
    public final List<Complex> getInterfaces() {
        return this.interfaces;
    }

    @Override
    @NotNull
    public List<Variable> getTypeArguments() {
        return this.typeArguments;
    }

    @Nullable
    public final Variable getOuterClass() {
        return this.outerClass;
    }

    public final void setOuterClass(@Nullable Variable variable2) {
        this.outerClass = variable2;
    }

    public final void setSuperClassInstance(@NotNull Complex superClass2) {
        Intrinsics.checkNotNullParameter(superClass2, "superClass");
        if (Intrinsics.areEqual(this.getIrClass(), superClass2.getIrClass())) {
            Iterable $this$forEach$iv = superClass2.getFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Variable it = (Variable)element$iv;
                boolean bl = false;
                if (this.contains(it)) continue;
                this.getFields().add(it);
            }
            this.superClass = superClass2.superClass;
            Complex complex = superClass2.superClass;
            if (complex != null) {
                complex.subClass = this;
            }
        } else {
            this.superClass = superClass2;
            superClass2.subClass = this;
        }
    }

    @NotNull
    public final Complex getOriginal() {
        Complex complex = this.subClass;
        return complex == null ? this : complex.getOriginal();
    }

    @NotNull
    public final String irClassFqName() {
        String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(this.getIrClass()).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "irClass.fqNameForIrSerialization.toString()");
        return string2;
    }

    private final boolean contains(Variable variable2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getFields();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Variable it = (Variable)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getSymbol(), variable2.getSymbol())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction getIrFunction(IrFunctionSymbol symbol2) {
        Object v0;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv2;
            Iterable $this$filterIsInstance$iv = this.getIrClass().getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Iterable<IrSimpleFunction> destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction irSimpleFunction;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrProperty it = (IrProperty)element$iv$iv;
                boolean bl2 = false;
                if (it.getGetter() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                IrSimpleFunction it$iv$iv = irSimpleFunction;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List propertyGetters = (List)destination$iv$iv;
            Iterable $this$filterIsInstance$iv2 = this.getIrClass().getDeclarations();
            boolean $i$f$filterIsInstance2 = false;
            destination$iv$iv = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrFunction)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List functions2 = (List)destination$iv$iv2;
            Iterable $this$firstOrNull$iv = CollectionsKt.plus((Collection)propertyGetters, (Iterable)functions2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrFunction it = (IrFunction)element$iv;
                boolean bl = false;
                if (!(it instanceof IrSimpleFunction ? AdditionalIrUtilsKt.overrides((IrSimpleFunction)it, (IrSimpleFunction)symbol2.getOwner()) : Intrinsics.areEqual(it, symbol2.getOwner()))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        return v0;
    }

    private final Complex getThisOrSuperReceiver(IrClass superIrClass) {
        Complex complex;
        if (superIrClass == null) {
            complex = this.getOriginal();
        } else if (IrUtilsKt.isInterface(superIrClass)) {
            Common common = new Common(superIrClass);
            boolean bl = false;
            boolean bl2 = false;
            Common $this$getThisOrSuperReceiver_u24lambda_u2d4 = common;
            boolean bl3 = false;
            $this$getThisOrSuperReceiver_u24lambda_u2d4.getInterfaces().add($this$getThisOrSuperReceiver_u24lambda_u2d4);
            $this$getThisOrSuperReceiver_u24lambda_u2d4.setSubClass(this);
            complex = common;
        } else {
            complex = this.superClass;
        }
        return complex;
    }

    @NotNull
    protected final IrSimpleFunction getOverridden(@NotNull IrSimpleFunction owner, @Nullable State qualifier) {
        IrSimpleFunction irSimpleFunction;
        Complex complex;
        Intrinsics.checkNotNullParameter(owner, "owner");
        if (!owner.isFakeOverride()) {
            return owner;
        }
        if (qualifier == null || qualifier instanceof ExceptionState || ((complex = qualifier instanceof Complex ? (Complex)qualifier : null) == null ? null : complex.superClass) == null) {
            return (IrSimpleFunction)UtilsKt.getLastOverridden(owner);
        }
        IrSimpleFunction overriddenOwner = (IrSimpleFunction)((IrSimpleFunctionSymbol)CollectionsKt.single(owner.getOverriddenSymbols())).getOwner();
        if (overriddenOwner.getBody() != null) {
            irSimpleFunction = overriddenOwner;
        } else {
            Complex complex2 = ((Complex)qualifier).superClass;
            Intrinsics.checkNotNull(complex2);
            irSimpleFunction = this.getOverridden(overriddenOwner, complex2);
        }
        return irSimpleFunction;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Object object = expression2.getSuperQualifierSymbol();
        Complex complex = this.getThisOrSuperReceiver(object == null ? null : (IrClass)object.getOwner());
        if (complex == null) {
            return null;
        }
        Complex receiver = complex;
        object = receiver.getIrFunction(expression2.getSymbol());
        if (object == null) {
            return null;
        }
        Object irFunction2 = object;
        return (object = ((IrFunction)irFunction2).getBody()) == null ? (IrFunction)this.getOverridden((IrSimpleFunction)irFunction2, UtilsKt.getCorrectReceiverByFunction(this, (IrFunction)irFunction2)) : irFunction2;
    }

    @Override
    public void addTypeArguments(@NotNull List<Variable> typeArguments2) {
        State.DefaultImpls.addTypeArguments(this, typeArguments2);
    }

    @Override
    @Nullable
    public State getState(@NotNull IrSymbol symbol2) {
        return State.DefaultImpls.getState(this, symbol2);
    }

    @Override
    public void setField(@NotNull Variable newVar) {
        State.DefaultImpls.setField(this, newVar);
    }
}

