/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorCallExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionException;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J+\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0082\bJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/ErrorExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "ignoreErrors", "", "getIgnoreErrors", "()Z", "generateErrorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "generateErrorExpression", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "e", "", "body", "Lkotlin/Function0;", "generateErrorSimpleName", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getErrorExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "ir.psi2ir"})
public final class ErrorExpressionGenerator
extends StatementGeneratorExtension {
    public ErrorExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }

    private final boolean getIgnoreErrors() {
        return this.getContext().getConfiguration().getIgnoreErrors();
    }

    @NotNull
    public final IrExpression generateErrorExpression(@NotNull KtElement ktElement, @NotNull Throwable e) {
        Object object;
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(ktElement, "ktElement");
        Intrinsics.checkNotNullParameter(e, "e");
        ErrorExpressionGenerator this_$iv = this;
        boolean $i$f$generateErrorExpression = false;
        if (this_$iv.getIgnoreErrors()) {
            boolean bl = false;
            if (ktElement instanceof KtExpression) {
                kotlinType = this.getErrorExpressionType((KtExpression)ktElement);
            } else {
                object = ErrorUtils.createErrorType("");
                Intrinsics.checkNotNullExpressionValue(object, "createErrorType(\"\")");
                kotlinType = (KotlinType)object;
            }
        } else {
            throw new ErrorExpressionException(ktElement, e);
        }
        KotlinType errorExpressionType = kotlinType;
        int n = PsiUtilsKt.getStartOffsetSkippingComments(ktElement);
        int n2 = PsiUtilsKt.getEndOffset(ktElement);
        IrType irType = this.toIrType(errorExpressionType);
        String string2 = e.getMessage();
        object = string2 == null ? ktElement.getText() : string2;
        Intrinsics.checkNotNullExpressionValue(object, "e.message ?: ktElement.text");
        return new IrErrorExpressionImpl(n, n2, irType, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateErrorCall(@NotNull KtCallExpression ktCall) {
        IrErrorCallExpressionImpl irErrorCall;
        Intrinsics.checkNotNullParameter(ktCall, "ktCall");
        Throwable e$iv = null;
        boolean $i$f$generateErrorExpression = false;
        if (this.getIgnoreErrors()) {
            IrExpression irExpression;
            boolean bl = false;
            IrType type2 = this.toIrType(this.getErrorExpressionType(ktCall));
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktCall);
            int n2 = PsiUtilsKt.getEndOffset(ktCall);
            List<KtValueArgument> list2 = ktCall.getText();
            Intrinsics.checkNotNullExpressionValue(list2, "ktCall.text");
            IrErrorCallExpressionImpl irErrorCallExpressionImpl = irErrorCall = new IrErrorCallExpressionImpl(n, n2, type2, (String)((Object)list2));
            Object object = ktCall.getParent();
            List<KtValueArgument> list3 = list2 = object instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)object : null;
            if (list2 == null) {
                irExpression = null;
            } else {
                void $this$generateErrorCall_u24lambda_u2d3_u24lambda_u2d1;
                object = list2;
                boolean bl2 = false;
                boolean bl3 = false;
                Object object2 = object;
                IrErrorCallExpressionImpl irErrorCallExpressionImpl2 = irErrorCallExpressionImpl;
                boolean bl4 = false;
                IrExpression irExpression2 = this.genExpr($this$generateErrorCall_u24lambda_u2d3_u24lambda_u2d1.getReceiverExpression());
                irErrorCallExpressionImpl = irErrorCallExpressionImpl2;
                irExpression = irExpression2;
            }
            irErrorCallExpressionImpl.setExplicitReceiver(irExpression);
            list2 = ktCall.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "ktCall.valueArguments");
            Collection collection = list2;
            list2 = ktCall.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "ktCall.lambdaArguments");
            Iterable $this$forEach$iv = CollectionsKt.plus(collection, (Iterable)list2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtValueArgument it = (KtValueArgument)element$iv;
                boolean bl5 = false;
                KtExpression ktArgument = it.getArgumentExpression();
                if (ktArgument == null) continue;
                irErrorCall.addArgument(this.genExpr(ktArgument));
            }
        } else {
            throw new ErrorExpressionException(ktCall, e$iv);
        }
        return irErrorCall;
    }

    private final KotlinType getErrorExpressionType(KtExpression ktExpression) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = GeneratorKt.getTypeInferredByFrontend(this, ktExpression);
        if (kotlinType2 == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("");
            Intrinsics.checkNotNullExpressionValue(simpleType2, "createErrorType(\"\")");
            kotlinType = simpleType2;
        } else {
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateErrorSimpleName(@NotNull KtSimpleNameExpression ktName) {
        IrExpression irExpression;
        IrErrorCallExpressionImpl irErrorCallExpressionImpl;
        IrErrorCallExpressionImpl irErrorCall;
        Intrinsics.checkNotNullParameter(ktName, "ktName");
        Throwable e$iv = null;
        boolean $i$f$generateErrorExpression = false;
        if (this.getIgnoreErrors()) {
            boolean bl = false;
            IrType type2 = this.toIrType(this.getErrorExpressionType(ktName));
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktName);
            int n2 = PsiUtilsKt.getEndOffset(ktName);
            Object object = ktName.getText();
            Intrinsics.checkNotNullExpressionValue(object, "ktName.text");
            irErrorCallExpressionImpl = irErrorCall = new IrErrorCallExpressionImpl(n, n2, type2, (String)object);
            Object object2 = ktName.getParent();
            Object object3 = object = object2 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)object2 : null;
            if (object == null) {
                irExpression = null;
            } else {
                void ktParent;
                object2 = object;
                boolean bl2 = false;
                boolean bl3 = false;
                Object object4 = object2;
                IrErrorCallExpressionImpl irErrorCallExpressionImpl2 = irErrorCallExpressionImpl;
                boolean bl4 = false;
                IrExpression irExpression2 = Intrinsics.areEqual(ktParent.getReceiverExpression(), ktName) ? null : this.genExpr(ktParent.getReceiverExpression());
                irErrorCallExpressionImpl = irErrorCallExpressionImpl2;
                irExpression = irExpression2;
            }
        } else {
            throw new ErrorExpressionException(ktName, e$iv);
        }
        irErrorCallExpressionImpl.setExplicitReceiver(irExpression);
        return irErrorCall;
    }
}

