/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.DescriptorBasedUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0013"}, d2={"allReservedWords", "", "", "reservedWords", "strictModeReservedWords", "getStrictModeReservedWords", "()Ljava/util/Set;", "isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "getExportCandidate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldDeclarationBeExported", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isExported", "backend.js"})
public final class ExportModelGeneratorKt {
    @NotNull
    private static final Set<String> reservedWords;
    @NotNull
    private static final Set<String> strictModeReservedWords;
    @NotNull
    private static final Set<String> allReservedWords;

    private static final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass2 = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return Intrinsics.areEqual(irClass2 == null ? null : Boolean.valueOf(IrUtilsKt.isInterface(irClass2)), true);
    }

    private static final IrDeclarationWithName getExportCandidate(IrDeclaration declaration2) {
        if (!(declaration2 instanceof IrDeclarationWithVisibility) || !(declaration2 instanceof IrDeclarationWithName) || !Intrinsics.areEqual(((IrDeclarationWithVisibility)declaration2).getVisibility(), DescriptorVisibilities.PUBLIC) || DescriptorBasedUtilsKt.isExpect(declaration2)) {
            return null;
        }
        if (declaration2 instanceof IrSimpleFunction) {
            IrProperty property2;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration2).getCorrespondingPropertySymbol();
            IrProperty irProperty2 = property2 = irPropertySymbol == null ? null : (IrProperty)irPropertySymbol.getOwner();
            if (property2 != null) {
                return Intrinsics.areEqual(property2.getGetter(), declaration2) ? (IrDeclarationWithName)property2 : null;
            }
        }
        return (IrDeclarationWithName)declaration2;
    }

    private static final boolean shouldDeclarationBeExported(IrDeclarationWithName declaration2, JsIrBackendContext context2) {
        if (CollectionsKt.contains((Iterable)context2.getAdditionalExportedDeclarationNames(), IrUtilsKt.getFqNameWhenAvailable(declaration2))) {
            return true;
        }
        if (context2.getAdditionalExportedDeclarations().contains(declaration2)) {
            return true;
        }
        if (AnnotationUtilsKt.isJsExport(declaration2)) {
            return true;
        }
        IrDeclarationParent parent2 = declaration2.getParent();
        return parent2 instanceof IrDeclarationWithName ? ExportModelGeneratorKt.shouldDeclarationBeExported((IrDeclarationWithName)((Object)parent2), context2) : (parent2 instanceof IrAnnotationContainer ? AnnotationUtilsKt.isJsExport((IrAnnotationContainer)((Object)parent2)) : false);
    }

    public static final boolean isExported(@NotNull IrDeclaration $this$isExported, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isExported, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate($this$isExported);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        return ExportModelGeneratorKt.shouldDeclarationBeExported(candidate2, context2);
    }

    @NotNull
    public static final Set<String> getStrictModeReservedWords() {
        return strictModeReservedWords;
    }

    public static final /* synthetic */ IrDeclarationWithName access$getExportCandidate(IrDeclaration declaration2) {
        return ExportModelGeneratorKt.getExportCandidate(declaration2);
    }

    public static final /* synthetic */ boolean access$shouldDeclarationBeExported(IrDeclarationWithName declaration2, JsIrBackendContext context2) {
        return ExportModelGeneratorKt.shouldDeclarationBeExported(declaration2, context2);
    }

    public static final /* synthetic */ Set access$getAllReservedWords$p$s-1108500313() {
        return allReservedWords;
    }

    public static final /* synthetic */ boolean access$isInterface(IrClassifierSymbol $receiver) {
        return ExportModelGeneratorKt.isInterface($receiver);
    }

    static {
        String[] stringArray = new String[]{"break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "null", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with"};
        reservedWords = SetsKt.setOf(stringArray);
        stringArray = new String[]{"as", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"};
        strictModeReservedWords = SetsKt.setOf(stringArray);
        allReservedWords = SetsKt.plus(reservedWords, (Iterable)strictModeReservedWords);
    }
}

