/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0005\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "js.translator"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    public LiteralFunctionTranslator(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
    }

    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration2) {
        Object it;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        PsiElement finalElement = UtilsKt.getFinalElement(declaration2);
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue(translationContext, "context()");
        TranslationContext invokingContext = translationContext;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration2);
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getFunctionDescriptor(invokingContext.bindingContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        JsFunction jsFunction = invokingContext.getFunctionObject(descriptor2);
        Intrinsics.checkNotNullExpressionValue(jsFunction, "invokingContext.getFunctionObject(descriptor)");
        JsFunction lambda = jsFunction;
        List<ValueParameterDescriptor> list2 = invokingContext.newFunctionBodyWithUsageTracker(lambda, descriptor2);
        Intrinsics.checkNotNullExpressionValue(list2, "invokingContext\n                .newFunctionBodyWithUsageTracker(lambda, descriptor)");
        TranslationContext translationContext2 = list2;
        list2 = lambda.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "lambda.parameters");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext2, descriptor2, (List<JsParameter>)list2);
        list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "descriptor.valueParameters");
        Object $this$forEach$iv = list2;
        boolean $i$f$forEach22 = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv2 = object.next();
            it = (ValueParameterDescriptor)element$iv2;
            boolean bl = false;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            lambda.getBody().getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        $this$forEach$iv = lambda.getBody();
        Object $i$f$forEach22 = ((JsBlock)$this$forEach$iv).getStatements();
        Intrinsics.checkNotNullExpressionValue($i$f$forEach22, "lambda.body.statements");
        $i$f$forEach22 = (Collection)$i$f$forEach22;
        object = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, functionContext);
        Intrinsics.checkNotNullExpressionValue(object, "setDefaultValueForArguments(descriptor, functionContext)");
        object = (Iterable)object;
        boolean element$iv2 = false;
        CollectionsKt.addAll($i$f$forEach22, object);
        $this$forEach$iv = lambda.getBody();
        $i$f$forEach22 = ((JsBlock)$this$forEach$iv).getStatements();
        Intrinsics.checkNotNullExpressionValue($i$f$forEach22, "lambda.body.statements");
        $i$f$forEach22 = (Collection)$i$f$forEach22;
        object = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration2, functionContext);
        element$iv2 = false;
        $i$f$forEach22.add((JsStatement)object);
        MetadataProperties.setFunctionDescriptor(lambda, descriptor2);
        lambda.setSource(declaration2);
        lambda.getBody().setSource(finalElement instanceof LeafPsiElement ? (LeafPsiElement)finalElement : null);
        object = functionContext.usageTracker();
        Intrinsics.checkNotNull(object);
        Object tracker = $i$f$forEach22 = object;
        object = invokingContext.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue(object, "invokingContext.getInnerNameForDescriptor(descriptor)");
        Object name = object;
        if (UsageTrackerKt.hasCapturedExceptContaining((UsageTracker)tracker)) {
            JsFunction element$iv2 = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda.source(declaration2));
            Intrinsics.checkNotNullExpressionValue(element$iv2, "simpleReturnFunction(invokingContext.scope(), lambda.source(declaration))");
            JsFunction lambdaCreator = element$iv2;
            MetadataProperties.setLocal(lambdaCreator, true);
            if (((UsageTracker)tracker).getCapturedDescriptors().contains(descriptor2) && !DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
                lambda.setName(UsageTrackerKt.getNameForCapturedDescriptor((UsageTracker)tracker, descriptor2));
            }
            MetadataProperties.setStaticRef((JsName)name, lambdaCreator);
            this.fillCoroutineMetadata(lambdaCreator, invokingContext, descriptor2);
            lambdaCreator.setSource(declaration2);
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, functionContext, (JsName)name, invokingContext, declaration2);
        }
        if (((UsageTracker)tracker).getCapturedDescriptors().contains(descriptor2)) {
            JsName element$iv2 = UsageTrackerKt.getNameForCapturedDescriptor((UsageTracker)tracker, descriptor2);
            Intrinsics.checkNotNull(element$iv2);
            JsName capturedName = element$iv2;
            it = invokingContext.getInnerNameForDescriptor(descriptor2);
            Intrinsics.checkNotNullExpressionValue(it, "invokingContext.getInnerNameForDescriptor(descriptor)");
            Object globalName = it;
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf(TuplesKt.to(capturedName, JsAstUtils.pureFqn((JsName)globalName, null))));
            replacingVisitor.accept((JsNode)lambda);
        }
        MetadataProperties.setLocal(lambda, true);
        LiteralFunctionTranslatorKt.access$addFunctionDeclaration(invokingContext, (JsName)name, lambda, declaration2);
        this.fillCoroutineMetadata(lambda, invokingContext, descriptor2);
        MetadataProperties.setStaticRef((JsName)name, lambda);
        object = JsAstUtils.pureFqn((JsName)name, null);
        Intrinsics.checkNotNullExpressionValue(object, "pureFqn(name, null)");
        return (JsExpression)object;
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context2, @NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter($this$fillCoroutineMetadata, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!descriptor2.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($this$fillCoroutineMetadata, context2, descriptor2, descriptor2.getExtensionReceiverParameter() != null);
        MetadataProperties.setForceStateMachine($this$fillCoroutineMetadata, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $this$translate, @NotNull TranslationContext context2) {
        KtDestructuringDeclaration ktDestructuringDeclaration;
        Object object;
        Intrinsics.checkNotNullParameter($this$translate, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($this$translate);
        Object object2 = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        Object object3 = object = object2 == null ? null : ((KtParameter)object2).getDestructuringDeclaration();
        if (object == null) {
            object2 = "Destructuring declaration for descriptor " + $this$translate + " not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        KtDestructuringDeclaration destructuringDeclaration = ktDestructuringDeclaration = object;
        object = ReferenceTranslator.translateAsValueReference($this$translate, context2);
        Intrinsics.checkNotNullExpressionValue(object, "translateAsValueReference(this, context)");
        Object parameterRef = object;
        object = DestructuringDeclarationTranslator.translate(destructuringDeclaration, (JsExpression)parameterRef, context2);
        Intrinsics.checkNotNullExpressionValue(object, "translate(destructuringDeclaration, parameterRef, context)");
        return object;
    }
}

