/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.incremental.components.LocationInfo;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "location", "Lorg/jetbrains/kotlin/incremental/components/LocationInfo;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/components/LocationInfo;", "frontend"})
public final class KotlinLookupLocation
implements LookupLocation {
    @NotNull
    private final KtElement element;

    public KotlinLookupLocation(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        this.element = element;
    }

    @NotNull
    public final KtElement getElement() {
        return this.element;
    }

    @Override
    @Nullable
    public LocationInfo getLocation() {
        KtFile ktFile = this.element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue(ktFile, "element.containingKtFile");
        KtFile containingJetFile = ktFile;
        if (KtPsiFactoryKt.getDoNotAnalyze(containingJetFile) != null) {
            return null;
        }
        return new LocationInfo(containingJetFile, this){
            @NotNull
            private final String filePath;
            final /* synthetic */ KtFile $containingJetFile;
            final /* synthetic */ KotlinLookupLocation this$0;
            {
                this.$containingJetFile = $containingJetFile;
                this.this$0 = $receiver;
                this.filePath = this.$containingJetFile.getVirtualFilePath();
            }

            @NotNull
            public String getFilePath() {
                return this.filePath;
            }

            @NotNull
            public Position getPosition() {
                PsiDiagnosticUtils.LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumnInPsiFile(this.$containingJetFile, this.this$0.getElement().getTextRange());
                boolean bl = false;
                boolean bl2 = false;
                PsiDiagnosticUtils.LineAndColumn it = lineAndColumn;
                boolean bl3 = false;
                return new Position(it.getLine(), it.getColumn());
            }
        };
    }
}

