/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ReadWriteDirectBufferWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ByteBufferWrapper {
    protected final Path myFile;
    protected final long myPosition;
    protected final long myLength;
    protected volatile boolean myDirty;

    protected ByteBufferWrapper(Path file2, long offset2, long length) {
        this.myFile = file2;
        this.myPosition = offset2;
        this.myLength = length;
    }

    @Nullable
    public abstract ByteBuffer getCachedBuffer();

    public final void markDirty() {
        if (!this.myDirty) {
            this.myDirty = true;
        }
    }

    public final boolean isDirty() {
        return this.myDirty;
    }

    public abstract ByteBuffer getBuffer() throws IOException;

    public abstract void flush();

    public abstract void release();

    public static ByteBufferWrapper readWriteDirect(Path file2, long offset2, int length) {
        return new ReadWriteDirectBufferWrapper(file2, offset2, length, false);
    }

    public static ByteBufferWrapper readOnlyDirect(Path file2, long offset2, int length) {
        return new ReadWriteDirectBufferWrapper(file2, offset2, length, true);
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myLength;
    }
}

