/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutImpl;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u0012\u0010\u0007\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"zippedKotlinLibraryChecks", "", "klibFile", "Lorg/jetbrains/kotlin/konan/file/File;", "extract", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "file", "extractDir", "directory", "kotlin-util-klib"})
public final class KotlinLibraryLayoutImplKt {
    @NotNull
    public static final File extract(@NotNull KotlinLibraryLayoutImpl $this$extract, @NotNull File file2) {
        Intrinsics.checkNotNullParameter($this$extract, "<this>");
        Intrinsics.checkNotNullParameter(file2, "file");
        return (File)ZipUtilKt.withZipFileSystem($this$extract.getKlib(), (Function1)new Function1<FileSystem, File>(file2){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final File invoke(@NotNull FileSystem zipFileSystem) {
                Intrinsics.checkNotNullParameter(zipFileSystem, "zipFileSystem");
                File temporary = FileKt.createTempFile$default(this.$file.getName(), null, 2, null);
                ZipUtilKt.file(zipFileSystem, this.$file).copyTo(temporary);
                temporary.deleteOnExit();
                return temporary;
            }
        });
    }

    @NotNull
    public static final File extractDir(@NotNull KotlinLibraryLayoutImpl $this$extractDir, @NotNull File directory) {
        Intrinsics.checkNotNullParameter($this$extractDir, "<this>");
        Intrinsics.checkNotNullParameter(directory, "directory");
        return (File)ZipUtilKt.withZipFileSystem($this$extractDir.getKlib(), (Function1)new Function1<FileSystem, File>(directory){
            final /* synthetic */ File $directory;
            {
                this.$directory = $directory;
                super(1);
            }

            @NotNull
            public final File invoke(@NotNull FileSystem zipFileSystem) {
                Intrinsics.checkNotNullParameter(zipFileSystem, "zipFileSystem");
                File temporary = FileKt.createTempDir(this.$directory.getName());
                File.recursiveCopyTo$default(ZipUtilKt.file(zipFileSystem, this.$directory), temporary, false, 2, null);
                temporary.deleteOnExitRecursively();
                return temporary;
            }
        });
    }

    public static final void zippedKotlinLibraryChecks(@NotNull File klibFile) {
        Intrinsics.checkNotNullParameter(klibFile, "klibFile");
        boolean bl = klibFile.getExists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Could not find " + klibFile + '.';
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        bl = klibFile.isFile();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string3 = "Expected " + klibFile + " to be a regular file.";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        String extension = klibFile.getExtension();
        CharSequence charSequence = extension;
        bl3 = false;
        boolean bl6 = charSequence.length() == 0 || Intrinsics.areEqual(extension, "klib") || Intrinsics.areEqual(extension, "jar");
        bl3 = false;
        boolean bl7 = false;
        if (!bl6) {
            boolean bl8 = false;
            String string4 = Intrinsics.stringPlus("KLIB path has unexpected extension: ", klibFile);
            throw (Throwable)new IllegalStateException(string4.toString());
        }
    }
}

