/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnonymousFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnonymousFunctionAsExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeParameters", "checkers"})
public final class FirAnonymousFunctionChecker
extends FirExpressionChecker<FirAnonymousFunction> {
    @NotNull
    public static final FirAnonymousFunctionChecker INSTANCE = new FirAnonymousFunctionChecker();

    private FirAnonymousFunctionChecker() {
    }

    @Override
    public void check(@NotNull FirAnonymousFunction expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirValueParameter valueParameter2 : expression2.getValueParameters()) {
            FirSourceElement firSourceElement = valueParameter2.getSource();
            if (firSourceElement == null) continue;
            FirSourceElement source = firSourceElement;
            if (valueParameter2.getDefaultValue() != null) {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE(), context2);
            }
            if (!valueParameter2.isVararg()) continue;
            DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getUSELESS_VARARG_ON_PARAMETER(), context2);
        }
        this.checkTypeParameters(expression2, reporter, context2);
    }

    private final void checkTypeParameters(FirAnonymousFunction expression2, DiagnosticReporter reporter, CheckerContext context2) {
        Object object = expression2.getSource();
        if (object == null) {
            return;
        }
        Object source = object;
        if ((object = LightTreePositioningStrategiesKt.typeParametersList(((FirSourceElement)source).getTreeStructure(), ((FirSourceElement)source).getLighterASTNode())) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object $noName_0 = object2;
            boolean bl3 = false;
            DiagnosticReporterKt.reportOn(reporter, (FirSourceElement)source, FirErrors.INSTANCE.getTYPE_PARAMETERS_NOT_ALLOWED(), context2);
        }
    }
}

