/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.TypeCheck;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u000b0\u000b0\u00172\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J(\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u001c\u0010%\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u001e\u0010%\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020&0\u0015H\u0016J\u001c\u0010%\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020'2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\fR\u0018\u0010\r\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0018\u0010\u000e\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/translate/utils/TypeCheckRewritingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "()V", "localVars", "Ljava/util/Stack;", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "scopes", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "isAssignmentToLocalVar", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Z", "isLocalVar", "needsAlias", "getNeedsAlias", "endVisit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "expandArgumentForTwoInvocations", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "argument", "generateAlias", "getReplacement", "callee", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "calleeArguments", "", "getReplacementForAndPredicate", "p1", "p2", "getReplacementForOrNull", "calleeArgument", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "js.translator"})
final class TypeCheckRewritingVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final Stack<JsScope> scopes = new Stack();
    @NotNull
    private final Stack<Set<JsName>> localVars;

    /*
     * WARNING - void declaration
     */
    public TypeCheckRewritingVisitor() {
        void $this$localVars_u24lambda_u2d0;
        Stack stack = new Stack();
        boolean bl = false;
        boolean bl2 = false;
        Stack stack2 = stack;
        TypeCheckRewritingVisitor typeCheckRewritingVisitor = this;
        boolean bl3 = false;
        boolean bl4 = false;
        $this$localVars_u24lambda_u2d0.push((Set)new LinkedHashSet());
        Unit unit = Unit.INSTANCE;
        typeCheckRewritingVisitor.localVars = stack;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx2) {
        void $this$mapTo$iv$iv;
        void $this$visit_u24lambda_u2d2;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx2, "ctx");
        this.scopes.push(x.getScope());
        Set set = CollectionUtilsKt.IdentitySet();
        boolean bl = false;
        boolean bl2 = false;
        Set set2 = set;
        Stack<Set<JsName>> stack = this.localVars;
        boolean bl3 = false;
        Collection collection = (Collection)$this$visit_u24lambda_u2d2;
        Iterable<JsParameter> iterable = x.getParameters();
        Intrinsics.checkNotNullExpressionValue(iterable, "x.parameters");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            JsName jsName = it.getName();
            Intrinsics.checkNotNullExpressionValue(jsName, "it.name");
            JsName jsName2 = jsName;
            collection2.add(jsName2);
        }
        iterable = (List)destination$iv$iv;
        boolean bl5 = false;
        CollectionsKt.addAll(collection, iterable);
        Unit unit = Unit.INSTANCE;
        stack.push(set);
        return super.visit(x, ctx2);
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx2) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx2, "ctx");
        JsName jsName = x.getName();
        Intrinsics.checkNotNullExpressionValue(jsName, "x.name");
        this.localVars.peek().add(jsName);
        return super.visit(x, ctx2);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx2) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx2, "ctx");
        this.scopes.pop();
        this.localVars.pop();
        super.endVisit(x, ctx2);
    }

    public boolean visit(@NotNull JsInvocation x, @NotNull JsContext<JsNode> ctx2) {
        JsExpression replacement;
        JsInvocation callee;
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx2, "ctx");
        JsExpression jsExpression = x.getQualifier();
        JsInvocation jsInvocation = callee = jsExpression instanceof JsInvocation ? (JsInvocation)jsExpression : null;
        List<JsExpression> calleeArguments = jsInvocation == null ? null : jsInvocation.getArguments();
        List<JsExpression> list2 = x.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "x.arguments");
        JsExpression argument2 = CollectionsKt.firstOrNull(list2);
        if (callee != null && argument2 != null && calleeArguments != null && (replacement = this.getReplacement(callee, calleeArguments, argument2)) != null) {
            ctx2.replaceMe((JsNode)((JsExpression)this.accept((JsNode)replacement)).source(x.getSource()));
            return false;
        }
        return true;
    }

    private final JsExpression getReplacement(JsInvocation callee, List<? extends JsExpression> calleeArguments, JsExpression argument2) {
        JsExpression jsExpression;
        TypeCheck typeCheck = MetadataProperties.getTypeCheck(callee);
        TypeCheck typeCheck2 = typeCheck;
        int n = typeCheck2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[typeCheck2.ordinal()];
        switch (n) {
            case 1: {
                jsExpression = calleeArguments.size() == 1 ? JsAstUtils.typeOfIs(argument2, (JsStringLiteral)calleeArguments.get(0)) : null;
                break;
            }
            case 2: {
                if (calleeArguments.size() == 1) {
                    jsExpression = Namer.isInstanceOf(argument2, calleeArguments.get(0));
                    break;
                }
                jsExpression = null;
                break;
            }
            case 3: {
                if (calleeArguments.size() == 1) {
                    jsExpression = this.getReplacementForOrNull(argument2, calleeArguments.get(0));
                    break;
                }
                jsExpression = null;
                break;
            }
            case 4: {
                if (calleeArguments.size() == 2) {
                    jsExpression = this.getReplacementForAndPredicate(argument2, calleeArguments.get(0), calleeArguments.get(1));
                    break;
                }
                jsExpression = null;
                break;
            }
            case -1: {
                jsExpression = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsExpression;
    }

    private final JsExpression getReplacementForOrNull(JsExpression argument2, JsExpression calleeArgument) {
        if (calleeArgument instanceof JsInvocation && MetadataProperties.getTypeCheck((JsInvocation)calleeArgument) == TypeCheck.OR_NULL) {
            JsExpression[] jsExpressionArray = new JsExpression[]{argument2};
            return new JsInvocation(calleeArgument, jsExpressionArray);
        }
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument2);
        JsExpression nullCheckTarget = pair.component1();
        JsExpression nextCheckTarget = pair.component2();
        JsBinaryOperation jsBinaryOperation = TranslationUtils.isNullCheck(nullCheckTarget);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "isNullCheck(nullCheckTarget)");
        JsBinaryOperation isNull = jsBinaryOperation;
        JsExpression[] jsExpressionArray = new JsExpression[]{nextCheckTarget};
        jsBinaryOperation = JsAstUtils.or(isNull, new JsInvocation(calleeArgument, jsExpressionArray));
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "or(isNull, JsInvocation(calleeArgument, nextCheckTarget))");
        return jsBinaryOperation;
    }

    private final JsExpression getReplacementForAndPredicate(JsExpression argument2, JsExpression p1, JsExpression p2) {
        Pair<JsExpression, JsExpression> pair = this.expandArgumentForTwoInvocations(argument2);
        JsExpression arg1 = pair.component1();
        JsExpression arg2 = pair.component2();
        JsExpression[] jsExpressionArray = new JsExpression[]{arg1};
        JsExpression first = (JsExpression)this.accept((JsNode)new JsInvocation(p1, jsExpressionArray));
        Object object = new JsExpression[]{arg2};
        JsExpression second = (JsExpression)this.accept((JsNode)new JsInvocation(p2, (JsExpression)object));
        object = JsAstUtils.and(first, second);
        Intrinsics.checkNotNullExpressionValue(object, "and(first, second)");
        return (JsExpression)object;
    }

    private final Pair<JsExpression, JsExpression> expandArgumentForTwoInvocations(JsExpression argument2) {
        return this.isAssignmentToLocalVar(argument2) ? new Pair<JsExpression, JsExpression>(argument2, ((JsBinaryOperation)argument2).getArg1()) : (this.getNeedsAlias(argument2) ? this.generateAlias(argument2) : new Pair<JsExpression, JsExpression>(argument2, argument2));
    }

    private final Pair<JsExpression, JsExpression> generateAlias(JsExpression argument2) {
        JsName jsName = JsScope.declareTemporary();
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporary()");
        JsName tmp = jsName;
        JsContext<JsStatement> jsContext = this.getLastStatementLevelContext();
        Intrinsics.checkNotNullExpressionValue(jsContext, "lastStatementLevelContext");
        JsContext<JsStatement> statementContext = jsContext;
        statementContext.addPrevious((JsNode)JsAstUtils.newVar(tmp, null));
        return new Pair<JsExpression, JsExpression>(JsAstUtils.assignment(tmp.makeRef(), argument2), tmp.makeRef());
    }

    private final boolean getNeedsAlias(JsExpression $this$needsAlias) {
        JsExpression jsExpression = $this$needsAlias;
        return jsExpression instanceof JsLiteral.JsValueLiteral ? false : !this.isLocalVar($this$needsAlias);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLocalVar(JsExpression $this$isLocalVar) {
        Object object = this.localVars;
        boolean bl = false;
        if (object.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (!($this$isLocalVar instanceof JsNameRef)) return false;
        object = ((JsNameRef)$this$isLocalVar).getName();
        bl = false;
        boolean bl3 = false;
        Object it = object;
        boolean bl4 = false;
        if (it == null) return false;
        if (!this.localVars.peek().contains(it)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAssignmentToLocalVar(JsExpression $this$isAssignmentToLocalVar) {
        Object object = this.localVars;
        boolean bl = false;
        if (object.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        object = JsAstUtils.decomposeAssignmentToVariable($this$isAssignmentToLocalVar);
        bl = false;
        boolean bl3 = false;
        Object it = object;
        boolean bl4 = false;
        if (it == null) return false;
        if (!this.localVars.peek().contains(((Pair)it).getFirst())) return false;
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeCheck.values().length];
            nArray[TypeCheck.TYPEOF.ordinal()] = 1;
            nArray[TypeCheck.INSTANCEOF.ordinal()] = 2;
            nArray[TypeCheck.OR_NULL.ordinal()] = 3;
            nArray[TypeCheck.AND_PREDICATE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

