/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u001d\u001a\u00020\u0014H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "T", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "getConstantValue", "()Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "hasIntegerLiteralType", "", "getHasIntegerLiteralType", "()Z", "isError", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "equals", "other", "", "hashCode", "", "toConstantValue", "expectedType", "descriptors"})
public final class TypedCompileTimeConstant<T>
implements CompileTimeConstant<T> {
    @NotNull
    private final ConstantValue<T> constantValue;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;
    @NotNull
    private final KotlinType type;

    public TypedCompileTimeConstant(@NotNull ConstantValue<? extends T> constantValue, @NotNull ModuleDescriptor module2, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkNotNullParameter(constantValue, "constantValue");
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this.constantValue = constantValue;
        this.parameters = parameters2;
        this.type = this.constantValue.getType(module2);
    }

    @NotNull
    public final ConstantValue<T> getConstantValue() {
        return this.constantValue;
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isError() {
        return this.constantValue instanceof ErrorValue;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ConstantValue<T> toConstantValue(@NotNull KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
        return this.constantValue;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypedCompileTimeConstant)) {
            return false;
        }
        if (this.isError()) {
            return ((TypedCompileTimeConstant)other).isError();
        }
        if (((TypedCompileTimeConstant)other).isError()) {
            return false;
        }
        return Intrinsics.areEqual(this.constantValue.getValue(), ((TypedCompileTimeConstant)other).constantValue.getValue()) && Intrinsics.areEqual(this.type, ((TypedCompileTimeConstant)other).type);
    }

    @Override
    public int hashCode() {
        int n;
        if (this.isError()) {
            return 13;
        }
        T t = this.constantValue.getValue();
        int result2 = t == null ? 0 : (n = t.hashCode());
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    @Override
    public boolean getHasIntegerLiteralType() {
        return false;
    }

    @Override
    public T getValue(@NotNull KotlinType expectedType2) {
        return CompileTimeConstant.DefaultImpls.getValue(this, expectedType2);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean isUnsignedNumberLiteral() {
        return CompileTimeConstant.DefaultImpls.isUnsignedNumberLiteral(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }
}

