/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirResolvedReifiedParameterReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0018H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirClassLiteralChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirGetClassCallChecker;", "()V", "canBeDoubleColonLHSAsType", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getCanBeDoubleColonLHSAsType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "safeAsTypeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getSafeAsTypeParameterSymbol", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isAllowedInClassLiteral", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isNullableTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "checkers"})
public final class FirClassLiteralChecker
extends FirExpressionChecker<FirGetClassCall> {
    @NotNull
    public static final FirClassLiteralChecker INSTANCE = new FirClassLiteralChecker();

    private FirClassLiteralChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirGetClassCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean isNullable;
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSourceElement firSourceElement = expression2.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (source.getKind() instanceof FirFakeSourceElementKind) {
            return;
        }
        KtSingleValueToken ktSingleValueToken = KtTokens.QUEST;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "QUEST");
        boolean markedNullable = FirSourceUtilsKt.getChild$default(source, ktSingleValueToken, 0, 1, 2, null) != null;
        FirExpression argument2 = expression2.getArgument();
        boolean bl = markedNullable || Intrinsics.areEqual((object = argument2 instanceof FirResolvedQualifier ? (FirResolvedQualifier)argument2 : null) == null ? null : Boolean.valueOf(((FirResolvedQualifier)object).isNullableLHSForCallableReference()), true) || ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getConeType(argument2.getTypeRef())) || this.isNullableTypeParameter(FirTypeUtilsKt.getConeType(argument2.getTypeRef()), InferenceComponentsKt.getInferenceComponents(context2.getSession()).getCtx()) ? true : (isNullable = false);
        if (isNullable) {
            if (this.getCanBeDoubleColonLHSAsType(argument2)) {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getNULLABLE_TYPE_IN_CLASS_LITERAL_LHS(), context2);
            } else {
                DiagnosticReporterKt.reportOn(reporter, argument2.getSource(), FirErrors.INSTANCE.getEXPRESSION_OF_NULLABLE_TYPE_IN_CLASS_LITERAL_LHS(), FirTypeUtilsKt.getConeType(argument2.getTypeRef()), context2);
            }
            return;
        }
        object = this.getSafeAsTypeParameterSymbol(argument2);
        if (object != null) {
            Object object2 = object;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object2;
            boolean bl4 = false;
            if (!((FirTypeParameter)((AbstractFirBasedSymbol)it).getFir()).isReified()) {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), it, context2);
            }
        }
        if (!(argument2 instanceof FirResolvedQualifier)) {
            return;
        }
        object = ((FirResolvedQualifier)argument2).getTypeArguments();
        boolean bl5 = false;
        if (!object.isEmpty() && !this.isAllowedInClassLiteral(FirTypeUtilsKt.getConeType(argument2.getTypeRef()), context2)) {
            int n;
            int expectedTypeArgumentSize;
            List list2;
            Object object3 = ((FirResolvedQualifier)argument2).getSymbol();
            FirClassLikeDeclaration firClassLikeDeclaration = object3 == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object3).getFir();
            FirTypeParameterRefsOwner firTypeParameterRefsOwner = firClassLikeDeclaration instanceof FirTypeParameterRefsOwner ? (FirTypeParameterRefsOwner)((Object)firClassLikeDeclaration) : null;
            List<FirTypeParameterRef> typeParameters2 = firTypeParameterRefsOwner == null ? null : firTypeParameterRefsOwner.getTypeParameters();
            object3 = typeParameters2;
            if (object3 == null) {
                list2 = null;
            } else {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = (Iterable)object3;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof FirTypeParameter)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            firClassLikeDeclaration = list2;
            int n2 = expectedTypeArgumentSize = firClassLikeDeclaration == null ? 0 : (n = firClassLikeDeclaration.size());
            if (expectedTypeArgumentSize != ((FirResolvedQualifier)argument2).getTypeArguments().size()) {
                return;
            }
            DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getCLASS_LITERAL_LHS_NOT_A_CLASS(), context2);
        }
    }

    private final boolean isNullableTypeParameter(ConeKotlinType $this$isNullableTypeParameter, ConeInferenceContext context2) {
        if (!($this$isNullableTypeParameter instanceof ConeTypeParameterType)) {
            return false;
        }
        FirTypeParameter typeParameter = (FirTypeParameter)((ConeTypeParameterType)$this$isNullableTypeParameter).getLookupTag().getTypeParameterSymbol().getFir();
        boolean bl = false;
        boolean bl2 = false;
        ConeInferenceContext $this$isNullableTypeParameter_u24lambda_u2d1 = context2;
        boolean bl3 = false;
        return !typeParameter.isReified() && $this$isNullableTypeParameter_u24lambda_u2d1.isNullableType(FirNestedClassifierScopeKt.toConeType(typeParameter));
    }

    private final boolean getCanBeDoubleColonLHSAsType(FirExpression $this$canBeDoubleColonLHSAsType) {
        return $this$canBeDoubleColonLHSAsType instanceof FirResolvedQualifier || $this$canBeDoubleColonLHSAsType instanceof FirResolvedReifiedParameterReference || this.getSafeAsTypeParameterSymbol($this$canBeDoubleColonLHSAsType) != null;
    }

    private final FirTypeParameterSymbol getSafeAsTypeParameterSymbol(FirExpression $this$safeAsTypeParameterSymbol) {
        FirQualifiedAccessExpression firQualifiedAccessExpression = $this$safeAsTypeParameterSymbol instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$safeAsTypeParameterSymbol : null;
        FirReference firReference = firQualifiedAccessExpression == null ? null : firQualifiedAccessExpression.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
        return abstractFirBasedSymbol instanceof FirTypeParameterSymbol ? (FirTypeParameterSymbol)abstractFirBasedSymbol : null;
    }

    private final boolean isAllowedInClassLiteral(ConeKotlinType $this$isAllowedInClassLiteral, CheckerContext context2) {
        boolean bl;
        block9: {
            ConeKotlinType coneKotlinType = $this$isAllowedInClassLiteral;
            if (coneKotlinType instanceof ConeClassLikeType) {
                if (ConeTypeUtilsKt.isNonPrimitiveArray($this$isAllowedInClassLiteral)) {
                    ConeTypeProjection[] $this$none$iv = $this$isAllowedInClassLiteral.getTypeArguments();
                    boolean $i$f$none = false;
                    ConeTypeProjection[] coneTypeProjectionArray = $this$none$iv;
                    int n = coneTypeProjectionArray.length;
                    for (int i = 0; i < n; ++i) {
                        boolean bl2;
                        ConeTypeProjection element$iv;
                        ConeTypeProjection typeArgument = element$iv = coneTypeProjectionArray[i];
                        boolean bl3 = false;
                        ConeTypeProjection coneTypeProjection = typeArgument;
                        if (coneTypeProjection instanceof ConeStarProjection) {
                            bl2 = true;
                        } else if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                            bl2 = !INSTANCE.isAllowedInClassLiteral(((ConeKotlinTypeProjection)typeArgument).getType(), context2);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        if (!bl2) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                } else {
                    ConeTypeProjection[] coneTypeProjectionArray = $this$isAllowedInClassLiteral.getTypeArguments();
                    boolean bl4 = false;
                    bl = coneTypeProjectionArray.length == 0;
                }
            } else {
                bl = coneKotlinType instanceof ConeTypeParameterType ? ((FirTypeParameter)((ConeTypeParameterType)$this$isAllowedInClassLiteral).getLookupTag().getTypeParameterSymbol().getFir()).isReified() : false;
            }
        }
        return bl;
    }
}

