/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMapper;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0011*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmStandardLibraryBuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "jvm8builtInReplacements", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "coerceIfPossible", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "toType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceWithCallTo", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "replacement", "backend.jvm"})
public final class JvmStandardLibraryBuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Map<Pair<String, String>, IrSimpleFunctionSymbol> jvm8builtInReplacements;

    public JvmStandardLibraryBuiltInsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        Pair[] pairArray = new Pair[]{TuplesKt.to(TuplesKt.to("kotlin.UInt", "compareTo"), this.context.getIr().getSymbols().getCompareUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "div"), this.context.getIr().getSymbols().getDivideUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "rem"), this.context.getIr().getSymbols().getRemainderUnsignedInt()), TuplesKt.to(TuplesKt.to("kotlin.UInt", "toString"), this.context.getIr().getSymbols().getToUnsignedStringInt()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "compareTo"), this.context.getIr().getSymbols().getCompareUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "div"), this.context.getIr().getSymbols().getDivideUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "rem"), this.context.getIr().getSymbols().getRemainderUnsignedLong()), TuplesKt.to(TuplesKt.to("kotlin.ULong", "toString"), this.context.getIr().getSymbols().getToUnsignedStringLong())};
        this.jvm8builtInReplacements = MapsKt.mapOf(pairArray);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (this.context.getState().getTarget().compareTo((Enum)JvmTarget.JVM_1_8) < 0) {
            return;
        }
        IrElementTransformerVoid transformer2 = new IrElementTransformerVoid(this){
            final /* synthetic */ JvmStandardLibraryBuiltInsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                expression2.transformChildren(this, null);
                String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(((IrSimpleFunction)expression2.getSymbol().getOwner()).getParent()).asString();
                Intrinsics.checkNotNullExpressionValue(string2, "expression.symbol.owner.\u2026rSerialization.asString()");
                String parentClass = string2;
                Object object = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue(object, "expression.symbol.owner.name.asString()");
                String functionName = object;
                object = (IrSimpleFunctionSymbol)JvmStandardLibraryBuiltInsLowering.access$getJvm8builtInReplacements$p(this.this$0).get(TuplesKt.to(parentClass, functionName));
                if (object != null) {
                    Object object2 = object;
                    JvmStandardLibraryBuiltInsLowering jvmStandardLibraryBuiltInsLowering = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object replacement = object2;
                    boolean bl3 = false;
                    return JvmStandardLibraryBuiltInsLowering.access$replaceWithCallTo(jvmStandardLibraryBuiltInsLowering, expression2, (IrSimpleFunctionSymbol)replacement);
                }
                return expression2;
            }
        };
        irFile.transformChildren(transformer2, null);
    }

    private final IrExpression replaceWithCallTo(IrCall $this$replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        IrExpression irExpression;
        IrType expectedType2 = $this$replaceWithCallTo.getType();
        IrType intrinsicCallType = ((IrSimpleFunction)replacement.getOwner()).getReturnType();
        IrExpression irExpression2 = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$replaceWithCallTo.getStartOffset(), $this$replaceWithCallTo.getEndOffset(), intrinsicCallType, replacement, 0, 0, null, null, 240, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl newCall = irExpression2;
        boolean bl3 = false;
        int valueArgumentOffset = 0;
        IrExpression irExpression3 = $this$replaceWithCallTo.getDispatchReceiver();
        if (irExpression3 != null) {
            IrExpression irExpression4 = irExpression3;
            boolean bl4 = false;
            boolean bl5 = false;
            IrExpression it = irExpression4;
            boolean bl6 = false;
            IrExpression irExpression5 = this.coerceIfPossible(it, ((IrSimpleFunction)replacement.getOwner()).getValueParameters().get(valueArgumentOffset).getType());
            if (irExpression5 == null) {
                return $this$replaceWithCallTo;
            }
            IrExpression coercedDispatchReceiver = irExpression5;
            newCall.putValueArgument(valueArgumentOffset, coercedDispatchReceiver);
            int n = valueArgumentOffset;
            valueArgumentOffset = n + 1;
        }
        int n = 0;
        int n2 = $this$replaceWithCallTo.getValueArgumentsCount();
        if (n < n2) {
            do {
                int index2 = n++;
                IrExpression irExpression6 = $this$replaceWithCallTo.getValueArgument(index2);
                Intrinsics.checkNotNull(irExpression6);
                IrExpression irExpression7 = this.coerceIfPossible(irExpression6, ((IrSimpleFunction)replacement.getOwner()).getValueParameters().get(index2).getType());
                if (irExpression7 == null) {
                    return $this$replaceWithCallTo;
                }
                IrExpression coercedValueArgument = irExpression7;
                newCall.putValueArgument(index2 + valueArgumentOffset, coercedValueArgument);
            } while (n < n2);
        }
        IrCallImpl intrinsicCall = irExpression2;
        if (IrTypePredicatesKt.isInt(intrinsicCallType) || IrTypePredicatesKt.isLong(intrinsicCallType)) {
            irExpression2 = this.coerceIfPossible(intrinsicCall, expectedType2);
            if (irExpression2 == null) {
                throw new AssertionError((Object)("Can't coerce '" + RenderIrElementKt.render(intrinsicCallType) + "' to '" + RenderIrElementKt.render(expectedType2) + '\''));
            }
            irExpression = irExpression2;
        } else {
            irExpression = intrinsicCall;
        }
        return irExpression;
    }

    private final IrExpression coerceIfPossible(IrExpression $this$coerceIfPossible, IrType toType) {
        IrExpression irExpression;
        Type toJvmType;
        Type fromJvmType = IrTypeMapper.mapType$default(this.context.getTypeMapper(), $this$coerceIfPossible.getType(), null, null, 6, null);
        if (!Intrinsics.areEqual(fromJvmType, toJvmType = IrTypeMapper.mapType$default(this.context.getTypeMapper(), toType, null, null, 6, null))) {
            irExpression = null;
        } else {
            IrCallImpl irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$coerceIfPossible.getStartOffset(), $this$coerceIfPossible.getEndOffset(), toType, this.context.getIr().getSymbols().getUnsafeCoerceIntrinsic(), 0, 0, null, null, 240, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl call2 = irCallImpl;
            boolean bl3 = false;
            call2.putTypeArgument(0, $this$coerceIfPossible.getType());
            call2.putTypeArgument(1, toType);
            call2.putValueArgument(0, $this$coerceIfPossible);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    public static final /* synthetic */ Map access$getJvm8builtInReplacements$p(JvmStandardLibraryBuiltInsLowering $this) {
        return $this.jvm8builtInReplacements;
    }

    public static final /* synthetic */ IrExpression access$replaceWithCallTo(JvmStandardLibraryBuiltInsLowering $this, IrCall $receiver, IrSimpleFunctionSymbol replacement) {
        return $this.replaceWithCallTo($receiver, replacement);
    }
}

