/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperatorCall;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\u001c\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"CONVERSION_NAMES", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/collections/HashSet;", "checkConstantArguments", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConstantArgumentKind;", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "canBeUsedForConstVal", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getReferencedClass", "Lorg/jetbrains/kotlin/fir/FirSymbolOwner;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypedDeclaration;", "checkers"})
public final class FirConstChecksKt {
    @NotNull
    private static final HashSet<Name> CONVERSION_NAMES;

    public static final boolean canBeUsedForConstVal(@NotNull ConeKotlinType $this$canBeUsedForConstVal) {
        Intrinsics.checkNotNullParameter($this$canBeUsedForConstVal, "<this>");
        ConeKotlinType coneKotlinType = ConeTypesKt.lowerBoundIfFlexible($this$canBeUsedForConstVal);
        boolean bl = false;
        boolean bl2 = false;
        ConeKotlinType $this$canBeUsedForConstVal_u24lambda_u2d0 = coneKotlinType;
        boolean bl3 = false;
        return ConeTypeUtilsKt.isPrimitive($this$canBeUsedForConstVal_u24lambda_u2d0) || ConeTypeUtilsKt.isString($this$canBeUsedForConstVal_u24lambda_u2d0) || ConeTypeUtilsKt.isUnsignedType($this$canBeUsedForConstVal_u24lambda_u2d0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final ConstantArgumentKind checkConstantArguments(@NotNull FirExpression expression2, @NotNull FirSession session2) {
        ConstantArgumentKind constantArgumentKind;
        Object exp;
        FirCall $this$arguments$iv;
        boolean bl;
        FirCallableDeclaration expressionSymbol;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2);
        FirCallableDeclaration firCallableDeclaration = expressionSymbol = firCallableSymbol == null ? null : (FirCallableDeclaration)firCallableSymbol.getFir();
        Object object = firCallableDeclaration == null ? null : FirConstChecksKt.getReferencedClass(firCallableDeclaration, session2);
        Object object2 = object instanceof FirRegularClass ? (FirRegularClass)object : null;
        ClassKind classKindOfParent = object2 == null ? null : ((FirRegularClass)object2).getClassKind();
        if (expression2 instanceof FirTypeOperatorCall) {
            if (((FirTypeOperatorCall)expression2).getOperation() != FirOperation.AS) return null;
            return ConstantArgumentKind.NOT_CONST;
        }
        if (expression2 instanceof FirConstExpression) return null;
        if (expressionSymbol instanceof FirEnumEntry) return null;
        Object object3 = object2 = expressionSymbol instanceof FirMemberDeclaration ? (FirMemberDeclaration)((Object)expressionSymbol) : null;
        if (object2 == null) {
            bl = false;
        } else {
            FirMemberDeclaration $this$isConst$iv = object2;
            boolean $i$f$isConst = false;
            if ($this$isConst$iv.getStatus().isConst()) {
                return null;
            }
            bl = false;
        }
        if (bl) return null;
        if (expressionSymbol instanceof FirConstructor && classKindOfParent == ClassKind.ANNOTATION_CLASS) return null;
        if (classKindOfParent == ClassKind.ENUM_CLASS) {
            return ConstantArgumentKind.ENUM_NOT_CONST;
        }
        if (expression2 instanceof FirComparisonExpression) {
            return FirConstChecksKt.checkConstantArguments(((FirComparisonExpression)expression2).getCompareToCall(), session2);
        }
        if (expression2 instanceof FirIntegerOperatorCall) {
            $this$arguments$iv = (FirCall)((Object)expression2);
            boolean $i$f$getArguments22 = false;
            object2 = CollectionsKt.plus((Collection)$this$arguments$iv.getArgumentList().getArguments(), ((FirIntegerOperatorCall)expression2).getDispatchReceiver()).iterator();
            if (!object2.hasNext()) return null;
            exp = object2.next();
            ConstantArgumentKind $i$f$getArguments22 = FirConstChecksKt.checkConstantArguments((FirExpression)exp, session2);
            boolean bl2 = false;
            boolean bl3 = false;
            return $i$f$getArguments22;
        }
        if (expression2 instanceof FirStringConcatenationCall || expression2 instanceof FirEqualityOperatorCall) {
            $this$arguments$iv = (FirCall)((Object)expression2);
            boolean $i$f$getArguments32 = false;
            object2 = $this$arguments$iv.getArgumentList().getArguments().iterator();
            if (!object2.hasNext()) return null;
            exp = object2.next();
            ConstantArgumentKind $i$f$getArguments32 = FirConstChecksKt.checkConstantArguments((FirExpression)exp, session2);
            boolean bl4 = false;
            boolean bl5 = false;
            return $i$f$getArguments32;
        }
        if (expression2 instanceof FirGetClassCall) {
            ConstantArgumentKind constantArgumentKind2;
            Object coneType;
            Object $i$f$getArguments32;
            Object $this$argument$iv;
            Object object4;
            Object object5 = exp = expression2 instanceof FirCall ? (FirCall)((Object)expression2) : null;
            if (exp == null) {
                object4 = null;
            } else {
                FirCall firCall = exp;
                boolean $i$f$getArgument = false;
                $i$f$getArguments32 = CollectionsKt.first($this$argument$iv.getArgumentList().getArguments());
                object4 = $i$f$getArguments32 == null ? null : (coneType = ($this$argument$iv = ((FirExpression)$i$f$getArguments32).getTypeRef()) == null ? null : FirTypeUtilsKt.getConeType((FirTypeRef)$this$argument$iv));
            }
            if (coneType instanceof ConeClassErrorType) {
                return ConstantArgumentKind.NOT_CONST;
            }
            while (Intrinsics.areEqual((exp = coneType) == null ? null : ConeTypeUtilsKt.getClassId((ConeKotlinType)exp), StandardClassIds.INSTANCE.getArray())) {
                $this$argument$iv = ArraysKt.first(ConeTypesKt.lowerBoundIfFlexible(coneType).getTypeArguments());
                $i$f$getArguments32 = $this$argument$iv instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)$this$argument$iv : null;
                Object object6 = exp = $i$f$getArguments32 == null ? null : ((ConeKotlinTypeProjection)$i$f$getArguments32).getType();
                if (exp == null) break;
                coneType = exp;
            }
            if (coneType instanceof ConeTypeParameterType) {
                constantArgumentKind2 = ConstantArgumentKind.KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR;
                return constantArgumentKind2;
            } else {
                FirCall $this$argument$iv2 = (FirCall)((Object)expression2);
                boolean $i$f$getArgument = false;
                if (CollectionsKt.first($this$argument$iv2.getArgumentList().getArguments()) instanceof FirResolvedQualifier) return null;
                constantArgumentKind2 = ConstantArgumentKind.NOT_KCLASS_LITERAL;
            }
            return constantArgumentKind2;
        }
        if (expressionSymbol == null) return null;
        if (expressionSymbol instanceof FirField) {
            if (!((FirMemberDeclaration)((Object)expressionSymbol)).getStatus().isStatic()) return ConstantArgumentKind.NOT_CONST;
            if (((FirMemberDeclaration)((Object)expressionSymbol)).getStatus().getModality() == Modality.FINAL) return null;
            return ConstantArgumentKind.NOT_CONST;
        }
        if (expressionSymbol instanceof FirConstructor) {
            FirExpression argumentExpression;
            ConstantArgumentKind $i$a$-let-FirConstChecksKt$checkConstantArguments$32;
            void $this$forEach$iv;
            if (!ConeTypeUtilsKt.isUnsignedType(FirTypeUtilsKt.getConeType(expression2.getTypeRef()))) return ConstantArgumentKind.NOT_CONST;
            Object $this$arguments$iv2 = (FirFunctionCall)expression2;
            boolean $i$f$getArguments = false;
            $this$arguments$iv2 = $this$arguments$iv2.getArgumentList().getArguments();
            boolean $i$f$forEach = false;
            Iterator $i$f$getArgument = $this$forEach$iv.iterator();
            do {
                if (!$i$f$getArgument.hasNext()) return null;
                Object element$iv = $i$f$getArgument.next();
                argumentExpression = (FirExpression)element$iv;
                boolean bl6 = false;
            } while (($i$a$-let-FirConstChecksKt$checkConstantArguments$32 = FirConstChecksKt.checkConstantArguments(argumentExpression, session2)) == null);
            ConstantArgumentKind constantArgumentKind3 = $i$a$-let-FirConstChecksKt$checkConstantArguments$32;
            boolean bl7 = false;
            boolean bl8 = false;
            return constantArgumentKind3;
        }
        if (expression2 instanceof FirFunctionCall) {
            FqName fqName2;
            CallableId callableId;
            FirNamedReference calleeReference = ((FirFunctionCall)expression2).getCalleeReference();
            if (calleeReference instanceof FirErrorNamedReference) {
                return null;
            }
            if (Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(expression2.getTypeRef())), StandardClassIds.INSTANCE.getKClass())) {
                return ConstantArgumentKind.NOT_KCLASS_LITERAL;
            }
            if (((FirFunctionCall)expression2).getDispatchReceiver() instanceof FirThisReceiverExpression) {
                return null;
            }
            object = calleeReference.getName();
            if ((((((OperatorNameConventions.BINARY_OPERATION_NAMES.contains(object) ? true : OperatorNameConventions.UNARY_OPERATION_NAMES.contains(object)) ? true : Intrinsics.areEqual(object, OperatorNameConventions.SHL)) ? true : Intrinsics.areEqual(object, OperatorNameConventions.SHR)) ? true : Intrinsics.areEqual(object, OperatorNameConventions.USHR)) ? true : Intrinsics.areEqual(object, OperatorNameConventions.OR)) ? true : Intrinsics.areEqual(object, OperatorNameConventions.AND)) {
                FirExpression exp2;
                ConstantArgumentKind constantArgumentKind4;
                ConeKotlinType element$iv;
                FirTypeRef $this$coneTypeSafe$iv = ((FirFunctionCall)expression2).getDispatchReceiver().getTypeRef();
                boolean $i$f$coneTypeSafe2 = false;
                boolean $i$a$-let-FirConstChecksKt$checkConstantArguments$32 = false;
                FirResolvedTypeRef $i$a$-let-FirConstChecksKt$checkConstantArguments$32 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = $i$a$-let-FirConstChecksKt$checkConstantArguments$32 == null ? null : $i$a$-let-FirConstChecksKt$checkConstantArguments$32.getType();
                if (!(coneKotlinType instanceof ConeKotlinType)) {
                    coneKotlinType = null;
                }
                if ((element$iv = coneKotlinType) == null) {
                    return ConstantArgumentKind.NOT_CONST;
                }
                ConeKotlinType coneType = element$iv;
                ClassId receiverClassId = ConeTypeUtilsKt.getClassId(ConeTypesKt.lowerBoundIfFlexible(coneType));
                if ((Intrinsics.areEqual(calleeReference.getName(), OperatorNameConventions.DIV) || Intrinsics.areEqual(calleeReference.getName(), OperatorNameConventions.REM)) && Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(expression2.getTypeRef())), StandardClassIds.INSTANCE.getInt())) {
                    FirCall $this$arguments$iv3 = (FirCall)((Object)expression2);
                    boolean $i$f$getArguments = false;
                    FirExpression $i$f$coneTypeSafe2 = CollectionsKt.first($this$arguments$iv3.getArgumentList().getArguments());
                    FirConstExpression value2 = $i$f$coneTypeSafe2 instanceof FirConstExpression ? (FirConstExpression)$i$f$coneTypeSafe2 : null;
                    $i$f$coneTypeSafe2 = value2;
                    if ($i$f$coneTypeSafe2 == null ? false : Intrinsics.areEqual(((FirConstExpression)$i$f$coneTypeSafe2).getValue(), (Object)0L)) {
                        return ConstantArgumentKind.NOT_CONST;
                    }
                }
                FirCall $this$arguments$iv4 = (FirCall)((Object)expression2);
                boolean $i$f$getArguments = false;
                Iterator<FirExpression> iterator2 = CollectionsKt.plus((Collection)$this$arguments$iv4.getArgumentList().getArguments(), ((FirFunctionCall)expression2).getDispatchReceiver()).iterator();
                do {
                    if (!iterator2.hasNext()) return null;
                    exp2 = iterator2.next();
                    ClassId expClassId = ConeTypeUtilsKt.getClassId(ConeTypesKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(exp2.getTypeRef())));
                    if (!Intrinsics.areEqual(calleeReference.getName(), OperatorNameConventions.PLUS) || Intrinsics.areEqual(expClassId, receiverClassId)) continue;
                    if (!CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getConstantAllowedTypes(), expClassId)) return ConstantArgumentKind.NOT_CONST;
                    if (CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getConstantAllowedTypes(), receiverClassId)) continue;
                    return ConstantArgumentKind.NOT_CONST;
                } while ((constantArgumentKind4 = FirConstChecksKt.checkConstantArguments(exp2, session2)) == null);
                ConstantArgumentKind constantArgumentKind5 = constantArgumentKind4;
                boolean bl9 = false;
                boolean bl10 = false;
                return constantArgumentKind5;
            }
            Object $this$arguments$iv5 = (FirCall)((Object)expression2);
            boolean $i$f$getArguments = false;
            $this$arguments$iv5 = $this$arguments$iv5.getArgumentList().getArguments();
            boolean bl11 = false;
            if (!$this$arguments$iv5.isEmpty()) return ConstantArgumentKind.NOT_CONST;
            if (!(calleeReference instanceof FirResolvedNamedReference)) {
                return ConstantArgumentKind.NOT_CONST;
            }
            FirCallableSymbol firCallableSymbol2 = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            FirCallableSymbol symbol2 = firCallableSymbol2 instanceof FirCallableSymbol ? (FirCallableSymbol)firCallableSymbol2 : null;
            if (Intrinsics.areEqual(calleeReference.getName(), OperatorNameConventions.TO_STRING)) return FirConstChecksKt.checkConstantArguments(((FirFunctionCall)expression2).getDispatchReceiver(), session2);
            if (!CONVERSION_NAMES.contains(calleeReference.getName())) return ConstantArgumentKind.NOT_CONST;
            firCallableSymbol2 = symbol2;
            if (!Intrinsics.areEqual(firCallableSymbol2 == null ? null : ((callableId = firCallableSymbol2.getCallableId()) == null ? null : ((fqName2 = callableId.getPackageName()) == null ? null : fqName2.asString())), "kotlin")) return ConstantArgumentKind.NOT_CONST;
            return FirConstChecksKt.checkConstantArguments(((FirFunctionCall)expression2).getDispatchReceiver(), session2);
        }
        if (!(expression2 instanceof FirQualifiedAccessExpression)) return ConstantArgumentKind.NOT_CONST;
        if (((FirProperty)expressionSymbol).isLocal()) return ConstantArgumentKind.NOT_CONST;
        object2 = ((FirProperty)expressionSymbol).getSymbol().getCallableId().getClassName();
        if (object2 == null ? false : !((FqName)object2).isRoot()) {
            return ConstantArgumentKind.NOT_CONST;
        }
        if (Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(expression2.getTypeRef())), StandardClassIds.INSTANCE.getKClass())) {
            return ConstantArgumentKind.NOT_KCLASS_LITERAL;
        }
        if (((FirQualifiedAccessExpression)expression2).getDispatchReceiver() instanceof FirThisReceiverExpression) {
            return null;
        }
        object = expressionSymbol instanceof FirProperty ? (FirProperty)expressionSymbol : null;
        Object object7 = object2 = object == null ? null : ((FirProperty)object).getInitializer();
        if (object2 instanceof FirConstExpression) {
            Object object8 = object = expressionSymbol instanceof FirVariable ? (FirVariable)expressionSymbol : null;
            constantArgumentKind = (object == null ? false : ((FirVariable)object).isVal()) ? ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION : ConstantArgumentKind.NOT_CONST;
            return constantArgumentKind;
        } else {
            constantArgumentKind = object2 instanceof FirGetClassCall ? ConstantArgumentKind.NOT_KCLASS_LITERAL : ConstantArgumentKind.NOT_CONST;
        }
        return constantArgumentKind;
    }

    /*
     * WARNING - void declaration
     */
    private static final FirSymbolOwner<?> getReferencedClass(FirTypedDeclaration $this$getReferencedClass, FirSession session2) {
        Object v0;
        FirTypedDeclaration firTypedDeclaration = $this$getReferencedClass;
        if (firTypedDeclaration == null) {
            v0 = null;
        } else {
            FirTypeRef firTypeRef = firTypedDeclaration.getReturnTypeRef();
            if (firTypeRef == null) {
                v0 = null;
            } else {
                FirClassifierSymbol<?> firClassifierSymbol;
                ConeLookupTagBasedType coneLookupTagBasedType;
                void $this$coneTypeSafe$iv;
                Object object = firTypeRef;
                boolean $i$f$coneTypeSafe = false;
                boolean bl = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                    coneKotlinType = null;
                }
                v0 = (coneLookupTagBasedType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType))) == null ? null : ((object = coneLookupTagBasedType.getLookupTag()) == null ? null : ((firClassifierSymbol = LookupTagUtilsKt.toSymbol((ConeClassifierLookupTag)object, session2)) == null ? null : firClassifierSymbol.getFir()));
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        void $this$mapTo$iv;
        Object object = new String[]{"toInt", "toLong", "toShort", "toByte", "toFloat", "toDouble", "toChar", "toBoolean"};
        object = CollectionsKt.listOf(object);
        boolean bl = false;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)it);
            collection.add(name);
        }
        CONVERSION_NAMES = (HashSet)var1_2;
    }
}

