/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkGlobalDeclaration", "checkLocalDeclaration", "checkers"})
public final class FirSealedSupertypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSealedSupertypeChecker INSTANCE = new FirSealedSupertypeChecker();

    private FirSealedSupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (FirDeclarationUtilKt.getClassId(declaration2).isLocal()) {
            this.checkLocalDeclaration(declaration2, context2, reporter);
        } else {
            this.checkGlobalDeclaration(declaration2, context2, reporter);
        }
    }

    private final void checkGlobalDeclaration(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FqName fqName2 = FirDeclarationUtilKt.getClassId(declaration2).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "declaration.classId.packageFqName");
        FqName subclassPackage = fqName2;
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            FirRegularClassSymbol superClass;
            FirRegularClassSymbol firRegularClassSymbol;
            ClassId superClassId;
            ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(superTypeRef));
            if (classId == null || (superClassId = classId).isLocal()) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(superClassId);
            FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null) continue;
            FirRegularClassSymbol $this$isSealed$iv = superClass = firRegularClassSymbol;
            boolean $i$f$isSealed = false;
            if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) continue;
            if (Intrinsics.areEqual(superClass.getOrigin(), FirDeclarationOrigin.Java.INSTANCE)) {
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_INHERITS_JAVA_SEALED_CLASS(), context2, null, 8, null);
                continue;
            }
            FqName fqName3 = superClass.getClassId().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName3, "superClass.classId.packageFqName");
            FqName superClassPackage = fqName3;
            if (!Intrinsics.areEqual(superClassPackage, subclassPackage)) {
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_PACKAGE(), context2, null, 8, null);
            }
            if (Intrinsics.areEqual(superClass.getModuleData(), declaration2.getModuleData())) continue;
            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_MODULE(), context2, null, 8, null);
        }
    }

    private final void checkLocalDeclaration(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeRef it : declaration2.getSuperTypeRefs()) {
            FirRegularClassSymbol classSymbol;
            FirRegularClassSymbol firRegularClassSymbol;
            ClassId classId;
            ClassId classId2 = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it));
            if (classId2 == null || (classId = classId2).isLocal()) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(classId);
            FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null) continue;
            FirRegularClassSymbol $this$modality$iv = classSymbol = firRegularClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.SEALED) continue;
            DiagnosticReporterKt.reportOn$default(reporter, it.getSource(), FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS(), context2, null, 8, null);
            return;
        }
    }
}

