/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmPackageNameAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "jvmPackageNameClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "stringParameterName", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJvmPackageNameAnnotationsChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirJvmPackageNameAnnotationsChecker INSTANCE = new FirJvmPackageNameAnnotationsChecker();
    @NotNull
    private static final ClassId jvmPackageNameClassId;
    @NotNull
    private static final Name stringParameterName;

    private FirJvmPackageNameAnnotationsChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        block12: {
            ConeClassLikeType coneClassLikeType;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Object $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirPureAbstractElement firPureAbstractElement = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firPureAbstractElement == null ? null : firPureAbstractElement.getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null) {
                return;
            }
            ConeClassLikeLookupTag lookupTag = coneClassLikeType.getLookupTag();
            if (!Intrinsics.areEqual(lookupTag.getClassId(), jvmPackageNameClassId)) {
                return;
            }
            $this$coneTypeSafe$iv = FirAnnotationUtilsKt.getStringArgument(expression2, stringParameterName);
            if ($this$coneTypeSafe$iv == null) {
                return;
            }
            Object nameValue = $this$coneTypeSafe$iv;
            if (((CharSequence)nameValue).length() == 0) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirJvmErrors.INSTANCE.getJVM_PACKAGE_NAME_CANNOT_BE_EMPTY(), context2, null, 8, null);
            } else if (!FqNamesUtilKt.isValidJavaFqName((String)nameValue)) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirJvmErrors.INSTANCE.getJVM_PACKAGE_NAME_MUST_BE_VALID_NAME(), context2, null, 8, null);
            }
            firPureAbstractElement = CollectionsKt.firstOrNull(context2.getContainingDeclarations());
            FirFile firFile = $i$f$coneTypeSafe = firPureAbstractElement instanceof FirFile ? (FirFile)firPureAbstractElement : null;
            if ($i$f$coneTypeSafe == null) {
                return;
            }
            FirFile file2 = $i$f$coneTypeSafe;
            Iterable $this$any$iv = file2.getDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirClass)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirJvmErrors.INSTANCE.getJVM_PACKAGE_NAME_NOT_SUPPORTED_IN_FILES_WITH_CLASSES(), context2, null, 8, null);
        }
    }

    static {
        Object object = ClassId.topLevel(new FqName("kotlin.jvm.JvmPackageName"));
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(FqName(\"kotlin.jvm.JvmPackageName\"))");
        jvmPackageNameClassId = object;
        object = Name.identifier("name");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"name\")");
        stringParameterName = object;
    }
}

