/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a7\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0019\b\u0002\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\b\f\u001a\u001d\u0010\r\u001a\u00020\t*\u0004\u0018\u00010\u0007\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0000\u00a8\u0006\u000e"}, d2={"render", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "renderAttributes", "renderFunctionType", "kind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isExtension", "", "renderType", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withPrettyRender", "cones"})
public final class TypeRendererKt {
    @NotNull
    public static final String render(@NotNull ConeKotlinType $this$render) {
        String string2;
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        String nullabilitySuffix = !($this$render instanceof ConeFlexibleType) && !($this$render instanceof ConeClassErrorType) ? $this$render.getNullability().getSuffix() : "";
        ConeKotlinType coneKotlinType = $this$render;
        if (coneKotlinType instanceof ConeTypeVariableType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "TypeVariable(" + ((ConeTypeVariableType)$this$render).getLookupTag().getName() + ')';
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            string2 = Intrinsics.stringPlus(TypeRendererKt.render(((ConeDefinitelyNotNullType)$this$render).getOriginal()), " & Any");
        } else if (coneKotlinType instanceof ConeClassErrorType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "ERROR CLASS: " + ((ConeClassErrorType)$this$render).getDiagnostic().getReason();
        } else if (coneKotlinType instanceof ConeCapturedType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "CapturedType(" + TypeRendererKt.render(((ConeCapturedType)$this$render).getConstructor().getProjection()) + ')';
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            StringBuilder stringBuilder2;
            StringBuilder $this$render_u24lambda_u2d0 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$render_u24lambda_u2d0.append(TypeRendererKt.renderAttributes($this$render));
            $this$render_u24lambda_u2d0.append(((ConeClassLikeType)$this$render).getLookupTag().getClassId().asString());
            if (!($this$render.getTypeArguments().length == 0)) {
                $this$render_u24lambda_u2d0.append(ArraysKt.joinToString$default($this$render.getTypeArguments(), null, (CharSequence)"<", (CharSequence)">", 0, null, (Function1)render.1.1.INSTANCE, 25, null));
            }
            String string3 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
            string2 = string3;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            string2 = Intrinsics.stringPlus(TypeRendererKt.renderAttributes($this$render), ((ConeLookupTagBasedType)$this$render).getLookupTag().getName().asString());
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            StringBuilder stringBuilder3;
            StringBuilder $this$render_u24lambda_u2d1 = stringBuilder3 = new StringBuilder();
            boolean bl = false;
            $this$render_u24lambda_u2d1.append("ft<");
            $this$render_u24lambda_u2d1.append(TypeRendererKt.render(((ConeFlexibleType)$this$render).getLowerBound()));
            $this$render_u24lambda_u2d1.append(", ");
            $this$render_u24lambda_u2d1.append(TypeRendererKt.render(((ConeFlexibleType)$this$render).getUpperBound()));
            $this$render_u24lambda_u2d1.append(">");
            String string4 = stringBuilder3.toString();
            Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
            string2 = string4;
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            string2 = CollectionsKt.joinToString$default(((ConeIntersectionType)$this$render).getIntersectedTypes(), " & ", Intrinsics.stringPlus(TypeRendererKt.renderAttributes($this$render), "it("), ")", 0, null, null, 56, null);
        } else if (coneKotlinType instanceof ConeStubType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "Stub: " + ((ConeStubType)$this$render).getVariable();
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            string2 = TypeRendererKt.renderAttributes($this$render) + "ILT: " + ((ConeIntegerLiteralType)$this$render).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Intrinsics.stringPlus(string2, nullabilitySuffix);
    }

    private static final String renderAttributes(ConeKotlinType $this$renderAttributes) {
        if (!CollectionsKt.any($this$renderAttributes.getAttributes())) {
            return "";
        }
        return CollectionsKt.joinToString$default($this$renderAttributes.getAttributes(), " ", null, " ", 0, null, renderAttributes.1.INSTANCE, 26, null);
    }

    @NotNull
    public static final String render(@NotNull ConeTypeProjection $this$render) {
        String string2;
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        ConeTypeProjection coneTypeProjection = $this$render;
        if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
            string2 = "*";
        } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
            string2 = Intrinsics.stringPlus("CONFLICTING-PROJECTION ", TypeRendererKt.render(((ConeKotlinTypeConflictingProjection)$this$render).getType()));
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            string2 = Intrinsics.stringPlus("in ", TypeRendererKt.render(((ConeKotlinTypeProjectionIn)$this$render).getType()));
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            string2 = Intrinsics.stringPlus("out ", TypeRendererKt.render(((ConeKotlinTypeProjectionOut)$this$render).getType()));
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            string2 = TypeRendererKt.render((ConeKotlinType)$this$render);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @NotNull
    public static final String renderFunctionType(@NotNull ConeKotlinType $this$renderFunctionType, @Nullable FunctionClassKind kind, boolean isExtension, @NotNull Function1<? super ConeTypeProjection, String> renderType) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter($this$renderFunctionType, "<this>");
        Intrinsics.checkNotNullParameter(renderType, "renderType");
        if (!TypeRendererKt.withPrettyRender(kind)) {
            return renderType.invoke($this$renderFunctionType);
        }
        StringBuilder $this$renderFunctionType_u24lambda_u2d2 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        if (kind == FunctionClassKind.SuspendFunction) {
            $this$renderFunctionType_u24lambda_u2d2.append("suspend ");
        }
        Pair<Object, List<ConeTypeProjection>> pair = isExtension && !Intrinsics.areEqual(ArraysKt.first($this$renderFunctionType.getTypeArguments()), ConeStarProjection.INSTANCE) ? TuplesKt.to(ArraysKt.first($this$renderFunctionType.getTypeArguments()), ArraysKt.drop($this$renderFunctionType.getTypeArguments(), 1)) : TuplesKt.to(null, ArraysKt.toList($this$renderFunctionType.getTypeArguments()));
        ConeTypeProjection receiver = pair.component1();
        List<ConeTypeProjection> otherTypeArguments = pair.component2();
        List<ConeTypeProjection> arguments2 = otherTypeArguments.subList(0, otherTypeArguments.size() - 1);
        ConeTypeProjection returnType2 = CollectionsKt.last(otherTypeArguments);
        if (receiver != null) {
            $this$renderFunctionType_u24lambda_u2d2.append(renderType.invoke(receiver));
            $this$renderFunctionType_u24lambda_u2d2.append(".");
        }
        $this$renderFunctionType_u24lambda_u2d2.append(CollectionsKt.joinToString$default(arguments2, ", ", "(", ")", 0, null, new Function1<ConeTypeProjection, CharSequence>(renderType){
            final /* synthetic */ Function1<ConeTypeProjection, String> $renderType;
            {
                this.$renderType = $renderType;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ConeTypeProjection it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$renderType.invoke(it);
            }
        }, 24, null));
        $this$renderFunctionType_u24lambda_u2d2.append(" -> ");
        $this$renderFunctionType_u24lambda_u2d2.append(renderType.invoke(returnType2));
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String renderedType2 = string2;
        return ConeTypeUtilsKt.isMarkedNullable($this$renderFunctionType) ? '(' + renderedType2 + ")?" : renderedType2;
    }

    public static /* synthetic */ String renderFunctionType$default(ConeKotlinType coneKotlinType, FunctionClassKind functionClassKind, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = renderFunctionType.1.INSTANCE;
        }
        return TypeRendererKt.renderFunctionType(coneKotlinType, functionClassKind, bl, function1);
    }

    public static final boolean withPrettyRender(@Nullable FunctionClassKind $this$withPrettyRender) {
        return $this$withPrettyRender != null && $this$withPrettyRender != FunctionClassKind.KSuspendFunction && $this$withPrettyRender != FunctionClassKind.KFunction;
    }
}

